/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public class TextOutputStream
extends OutputStream {
    private PrintWriter out;
    private int width;
    private int precision;
    private String pre;
    private String post;
    private boolean leading_zeroes;
    private boolean show_plus;
    private boolean alternate;
    private boolean show_space;
    private boolean left_align;
    private char fmt;

    public TextOutputStream(String string, boolean bl) {
        try {
            this.out = new PrintWriter(new FileOutputStream(string, bl));
        }
        catch (IOException iOException) {
            this.out = null;
        }
    }

    public TextOutputStream(PrintStream printStream) {
        this.out = new PrintWriter(printStream);
    }

    public TextOutputStream(String string) {
        try {
            this.out = new PrintWriter(new FileOutputStream(string));
        }
        catch (IOException iOException) {
            this.out = null;
        }
    }

    public boolean fail() {
        return this.out == null;
    }

    public boolean checkError() {
        return this.out.checkError();
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    public void write(int n) {
        this.out.write(n);
    }

    public void print(String string) {
        this.out.print(string);
        this.flush();
    }

    public void print(char c) {
        this.out.print(c);
        this.flush();
    }

    public void print(Object object) {
        this.out.print(object);
        this.flush();
    }

    public void print(long l) {
        this.out.print(l);
        this.flush();
    }

    public void print(double d) {
        this.out.print(d);
        this.flush();
    }

    public void println(String string) {
        this.out.println(string);
        this.flush();
    }

    public void println(char c) {
        this.out.println(c);
        this.flush();
    }

    public void println(Object object) {
        this.out.println(object);
        this.flush();
    }

    public void println(long l) {
        this.out.println(l);
        this.flush();
    }

    public void println(double d) {
        this.out.println(d);
        this.flush();
    }

    public void println() {
        this.out.println();
        this.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseFormat(String string) {
        this.width = 0;
        this.precision = -1;
        this.pre = "";
        this.post = "";
        this.leading_zeroes = false;
        this.show_plus = false;
        this.alternate = false;
        this.show_space = false;
        this.left_align = false;
        this.fmt = (char)32;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 == 0) {
            if (n3 >= n) {
                n2 = 5;
            } else if (string.charAt(n3) == '%') {
                if (n3 >= n - 1) throw new IllegalArgumentException();
                if (string.charAt(n3 + 1) == '%') {
                    this.pre = this.pre + '%';
                    ++n3;
                } else {
                    n2 = 1;
                }
            } else {
                this.pre = this.pre + string.charAt(n3);
            }
            ++n3;
        }
        while (n2 == 1) {
            if (n3 >= n) {
                n2 = 5;
            } else if (string.charAt(n3) == ' ') {
                this.show_space = true;
            } else if (string.charAt(n3) == '-') {
                this.left_align = true;
            } else if (string.charAt(n3) == '+') {
                this.show_plus = true;
            } else if (string.charAt(n3) == '0') {
                this.leading_zeroes = true;
            } else if (string.charAt(n3) == '#') {
                this.alternate = true;
            } else {
                n2 = 2;
                --n3;
            }
            ++n3;
        }
        while (n2 == 2) {
            if (n3 >= n) {
                n2 = 5;
                continue;
            }
            if ('0' <= string.charAt(n3) && string.charAt(n3) <= '9') {
                this.width = this.width * 10 + string.charAt(n3) - 48;
                ++n3;
                continue;
            }
            if (string.charAt(n3) == '.') {
                n2 = 3;
                this.precision = 0;
                ++n3;
                continue;
            }
            n2 = 4;
        }
        while (n2 == 3) {
            if (n3 >= n) {
                n2 = 5;
                continue;
            }
            if ('0' <= string.charAt(n3) && string.charAt(n3) <= '9') {
                this.precision = this.precision * 10 + string.charAt(n3) - 48;
                ++n3;
                continue;
            }
            n2 = 4;
        }
        if (n2 == 4) {
            if (n3 >= n) {
                n2 = 5;
            } else {
                this.fmt = string.charAt(n3);
            }
            ++n3;
        }
        if (n3 >= n) return;
        this.post = string.substring(n3, n);
    }

    public void printf(String string, double d) {
        this.parseFormat(string);
        this.print(this.form(d));
    }

    public void printf(String string, long l) {
        this.parseFormat(string);
        this.print(this.form(l));
    }

    public void printf(String string, char c) {
        this.parseFormat(string);
        this.print(this.form(c));
    }

    public void printf(String string, String string2) {
        this.parseFormat(string);
        this.print(this.form(string2));
    }

    private static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String convert(long l, int n, int n2, String string) {
        if (l == 0L) {
            return "0";
        }
        String string2 = "";
        while (l != 0L) {
            string2 = string.charAt((int)(l & (long)n2)) + string2;
            l >>>= n;
        }
        return string2;
    }

    private String pad(String string) {
        String string2 = TextOutputStream.repeat(' ', this.width - string.length());
        if (this.left_align) {
            return this.pre + string + string2 + this.post;
        }
        return this.pre + string2 + string + this.post;
    }

    private String sign(int n, String string) {
        String string2 = "";
        if (n < 0) {
            string2 = "-";
        } else if (n > 0) {
            if (this.show_plus) {
                string2 = "+";
            } else if (this.show_space) {
                string2 = " ";
            }
        } else if (this.fmt == 'o' && this.alternate && string.length() > 0 && string.charAt(0) != '0') {
            string2 = "0";
        } else if (this.fmt == 'x' && this.alternate) {
            string2 = "0x";
        } else if (this.fmt == 'X' && this.alternate) {
            string2 = "0X";
        }
        int n2 = 0;
        if (this.leading_zeroes) {
            n2 = this.width;
        } else if ((this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            n2 = this.precision;
        }
        return string2 + TextOutputStream.repeat('0', n2 - string2.length() - string.length()) + string;
    }

    private String fixed_format(double d) {
        String string = "";
        if (d > 9.223372036854776E18) {
            return this.exp_format(d);
        }
        long l = (long)(this.precision == 0 ? d + 0.5 : d);
        string = string + l;
        double d2 = d - (double)l;
        if (d2 >= 1.0 || d2 < 0.0) {
            return this.exp_format(d);
        }
        String string2 = this.frac_part(d2);
        if (string2 == "0") {
            int n = (int)d + 1;
            String string3 = "";
            for (int i = 1; i <= this.precision; ++i) {
                string3 = string3 + "0";
            }
            return n + "." + string3;
        }
        return string + string2;
    }

    private String frac_part(double d) {
        String string = "";
        if (this.precision > 0) {
            double d2 = 1.0;
            String string2 = "";
            for (int i = 1; i <= this.precision && d2 <= 9.223372036854776E18; d2 *= 10.0, ++i) {
                string2 = string2 + "0";
            }
            long l = (long)(d2 * d + 0.5);
            if ((double)l == d2) {
                return "0";
            }
            string = string2 + l;
            string = string.substring(string.length() - this.precision, string.length());
        }
        if (this.precision > 0 || this.alternate) {
            string = "." + string;
        }
        if (!(this.fmt != 'G' && this.fmt != 'g' || this.alternate)) {
            int n;
            for (n = string.length() - 1; n >= 0 && string.charAt(n) == '0'; --n) {
            }
            if (n >= 0 && string.charAt(n) == '.') {
                --n;
            }
            string = string.substring(0, n + 1);
        }
        return string;
    }

    private String exp_format(double d) {
        String string = "";
        int n = 0;
        double d2 = 1.0;
        if (d != 0.0) {
            double d3;
            for (d3 = d; d3 > 10.0; d3 /= 10.0) {
                ++n;
                d2 /= 10.0;
            }
            while (d3 < 1.0) {
                --n;
                d2 *= 10.0;
                d3 *= 10.0;
            }
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && n >= -4 && n < this.precision) {
            return this.fixed_format(d);
        }
        string = string + this.fixed_format(d *= d2);
        string = this.fmt == 'e' || this.fmt == 'g' ? string + "e" : string + "E";
        String string2 = "000";
        if (n >= 0) {
            string = string + "+";
            string2 = string2 + n;
        } else {
            string = string + "-";
            string2 = string2 + -n;
        }
        return string + string2.substring(string2.length() - 3, string2.length());
    }

    private String form(double d) {
        String string;
        if (this.precision < 0) {
            this.precision = 6;
        }
        int n = 1;
        if (d < 0.0) {
            d = -d;
            n = -1;
        }
        if (this.fmt == 'f') {
            string = this.fixed_format(d);
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            string = this.exp_format(d);
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(n, string));
    }

    private String form(long l) {
        String string;
        int n = 0;
        if (this.fmt == 'd' || this.fmt == 'i') {
            if (l < 0L) {
                string = ("" + l).substring(1);
                n = -1;
            } else {
                string = "" + l;
                n = 1;
            }
        } else if (this.fmt == 'o') {
            string = TextOutputStream.convert(l, 3, 7, "01234567");
        } else if (this.fmt == 'x') {
            string = TextOutputStream.convert(l, 4, 15, "0123456789abcdef");
        } else if (this.fmt == 'X') {
            string = TextOutputStream.convert(l, 4, 15, "0123456789ABCDEF");
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(n, string));
    }

    private String form(char c) {
        if (this.fmt != 'c') {
            throw new IllegalArgumentException();
        }
        String string = "" + c;
        return this.pad(string);
    }

    private String form(String string) {
        if (this.fmt != 's') {
            throw new IllegalArgumentException();
        }
        if (this.precision >= 0) {
            string = string.substring(0, this.precision);
        }
        return this.pad(string);
    }
}

