/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.selection;

import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.selection.BIC;
import es.uvigo.darwin.jmodeltest.selection.InformationCriterion;
import es.uvigo.darwin.jmodeltest.tree.TreeDistancesCache;
import es.uvigo.darwin.jmodeltest.tree.TreeEuclideanDistancesCache;
import java.util.Random;

public class DT
extends InformationCriterion {
    private TreeDistancesCache distances = TreeEuclideanDistancesCache.getInstance();

    public DT(boolean bl, boolean bl2, boolean bl3, double d) {
        super(bl, bl2, bl3, d);
    }

    @Override
    public void compute() {
        double d;
        int n;
        double[] dArray = new double[this.numModels];
        double[] dArray2 = new double[this.numModels];
        double[] dArray3 = new double[this.numModels];
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        for (n = 0; n < this.numModels; ++n) {
            dArray2[n] = BIC.computeBic(this.models[n], this.options);
            if (!(dArray2[n] < d3)) continue;
            d3 = dArray2[n];
        }
        double d4 = 0.0;
        for (n = 0; n < this.numModels; ++n) {
            dArray3[n] = Math.exp(-0.5 * (dArray2[n] - d3));
            d4 += dArray3[n];
        }
        for (Model model : this.models) {
            d = 0.0;
            int n2 = 0;
            for (Model model2 : this.models) {
                double d5 = this.distances.getDistance(model.getTree(), model2.getTree());
                if (d5 > 0.0) {
                    d += d5 * dArray3[n2];
                }
                ++n2;
            }
            model.setDT(d / d4);
            if (!(model.getDT() < d2)) continue;
            d2 = model.getDT();
            this.minModel = model;
        }
        d = 0.0;
        double d6 = 0.0;
        for (n = 0; n < this.numModels; ++n) {
            this.models[n].setDTd(this.models[n].getDT() - this.minModel.getDT());
            d6 += 1.0 / this.models[n].getDT();
        }
        for (n = 0; n < this.numModels; ++n) {
            if (this.models[n].getDTd() > 1000.0) {
                this.models[n].setDTw(0.0);
            } else {
                this.models[n].setDTw(1.0 / this.models[n].getDT() / d6);
            }
            dArray[n] = this.models[n].getDT();
            this.order[n] = n;
        }
        boolean bl = false;
        int n3 = 1;
        while (!bl) {
            bl = true;
            for (n = 0; n < this.numModels - n3; ++n) {
                if (!(dArray[n] > dArray[n + 1])) continue;
                double d7 = dArray[n + 1];
                dArray[n + 1] = dArray[n];
                dArray[n] = d7;
                int n4 = this.order[n + 1];
                this.order[n + 1] = this.order[n];
                this.order[n] = n4;
                bl = false;
            }
            ++n3;
        }
        double d8 = 0.0;
        for (n = 0; n < this.numModels; ++n) {
            this.models[this.order[n]].setCumDTw(d8 += this.models[this.order[n]].getDTw());
        }
        this.buildConfidenceInterval();
        if (this.doImportances || this.doModelAveraging) {
            this.parameterImportance();
        }
        if (this.doModelAveraging) {
            this.averageModels();
        }
    }

    @Override
    public double computeSingle(Model model) {
        throw new RuntimeException("Cannot compute a single criterion value for DT");
    }

    @Override
    protected void printHeader(TextOutputStream textOutputStream) {
        textOutputStream.println("\n\n\n---------------------------------------------------------------");
        textOutputStream.println("*                                                             *");
        textOutputStream.println("*      DECISION THEORY PERFORMANCE-BASED SELECTION (DT)       *");
        textOutputStream.println("*                                                             *");
        textOutputStream.println("---------------------------------------------------------------");
        textOutputStream.println(" ");
        textOutputStream.println(" Sample size: " + this.options.getSampleSize());
    }

    @Override
    protected void printFooter(TextOutputStream textOutputStream) {
        textOutputStream.println("-lnL:t\tnegative log likelihod");
        textOutputStream.println("K:\tnumber of estimated parameters");
        textOutputStream.println("DT:\tdecision theory performance-based score");
        textOutputStream.println("delta:\tDT difference");
        textOutputStream.println("weight:\tDT weight* (calculated using 1/DT)");
        textOutputStream.println("cumWeight:\tcumulative DT weight");
    }

    @Override
    public void buildConfidenceInterval() {
        Model model = this.models[0];
        this.cumWeight = 0.0;
        if (this.confidenceInterval >= 1.0) {
            for (int i = 0; i < this.numModels; ++i) {
                model = this.models[this.order[i]];
                model.setInDTinterval(true);
                this.confidenceModels.add(model);
            }
            this.cumWeight = 1.0;
        } else {
            for (int i = 0; i < this.numModels && (model = this.models[this.order[i]]).getCumDTw() <= this.confidenceInterval; ++i) {
                model.setInDTinterval(true);
                this.confidenceModels.add(model);
                this.cumWeight += model.getDTw();
            }
            double d = (model.getCumDTw() - this.confidenceInterval) / model.getDTw();
            double d2 = 1.0 - d;
            Random random = new Random();
            double d3 = random.nextDouble();
            if (d3 <= d2) {
                model.setInDTinterval(true);
                this.confidenceModels.add(model);
                this.cumWeight += model.getDTw();
            } else {
                model.setInDTinterval(false);
            }
        }
    }

    @Override
    public double getMinModelValue() {
        return this.minModel.getDT();
    }

    @Override
    public double getMinModelWeight() {
        return this.minModel.getDTw();
    }

    @Override
    public double getValue(Model model) {
        return model.getDT();
    }

    @Override
    public double getWeight(Model model) {
        return model.getDTw();
    }

    @Override
    public double getDelta(Model model) {
        return model.getDTd();
    }

    @Override
    public double getUDelta(Model model) {
        return Double.NaN;
    }

    @Override
    public double setUDelta(Model model) {
        return Double.NaN;
    }

    @Override
    public double getCumWeight(Model model) {
        return model.getCumDTw();
    }

    @Override
    public int getType() {
        return 4;
    }
}

