/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.tree;

import es.uvigo.darwin.jmodeltest.exception.InternalException;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.selection.InformationCriterion;
import es.uvigo.darwin.jmodeltest.tree.TreeUtilities;
import es.uvigo.darwin.jmodeltest.tree.WeightedTree;
import es.uvigo.darwin.jmodeltest.utilities.FixedBitSet;
import es.uvigo.darwin.jmodeltest.utilities.MyFormattedOutput;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import pal.misc.IdGroup;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.tree.SimpleTree;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public class Consensus {
    public static final boolean SUPPORT_AS_PERCENT = false;
    public static final int BRANCH_LENGTHS_AVERAGE = 1;
    public static final int BRANCH_LENGTHS_MEDIAN = 2;
    private static final BranchDistances DEFAULT_BRANCH_DISTANCES = BranchDistances.WeightedMedian;
    private static final int FIRST = 0;
    private List<WeightedTree> trees;
    private double cumWeight = 0.0;
    private int numTaxa;
    private IdGroup idGroup;
    private Map<FixedBitSet, Support> support = new HashMap<FixedBitSet, Support>();
    private Map<FixedBitSet, Double> cladeSupport;
    private Tree consensusTree;
    private List<FixedBitSet> splitsInConsensus = new ArrayList<FixedBitSet>();
    private List<FixedBitSet> splitsOutFromConsensus = new ArrayList<FixedBitSet>();

    private Map<FixedBitSet, Support> getSupport() {
        return this.support;
    }

    public Map<FixedBitSet, Double> getCladeSupport() {
        if (this.cladeSupport == null) {
            this.cladeSupport = new HashMap<FixedBitSet, Double>(this.support.size());
            Object[] objectArray = this.support.keySet().toArray(new FixedBitSet[0]);
            Arrays.sort(objectArray);
            for (Object object : objectArray) {
                this.cladeSupport.put((FixedBitSet)object, this.support.get(object).treesWeightWithClade / this.cumWeight);
            }
        }
        return this.cladeSupport;
    }

    public IdGroup getIdGroup() {
        return this.idGroup;
    }

    public Tree getConsensusTree() {
        return this.consensusTree;
    }

    public Collection<WeightedTree> getTrees() {
        return this.trees;
    }

    private boolean addTree(WeightedTree weightedTree) {
        if (weightedTree.getTree() == null || weightedTree.getWeight() < 0.0) {
            throw new InternalException();
        }
        if (this.trees.isEmpty()) {
            this.trees.add(weightedTree);
            this.numTaxa = weightedTree.getTree().getIdCount();
            this.idGroup = TreeUtils.getLeafIdGroup(weightedTree.getTree());
        } else {
            if (weightedTree.getTree().getIdCount() != this.numTaxa) {
                return false;
            }
            Tree tree = this.trees.get(0).getTree();
            for (int i = 0; i < this.numTaxa; ++i) {
                boolean bl = false;
                for (int j = 0; j < this.numTaxa; ++j) {
                    if (!weightedTree.getTree().getIdentifier(i).equals(tree.getIdentifier(j))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                System.out.println("NOT COMPATIBLE TREES");
                return false;
            }
            this.trees.add(weightedTree);
        }
        this.cumWeight += weightedTree.getWeight();
        return true;
    }

    public Consensus(InformationCriterion informationCriterion, double d) {
        this(informationCriterion, d, 0);
    }

    public Consensus(InformationCriterion informationCriterion, double d, int n) {
        this.trees = new ArrayList<WeightedTree>();
        for (Model model : informationCriterion.getConfidenceModels()) {
            WeightedTree weightedTree = new WeightedTree(model.getTree(), informationCriterion.getWeight(model));
            this.addTree(weightedTree);
        }
        this.consensusTree = this.buildTree(d, this.getBranchDistances(n));
    }

    public Consensus(List<WeightedTree> list, double d, int n) {
        this.trees = new ArrayList<WeightedTree>();
        for (WeightedTree weightedTree : list) {
            this.addTree(weightedTree);
        }
        this.consensusTree = this.buildTree(d, this.getBranchDistances(n));
    }

    private FixedBitSet rootedSupport(WeightedTree weightedTree, Node node, Map<FixedBitSet, Support> map) {
        FixedBitSet fixedBitSet = new FixedBitSet(this.numTaxa);
        if (node.isLeaf()) {
            fixedBitSet.set(this.idGroup.whichIdNumber(node.getIdentifier().getName()));
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                Node node2 = node.getChild(i);
                FixedBitSet fixedBitSet2 = this.rootedSupport(weightedTree, node2, map);
                fixedBitSet.union(fixedBitSet2);
            }
        }
        Support support = map.get(fixedBitSet);
        if (support == null) {
            support = new Support();
            map.put(fixedBitSet, support);
        }
        support.add(weightedTree.getWeight(), TreeUtilities.safeNodeHeight(weightedTree.getTree(), node), node.getBranchLength());
        return fixedBitSet;
    }

    public Node detachChildren(Tree tree, Node node, List<Integer> list) {
        assert (list.size() > 1);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Object object = list.iterator();
        while (object.hasNext()) {
            int n = object.next();
            arrayList.add(node.getChild(n));
        }
        object = tree.getRoot();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = node.getChild(i);
            if (!arrayList.contains(node2)) continue;
            arrayList2.add(0, i);
        }
        Object object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            int n = (Integer)object2.next();
            node.removeChild(n);
        }
        object2 = NodeFactory.createNode(arrayList.toArray(new Node[0]));
        node.addChild((Node)object2);
        tree.setRoot((Node)object);
        return object2;
    }

    private Tree buildTree(double d, BranchDistances branchDistances) {
        double objectArray;
        int n;
        Set<FixedBitSet> set;
        if (this.trees.isEmpty()) {
            throw new InternalException("There are no trees to consense");
        }
        if (d < 0.5 || d > 1.0) {
            throw new InternalException("Invalid threshold value: " + d);
        }
        double d3 = d;
        if (d == 0.5) {
            d3 += 1.0 / (double)(this.numTaxa + 1);
        } else if (d == 1.0) {
            d3 -= 1.0 / (double)(this.numTaxa + 1);
        }
        this.support = new HashMap<FixedBitSet, Support>();
        for (WeightedTree object2 : this.trees) {
            this.rootedSupport(object2, object2.getTree().getRoot(), this.support);
        }
        SimpleTree simpleTree = new SimpleTree();
        ArrayList<Node> arrayList = new ArrayList<Node>(this.numTaxa);
        ArrayList<FixedBitSet> arrayList2 = new ArrayList<FixedBitSet>(this.numTaxa);
        assert (this.idGroup.getIdCount() == this.numTaxa);
        arrayList2.add(new FixedBitSet(this.numTaxa));
        FixedBitSet fixedBitSet = (FixedBitSet)arrayList2.get(0);
        Node[] nodeArray = new Node[this.numTaxa];
        for (int node = 0; node < this.numTaxa; ++node) {
            nodeArray[node] = NodeFactory.createNode(this.idGroup.getIdentifier(node));
            fixedBitSet.set(node);
        }
        Node node = NodeFactory.createNode(nodeArray);
        arrayList.add(node);
        simpleTree.setRoot(node);
        Comparator<Map.Entry<FixedBitSet, Support>> comparator = new Comparator<Map.Entry<FixedBitSet, Support>>(){

            @Override
            public int compare(Map.Entry<FixedBitSet, Support> entry, Map.Entry<FixedBitSet, Support> entry2) {
                double d = entry2.getValue().treesWeightWithClade - entry.getValue().treesWeightWithClade;
                if (d > 0.0) {
                    return 1;
                }
                if (d < 0.0) {
                    return -1;
                }
                return 0;
            }
        };
        PriorityQueue<Map.Entry<FixedBitSet, Support>> priorityQueue = new PriorityQueue<Map.Entry<FixedBitSet, Support>>(this.support.size(), comparator);
        Object object = this.support.entrySet().iterator();
        while (object.hasNext()) {
            set = object.next();
            Support d2 = set.getValue();
            Object[] objectArray2 = set.getKey();
            int fixedBitSet2 = objectArray2.cardinality();
            if (fixedBitSet2 == this.numTaxa) {
                simpleTree.getRoot().setNodeHeight(d2.sumBranches / (double)this.trees.size());
                simpleTree.getRoot().setBranchLength(branchDistances.build(d2.branchLengths));
                continue;
            }
            if (Math.abs(d2.treesWeightWithClade - this.cumWeight) < 1.0E-5 && fixedBitSet2 == 1) {
                n = objectArray2.nextOnBit(0);
                Node i = simpleTree.getExternalNode(n);
                i.setNodeHeight(d2.sumBranches / (double)this.trees.size());
                i.setBranchLength(branchDistances.build(d2.branchLengths));
                continue;
            }
            priorityQueue.add((Map.Entry<FixedBitSet, Support>)((Object)set));
        }
        block3: while (priorityQueue.peek() != null && !((objectArray = 1.0 * ((Support)((Object)(set = (Support)(object = priorityQueue.poll()).getValue()))).treesWeightWithClade / this.cumWeight) < d3)) {
            FixedBitSet fixedBitSet2 = (FixedBitSet)object.getKey();
            n = 0;
            for (int object4 = arrayList2.size() - 1; object4 >= 0; --object4) {
                FixedBitSet d5 = (FixedBitSet)arrayList2.get(object4);
                int n2 = d5.intersectCardinality(fixedBitSet2);
                if (n2 != fixedBitSet2.cardinality()) continue;
                n = 1;
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                Node node2 = (Node)arrayList.get(object4);
                int n3 = 0;
                for (int node5 = 0; node5 < node2.getChildCount(); ++node5) {
                    Node d4 = node2.getChild(node5);
                    if (d4.isLeaf()) {
                        if (fixedBitSet2.contains(this.idGroup.whichIdNumber(d4.getIdentifier().getName()))) {
                            arrayList3.add(n3);
                        }
                    } else {
                        int n4 = arrayList.indexOf(d4);
                        int n5 = ((FixedBitSet)arrayList2.get(n4)).intersectCardinality(fixedBitSet2);
                        if (n5 == ((FixedBitSet)arrayList2.get(n4)).cardinality()) {
                            arrayList3.add(n3);
                        } else if (n5 > 0) {
                            n = 0;
                            break;
                        }
                    }
                    ++n3;
                }
                if (n == 0 || arrayList3.size() >= node2.getChildCount()) {
                    n = 0;
                    continue block3;
                }
                if (arrayList3.isEmpty()) {
                    System.err.println("Bug??");
                    assert (false);
                }
                Node node3 = this.detachChildren(simpleTree, node2, arrayList3);
                double d2 = ((Support)set).sumBranches / (double)((Support)set).nTreesWithClade;
                node3.setNodeHeight(d2);
                node3.setBranchLength(branchDistances.build(((Support)set).branchLengths));
                simpleTree.setAttribute(node3, "support", objectArray);
                arrayList.add(object4 + 1, node3);
                arrayList2.add(object4 + 1, new FixedBitSet(fixedBitSet2));
                continue block3;
            }
        }
        TreeUtilities.insureConsistency(simpleTree, simpleTree.getRoot());
        object = String.valueOf(d * 100.0);
        simpleTree.setAttribute(simpleTree.getRoot(), "treeName", "cons_" + (String)object + "_majRule");
        set = this.getSupport().keySet();
        Object[] objectArray3 = set.toArray(new FixedBitSet[0]);
        Arrays.sort(objectArray3);
        for (Object object2 : objectArray3) {
            if (((FixedBitSet)object2).cardinality() <= 1) continue;
            double d4 = 1.0 * this.getSupport().get(object2).getTreesWeightWithClade() / this.cumWeight;
            if (d4 < d3) {
                this.splitsOutFromConsensus.add((FixedBitSet)object2);
                continue;
            }
            this.splitsInConsensus.add((FixedBitSet)object2);
        }
        return simpleTree;
    }

    public String getTaxaHeader() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < this.numTaxa; ++n) {
            stringBuilder.append(String.valueOf(n + 1).charAt(0));
        }
        if (this.numTaxa >= 10) {
            stringBuilder.append('\n');
            stringBuilder.append(MyFormattedOutput.space(13, ' '));
            for (n = 9; n < this.numTaxa; ++n) {
                stringBuilder.append(String.valueOf(n + 1).charAt(1));
            }
        }
        if (this.numTaxa >= 100) {
            stringBuilder.append('\n');
            stringBuilder.append(MyFormattedOutput.space(103, ' '));
            for (n = 99; n < this.numTaxa; ++n) {
                stringBuilder.append(String.valueOf(n + 1).charAt(2));
            }
        }
        if (this.numTaxa >= 1000) {
            stringBuilder.append('\n');
            stringBuilder.append(MyFormattedOutput.space(1003, ' '));
            for (n = 999; n < this.numTaxa; ++n) {
                stringBuilder.append(String.valueOf(n + 1).charAt(3));
            }
        }
        return stringBuilder.toString();
    }

    public String getSetsIncluded() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("    ");
        stringBuilder.append(this.getTaxaHeader());
        stringBuilder.append('\n');
        for (FixedBitSet fixedBitSet : this.splitsInConsensus) {
            stringBuilder.append("    ").append(fixedBitSet.splitRepresentation()).append(" ( ").append(Utilities.roundDoubleTo(this.getCladeSupport().get(fixedBitSet), 5)).append(" )").append('\n');
        }
        return stringBuilder.toString();
    }

    public String getSetsNotIncluded() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("    ");
        stringBuilder.append(this.getTaxaHeader());
        stringBuilder.append('\n');
        for (FixedBitSet fixedBitSet : this.splitsOutFromConsensus) {
            stringBuilder.append("    ").append(fixedBitSet.splitRepresentation()).append(" ( ").append(Utilities.roundDoubleTo(this.getCladeSupport().get(fixedBitSet), 5)).append(" )").append('\n');
        }
        return stringBuilder.toString();
    }

    private BranchDistances getBranchDistances(int n) {
        BranchDistances branchDistances;
        switch (n) {
            case 1: {
                branchDistances = BranchDistances.WeightedAverage;
                break;
            }
            case 2: {
                branchDistances = BranchDistances.WeightedMedian;
                break;
            }
            default: {
                branchDistances = DEFAULT_BRANCH_DISTANCES;
            }
        }
        return branchDistances;
    }

    static class UnweightedTree
    extends WeightedTree {
        UnweightedTree(Tree tree) {
            super(tree, 1.0);
        }
    }

    static class WeightLengthPair
    implements Comparable<WeightLengthPair> {
        private double weight;
        private double branchLength;

        WeightLengthPair(double d, double d2) {
            this.weight = d;
            this.branchLength = d2;
        }

        @Override
        public int compareTo(WeightLengthPair weightLengthPair) {
            if (this.branchLength < weightLengthPair.branchLength) {
                return -1;
            }
            if (this.branchLength > weightLengthPair.branchLength) {
                return 1;
            }
            return 0;
        }
    }

    static final class Support {
        private int nTreesWithClade = 0;
        private double treesWeightWithClade = 0.0;
        private ArrayList<WeightLengthPair> branchLengths = new ArrayList();
        private double sumBranches = 0.0;

        public double getTreesWeightWithClade() {
            return this.treesWeightWithClade;
        }

        Support() {
        }

        public final void add(double d, double d2, double d3) {
            this.sumBranches += d2;
            this.branchLengths.add(new WeightLengthPair(d, d3));
            this.treesWeightWithClade += d;
            ++this.nTreesWithClade;
        }
    }

    private static enum BranchDistances {
        WeightedAverage{

            @Override
            public double build(List<WeightLengthPair> list) {
                double d = 0.0;
                double d2 = 0.0;
                for (WeightLengthPair weightLengthPair : list) {
                    d += weightLengthPair.branchLength * weightLengthPair.weight;
                    d2 += weightLengthPair.weight;
                }
                return d /= d2;
            }
        }
        ,
        WeightedMedian{

            @Override
            public double build(List<WeightLengthPair> list) {
                Collections.sort(list);
                double d = -1.0;
                double d2 = 0.0;
                for (WeightLengthPair weightLengthPair : list) {
                    d2 += weightLengthPair.weight;
                }
                double d3 = d2 / 2.0;
                double d4 = 0.0;
                for (WeightLengthPair weightLengthPair : list) {
                    if (!((d4 += weightLengthPair.weight) >= d3)) continue;
                    d = weightLengthPair.branchLength;
                    break;
                }
                return d;
            }
        };


        public abstract double build(List<WeightLengthPair> var1);
    }
}

