/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.tree;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import pal.io.FormattedOutput;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.ReadTree;
import pal.tree.SplitSystem;
import pal.tree.SplitUtils;
import pal.tree.Tree;
import pal.tree.TreeParseException;

public class TreeUtilities {
    public static final int DEFAULT_COLUMN_WIDTH = 70;
    public static final String TREE_WEIGHT_ATTRIBUTE = "weight";
    public static final String TREE_CLADE_SUPPORT_ATTRIBUTE = "support";
    public static final String TREE_NAME_ATTRIBUTE = "treeName";

    public static Tree readTree(String string) throws IOException, TreeParseException {
        ReadTree readTree;
        try {
            readTree = new ReadTree(string);
        }
        catch (TreeParseException treeParseException) {
            throw treeParseException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        return readTree;
    }

    public static double insureConsistency(Tree tree, Node node) {
        double d = TreeUtilities.safeNodeHeight(tree, node);
        if (node.isLeaf()) {
            return d;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = node.getChild(i);
            double d2 = TreeUtilities.insureConsistency(tree, node2);
            d = Math.max(d, d2);
        }
        node.setNodeHeight(d);
        return d;
    }

    public static int nodeDistance(Node node) {
        if (node.isLeaf()) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = node.getChild(i);
            n = Math.max(n, TreeUtilities.nodeDistance(node2));
        }
        return n + 1;
    }

    public static double safeNodeHeight(Tree tree, Node node) {
        if (node.getNodeHeight() > 0.0) {
            return node.getNodeHeight();
        }
        return TreeUtilities.nodeDistance(node);
    }

    private static void putCharAtLevel(PrintWriter printWriter, int n, char c, int[] nArray) {
        int n2 = nArray[n] - 1;
        for (int i = 0; i < n2; ++i) {
            printWriter.print(' ');
        }
        printWriter.print(c);
    }

    private static void printlnNodeWithNumberAndLabel(PrintWriter printWriter, Node node, int n, int n2, boolean[] blArray, int[] nArray) {
        int n3;
        for (n3 = 0; n3 < n - 1; ++n3) {
            if (blArray[n3]) {
                TreeUtilities.putCharAtLevel(printWriter, n3, '|', nArray);
                continue;
            }
            TreeUtilities.putCharAtLevel(printWriter, n3, ' ', nArray);
        }
        TreeUtilities.putCharAtLevel(printWriter, n - 1, '+', nArray);
        n3 = node.isLeaf() ? node.getNumber() + 1 : node.getNumber() + 1 + n2;
        String string = Integer.toString(n3);
        int n4 = nArray[n] - string.length();
        for (int i = 0; i < n4; ++i) {
            printWriter.print('-');
        }
        printWriter.print(string);
        if (node.isLeaf()) {
            printWriter.println(" " + node.getIdentifier());
        } else {
            if (!node.getIdentifier().equals(Identifier.ANONYMOUS)) {
                printWriter.print("(" + node.getIdentifier() + ")");
            }
            printWriter.println();
        }
    }

    private static void printNodeInASCII(PrintWriter printWriter, Node node, int n, int n2, int n3, int n4, boolean[] blArray, int[] nArray, double d, int n5) {
        nArray[n] = (int)(node.getBranchLength() * d);
        if (nArray[n] < n5) {
            nArray[n] = n5;
        }
        if (node.isLeaf()) {
            if (n2 == n3 - 1) {
                blArray[n - 1] = true;
            }
            TreeUtilities.printlnNodeWithNumberAndLabel(printWriter, node, n, n4, blArray, nArray);
            if (n2 == 0) {
                blArray[n - 1] = false;
            }
        } else {
            for (int i = node.getChildCount() - 1; i > -1; --i) {
                TreeUtilities.printNodeInASCII(printWriter, node.getChild(i), n + 1, i, node.getChildCount(), n4, blArray, nArray, d, n5);
                if (n2 == n3 - 1 && i == node.getChildCount() / 2) {
                    blArray[n - 1] = true;
                }
                if (i != 0) {
                    if (i == node.getChildCount() / 2) {
                        TreeUtilities.printlnNodeWithNumberAndLabel(printWriter, node, n, n4, blArray, nArray);
                    } else {
                        for (int j = 0; j < n + 1; ++j) {
                            if (blArray[j]) {
                                TreeUtilities.putCharAtLevel(printWriter, j, '|', nArray);
                                continue;
                            }
                            TreeUtilities.putCharAtLevel(printWriter, j, ' ', nArray);
                        }
                        printWriter.println();
                    }
                }
                if (n2 != 0 || i != node.getChildCount() / 2) continue;
                blArray[n - 1] = false;
            }
        }
    }

    public static void printASCII(Tree tree, PrintWriter printWriter) {
        int n;
        tree.createNodeList();
        int n2 = tree.getExternalNodeCount();
        int n3 = tree.getInternalNodeCount();
        int n4 = n3 + n2 - 1;
        boolean[] blArray = new boolean[n2];
        int[] nArray = new int[n2];
        int n5 = Integer.toString(n4).length() + 1;
        int n6 = 40;
        Node node = tree.getRoot();
        if (node.getNodeHeight() == 0.0) {
            NodeUtils.lengths2Heights(node);
        }
        double d = (double)n6 / node.getNodeHeight();
        for (n = 0; n < n2; ++n) {
            blArray[n] = false;
        }
        nArray[0] = 1;
        for (n = node.getChildCount() - 1; n > -1; --n) {
            TreeUtilities.printNodeInASCII(printWriter, node.getChild(n), 1, n, node.getChildCount(), n2, blArray, nArray, d, n5);
            if (n == 0) continue;
            TreeUtilities.putCharAtLevel(printWriter, 0, '|', nArray);
            printWriter.println();
        }
    }

    public static void printNH(PrintWriter printWriter, Tree tree, Node node, boolean bl, boolean bl2, boolean bl3) {
        if (!node.isLeaf()) {
            printWriter.print("(");
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (i != 0) {
                    printWriter.print(",");
                }
                TreeUtilities.printNH(printWriter, tree, node.getChild(i), bl, bl2, bl3);
            }
            printWriter.print(")");
        }
        if (!node.isRoot()) {
            if (node.isLeaf() || bl2) {
                String string = node.getIdentifier().toString();
                printWriter.print(string);
            }
            if (bl3 && tree.getAttribute(node, TREE_CLADE_SUPPORT_ATTRIBUTE) != null) {
                double d = (Double)tree.getAttribute(node, TREE_CLADE_SUPPORT_ATTRIBUTE);
                printWriter.printf(":" + FormattedOutput.getInstance().getDecimalString(d, 4), new Object[0]);
            }
            if (bl) {
                printWriter.printf(":" + FormattedOutput.getInstance().getDecimalString(node.getBranchLength(), 10), new Object[0]);
            }
        }
    }

    public static String toNewick(Tree tree, boolean bl, boolean bl2, boolean bl3) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        TreeUtilities.printNH(printWriter, tree, tree.getRoot(), bl, bl2, bl3);
        stringWriter.append(';');
        return stringWriter.toString();
    }

    public static double getEuclideanTreeDistance(Tree tree, Tree tree2) {
        double d;
        double d2;
        int n;
        double d3 = 0.0;
        int n2 = tree.getInternalNodeCount();
        if (n2 != tree2.getInternalNodeCount()) {
            throw new RuntimeException("Different number of internal nodes: " + tree.getInternalNodeCount() + " vs " + tree2.getInternalNodeCount());
        }
        int n3 = tree.getExternalNodeCount();
        if (n3 != tree2.getExternalNodeCount()) {
            throw new RuntimeException("Different number of external nodes: " + tree.getInternalNodeCount() + " vs " + tree2.getInternalNodeCount());
        }
        for (n = 0; n < n2; ++n) {
            d2 = tree.getInternalNode(n).getBranchLength();
            d = tree2.getInternalNode(n).getBranchLength();
            d3 += (d2 - d) * (d2 - d);
        }
        for (n = 0; n < n3; ++n) {
            d2 = tree.getExternalNode(n).getBranchLength();
            d = tree2.getExternalNode(n).getBranchLength();
            d3 += (d2 - d) * (d2 - d);
        }
        return Math.sqrt(d3);
    }

    public static double getRobinsonFouldsTreeDistance(Tree tree, Tree tree2) {
        int n;
        SplitSystem splitSystem = SplitUtils.getSplits(tree);
        IdGroup idGroup = splitSystem.getIdGroup();
        SplitSystem splitSystem2 = SplitUtils.getSplits(idGroup, tree2);
        if (splitSystem.getLabelCount() != splitSystem2.getLabelCount()) {
            throw new IllegalArgumentException("Number of labels must be the same!");
        }
        int n2 = splitSystem.getSplitCount();
        int n3 = splitSystem2.getSplitCount();
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (splitSystem2.hasSplit(splitSystem.getSplit(n))) continue;
            ++n4;
        }
        n = 0;
        for (int i = 0; i < n3; ++i) {
            if (splitSystem.hasSplit(splitSystem2.getSplit(i))) continue;
            ++n;
        }
        return (double)n + (double)n4;
    }
}

