/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.utilities;

import java.util.Arrays;

public class FixedBitSet
implements Comparable<FixedBitSet> {
    int[] bits;
    int size;
    private static final int ADDRESS_BITS_PER_UNIT = 5;
    private static final int BITS_PER_UNIT = 32;
    private static final int BIT_INDEX_MASK = 31;
    private static final byte[] firstBitLocation = new byte[]{-1, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    private static int unitIndex(int n) {
        return n >> 5;
    }

    private int countBits(int n) {
        int n2 = 0;
        while (n != 0) {
            n &= n - 1;
            ++n2;
        }
        return n2;
    }

    private static int bit(int n) {
        return 1 << (n & 0x1F);
    }

    public FixedBitSet(int n) {
        this.size = n;
        this.bits = new int[FixedBitSet.unitIndex(n - 1) + 1];
    }

    public FixedBitSet(FixedBitSet fixedBitSet) {
        this.bits = (int[])fixedBitSet.bits.clone();
        this.size = fixedBitSet.size;
    }

    public void set(int n) {
        int n2;
        int n3 = n2 = FixedBitSet.unitIndex(n);
        this.bits[n3] = this.bits[n3] | FixedBitSet.bit(n);
    }

    public void clear(int n) {
        int n2;
        int n3 = n2 = FixedBitSet.unitIndex(n);
        this.bits[n3] = this.bits[n3] & ~FixedBitSet.bit(n);
    }

    public boolean setInclusion(FixedBitSet fixedBitSet) {
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == (this.bits[i] & fixedBitSet.bits[i])) continue;
            return false;
        }
        return true;
    }

    public void union(FixedBitSet fixedBitSet) {
        for (int i = 0; i < Math.min(this.bits.length, fixedBitSet.bits.length); ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | fixedBitSet.bits[i];
        }
    }

    public void intersect(FixedBitSet fixedBitSet) {
        for (int i = 0; i < Math.min(this.bits.length, fixedBitSet.bits.length); ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & fixedBitSet.bits[i];
        }
    }

    public void setMinus(FixedBitSet fixedBitSet) {
        for (int i = 0; i < Math.min(this.bits.length, fixedBitSet.bits.length); ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & ~fixedBitSet.bits[i];
        }
    }

    public int intersectCardinality(FixedBitSet fixedBitSet) {
        int n = 0;
        for (int i = 0; i < Math.min(this.bits.length, fixedBitSet.bits.length); ++i) {
            n += this.countBits(this.bits[i] & fixedBitSet.bits[i]);
        }
        return n;
    }

    public static FixedBitSet complement(FixedBitSet fixedBitSet) {
        FixedBitSet fixedBitSet2 = new FixedBitSet(fixedBitSet);
        fixedBitSet2.complement();
        return fixedBitSet2;
    }

    public void complement() {
        int n;
        for (n = 0; n < this.bits.length - 1; ++n) {
            this.bits[n] = ~this.bits[n];
        }
        this.bits[n] = ~this.bits[n];
        int n2 = FixedBitSet.bit(this.size) - 1;
        if (n2 != 0) {
            int n3 = n;
            this.bits[n3] = this.bits[n3] & n2;
        }
    }

    private int firstOnBit(int n) {
        for (int i = 0; i < 4; ++i) {
            char c = (char)(n & 0xFF);
            if (c != '\u0000') {
                return 8 * i + firstBitLocation[c];
            }
            n >>= 8;
        }
        return -1;
    }

    public int nextOnBit(int n) {
        int n2;
        int n3 = FixedBitSet.unitIndex(n);
        int n4 = this.bits[n3] >> (n2 = n & 0x1F);
        if (n4 == 0) {
            n2 = 0;
            while (n4 == 0 && n3 < this.bits.length - 1) {
                n4 = this.bits[++n3];
            }
        }
        if (n4 == 0) {
            return -1;
        }
        return n3 * 32 + (n2 += this.firstOnBit(n4));
    }

    public int cardinality() {
        int n = 0;
        for (int n2 : this.bits) {
            n += this.countBits(n2);
        }
        return n;
    }

    public boolean contains(int n) {
        int n2 = FixedBitSet.unitIndex(n);
        return (this.bits[n2] & FixedBitSet.bit(n)) != 0;
    }

    public int hashCode() {
        int n = 0;
        for (int n2 : this.bits) {
            n ^= n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof FixedBitSet) {
            FixedBitSet fixedBitSet = (FixedBitSet)object;
            return fixedBitSet.size == this.size && Arrays.equals(this.bits, fixedBitSet.bits);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        for (int i = 0; i < this.size; ++i) {
            if (!this.contains(i)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("," + i);
                continue;
            }
            stringBuilder.append("" + i);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public String splitRepresentation() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            if (this.contains(i)) {
                stringBuilder.append("*");
                continue;
            }
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(FixedBitSet fixedBitSet) {
        int n;
        int n2;
        if (this.size < fixedBitSet.size) {
            n2 = this.size;
            n = -1;
        } else {
            n2 = fixedBitSet.size;
            n = this.size == fixedBitSet.size ? 0 : 1;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.contains(i) && !fixedBitSet.contains(i)) {
                return -1;
            }
            if (this.contains(i) || !fixedBitSet.contains(i)) continue;
            return 1;
        }
        return n;
    }
}

