/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.BxorByte;
import mpi.BxorChar;
import mpi.BxorInt;
import mpi.BxorLong;
import mpi.BxorShort;
import mpi.Datatype;
import mpi.MPIException;
import mpi.Op;
import mpi.OpWorker;

public class BxorWorker
implements OpWorker {
    BxorWorker() {
    }

    @Override
    public Op getWorker(Datatype datatype) throws MPIException {
        switch (datatype.baseType) {
            case 1: {
                return new BxorByte();
            }
            case 2: {
                return new BxorChar();
            }
            case 3: {
                return new BxorShort();
            }
            case 4: {
                throw new MPIException("MPI.BXOR is not valid for MPI.BOOLEAN");
            }
            case 5: {
                return new BxorInt();
            }
            case 6: {
                return new BxorLong();
            }
            case 7: {
                throw new MPIException("MPI.BXOR is not valid for MPI.FLOAT");
            }
            case 8: {
                throw new MPIException("MPI.BXOR is not valid for MPI.DOUBLE");
            }
        }
        return null;
    }
}

