/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.nio.ByteBuffer;
import mpi.Datatype;
import mpi.GenericPacker;
import mpi.MPI;
import mpi.MPIException;
import mpi.MultistridedPacker;
import mpi.MultistridedPackerFactory;
import mpi.Packer;
import mpi.SimplePacker;
import mpi.SimplePackerFactory;
import mpjbuf.Buffer;
import mpjbuf.BufferFactory;
import mpjbuf.NIOBuffer;
import mpjbuf.RawBuffer;

public class Contiguous
extends Datatype {
    private int count;
    private int oldSize;
    private Datatype oldType;

    Contiguous(int count, Datatype oldType) throws MPIException {
        this.bufferType = oldType.bufferType;
        if (count < 0) {
            throw new MPIException("Count argument of Contiguous must be non-negative");
        }
        this.oldType = oldType;
        this.count = count;
        this.baseType = oldType.baseType;
        this.oldSize = oldType.Size();
        this.size = count * this.oldSize;
        this.byteSize = count * oldType.byteSize;
        this.computeBounds();
    }

    private void computeBounds() {
        this.ubSet = this.count > 0 && this.oldType.ubSet;
        this.lbSet = this.count > 0 && this.oldType.lbSet;
        this.lb = Integer.MAX_VALUE;
        this.ub = Integer.MIN_VALUE;
        this.extent = 0;
        if ((this.oldSize != 0 || this.oldType.lbSet || this.oldType.ubSet) && this.count > 0) {
            int oldExtent = this.oldType.extent;
            this.extent = this.count * oldExtent;
            this.lb = this.oldType.lb;
            this.ub = this.lb + this.extent;
        }
    }

    @Override
    Buffer createWriteBuffer(ByteBuffer slicedBuffer, int messageSize) {
        return new Buffer(new NIOBuffer(messageSize, slicedBuffer), MPI.BSEND_OVERHEAD, messageSize);
    }

    @Override
    Buffer createWriteBuffer(int count) throws MPIException {
        int capacity = this.packedSize(count) + MPI.SEND_OVERHEAD;
        int offset = MPI.SEND_OVERHEAD;
        RawBuffer rawBuffer = BufferFactory.create(capacity);
        Buffer wBuffer = new Buffer(rawBuffer, offset, capacity);
        try {
            wBuffer.putSectionHeader(this.bufferType);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        return wBuffer;
    }

    @Override
    Buffer createReadBuffer(int count) {
        int capacity = this.packedSize(count) + MPI.RECV_OVERHEAD;
        int offset = MPI.RECV_OVERHEAD;
        RawBuffer rawBuffer = BufferFactory.create(capacity);
        Buffer mpjbuf = new Buffer(rawBuffer, offset, capacity);
        return mpjbuf;
    }

    @Override
    int packedSize(int count) {
        int dataSize = count * this.byteSize;
        int totalSize = 0;
        int sectionHeader = 8;
        totalSize = sectionHeader + dataSize;
        int padding = 0;
        if (totalSize % 8 != 0) {
            padding = totalSize % 8;
        }
        return totalSize + padding;
    }

    @Override
    void setPacker() {
        Packer oldPacker = this.oldType.getPacker();
        if (oldPacker instanceof SimplePacker) {
            int oldCount = ((SimplePacker)oldPacker).numEls;
            int newCount = this.count * oldCount;
            this.packer = SimplePackerFactory.create(newCount, this.baseType);
        } else if (oldPacker instanceof MultistridedPacker) {
            int i;
            MultistridedPacker multiOldPacker = (MultistridedPacker)oldPacker;
            int oldRank = multiOldPacker.rank;
            int[] oldIndexes = multiOldPacker.indexes;
            int oldExtent = multiOldPacker.rank;
            int rank = oldRank + 1;
            int[] indexes = new int[2 * rank];
            for (i = 0; i < oldRank; ++i) {
                indexes[i] = oldIndexes[i];
            }
            indexes[oldRank] = this.count;
            for (i = 0; i < oldRank; ++i) {
                indexes[rank + i] = oldIndexes[oldRank + i];
            }
            indexes[rank + oldRank] = oldExtent;
            this.packer = MultistridedPackerFactory.create(rank, indexes, this.extent, this.size, this.baseType);
        } else {
            this.packer = new ContiguousPacker(this.count, this.oldType);
        }
    }

    private class ContiguousPacker
    extends GenericPacker {
        Packer itemPacker;
        int itemLen;
        int itemSize;

        ContiguousPacker(int count, Datatype oldType) {
            super(Contiguous.this.extent, Contiguous.this.size);
            this.itemPacker = oldType.getPacker();
            this.itemLen = oldType.extent;
            this.itemSize = oldType.size;
        }

        @Override
        public void pack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
            for (int i = 0; i < Contiguous.this.count; ++i) {
                this.itemPacker.pack(mpjbuf, buf, offset);
                offset += this.itemLen;
            }
        }

        @Override
        public void unpack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
            for (int i = 0; i < Contiguous.this.count; ++i) {
                this.itemPacker.unpack(mpjbuf, buf, offset);
                offset += this.itemLen;
            }
        }

        @Override
        public void unpackPartial(Buffer mpjbuf, int length, Object buf, int offset) throws MPIException {
            int numFull = length / this.itemSize;
            for (int i = 0; i < numFull; ++i) {
                this.itemPacker.unpack(mpjbuf, buf, offset);
                offset += this.itemLen;
            }
            int residue = length - numFull * this.itemSize;
            if (residue > 0) {
                this.itemPacker.unpackPartial(mpjbuf, residue, buf, offset);
            }
        }
    }
}

