/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.GraphParms;
import mpi.Intracomm;
import mpi.MPI;
import mpi.MPIException;
import mpjdev.Comm;
import mpjdev.Group;

public class Graphcomm
extends Intracomm {
    GraphParms graphParms = null;

    Graphcomm(int[] index, int[] edges, boolean reorder, Comm mpjdevComm, Group group) throws MPIException {
        super(mpjdevComm, group);
        int rank = group.rank();
        this.graphParms = new GraphParms();
        this.graphParms.index = new int[index.length];
        System.arraycopy(index, 0, this.graphParms.index, 0, index.length);
        this.graphParms.edges = new int[edges.length];
        System.arraycopy(edges, 0, this.graphParms.edges, 0, edges.length);
    }

    @Override
    public Object clone() throws MPIException {
        return this.Create_graph(this.graphParms.index, this.graphParms.edges, false);
    }

    public GraphParms Get() throws MPIException {
        return this.graphParms;
    }

    public int[] Neighbours(int rank) throws MPIException {
        int nnbrs = this.graphParms.index[rank];
        int i = 0;
        int p = 0;
        if (rank > 0) {
            i = this.graphParms.index[rank - 1];
            nnbrs -= i;
            p = i;
        }
        int[] nbrs = new int[nnbrs];
        i = 0;
        while (i < nnbrs) {
            nbrs[i] = this.graphParms.edges[p];
            ++i;
            ++p;
        }
        return nbrs;
    }

    public int Map(int[] index, int[] edges) throws MPIException {
        int myrank = this.group.Rank();
        return myrank < 0 || myrank >= index.length ? -1 : myrank;
    }

    @Override
    public int Topo_test() throws MPIException {
        return MPI.GRAPH;
    }
}

