/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Datatype;
import mpi.MPIException;
import mpi.MinByte;
import mpi.MinChar;
import mpi.MinDouble;
import mpi.MinFloat;
import mpi.MinInt;
import mpi.MinLong;
import mpi.MinShort;
import mpi.Op;
import mpi.OpWorker;

public class MinWorker
implements OpWorker {
    MinWorker() {
    }

    @Override
    public Op getWorker(Datatype datatype) throws MPIException {
        switch (datatype.baseType) {
            case 1: {
                return new MinByte();
            }
            case 2: {
                return new MinChar();
            }
            case 3: {
                return new MinShort();
            }
            case 4: {
                throw new MPIException("MPI.MIN is invalid for MPI.BOOLEAN");
            }
            case 5: {
                return new MinInt();
            }
            case 6: {
                return new MinLong();
            }
            case 7: {
                return new MinFloat();
            }
            case 8: {
                return new MinDouble();
            }
        }
        return null;
    }
}

