/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.MPIException;
import mpi.Packer;
import mpjbuf.Buffer;

public abstract class MultistridedPacker
implements Packer {
    int rank;
    int[] indexes;
    int extent;
    int size;

    public MultistridedPacker(int rank, int[] indexes, int extent, int size) {
        this.rank = rank;
        this.indexes = indexes;
        this.extent = extent;
        this.size = size;
    }

    @Override
    public void unpack(Buffer mpjbuf, int length, Object buf, int offset, int count) throws MPIException {
        if (count * this.size < length) {
            throw new MPIException("Error in GenericPacker: count*size <" + count * this.size + " is less than length <" + length + ">");
        }
        int numFull = length / this.size;
        this.unpack(mpjbuf, buf, offset, numFull);
        int residue = length - numFull * this.size;
        if (residue > 0) {
            this.unpackPartial(mpjbuf, residue, buf, offset);
        }
    }
}

