/*
 * Decompiled with CFR 0.152.
 */
package mpi;

public class ProcTree {
    public static final int PROCTREE_A = 4;
    public int numChildren = -1;
    public int[] child = new int[4];
    public int parent;
    public int root;
    public boolean isRoot = false;

    public ProcTree() {
        for (int i = 0; i < this.child.length; ++i) {
            this.child[i] = -1;
        }
        this.root = -1;
        this.parent = -1;
    }

    public static void main(String[] args) {
        int i;
        ProcTree procTree = null;
        if (args.length < 3) {
            System.out.println("three arguments ...");
            System.out.println("rank, size, root");
            return;
        }
        int index = Integer.parseInt(args[0]);
        int extent = Integer.parseInt(args[1]);
        int root = Integer.parseInt(args[2]);
        procTree = new ProcTree();
        int places = 4 * index;
        for (i = 1; i <= 4; ++i) {
            int ch = 4 * index + i + root;
            System.out.println("places " + ++places);
            ch %= extent;
            if (places < extent) {
                System.out.println("ch <" + i + ">" + "=<" + ch + ">");
                System.out.println("adding to the tree at index <" + (i - 1) + ">\n\n");
                procTree.child[i - 1] = ch;
                ++procTree.numChildren;
                continue;
            }
            System.out.println("not adding to the tree");
        }
        System.out.println("procTree.numChildren <" + procTree.numChildren + ">");
        if (index == root) {
            procTree.isRoot = true;
        } else {
            int pr;
            procTree.isRoot = false;
            procTree.parent = pr = (index - 1) / 4;
        }
        procTree.root = root;
        i = 0;
        while (true) {
            if (i >= 4) break;
            System.out.print(" child[" + i + "]=>" + procTree.child[i]);
            ++i;
        }
        System.out.println("  ------- End --------");
    }
}

