/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Datatype;
import mpi.MPIException;
import mpi.Op;
import mpi.OpWorker;
import mpi.ProdByte;
import mpi.ProdChar;
import mpi.ProdDouble;
import mpi.ProdFloat;
import mpi.ProdInt;
import mpi.ProdLong;
import mpi.ProdShort;

public class ProdWorker
implements OpWorker {
    ProdWorker() {
    }

    @Override
    public Op getWorker(Datatype datatype) throws MPIException {
        switch (datatype.baseType) {
            case 1: {
                return new ProdByte();
            }
            case 2: {
                return new ProdChar();
            }
            case 3: {
                return new ProdShort();
            }
            case 4: {
                throw new MPIException("MPI.PROD is invalid for MPI.BOOLEAN");
            }
            case 5: {
                return new ProdInt();
            }
            case 6: {
                return new ProdLong();
            }
            case 7: {
                return new ProdFloat();
            }
            case 8: {
                return new ProdDouble();
            }
        }
        return null;
    }
}

