/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.MPIException;
import mpi.SimplePacker;
import mpjbuf.Buffer;

public class SimplePackerLong
extends SimplePacker {
    public SimplePackerLong(int numEls) {
        super(numEls);
    }

    @Override
    public void pack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
        try {
            mpjbuf.write((long[])buf, offset, this.numEls);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    @Override
    public void unpack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
        try {
            mpjbuf.read((long[])buf, offset, this.numEls);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    @Override
    public void unpackPartial(Buffer mpjbuf, int length, Object buf, int offset) throws MPIException {
        try {
            mpjbuf.read((long[])buf, offset, length);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    @Override
    public void pack(Buffer mpjbuf, Object buf, int offset, int count) throws MPIException {
        try {
            mpjbuf.write((long[])buf, offset, count * this.numEls);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    @Override
    public void unpack(Buffer mpjbuf, Object buf, int offset, int count) throws MPIException {
        try {
            mpjbuf.read((long[])buf, offset, count * this.numEls);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    @Override
    public void unpack(Buffer mpjbuf, int length, Object buf, int offset, int count) throws MPIException {
        if (count * this.numEls < length) {
            throw new MPIException("Error in SimplePacker : count <" + count * this.numEls + "> is less than length <" + length + ">");
        }
        try {
            mpjbuf.read((long[])buf, offset, length);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }
}

