/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.nio.ByteBuffer;
import mpi.Datatype;
import mpi.GenericPacker;
import mpi.MPI;
import mpi.MPIException;
import mpi.Packer;
import mpjbuf.Buffer;
import mpjbuf.BufferFactory;
import mpjbuf.NIOBuffer;
import mpjbuf.RawBuffer;

public class Struct
extends Datatype {
    private int[] blockLengths;
    private int[] displacements;
    private Datatype[] oldTypes;
    private boolean unitsOfOldExtent;
    private boolean unitBlocks;
    private Datatype oldType;
    private int numBlocks;

    public Struct(int[] array_of_blocklengths, int[] array_of_displacements, Datatype[] array_of_types) throws MPIException {
        int i;
        this.numBlocks = array_of_blocklengths.length;
        this.blockLengths = new int[this.numBlocks];
        this.displacements = new int[this.numBlocks];
        this.oldTypes = new Datatype[this.numBlocks];
        for (i = 0; i < this.numBlocks; ++i) {
            this.blockLengths[i] = array_of_blocklengths[i];
            this.displacements[i] = array_of_displacements[i];
            this.oldTypes[i] = array_of_types[i];
        }
        this.baseType = -1;
        for (i = 0; i < this.numBlocks; ++i) {
            Datatype oldType = this.oldTypes[i];
            int oldBaseType = oldType.baseType;
            if (oldBaseType == -1) continue;
            if (this.baseType == -1) {
                this.baseType = oldBaseType;
                this.bufferType = oldType.bufferType;
            } else if (oldBaseType != this.baseType) {
                throw new MPIException("Base types of all component types in a Struct must agree");
            }
            this.size += this.blockLengths[i] * oldType.Size();
        }
        this.computeBounds();
    }

    private void computeBounds() throws MPIException {
        this.ubSet = false;
        this.lbSet = false;
        this.lb = Integer.MAX_VALUE;
        this.ub = Integer.MIN_VALUE;
        int trueLb = Integer.MAX_VALUE;
        int trueUb = Integer.MIN_VALUE;
        this.extent = 0;
        for (int i = 0; i < this.numBlocks; ++i) {
            int blockLen = this.blockLengths[i];
            if (blockLen < 0) {
                throw new MPIException("All block-lengths for Struct must be non-negative");
            }
            if (blockLen <= 0) continue;
            Datatype oldtype = this.oldTypes[i];
            int oldBaseType = oldtype.baseType;
            int oldSize = oldtype.Size();
            boolean oldUbSet = oldtype.ubSet;
            boolean oldLbSet = oldtype.lbSet;
            if (oldSize == 0 && !oldLbSet && !oldUbSet) continue;
            int oldExtent = oldtype.Extent();
            int max_ub = this.displacements[i] + (blockLen - 1) * oldExtent + oldtype.ub;
            if (oldUbSet) {
                this.ubSet = true;
                this.ub = max_ub;
            } else if (max_ub > trueUb) {
                trueUb = max_ub;
                this.ub = max_ub > this.displacements[i] ? max_ub : this.displacements[i];
            }
            int min_lb = this.displacements[i] + oldtype.lb;
            if (oldLbSet) {
                this.lbSet = true;
                this.lb = min_lb;
                continue;
            }
            if (min_lb >= trueLb) continue;
            trueLb = min_lb;
            this.lb = min_lb < this.displacements[i] ? min_lb : this.displacements[i];
        }
        if (this.lb != Integer.MAX_VALUE || this.ub != Integer.MIN_VALUE) {
            this.extent = this.ub - this.lb;
        }
    }

    @Override
    Buffer createWriteBuffer(ByteBuffer slicedBuffer, int messageSize) {
        return new Buffer(new NIOBuffer(messageSize, slicedBuffer), MPI.BSEND_OVERHEAD, messageSize);
    }

    @Override
    Buffer createWriteBuffer(int count) throws MPIException {
        int capacity = this.packedSize(count) + MPI.SEND_OVERHEAD;
        int offset = MPI.SEND_OVERHEAD;
        RawBuffer rawBuffer = BufferFactory.create(capacity);
        Buffer wBuffer = new Buffer(rawBuffer, offset, capacity);
        try {
            wBuffer.putSectionHeader(this.bufferType);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        return wBuffer;
    }

    @Override
    Buffer createReadBuffer(int count) {
        int capacity = this.packedSize(count) + MPI.RECV_OVERHEAD;
        int offset = MPI.RECV_OVERHEAD;
        RawBuffer rawBuffer = BufferFactory.create(capacity);
        Buffer mpjbuf = new Buffer(rawBuffer, offset, capacity);
        return mpjbuf;
    }

    @Override
    int packedSize(int count) {
        int sectionHeader = 8;
        for (int i = 0; i < this.blockLengths.length; ++i) {
            int blockLen = this.blockLengths[i];
            Datatype oldtype = this.oldTypes[i];
            int sectionSize = 0;
            sectionSize = blockLen * oldtype.byteSize;
            this.byteSize += sectionSize;
        }
        return this.byteSize * count + sectionHeader;
    }

    @Override
    void setPacker() {
        this.packer = new StructPacker();
    }

    private class StructPacker
    extends GenericPacker {
        StructPacker() {
            super(Struct.this.extent, Struct.this.size);
        }

        @Override
        public void pack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
            int numBlocks = Struct.this.displacements.length;
            for (int i = 0; i < numBlocks; ++i) {
                int boffset = offset + Struct.this.displacements[i];
                int blockLen = Struct.this.blockLengths[i];
                Datatype oldtype = Struct.this.oldTypes[i];
                Packer itemPacker = oldtype.getPacker();
                int itemExtent = oldtype.extent;
                for (int j = 0; j < blockLen; ++j) {
                    itemPacker.pack(mpjbuf, buf, boffset);
                    boffset += itemExtent;
                }
            }
        }

        @Override
        public void unpack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
            int numBlocks = Struct.this.displacements.length;
            for (int i = 0; i < numBlocks; ++i) {
                int boffset = offset + Struct.this.displacements[i];
                int blockLen = Struct.this.blockLengths[i];
                Datatype oldtype = Struct.this.oldTypes[i];
                Packer itemPacker = oldtype.getPacker();
                int itemExtent = oldtype.extent;
                for (int j = 0; j < blockLen; ++j) {
                    itemPacker.unpack(mpjbuf, buf, boffset, itemExtent);
                    boffset += itemExtent;
                }
                if (oldtype.bufferType != null) continue;
                System.out.println("bufferType is null in createWriteBuffer");
            }
        }

        @Override
        public void unpackPartial(Buffer mpjbuf, int length, Object buf, int offset) throws MPIException {
            int numBlocks = Struct.this.displacements.length;
            int residue = length;
            int boffset = 0;
            Datatype oldtype = null;
            for (int i = 0; i < numBlocks; ++i) {
                boffset = offset + Struct.this.displacements[i];
                int blockLen = Struct.this.blockLengths[i];
                oldtype = Struct.this.oldTypes[i];
                int blockSize = blockLen * oldtype.size;
                if (residue < blockSize) break;
                Packer itemPacker = oldtype.getPacker();
                int itemLen = oldtype.extent;
                for (int j = 0; j < blockLen; ++j) {
                    itemPacker.unpack(mpjbuf, buf, boffset);
                    boffset += itemLen;
                }
                residue -= blockSize;
            }
            int remFull = residue / oldtype.size;
            for (int j = 0; j < remFull; ++j) {
                Packer itemPacker = oldtype.getPacker();
                int itemLen = oldtype.extent;
                itemPacker.unpack(mpjbuf, buf, boffset);
                boffset += itemLen;
            }
            Packer itemPacker = oldtype.getPacker();
            if ((residue -= remFull * oldtype.size) > 0) {
                itemPacker.unpackPartial(mpjbuf, residue, buf, boffset);
            }
        }
    }
}

