/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.nio.ByteBuffer;
import mpi.Datatype;
import mpi.GenericPacker;
import mpi.MPI;
import mpi.MPIException;
import mpi.MultistridedPacker;
import mpi.MultistridedPackerFactory;
import mpi.Packer;
import mpi.SimplePacker;
import mpjbuf.Buffer;
import mpjbuf.BufferFactory;
import mpjbuf.NIOBuffer;
import mpjbuf.RawBuffer;

public class Vector
extends Datatype {
    private int count;
    private int blockLength;
    private int stride;
    private boolean unitsOfOldExtent;
    private Datatype oldType;
    private int realStride;

    public Vector(int count, int blockLength, int stride, Datatype oldType, boolean unitsOfOldExtent) throws MPIException {
        if (count < 0) {
            throw new MPIException("count argument of Vector or Hvector  must be non-negative");
        }
        if (blockLength < 0) {
            throw new MPIException("Block-length argument of Vector or Hvector must be non-negative");
        }
        this.bufferType = oldType.bufferType;
        this.oldType = oldType;
        this.count = count;
        this.blockLength = blockLength;
        this.stride = stride;
        int oldExtent = oldType.extent;
        this.realStride = stride;
        if (unitsOfOldExtent) {
            this.realStride *= oldExtent;
        }
        this.baseType = oldType.baseType;
        int oldSize = oldType.Size();
        int repetitions = count * blockLength;
        this.size = repetitions * oldSize;
        this.byteSize = repetitions * oldType.byteSize;
        this.computeBounds(oldSize, repetitions);
    }

    private void computeBounds(int oldSize, int repetitions) {
        this.ubSet = repetitions > 0 && this.oldType.ubSet;
        this.lbSet = repetitions > 0 && this.oldType.lbSet;
        this.lb = Integer.MAX_VALUE;
        this.ub = Integer.MIN_VALUE;
        this.extent = 0;
        if ((oldSize != 0 || this.oldType.lbSet || this.oldType.ubSet) && this.count > 0 && this.blockLength > 0) {
            int oldExtent = this.oldType.extent;
            if (this.realStride > 0) {
                this.ub = this.realStride * (this.count - 1) + (this.blockLength - 1) * oldExtent + this.oldType.ub;
                this.lb = this.oldType.lb;
            } else {
                this.ub = (this.blockLength - 1) * oldExtent + this.oldType.ub;
                this.lb = this.realStride * (this.count - 1) + this.oldType.lb;
            }
            this.extent = this.ub - this.lb;
        }
    }

    @Override
    Buffer createWriteBuffer(int count) throws MPIException {
        int capacity = this.packedSize(count) + MPI.SEND_OVERHEAD;
        int offset = MPI.SEND_OVERHEAD;
        RawBuffer rawBuffer = BufferFactory.create(capacity);
        Buffer wBuffer = new Buffer(rawBuffer, offset, capacity);
        try {
            wBuffer.putSectionHeader(this.bufferType);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        return wBuffer;
    }

    @Override
    Buffer createWriteBuffer(ByteBuffer slicedBuffer, int messageSize) {
        return new Buffer(new NIOBuffer(messageSize, slicedBuffer), MPI.BSEND_OVERHEAD, messageSize);
    }

    @Override
    Buffer createReadBuffer(int count) {
        int capacity = this.packedSize(count) + MPI.RECV_OVERHEAD;
        int offset = MPI.RECV_OVERHEAD;
        RawBuffer rawBuffer = BufferFactory.create(capacity);
        Buffer mpjbuf = new Buffer(rawBuffer, offset, capacity);
        return mpjbuf;
    }

    @Override
    int packedSize(int count) {
        int dataSize = count * this.byteSize;
        int totalSize = 0;
        int sectionHeader = 8;
        totalSize = sectionHeader + dataSize;
        int padding = 0;
        if (totalSize % 8 != 0) {
            padding = totalSize % 8;
        }
        return totalSize + padding;
    }

    @Override
    void setPacker() {
        Packer oldPacker = this.oldType.getPacker();
        if (oldPacker instanceof SimplePacker) {
            int oldCount = ((SimplePacker)oldPacker).numEls;
            int newCount = this.blockLength * oldCount;
            int[] indexes = new int[]{newCount, this.count, 1, this.realStride};
            this.packer = MultistridedPackerFactory.create(2, indexes, this.extent, this.size, this.baseType);
        } else if (oldPacker instanceof MultistridedPacker) {
            int[] indexes;
            int rank;
            MultistridedPacker multiOldPacker = (MultistridedPacker)oldPacker;
            int oldRank = multiOldPacker.rank;
            int[] oldIndexes = multiOldPacker.indexes;
            if (this.blockLength == 1) {
                int i;
                rank = oldRank + 1;
                indexes = new int[2 * rank];
                for (i = 0; i < oldRank; ++i) {
                    indexes[i] = oldIndexes[i];
                }
                indexes[oldRank] = this.count;
                for (i = 0; i < oldRank; ++i) {
                    indexes[rank + i] = oldIndexes[oldRank + i];
                }
                indexes[rank + oldRank] = this.realStride;
            } else {
                int i;
                rank = oldRank + 2;
                indexes = new int[2 * rank];
                for (i = 0; i < oldRank; ++i) {
                    indexes[i] = oldIndexes[i];
                }
                indexes[oldRank] = this.blockLength;
                indexes[oldRank + 1] = this.count;
                for (i = 0; i < oldRank; ++i) {
                    indexes[rank + i] = oldIndexes[oldRank + i];
                }
                indexes[rank + oldRank] = this.oldType.extent;
                indexes[rank + oldRank + 1] = this.realStride;
            }
            this.packer = MultistridedPackerFactory.create(rank, indexes, this.extent, this.size, this.baseType);
        } else {
            this.packer = new VectorPacker();
        }
    }

    private class VectorPacker
    extends GenericPacker {
        Packer itemPacker;
        int itemExtent;
        int itemSize;

        VectorPacker() {
            super(Vector.this.extent, Vector.this.size);
            this.itemPacker = Vector.this.oldType.getPacker();
            this.itemExtent = ((Vector)Vector.this).oldType.extent;
            this.itemSize = ((Vector)Vector.this).oldType.size;
        }

        @Override
        public void pack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
            for (int i = 0; i < Vector.this.count; ++i) {
                int boffset = offset;
                for (int j = 0; j < Vector.this.blockLength; ++j) {
                    this.itemPacker.pack(mpjbuf, buf, boffset);
                    boffset += this.itemExtent;
                }
                offset += Vector.this.realStride;
            }
        }

        @Override
        public void unpack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
            for (int i = 0; i < Vector.this.count; ++i) {
                int boffset = offset;
                for (int j = 0; j < Vector.this.blockLength; ++j) {
                    this.itemPacker.unpack(mpjbuf, buf, boffset);
                    boffset += this.itemExtent;
                }
                offset += Vector.this.realStride;
            }
        }

        @Override
        public void unpackPartial(Buffer mpjbuf, int length, Object buf, int offset) throws MPIException {
            int numFull = length / this.itemSize;
            int numBlocks = numFull / Vector.this.blockLength;
            for (int i = 0; i < numBlocks; ++i) {
                int boffset = offset;
                for (int j = 0; j < Vector.this.blockLength; ++j) {
                    this.itemPacker.unpack(mpjbuf, buf, boffset);
                    boffset += this.itemExtent;
                }
                offset += Vector.this.realStride;
            }
            int remFull = numFull - numBlocks * Vector.this.blockLength;
            for (int j = 0; j < remFull; ++j) {
                this.itemPacker.unpack(mpjbuf, buf, offset);
                offset += this.itemExtent;
            }
            int residue = length - numFull * this.itemSize;
            if (residue > 0) {
                this.itemPacker.unpackPartial(mpjbuf, residue, buf, offset);
            }
        }
    }
}

