/*
 * Decompiled with CFR 0.152.
 */
package mpjbuf;

public class CustomMath {
    private static double invln2 = 1.0 / Math.log(2.0);

    public static int widthInBits1(int n) {
        if (n < 0) {
            return 32;
        }
        if (n > 0x3FFFFFFF) {
            return 31;
        }
        return (int)Math.ceil(Math.log(n + 1) * invln2);
    }

    public static final int widthInBits(int n) {
        if (n < 0) {
            return 32;
        }
        if (n > 65535) {
            if (n > 0xFFFFFF) {
                if (n > 0xFFFFFFF) {
                    if (n > 0x3FFFFFFF) {
                        return 31;
                    }
                    if (n > 0x1FFFFFFF) {
                        return 30;
                    }
                    return 29;
                }
                if (n > 0x3FFFFFF) {
                    if (n > 0x7FFFFFF) {
                        return 28;
                    }
                    return 27;
                }
                if (n > 0x1FFFFFF) {
                    return 26;
                }
                return 25;
            }
            if (n > 1048575) {
                if (n > 0x3FFFFF) {
                    if (n > 0x7FFFFF) {
                        return 24;
                    }
                    return 23;
                }
                if (n > 0x1FFFFF) {
                    return 22;
                }
                return 21;
            }
            if (n > 262143) {
                if (n > 524287) {
                    return 20;
                }
                return 19;
            }
            if (n > 131071) {
                return 18;
            }
            return 17;
        }
        if (n > 255) {
            if (n > 4095) {
                if (n > 16383) {
                    if (n > Short.MAX_VALUE) {
                        return 16;
                    }
                    return 15;
                }
                if (n > 8191) {
                    return 14;
                }
                return 13;
            }
            if (n > 1023) {
                if (n > 2047) {
                    return 12;
                }
                return 11;
            }
            if (n > 511) {
                return 10;
            }
            return 9;
        }
        if (n > 15) {
            if (n > 63) {
                if (n > 127) {
                    return 8;
                }
                return 7;
            }
            if (n > 31) {
                return 6;
            }
            return 5;
        }
        if (n > 3) {
            if (n > 7) {
                return 4;
            }
            return 3;
        }
        if (n > 1) {
            return 2;
        }
        return n;
    }
}

