/*
 * Decompiled with CFR 0.152.
 */
package mpjbuf;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import mpjbuf.RawBuffer;
import mpjbuf.Type;

public class NIOBuffer
implements RawBuffer {
    private ByteBuffer buffer = null;
    private int capacity;

    NIOBuffer() {
    }

    NIOBuffer(int capacity) {
        this.capacity = capacity;
        this.buffer = ByteBuffer.allocate(capacity);
    }

    public NIOBuffer(int capacity, ByteBuffer slicedBuffer) {
        this.capacity = capacity;
        this.buffer = slicedBuffer;
    }

    @Override
    public void copy(ByteBuffer srcBuffer, int srcOffset, int srcLength, int dstOffset) {
        this.buffer.position(dstOffset);
        srcBuffer.limit(srcLength + srcOffset);
        srcBuffer.position(srcOffset);
        this.buffer.put(srcBuffer);
        this.buffer.flip();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public void setBuffer(ByteBuffer buf) {
        this.buffer.put(buf);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setEncoding(ByteOrder order) {
        this.buffer.order(order);
    }

    @Override
    public void free() {
        this.buffer.clear();
    }

    public void clear() {
        this.buffer.clear();
    }

    @Override
    public void putByte(int value, int bufOff) {
        this.buffer.position(bufOff);
        this.buffer.put((byte)value);
    }

    @Override
    public int getByte(int bufOff) {
        this.buffer.clear();
        this.buffer.position(bufOff);
        byte b = this.buffer.get();
        return b;
    }

    @Override
    public void putInt(int value, int bufOff) {
        this.buffer.position(bufOff);
        this.buffer.putInt(value);
    }

    @Override
    public int getInt(int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        int i = this.buffer.getInt();
        return i;
    }

    @Override
    public void write(byte[] source, int srcOff, int numEls, int bufOff) {
        this.buffer.position(bufOff);
        this.buffer.put(source, srcOff, numEls);
    }

    @Override
    public int gather(byte[] source, int numEls, int offs, int[] indexes, int bufOff) {
        this.buffer.position(bufOff);
        int index = 0;
        for (int i = 0; i < numEls; ++i) {
            index = indexes[offs + i];
            this.buffer.put(source[index]);
        }
        return numEls;
    }

    @Override
    public void strGather(byte[] source, int srcOff, int rank, int exts, int strs, int[] shape, int bufOff) {
        this.buffer.position(bufOff);
        this.writeStrGather(source, srcOff, rank, exts, strs, shape, Type.BYTE);
    }

    @Override
    public void read(byte[] dest, int dstOff, int numEls, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        this.buffer.get(dest, dstOff, numEls);
    }

    @Override
    public int scatter(byte[] dest, int numEls, int offs, int[] indexes, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        int indx = 0;
        for (int i = 0; i < numEls; ++i) {
            indx = indexes[offs + i];
            dest[indx] = this.buffer.get();
        }
        return numEls;
    }

    @Override
    public void strScatter(byte[] dest, int dstOff, int rank, int exts, int strs, int[] shape, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        this.readStrScatter(dest, dstOff, rank, exts, strs, shape, Type.BYTE);
    }

    @Override
    public void write(short[] source, int srcOff, int numEls, int bufOff) {
        this.buffer.position(bufOff);
        ShortBuffer ShortBuffer2 = this.buffer.asShortBuffer();
        ShortBuffer2.put(source, srcOff, numEls);
    }

    @Override
    public int gather(short[] source, int numEls, int offs, int[] indexes, int bufOff) {
        this.buffer.position(bufOff);
        int index = 0;
        for (int i = 0; i < numEls; ++i) {
            index = indexes[offs + i];
            this.buffer.putShort(source[index]);
        }
        return numEls;
    }

    @Override
    public void strGather(short[] source, int srcOff, int rank, int exts, int strs, int[] shape, int bufOff) {
        this.buffer.position(bufOff);
        this.writeStrGather(source, srcOff, rank, exts, strs, shape, Type.SHORT);
    }

    @Override
    public void read(short[] dest, int dstOff, int numEls, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        ShortBuffer ShortBuffer2 = this.buffer.asShortBuffer();
        ShortBuffer2.get(dest, dstOff, numEls);
    }

    @Override
    public int scatter(short[] dest, int numEls, int offs, int[] indexes, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        int indx = 0;
        for (int i = 0; i < numEls; ++i) {
            indx = indexes[offs + i];
            dest[indx] = this.buffer.getShort();
        }
        return numEls;
    }

    @Override
    public void strScatter(short[] dest, int dstOff, int rank, int exts, int strs, int[] shape, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        this.readStrScatter(dest, dstOff, rank, exts, strs, shape, Type.SHORT);
    }

    @Override
    public void write(int[] source, int srcOff, int numEls, int bufOff) {
        this.buffer.position(bufOff);
        IntBuffer IntBuffer2 = this.buffer.asIntBuffer();
        IntBuffer2.put(source, srcOff, numEls);
    }

    @Override
    public int gather(int[] source, int numEls, int offs, int[] indexes, int bufOff) {
        this.buffer.position(bufOff);
        int index = 0;
        for (int i = 0; i < numEls; ++i) {
            index = indexes[offs + i];
            this.buffer.putInt(source[index]);
        }
        return numEls;
    }

    @Override
    public void strGather(int[] source, int srcOff, int rank, int exts, int strs, int[] shape, int bufOff) {
        this.buffer.position(bufOff);
        this.writeStrGather(source, srcOff, rank, exts, strs, shape, Type.INT);
    }

    @Override
    public void read(int[] dest, int dstOff, int numEls, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        IntBuffer IntBuffer2 = this.buffer.asIntBuffer();
        IntBuffer2.get(dest, dstOff, numEls);
    }

    @Override
    public int scatter(int[] dest, int numEls, int offs, int[] indexes, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        int indx = 0;
        for (int i = 0; i < numEls; ++i) {
            indx = indexes[offs + i];
            dest[indx] = this.buffer.getInt();
        }
        return numEls;
    }

    @Override
    public void strScatter(int[] dest, int dstOff, int rank, int exts, int strs, int[] shape, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        this.readStrScatter(dest, dstOff, rank, exts, strs, shape, Type.INT);
    }

    @Override
    public void write(long[] source, int srcOff, int numEls, int bufOff) {
        this.buffer.position(bufOff);
        LongBuffer LongBuffer2 = this.buffer.asLongBuffer();
        LongBuffer2.put(source, srcOff, numEls);
    }

    @Override
    public int gather(long[] source, int numEls, int offs, int[] indexes, int bufOff) {
        this.buffer.position(bufOff);
        int index = 0;
        for (int i = 0; i < numEls; ++i) {
            index = indexes[offs + i];
            this.buffer.putLong(source[index]);
        }
        return numEls;
    }

    @Override
    public void strGather(long[] source, int srcOff, int rank, int exts, int strs, int[] shape, int bufOff) {
        this.buffer.position(bufOff);
        this.writeStrGather(source, srcOff, rank, exts, strs, shape, Type.LONG);
    }

    @Override
    public void read(long[] dest, int dstOff, int numEls, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        LongBuffer LongBuffer2 = this.buffer.asLongBuffer();
        LongBuffer2.get(dest, dstOff, numEls);
    }

    @Override
    public int scatter(long[] dest, int numEls, int offs, int[] indexes, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        int indx = 0;
        for (int i = 0; i < numEls; ++i) {
            indx = indexes[offs + i];
            dest[indx] = this.buffer.getLong();
        }
        return numEls;
    }

    @Override
    public void strScatter(long[] dest, int dstOff, int rank, int exts, int strs, int[] shape, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        this.readStrScatter(dest, dstOff, rank, exts, strs, shape, Type.LONG);
    }

    @Override
    public void write(char[] source, int srcOff, int numEls, int bufOff) {
        this.buffer.position(bufOff);
        CharBuffer CharBuffer2 = this.buffer.asCharBuffer();
        CharBuffer2.put(source, srcOff, numEls);
    }

    @Override
    public int gather(char[] source, int numEls, int offs, int[] indexes, int bufOff) {
        this.buffer.position(bufOff);
        int index = 0;
        for (int i = 0; i < numEls; ++i) {
            index = indexes[offs + i];
            this.buffer.putChar(source[index]);
        }
        return numEls;
    }

    @Override
    public void strGather(char[] source, int srcOff, int rank, int exts, int strs, int[] shape, int bufOff) {
        this.buffer.position(bufOff);
        this.writeStrGather(source, srcOff, rank, exts, strs, shape, Type.CHAR);
    }

    @Override
    public void read(char[] dest, int dstOff, int numEls, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        CharBuffer CharBuffer2 = this.buffer.asCharBuffer();
        CharBuffer2.get(dest, dstOff, numEls);
    }

    @Override
    public int scatter(char[] dest, int numEls, int offs, int[] indexes, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        int indx = 0;
        for (int i = 0; i < numEls; ++i) {
            indx = indexes[offs + i];
            dest[indx] = this.buffer.getChar();
        }
        return numEls;
    }

    @Override
    public void strScatter(char[] dest, int dstOff, int rank, int exts, int strs, int[] shape, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        this.readStrScatter(dest, dstOff, rank, exts, strs, shape, Type.CHAR);
    }

    @Override
    public void write(float[] source, int srcOff, int numEls, int bufOff) {
        this.buffer.position(bufOff);
        FloatBuffer FloatBuffer2 = this.buffer.asFloatBuffer();
        FloatBuffer2.put(source, srcOff, numEls);
    }

    @Override
    public int gather(float[] source, int numEls, int offs, int[] indexes, int bufOff) {
        this.buffer.position(bufOff);
        int index = 0;
        for (int i = 0; i < numEls; ++i) {
            index = indexes[offs + i];
            this.buffer.putFloat(source[index]);
        }
        return numEls;
    }

    @Override
    public void strGather(float[] source, int srcOff, int rank, int exts, int strs, int[] shape, int bufOff) {
        this.buffer.position(bufOff);
        this.writeStrGather(source, srcOff, rank, exts, strs, shape, Type.FLOAT);
    }

    @Override
    public void read(float[] dest, int dstOff, int numEls, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        FloatBuffer FloatBuffer2 = this.buffer.asFloatBuffer();
        FloatBuffer2.get(dest, dstOff, numEls);
    }

    @Override
    public int scatter(float[] dest, int numEls, int offs, int[] indexes, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        int indx = 0;
        for (int i = 0; i < numEls; ++i) {
            indx = indexes[offs + i];
            dest[indx] = this.buffer.getFloat();
        }
        return numEls;
    }

    @Override
    public void strScatter(float[] dest, int dstOff, int rank, int exts, int strs, int[] shape, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        this.readStrScatter(dest, dstOff, rank, exts, strs, shape, Type.FLOAT);
    }

    @Override
    public void write(double[] source, int srcOff, int numEls, int bufOff) {
        this.buffer.position(bufOff);
        DoubleBuffer DoubleBuffer2 = this.buffer.asDoubleBuffer();
        DoubleBuffer2.put(source, srcOff, numEls);
    }

    @Override
    public int gather(double[] source, int numEls, int offs, int[] indexes, int bufOff) {
        this.buffer.position(bufOff);
        int index = 0;
        for (int i = 0; i < numEls; ++i) {
            index = indexes[offs + i];
            this.buffer.putDouble(source[index]);
        }
        return numEls;
    }

    @Override
    public void strGather(double[] source, int srcOff, int rank, int exts, int strs, int[] shape, int bufOff) {
        this.buffer.position(bufOff);
        this.writeStrGather(source, srcOff, rank, exts, strs, shape, Type.DOUBLE);
    }

    @Override
    public void read(double[] dest, int dstOff, int numEls, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        DoubleBuffer DoubleBuffer2 = this.buffer.asDoubleBuffer();
        DoubleBuffer2.get(dest, dstOff, numEls);
    }

    @Override
    public int scatter(double[] dest, int numEls, int offs, int[] indexes, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        int indx = 0;
        for (int i = 0; i < numEls; ++i) {
            indx = indexes[offs + i];
            dest[indx] = this.buffer.getDouble();
        }
        return numEls;
    }

    @Override
    public void strScatter(double[] dest, int dstOff, int rank, int exts, int strs, int[] shape, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        this.readStrScatter(dest, dstOff, rank, exts, strs, shape, Type.DOUBLE);
    }

    @Override
    public void write(boolean[] source, int srcOff, int numEls, int bufOff) {
        this.buffer.position(bufOff);
        for (int i = 0; i < numEls; ++i) {
            this.buffer.put((byte)(source[i + srcOff] ? 1 : 0));
        }
    }

    @Override
    public int gather(boolean[] source, int numEls, int offs, int[] indexes, int bufOff) {
        this.buffer.position(bufOff);
        int index = 0;
        for (int i = 0; i < numEls; ++i) {
            index = indexes[offs + i];
            this.buffer.put((byte)(source[index] ? 1 : 0));
        }
        return numEls;
    }

    @Override
    public void strGather(boolean[] source, int srcOff, int rank, int exts, int strs, int[] shape, int bufOff) {
        this.buffer.position(bufOff);
        this.writeStrGather(source, srcOff, rank, exts, strs, shape, Type.BOOLEAN);
    }

    @Override
    public void read(boolean[] dest, int dstOff, int numEls, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        for (int i = 0; i < numEls; ++i) {
            dest[i + dstOff] = this.buffer.get() == 1;
        }
    }

    @Override
    public int scatter(boolean[] dest, int numEls, int offs, int[] indexes, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        int indx = 0;
        for (int i = 0; i < numEls; ++i) {
            indx = indexes[offs + i];
            dest[indx] = this.buffer.get() == 1;
        }
        return numEls;
    }

    @Override
    public void strScatter(boolean[] dest, int dstOff, int rank, int exts, int strs, int[] shape, int bufOff, boolean revBytes) {
        this.buffer.position(bufOff);
        this.readStrScatter(dest, dstOff, rank, exts, strs, shape, Type.BOOLEAN);
    }

    private void writeStrGatherBuffer(Object source, int off, Type type) {
        switch (type.getCode()) {
            case 0: {
                this.buffer.put(((byte[])source)[off]);
                break;
            }
            case 1: {
                this.buffer.putChar(((char[])source)[off]);
                break;
            }
            case 2: {
                this.buffer.putShort(((short[])source)[off]);
                break;
            }
            case 3: {
                if (((boolean[])source)[off]) {
                    this.buffer.put((byte)1);
                    break;
                }
                this.buffer.put((byte)0);
                break;
            }
            case 4: {
                this.buffer.putInt(((int[])source)[off]);
                break;
            }
            case 5: {
                this.buffer.putLong(((long[])source)[off]);
                break;
            }
            case 6: {
                this.buffer.putFloat(((float[])source)[off]);
                break;
            }
            case 7: {
                this.buffer.putDouble(((double[])source)[off]);
                break;
            }
            default: {
                throw new RuntimeException("WriteBuffer::writeStrGatherBuffer:Unknown type " + type + ".");
            }
        }
    }

    private void writeStrGather(Object source, int srcOff, int rank, int exts, int strs, int[] indexes, Type type) {
        switch (rank) {
            case 0: {
                this.writeStrGatherBuffer(source, srcOff, type);
                break;
            }
            case 1: {
                int index0 = srcOff;
                for (int i = 0; i < indexes[exts]; ++i) {
                    this.writeStrGatherBuffer(source, index0, type);
                    index0 += indexes[strs];
                }
                break;
            }
            case 2: {
                int index0 = srcOff;
                for (int i = 0; i < indexes[exts]; ++i) {
                    int index1 = index0;
                    for (int j = 0; j < indexes[exts + 1]; ++j) {
                        this.writeStrGatherBuffer(source, index1, type);
                        index1 += indexes[strs + 1];
                    }
                    index0 += indexes[strs];
                }
                break;
            }
            case 3: {
                int index0 = srcOff;
                for (int i = 0; i < indexes[exts]; ++i) {
                    int index1 = index0;
                    for (int j = 0; j < indexes[exts + 1]; ++j) {
                        int index2 = index1;
                        for (int k = 0; k < indexes[exts + 2]; ++k) {
                            this.writeStrGatherBuffer(source, index2, type);
                            index2 += indexes[strs + 2];
                        }
                        index1 += indexes[strs + 1];
                    }
                    index0 += indexes[strs];
                }
                break;
            }
            default: {
                int str = indexes[strs];
                for (int i = 0; i < indexes[exts]; ++i) {
                    this.writeStrGather(source, srcOff + str * i, rank - 1, exts + 1, strs + 1, indexes, type);
                }
            }
        }
    }

    private void readStrScatterBuffer(Object source, int off, Type type) {
        switch (type.getCode()) {
            case 0: {
                try {
                    ((byte[])source)[off] = this.buffer.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(0);
                }
                break;
            }
            case 1: {
                ((char[])source)[off] = this.buffer.getChar();
                break;
            }
            case 2: {
                ((short[])source)[off] = this.buffer.getShort();
                break;
            }
            case 3: {
                if (this.buffer.get() == 1) {
                    ((boolean[])source)[off] = true;
                    break;
                }
                ((boolean[])source)[off] = false;
                break;
            }
            case 4: {
                ((int[])source)[off] = this.buffer.getInt();
                break;
            }
            case 5: {
                ((long[])source)[off] = this.buffer.getLong();
                break;
            }
            case 6: {
                ((float[])source)[off] = this.buffer.getFloat();
                break;
            }
            case 7: {
                ((double[])source)[off] = this.buffer.getDouble();
                break;
            }
            default: {
                throw new RuntimeException("WriteBuffer::readStrGatherBuffer:Unknown type " + type + ".");
            }
        }
    }

    private void readStrScatter(Object dest, int dstOff, int rank, int exts, int strs, int[] indexes, Type type) {
        switch (rank) {
            case 0: {
                this.readStrScatterBuffer(dest, dstOff, type);
                break;
            }
            case 1: {
                int index0 = dstOff;
                for (int i = 0; i < indexes[exts]; ++i) {
                    this.readStrScatterBuffer(dest, index0, type);
                    index0 += indexes[strs];
                }
                break;
            }
            case 2: {
                int index0 = dstOff;
                for (int i = 0; i < indexes[exts]; ++i) {
                    int index1 = index0;
                    for (int j = 0; j < indexes[exts + 1]; ++j) {
                        this.readStrScatterBuffer(dest, index1, type);
                        index1 += indexes[strs + 1];
                    }
                    index0 += indexes[strs];
                }
                break;
            }
            case 3: {
                int index0 = dstOff;
                for (int i = 0; i < indexes[exts]; ++i) {
                    int index1 = index0;
                    for (int j = 0; j < indexes[exts + 1]; ++j) {
                        int index2 = index1;
                        for (int k = 0; k < indexes[exts + 2]; ++k) {
                            this.readStrScatterBuffer(dest, index2, type);
                            index2 += indexes[strs + 2];
                        }
                        index1 += indexes[strs + 1];
                    }
                    index0 += indexes[strs];
                }
                break;
            }
            default: {
                int str = indexes[strs];
                for (int i = 0; i < indexes[exts]; ++i) {
                    this.readStrScatter(dest, dstOff + str * i, rank - 1, exts + 1, strs + 1, indexes, type);
                }
            }
        }
    }
}

