/*
 * Decompiled with CFR 0.152.
 */
package mpjdev;

import java.util.Arrays;
import mpi.MPI;
import mpjbuf.Buffer;
import mpjbuf.BufferFactory;
import mpjbuf.Type;
import mpjdev.CompletionHandler;
import mpjdev.Group;
import mpjdev.MPJDev;
import mpjdev.MPJDevException;
import mpjdev.Request;
import mpjdev.Status;
import xdev.Device;
import xdev.ProcessID;

public class Comm {
    Device device = null;
    public int sendctxt = 0;
    public int recvctxt = 0;
    int collctxt = 0;
    public Group group = null;
    public Group localgroup = null;
    int calContextTag = 34020;
    int mpjdevBarrierTag = 34021;
    int splitTag = 34022;
    int bCount = 1000;
    static int staticContext = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Comm(Device device, Group group) throws MPJDevException {
        this.device = device;
        this.group = group;
        int highestContext = -1;
        int nextContext = 0;
        Class<Comm> clazz = Comm.class;
        synchronized (Comm.class) {
            nextContext = ++staticContext;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            try {
                highestContext = this.calculateContext(10, false, nextContext);
            }
            catch (Exception e) {
                throw new MPJDevException(e);
            }
            this.sendctxt = highestContext;
            this.recvctxt = highestContext;
            this.collctxt = highestContext + 2 * highestContext;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Comm(Device device, Group localgroup, Group peergroup, int localleader, int remoteleader, int tag, int peercontext, int context) throws MPJDevException {
        Object rids;
        Request req = null;
        int value = 5;
        int me = peergroup.rank();
        this.device = device;
        this.localgroup = localgroup;
        int sendOverhead = MPJDev.getSendOverhead();
        int recvOverhead = MPJDev.getRecvOverhead();
        int capacity = sendOverhead + 23;
        Buffer sbuf = new Buffer(BufferFactory.create(capacity), sendOverhead, capacity);
        Buffer rbuf = new Buffer(BufferFactory.create(capacity), recvOverhead, 16 + recvOverhead);
        int[] intdata = new int[1];
        if (localgroup.ids[localleader].uuid().equals(localgroup.myID.uuid())) {
            int i;
            intdata[0] = localgroup.size();
            try {
                sbuf.putSectionHeader(Type.INT);
                sbuf.write(intdata, 0, 1);
                sbuf.commit();
                System.out.println("sending ..");
                req = device.isend(sbuf, peergroup.ids[remoteleader], tag, peercontext);
            }
            catch (Exception e) {
                throw new MPJDevException(e);
            }
            Request[] localgroupreq = new Request[localgroup.size()];
            Buffer[] wBuffer = new Buffer[localgroup.size()];
            for (int i2 = 0; i2 < localgroup.size(); ++i2) {
                int prank = 0;
                for (int j = 0; j < peergroup.size(); ++j) {
                    if (!localgroup.ids[i2].uuid().equals(peergroup.ids[j].uuid())) continue;
                    prank = j;
                }
                intdata[0] = prank;
                try {
                    wBuffer[i2] = new Buffer(BufferFactory.create(capacity), sendOverhead, capacity);
                    wBuffer[i2].putSectionHeader(Type.INT);
                    wBuffer[i2].write(intdata, 0, 1);
                    wBuffer[i2].commit();
                    localgroupreq[i2] = device.isend(wBuffer[i2], peergroup.ids[remoteleader], tag, peercontext);
                    continue;
                }
                catch (Exception e) {
                    throw new MPJDevException(e);
                }
            }
            device.recv(rbuf, peergroup.ids[remoteleader], tag, peercontext);
            try {
                rbuf.commit();
                rbuf.getSectionHeader();
                rbuf.getSectionSize();
                rbuf.read(intdata, 0, 1);
                rbuf.clear();
            }
            catch (Exception e) {
                System.out.println(me + "has failed ..");
                throw new MPJDevException(e);
            }
            req.iwait();
            try {
                sbuf.clear();
            }
            catch (Exception e) {
                throw new MPJDevException(e);
            }
            int rgroupsize = intdata[0];
            ProcessID[] rids2 = new ProcessID[rgroupsize];
            int[] rranks = new int[rgroupsize];
            for (i = 0; i < rgroupsize; ++i) {
                try {
                    device.recv(rbuf, peergroup.ids[remoteleader], tag, peercontext);
                    rbuf.commit();
                    rbuf.getSectionHeader();
                    rbuf.getSectionSize();
                    rbuf.read(intdata, 0, 1);
                    rbuf.clear();
                }
                catch (Exception e) {
                    throw new MPJDevException(e);
                }
                rranks[i] = intdata[0];
                rids2[i] = new ProcessID(peergroup.ids[rranks[i]].uuid());
            }
            for (i = 0; i < localgroup.size(); ++i) {
                localgroupreq[i].iwait();
                try {
                    wBuffer[i].clear();
                }
                catch (Exception e) {
                    throw new MPJDevException(e);
                }
                BufferFactory.destroy(wBuffer[i].getStaticBuffer());
            }
            this.group = peergroup.incl(rranks);
            for (i = 0; i < localgroup.size(); ++i) {
                if (localgroup.ids[localleader].uuid().equals(localgroup.ids[i].uuid())) continue;
                intdata[0] = rgroupsize;
                try {
                    sbuf.putSectionHeader(Type.INT);
                    sbuf.write(intdata, 0, 1);
                    sbuf.commit();
                    device.send(sbuf, localgroup.ids[i], tag, context);
                    sbuf.clear();
                }
                catch (Exception e) {
                    throw new MPJDevException(e);
                }
                for (int j = 0; j < rgroupsize; ++j) {
                    intdata[0] = rranks[j];
                    try {
                        sbuf.putSectionHeader(Type.INT);
                        sbuf.write(intdata, 0, 1);
                        sbuf.commit();
                        device.send(sbuf, localgroup.ids[i], tag, context);
                        sbuf.clear();
                        continue;
                    }
                    catch (Exception e) {
                        throw new MPJDevException(e);
                    }
                }
            }
        } else {
            try {
                device.recv(rbuf, localgroup.ids[localleader], tag, context);
                rbuf.commit();
                rbuf.getSectionHeader();
                rbuf.getSectionSize();
                rbuf.read(intdata, 0, 1);
                rbuf.clear();
            }
            catch (Exception e) {
                throw new MPJDevException(e);
            }
            int rgroupsize = intdata[0];
            rids = new ProcessID[rgroupsize];
            int[] rranks = new int[rgroupsize];
            for (int i = 0; i < rgroupsize; ++i) {
                try {
                    device.recv(rbuf, localgroup.ids[localleader], tag, context);
                    rbuf.commit();
                    rbuf.getSectionHeader();
                    rbuf.getSectionSize();
                    rbuf.read(intdata, 0, 1);
                    rbuf.clear();
                }
                catch (Exception e) {
                    throw new MPJDevException(e);
                }
                rranks[i] = intdata[0];
                rids[i] = new ProcessID(peergroup.ids[rranks[i]].uuid());
            }
            this.group = peergroup.incl(rranks);
        }
        int nextContext = 0;
        rids = Comm.class;
        synchronized (Comm.class) {
            nextContext = staticContext + 2;
            // ** MonitorExit[rids /* !! */ ] (shouldn't be in output)
            int hcontext = this.calculateContext(context, true, nextContext);
            if (localgroup.ids[localleader].uuid().equals(localgroup.myID.uuid())) {
                intdata[0] = hcontext;
                try {
                    sbuf.putSectionHeader(Type.INT);
                    sbuf.write(intdata, 0, 1);
                    sbuf.commit();
                    req = device.isend(sbuf, peergroup.ids[remoteleader], tag, peercontext);
                    device.recv(rbuf, peergroup.ids[remoteleader], tag, peercontext);
                    rbuf.commit();
                    rbuf.getSectionHeader();
                    rbuf.getSectionSize();
                    rbuf.read(intdata, 0, 1);
                    rbuf.clear();
                    req.iwait();
                    sbuf.clear();
                }
                catch (Exception e) {
                    throw new MPJDevException(e);
                }
                int rhcontext = intdata[0];
                if (hcontext == rhcontext) {
                    int peersRemoteLeader = 0;
                    try {
                        sbuf.putSectionHeader(Type.INT);
                        intdata[0] = remoteleader;
                        sbuf.write(intdata, 0, 1);
                        sbuf.commit();
                        req = device.isend(sbuf, peergroup.ids[remoteleader], tag, peercontext);
                        device.recv(rbuf, peergroup.ids[remoteleader], tag, peercontext);
                        rbuf.commit();
                        rbuf.getSectionHeader();
                        rbuf.getSectionSize();
                        rbuf.read(intdata, 0, 1);
                        rbuf.clear();
                        req.iwait();
                        sbuf.clear();
                        peersRemoteLeader = intdata[0];
                    }
                    catch (Exception e) {
                        throw new MPJDevException(e);
                    }
                    if (peersRemoteLeader > remoteleader) {
                        this.sendctxt = hcontext;
                        this.recvctxt = hcontext - 1;
                    } else {
                        this.sendctxt = hcontext - 1;
                        this.recvctxt = hcontext;
                    }
                } else {
                    this.sendctxt = hcontext;
                    this.recvctxt = rhcontext;
                }
                for (int i = 0; i < localgroup.size(); ++i) {
                    if (localgroup.ids[localleader].uuid().equals(localgroup.ids[i].uuid())) continue;
                    intdata[0] = this.sendctxt;
                    try {
                        sbuf.putSectionHeader(Type.INT);
                        sbuf.write(intdata, 0, 1);
                        sbuf.commit();
                        device.send(sbuf, localgroup.ids[i], tag, context);
                        sbuf.clear();
                    }
                    catch (Exception e) {
                        throw new MPJDevException(e);
                    }
                    intdata[0] = this.recvctxt;
                    try {
                        sbuf.putSectionHeader(Type.INT);
                        sbuf.write(intdata, 0, 1);
                        sbuf.commit();
                        device.send(sbuf, localgroup.ids[i], tag, context);
                        sbuf.clear();
                        continue;
                    }
                    catch (Exception e) {
                        throw new MPJDevException(e);
                    }
                }
            } else {
                try {
                    device.recv(rbuf, localgroup.ids[localleader], tag, context);
                    rbuf.commit();
                    rbuf.getSectionHeader();
                    rbuf.getSectionSize();
                    rbuf.read(intdata, 0, 1);
                    rbuf.clear();
                    this.sendctxt = intdata[0];
                    device.recv(rbuf, localgroup.ids[localleader], tag, context);
                    rbuf.commit();
                    rbuf.getSectionHeader();
                    rbuf.getSectionSize();
                    rbuf.read(intdata, 0, 1);
                    rbuf.clear();
                }
                catch (Exception e) {
                    throw new MPJDevException(e);
                }
                this.recvctxt = intdata[0];
            }
            this.collctxt = -1;
            BufferFactory.destroy(rbuf.getStaticBuffer());
            BufferFactory.destroy(sbuf.getStaticBuffer());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Comm(Device device, Group group, int context) {
        this.device = device;
        this.group = group;
        int highestContext = -1;
        int nextContext = 0;
        Class<Comm> clazz = Comm.class;
        synchronized (Comm.class) {
            nextContext = ++staticContext;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            try {
                highestContext = this.calculateContext(context, false, nextContext);
            }
            catch (Exception e) {
                throw new MPJDevException(e);
            }
            this.sendctxt = highestContext;
            this.collctxt = highestContext + 2 * highestContext;
            this.recvctxt = highestContext;
            return;
        }
    }

    Comm(Device device, Group group, Group localgroup, int context) {
        this.device = device;
        this.group = group;
    }

    private int calculateContext(int context, boolean isIComm, int nextContext) throws MPJDevException {
        int i;
        int myRank = -1;
        int mySize = -1;
        ProcessID[] ids = null;
        if (isIComm) {
            myRank = this.localgroup.rank();
            mySize = this.localgroup.size();
            ids = this.localgroup.ids;
        } else {
            myRank = this.group.rank();
            mySize = this.group.size();
            ids = this.group.ids;
        }
        int[] contextArray = new int[]{nextContext};
        Request[] req = new Request[mySize];
        int sendOverhead = MPJDev.getSendOverhead();
        int recvOverhead = MPJDev.getRecvOverhead();
        int cap = sendOverhead + 23;
        Buffer[] wBuffer = new Buffer[mySize];
        for (i = 0; i < mySize; ++i) {
            if (i == myRank) continue;
            try {
                wBuffer[i] = new Buffer(BufferFactory.create(cap), sendOverhead, cap);
                wBuffer[i].putSectionHeader(Type.INT);
                wBuffer[i].write(contextArray, 0, 1);
                wBuffer[i].commit();
                req[i] = this.device.isend(wBuffer[i], ids[i], this.calContextTag + i, context);
                continue;
            }
            catch (Exception e) {
                throw new MPJDevException(e);
            }
        }
        Buffer rBuffer = new Buffer(BufferFactory.create(recvOverhead + 16), recvOverhead, recvOverhead + 16);
        int highestContext = contextArray[0];
        for (i = 0; i < mySize; ++i) {
            if (i == myRank) continue;
            try {
                this.device.recv(rBuffer, ids[i], this.calContextTag + myRank, context);
                rBuffer.commit();
                Type type = rBuffer.getSectionHeader();
                rBuffer.getSectionSize();
                rBuffer.read(contextArray, 0, 1);
                rBuffer.clear();
            }
            catch (Exception e) {
                throw new MPJDevException(e);
            }
            if (contextArray[0] <= highestContext) continue;
            highestContext = contextArray[0];
        }
        for (i = 0; i < mySize; ++i) {
            if (i == myRank) continue;
            req[i].iwait();
            try {
                wBuffer[i].clear();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < mySize; ++i) {
            if (i == myRank) continue;
            BufferFactory.destroy(wBuffer[i].getStaticBuffer());
        }
        BufferFactory.destroy(rBuffer.getStaticBuffer());
        return highestContext;
    }

    public Comm create(int[] ids) throws MPJDevException {
        Group tmpgrp = this.group.incl(ids);
        return tmpgrp != null ? this.create(tmpgrp) : null;
    }

    public Comm create(Group ngroup) throws MPJDevException {
        if (ngroup.rank() == -1) {
            return null;
        }
        return new Comm(this.device, ngroup, this.collctxt);
    }

    public Comm create(Comm localcomm, Group peergroup, int localleader, int remoteleader, int tag) throws MPJDevException {
        return new Comm(this.device, localcomm.group, peergroup, localleader, remoteleader, tag, this.sendctxt, localcomm.collctxt);
    }

    public Comm clone() {
        return null;
    }

    public Status probe(int src, int tag) throws MPJDevException {
        if (src < 0 && src != -2) {
            throw new MPJDevException("In Comm.iprobe(), requested negative message destination: " + src);
        }
        if (src >= this.size() && src != -2) {
            throw new MPJDevException("In Comm.iprobe(), requested source " + src + " does not exist in communicator of size " + this.size());
        }
        ProcessID srcID = null;
        srcID = src == MPI.ANY_SOURCE ? Device.ANY_SRC : this.group.ids[src];
        Status status = this.device.probe(srcID, tag, this.recvctxt);
        for (int j = 0; j < this.group.ids.length; ++j) {
            if (!this.group.ids[j].uuid().equals(status.srcID)) continue;
            status.source = j;
            break;
        }
        return status;
    }

    public Status iprobe(int src, int tag) throws MPJDevException {
        if (src < 0 && src != -2) {
            throw new MPJDevException("In Comm.iprobe(), requested negative message destination: " + src);
        }
        if (src >= this.size() && src != -2) {
            throw new MPJDevException("In Comm.iprobe(), requested source " + src + " does not exist in communicator of size " + this.size());
        }
        ProcessID srcID = null;
        srcID = src == MPI.ANY_SOURCE ? Device.ANY_SRC : this.group.ids[src];
        Status status = this.device.iprobe(srcID, tag, this.recvctxt);
        if (status != null) {
            for (int j = 0; j < this.group.ids.length; ++j) {
                if (!this.group.ids[j].uuid().equals(status.srcID)) continue;
                status.source = j;
                break;
            }
        }
        return status;
    }

    public Request irecv(Buffer buf, int src, int tag, Status status, boolean pt2pt) throws MPJDevException {
        if (buf == null) {
            throw new MPJDevException("In Comm.irecv(), buffer is null.");
        }
        if (src < 0 && src != -2) {
            throw new MPJDevException("In Comm.irecv(), requested negative message destination: " + src);
        }
        if (src >= this.size() && src != -2) {
            throw new MPJDevException("In Comm.irecv(), requested source " + src + " does not exist in communicator of size " + this.size());
        }
        int context = 0;
        context = pt2pt ? this.recvctxt : this.collctxt;
        ProcessID srcID = null;
        srcID = src == MPI.ANY_SOURCE ? Device.ANY_SRC : this.group.ids[src];
        Request request = this.device.irecv(buf, srcID, tag, context, status);
        request.addCompletionHandler(new CompletionHandler(){

            @Override
            public void handleCompletion(Status status) {
                for (int j = 0; j < Comm.this.group.ids.length; ++j) {
                    if (!Comm.this.group.ids[j].uuid().equals(status.srcID)) continue;
                    status.source = j;
                    break;
                }
            }
        });
        return request;
    }

    public Status recv(Buffer buf, int src, int tag, boolean pt2pt) throws MPJDevException {
        if (buf == null) {
            throw new MPJDevException("In Comm.irecv(), buffer is null.");
        }
        if (src < 0 && src != -2) {
            throw new MPJDevException("In Comm.irecv(), requested negative message destination: " + src);
        }
        if (src >= this.size() && src != -2) {
            throw new MPJDevException("In Comm.irecv(), requested source " + src + " does not exist in communicator of size " + this.size());
        }
        int context = 0;
        Status status = null;
        context = pt2pt ? this.recvctxt : this.collctxt;
        ProcessID srcID = null;
        srcID = src == MPI.ANY_SOURCE ? Device.ANY_SRC : this.group.ids[src];
        status = this.device.recv(buf, srcID, tag, context);
        for (int j = 0; j < this.group.ids.length; ++j) {
            if (!this.group.ids[j].uuid().equals(status.srcID)) continue;
            status.source = j;
            break;
        }
        return status;
    }

    public void barrier() throws MPJDevException {
        if (this.localgroup != null) {
            System.out.println("mpjdev_barrier cannot be called for intercomm");
            return;
        }
        ++this.bCount;
        int size = this.group.size();
        int rank = this.group.rank();
        int[] stuff = new int[1];
        boolean x = true;
        int y = (int)Math.pow(2.0, Math.floor(Math.log(size) / Math.log(2.0)));
        int sendOverhead = MPJDev.getSendOverhead();
        int cap = sendOverhead + 23;
        Buffer wBuffer = new Buffer(BufferFactory.create(cap), sendOverhead, cap);
        Buffer rBuffer = new Buffer(BufferFactory.create(16), 0, 16);
        try {
            wBuffer.putSectionHeader(Type.INT);
            wBuffer.write(stuff, 0, 1);
            wBuffer.commit();
        }
        catch (Exception e) {
            throw new MPJDevException(e);
        }
        if (rank >= y) {
            try {
                this.send(wBuffer, rank - y, (this.mpjdevBarrierTag + rank - y) * this.bCount, false);
                this.recv(rBuffer, rank - y, (this.mpjdevBarrierTag + rank) * this.bCount, false);
                rBuffer.clear();
            }
            catch (Exception e) {
                throw new MPJDevException(e);
            }
        }
        if (size - y > rank) {
            try {
                this.recv(rBuffer, rank + y, (this.mpjdevBarrierTag + rank) * this.bCount, false);
                rBuffer.clear();
            }
            catch (Exception e) {
                throw new MPJDevException(e);
            }
        }
        int round = -1;
        int peer = 0;
        do {
            peer = rank ^ (int)Math.pow(2.0, ++round);
            try {
                this.send(wBuffer, peer, (this.mpjdevBarrierTag + peer) * this.bCount, false);
                this.recv(rBuffer, peer, (this.mpjdevBarrierTag + rank) * this.bCount, false);
                rBuffer.clear();
            }
            catch (Exception e) {
                throw new MPJDevException(e);
            }
        } while (round != (int)(Math.log(y) / Math.log(2.0)) - 1);
        if (size - y > rank) {
            try {
                this.send(wBuffer, rank + y, (this.mpjdevBarrierTag + rank + y) * this.bCount, false);
            }
            catch (Exception e) {
                throw new MPJDevException(e);
            }
        }
        if (this.bCount == 0x7FFFFFFE) {
            this.bCount = 1000;
        }
        BufferFactory.destroy(wBuffer.getStaticBuffer());
        BufferFactory.destroy(rBuffer.getStaticBuffer());
    }

    public Request isend(Buffer buf, int dest, int tag, boolean pt2pt) throws MPJDevException {
        if (buf == null) {
            throw new MPJDevException("In Comm.isend(), buffer is null.");
        }
        if (dest < 0) {
            throw new MPJDevException("In Comm.isend(), requested negative message destination: " + dest);
        }
        if (dest >= this.size()) {
            throw new MPJDevException("In Comm.isend(), requested destination " + dest + " does not exist in communicator of size " + this.size());
        }
        int context = 0;
        context = pt2pt ? this.sendctxt : this.collctxt;
        return this.device.isend(buf, this.group.ids[dest], tag, context);
    }

    public void send(Buffer buf, int dest, int tag, boolean pt2pt) throws MPJDevException {
        if (buf == null) {
            throw new MPJDevException("In Comm.isend(), buffer is null.");
        }
        if (dest < 0) {
            throw new MPJDevException("In Comm.isend(), requested negative message destination: " + dest);
        }
        if (dest >= this.size()) {
            throw new MPJDevException("In Comm.isend(), requested destination " + dest + " does not exist in communicator of size " + this.size());
        }
        int context = 0;
        context = pt2pt ? this.sendctxt : this.collctxt;
        this.device.send(buf, this.group.ids[dest], tag, context);
    }

    public Request issend(Buffer buf, int dest, int tag, boolean pt2pt) throws MPJDevException {
        if (buf == null) {
            throw new MPJDevException("In Comm.isend(), buffer is null.");
        }
        if (dest < 0) {
            throw new MPJDevException("In Comm.isend(), requested negative message destination: " + dest);
        }
        if (dest >= this.size()) {
            throw new MPJDevException("In Comm.isend(), requested destination " + dest + " does not exist in communicator of size " + this.size());
        }
        int context = 0;
        context = pt2pt ? this.sendctxt : this.collctxt;
        return this.device.issend(buf, this.group.ids[dest], tag, context);
    }

    public void ssend(Buffer buf, int dest, int tag, boolean pt2pt) throws MPJDevException {
        if (buf == null) {
            throw new MPJDevException("In Comm.isend(), buffer is null.");
        }
        if (dest < 0) {
            throw new MPJDevException("In Comm.isend(), requested negative message destination: " + dest);
        }
        if (dest >= this.size()) {
            throw new MPJDevException("In Comm.isend(), requested destination " + dest + " does not exist in communicator of size " + this.size());
        }
        int context = 0;
        context = pt2pt ? this.sendctxt : this.collctxt;
        this.device.ssend(buf, this.group.ids[dest], tag, context);
    }

    public int size() {
        return this.group.size();
    }

    public int id() {
        return this.group.rank();
    }

    public void free() throws MPJDevException {
    }

    public Comm split(int color, int key) throws MPJDevException {
        int i;
        int[][] b = new int[this.group.size()][3];
        int len = 0;
        int[] a = new int[]{color, key};
        b[len][0] = color;
        b[len][1] = key;
        b[len][2] = this.group.rank();
        ++len;
        int size = this.group.size();
        int rank = this.group.rank();
        int tag = this.splitTag;
        int sOverhead = MPJDev.getSendOverhead();
        int cap = sOverhead + 23;
        Buffer buf = new Buffer(BufferFactory.create(cap), sOverhead, cap);
        try {
            buf.putSectionHeader(Type.INT);
            buf.write(a, 0, 2);
            buf.commit();
        }
        catch (Exception e) {
            throw new MPJDevException(e);
        }
        Request[] reqs = new Request[size];
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 == rank) continue;
            reqs[i2] = this.isend(buf, i2, rank + tag + i2, false);
        }
        try {
            buf.clear();
        }
        catch (Exception e) {
            throw new MPJDevException(e);
        }
        Buffer rbuf = new Buffer(BufferFactory.create(16), 0, 16);
        for (i = 0; i < size; ++i) {
            if (i == rank) continue;
            try {
                this.recv(rbuf, i, tag + i + rank, false);
                rbuf.commit();
                rbuf.getSectionHeader();
                rbuf.getSectionSize();
                rbuf.read(a, 0, 2);
                rbuf.clear();
            }
            catch (Exception e) {
                throw new MPJDevException(e);
            }
            if (a[0] != color) continue;
            b[len][0] = a[0];
            b[len][1] = a[1];
            b[len][2] = i;
            ++len;
        }
        for (i = 0; i < size; ++i) {
            if (i == rank) continue;
            reqs[i].iwait();
        }
        int[] keys = new int[len];
        for (int i3 = 0; i3 < len; ++i3) {
            keys[i3] = b[i3][1];
        }
        Arrays.sort(keys);
        int[] nids = new int[len];
        for (int i4 = 0; i4 < len; ++i4) {
            for (int j = 0; j < len; ++j) {
                if (keys[i4] != b[j][1]) continue;
                nids[i4] = b[j][2];
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("rank " + rank);
        for (int i5 = 0; i5 < nids.length; ++i5) {
            buffer.append("nids[" + i5 + "]=" + nids[i5]);
        }
        BufferFactory.destroy(buf.getStaticBuffer());
        BufferFactory.destroy(rbuf.getStaticBuffer());
        return this.create(nids);
    }
}

