/*
 * Decompiled with CFR 0.152.
 */
package mpjdev;

import java.util.UUID;
import mpjdev.MPJDevException;
import xdev.ProcessID;

public class Group {
    public ProcessID[] ids = null;
    public static final int NO_RANK = -1;
    ProcessID myID = null;
    int rank;
    int size;
    public static final int IDENT = 0;
    public static final int CONGRUENT = 3;
    public static final int SIMILAR = 1;
    public static final int UNEQUAL = 2;
    static final int UNDEFINED = -1;

    public Group(ProcessID[] ids, ProcessID myID, int rank) {
        this.ids = ids;
        this.size = ids.length;
        if (myID != null) {
            this.rank = rank;
            this.myID = myID;
            if (!ids[rank].uuid().equals(myID.uuid())) {
                System.out.println("The group should contain itself Error in mpjdev.Group constructor ");
            }
        } else {
            this.rank = -1;
        }
    }

    public void free() {
    }

    public int size() {
        return this.size;
    }

    public int rank() {
        return this.rank;
    }

    public static int[] transRanks(Group group1, int[] ranks1, Group group2) {
        int[] ranks2 = new int[ranks1.length];
        for (int k = 0; k < ranks2.length; ++k) {
            ranks2[k] = -1;
        }
        ProcessID[] ids1 = group1.ids;
        int size1 = group1.size;
        ProcessID[] ids2 = group2.ids;
        int size2 = group2.size;
        UUID temp1 = null;
        UUID temp2 = null;
        block1: for (int i = 0; i < ranks1.length; ++i) {
            temp1 = ids1[i].uuid();
            for (int j = 0; j < size2; ++j) {
                temp2 = ids2[j].uuid();
                if (!temp1.equals(temp2)) continue;
                ranks2[i] = j;
                continue block1;
            }
        }
        return ranks2;
    }

    public static int compare(Group group1, Group group2) {
        int i;
        if (group1 == null && group2 == null) {
            System.out.println("compare why are you comparing two null groups :( ?");
            return -1;
        }
        if (group1 == null && group2 != null) {
            System.out.println("compare group1 is null" + group1);
            return -1;
        }
        if (group1 != null && group2 == null) {
            System.out.println("compare group2 is null" + group2);
            return -1;
        }
        ProcessID[] ids1 = group1.ids;
        ProcessID myID1 = group1.myID;
        int size1 = group1.size;
        int rank1 = group1.rank;
        ProcessID[] ids2 = group2.ids;
        ProcessID myID2 = group2.myID;
        int size2 = group2.size;
        int rank2 = group2.rank;
        ProcessID[] tempids = new ProcessID[size1];
        Object ids = null;
        Object myID = null;
        boolean rank = false;
        boolean size = false;
        UUID temp1 = null;
        UUID temp2 = null;
        if (size1 != size2) {
            return 2;
        }
        boolean ident = true;
        for (i = 0; i < size1; ++i) {
            temp1 = ids1[i].uuid();
            if (temp1.equals(temp2 = ids2[i].uuid())) continue;
            ident = false;
            break;
        }
        if (ident) {
            return 0;
        }
        boolean sim = true;
        for (i = 0; i < size1; ++i) {
            temp1 = ids1[i].uuid();
            for (int j = 0; j < size2 && !temp1.equals(temp2 = ids2[j].uuid()); ++j) {
                if (j != size2) continue;
                sim = false;
            }
        }
        if (sim) {
            return 1;
        }
        return 2;
    }

    public static Group union(Group group1, Group group2) throws MPJDevException {
        int j;
        int i;
        if (group1 == null && group2 == null) {
            return null;
        }
        if (group1 == null && group2 != null) {
            ProcessID[] ids2 = group2.ids;
            ProcessID myID2 = group2.myID;
            int size2 = group2.size;
            int rank2 = group2.rank;
            ProcessID[] ids = new ProcessID[size2];
            ProcessID myID = null;
            int rank = -1;
            int size = 0;
            for (int i2 = 0; i2 < size2; ++i2) {
                ids[i2] = ids2[i2];
                if (myID2 == null || !ids[i2].uuid().equals(myID2.uuid())) continue;
                rank = rank2;
                myID = ids[i2];
            }
            size = size2;
            return new Group(ids, myID, rank);
        }
        if (group1 != null && group2 == null) {
            ProcessID[] ids1 = group1.ids;
            ProcessID myID1 = group1.myID;
            int size1 = group1.size;
            int rank1 = group1.rank;
            ProcessID[] ids = new ProcessID[size1];
            ProcessID myID = null;
            int rank = -1;
            int size = 0;
            for (int i3 = 0; i3 < size1; ++i3) {
                ids[i3] = ids1[i3];
                rank = i3;
                if (myID1 == null || !ids[i3].uuid().equals(myID1.uuid())) continue;
                myID = ids[i3];
            }
            size = size1;
            return new Group(ids, myID, rank);
        }
        ProcessID[] ids1 = group1.ids;
        ProcessID myID1 = group1.myID;
        int size1 = group1.size;
        int rank1 = group1.rank;
        ProcessID[] ids2 = group2.ids;
        ProcessID myID2 = group2.myID;
        int size2 = group2.size;
        int rank2 = group2.rank;
        ProcessID[] tempids = new ProcessID[size1 + size2];
        ProcessID[] ids = null;
        ProcessID myID = null;
        int rank = -1;
        int size = 0;
        for (i = 0; i < size1; ++i) {
            tempids[i] = ids1[i];
            if (myID1 == null || !tempids[i].uuid().equals(myID1.uuid())) continue;
            myID = tempids[i];
            rank = i;
        }
        size = size1;
        i = 0;
        UUID uuid2 = null;
        for (j = 0; j < size2; ++j) {
            uuid2 = ids2[j].uuid();
            boolean present = false;
            for (i = 0; i < size; ++i) {
                if (!tempids[i].uuid().equals(uuid2)) continue;
                present = true;
                break;
            }
            if (!present) {
                tempids[size] = ids2[j];
                if (myID2 != null && tempids[size].uuid().equals(myID2.uuid())) {
                    myID = tempids[size];
                    rank = size;
                }
                ++size;
            }
            present = false;
        }
        ids = new ProcessID[size];
        for (j = 0; j < size; ++j) {
            ids[j] = tempids[j];
        }
        return new Group(ids, myID, rank);
    }

    public static Group intersection(Group group1, Group group2) {
        int j;
        if (group1 == null || group2 == null) {
            return null;
        }
        ProcessID[] ids1 = group1.ids;
        ProcessID myID1 = group1.myID;
        int size1 = group1.size;
        int rank1 = group1.rank;
        ProcessID[] ids2 = group2.ids;
        ProcessID myID2 = group2.myID;
        int size2 = group2.size;
        int rank2 = group2.rank;
        ProcessID[] tempids = new ProcessID[size1 + size2];
        ProcessID[] ids = null;
        ProcessID myID = null;
        int rank = -1;
        int size = 0;
        block0: for (int i = 0; i < size1; ++i) {
            UUID temp1 = ids1[i].uuid();
            for (j = 0; j < size2; ++j) {
                UUID temp2 = ids2[j].uuid();
                if (!temp1.equals(temp2)) continue;
                tempids[size] = ids1[i];
                if (myID2 != null && tempids[size].uuid().equals(myID2.uuid()) || myID1 != null && tempids[size].uuid().equals(myID1.uuid())) {
                    rank = size;
                    myID = tempids[size];
                }
                ++size;
                continue block0;
            }
        }
        ids = new ProcessID[size];
        for (j = 0; j < size; ++j) {
            ids[j] = tempids[j];
        }
        return new Group(ids, myID, rank);
    }

    public static Group difference(Group group1, Group group2) throws MPJDevException {
        int j;
        if (group1 == null && group2 == null) {
            return null;
        }
        if (group1 == null && group2 != null) {
            return null;
        }
        if (group1 != null && group2 == null) {
            ProcessID[] ids1 = group1.ids;
            ProcessID myID1 = group1.myID;
            return new Group(ids1, myID1, group1.rank);
        }
        ProcessID[] ids1 = group1.ids;
        ProcessID myID1 = group1.myID;
        int size1 = group1.size;
        int rank1 = group1.rank;
        ProcessID[] ids2 = group2.ids;
        ProcessID myID2 = group2.myID;
        int size2 = group2.size;
        int rank2 = group2.rank;
        ProcessID[] tempids = new ProcessID[size1];
        ProcessID[] ids = null;
        ProcessID myID = null;
        int rank = -1;
        int size = 0;
        UUID temp1 = null;
        UUID temp2 = null;
        for (int i = 0; i < size1; ++i) {
            temp1 = ids1[i].uuid();
            boolean present = false;
            boolean sid = false;
            for (j = 0; j < size2; ++j) {
                temp2 = ids2[j].uuid();
                if (!temp1.equals(temp2)) continue;
                present = true;
                break;
            }
            if (!present) {
                tempids[size] = ids1[i];
                if (rank1 != -1 && temp1.equals(myID1.uuid())) {
                    myID = tempids[size];
                    rank = size;
                }
                ++size;
            }
            present = false;
        }
        ids = new ProcessID[size];
        for (j = 0; j < size; ++j) {
            ids[j] = tempids[j];
        }
        return new Group(ids, myID, rank);
    }

    public Group incl(int[] ranks) throws MPJDevException {
        StringBuffer buffer = new StringBuffer();
        int rank = -1;
        if (ranks.length > this.size) {
            throw new MPJDevException("Error in Group Incl method: length of array " + ranks.length + " is greater than size <" + this.size + ">");
        }
        for (int i = 0; i < ranks.length; ++i) {
            if (ranks[i] <= this.size - 1 && ranks[i] >= 0) continue;
            throw new MPJDevException("Error in Group Incl method: arg[" + i + "] " + "of array is bounded by [0-" + (this.size - 1) + "]");
        }
        ProcessID[] newIds = new ProcessID[ranks.length];
        ProcessID myID = null;
        for (int j = 0; j < ranks.length; ++j) {
            newIds[j] = this.ids[ranks[j]];
            if (ranks[j] != this.rank) continue;
            myID = newIds[j];
            rank = j;
        }
        return new Group(newIds, myID, rank);
    }

    public Group excl(int[] ranks) throws MPJDevException {
        int i;
        if (ranks.length > this.size) {
            throw new MPJDevException("Error in Group Excl method: length of array " + ranks.length + " is greater than size <" + this.size + ">");
        }
        for (i = 0; i < ranks.length; ++i) {
            if (ranks[i] <= this.size - 1 && ranks[i] >= 0) continue;
            throw new MPJDevException("Error in Group Excl method: arg[" + i + "] " + "of array is bounded by [0-" + (this.size - 1) + "]");
        }
        ProcessID[] newIds = new ProcessID[this.size - ranks.length];
        ProcessID myID = null;
        int rank = -1;
        int nrank = 0;
        boolean present = false;
        for (int j = 0; j < this.size; ++j) {
            for (i = 0; i < ranks.length; ++i) {
                if (j != ranks[i]) continue;
                present = true;
            }
            if (!present) {
                newIds[nrank] = this.ids[j];
                if (j == this.rank) {
                    myID = newIds[nrank];
                    rank = nrank;
                }
                ++nrank;
            }
            present = false;
        }
        return new Group(newIds, myID, rank);
    }

    public Group rangeIncl(int[][] ranges) throws MPJDevException {
        int str;
        int lRank;
        int fRank;
        int i;
        int len = ranges.length;
        int np = 0;
        for (i = 0; i < len; ++i) {
            fRank = ranges[i][0];
            lRank = ranges[i][1];
            str = ranges[i][2];
            if (str != 0) {
                if (str > 0 && fRank > lRank) {
                    throw new MPJDevException("Error in rangeIncl: stride <" + str + ">" + "is greater than zero and firstRank <" + fRank + "> is greater than lastRank <" + lRank + ">");
                }
                if (str < 0 && fRank < lRank) {
                    throw new MPJDevException("Error in rangeIncl: stride <" + str + ">" + "is less than zero and firstRank <" + fRank + "> is less than lastRank <" + lRank + ">");
                }
                int ranks = (lRank - fRank) / str + 1;
                if (ranks <= 0) continue;
                np += ranks;
                continue;
            }
            throw new MPJDevException("Error in rangeIncl: stride <" + str + ">" + "is zero");
        }
        if (np == 0) {
            throw new MPJDevException("Error in rangeIncl: number of processes <" + np + "> to be included in new group is zero");
        }
        int[] npp = new int[np];
        int k = 0;
        for (i = 0; i < len; ++i) {
            fRank = ranges[i][0];
            lRank = ranges[i][1];
            str = ranges[i][2];
            if (str != 0) {
                int j = fRank;
                while (j * str <= lRank * str) {
                    if (j < this.size() && j >= 0) {
                        npp[k] = j;
                        ++k;
                    }
                    j += str;
                }
                continue;
            }
            throw new MPJDevException("Error in rangeIncl: stride <" + str + ">" + "is zero");
        }
        return this.incl(npp);
    }

    public Group rangeExcl(int[][] ranges) throws MPJDevException {
        int str;
        int lRank;
        int fRank;
        int i;
        int len = ranges.length;
        int np = 0;
        for (i = 0; i < len; ++i) {
            fRank = ranges[i][0];
            lRank = ranges[i][1];
            str = ranges[i][2];
            if (str != 0) {
                if (str > 0 && fRank > lRank) {
                    throw new MPJDevException("Error in rangeExcl: stride <" + str + ">" + "is greater than zero and firstRank <" + fRank + "> is greater than lastRank <" + lRank + ">");
                }
                if (str < 0 && fRank < lRank) {
                    throw new MPJDevException("Error in rangeExcl: stride <" + str + ">" + "is less than zero and firstRank <" + fRank + "> is less than lastRank <" + lRank + ">");
                }
                int ranks = (lRank - fRank) / str + 1;
                if (ranks <= 0) continue;
                np += ranks;
                continue;
            }
            throw new MPJDevException("Error in rangeExcl: stride <" + str + ">" + "is zero");
        }
        if (np == 0) {
            throw new MPJDevException("Error in rangeExcl: number of processes <" + np + "> to be included in new group is zero");
        }
        int k = 0;
        int[] npp = new int[np];
        for (i = 0; i < len; ++i) {
            fRank = ranges[i][0];
            lRank = ranges[i][1];
            str = ranges[i][2];
            if (str != 0) {
                int j = fRank;
                while (j * str <= lRank * str) {
                    if (j < this.size() && j >= 0) {
                        npp[k] = j;
                        ++k;
                    }
                    j += str;
                }
                continue;
            }
            throw new MPJDevException("Error in rangeExcl: stride <" + str + ">" + "is zero");
        }
        return this.excl(npp);
    }

    public void finalize() throws MPJDevException {
    }
}

