/*
 * Decompiled with CFR 0.152.
 */
package mpjdev;

import mpjdev.Comm;
import mpjdev.Group;
import mpjdev.MPJDevException;
import org.apache.log4j.Logger;
import xdev.Device;
import xdev.ProcessID;
import xdev.XDevException;
import xdev.mxdev.MXDevice;
import xdev.niodev.NIODevice;
import xdev.smpdev.SMPDevice;

public class MPJDev {
    public static Comm WORLD = null;
    static Device dev = null;
    static Logger logger = Logger.getLogger((String)"mpj");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Device init(String[] args) throws MPJDevException {
        if (args.length < 3) {
            throw new MPJDevException("Usage: java MPJDev <myrank> <conf_file> <device_name>conf_file can be, ../conf/xdev.conf <Local>OR http://holly.dsg.port.ac.uk:15000/xdev.conf <Remote>");
        }
        Class<MPJDev> clazz = MPJDev.class;
        synchronized (MPJDev.class) {
            if (dev == null) {
                String device = args[2];
                if (device.equals("niodev")) {
                    dev = new NIODevice();
                } else if (device.equals("mxdev")) {
                    dev = new MXDevice();
                } else if (device.equals("smpdev")) {
                    dev = new SMPDevice();
                } else {
                    throw new MPJDevException("No matching device found for <" + dev + ">");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (dev == null) {
                System.out.println("Specified device: " + args[2]);
                System.out.println("Available devices, niodev, smpdev, gmdev");
                System.out.println("Error, cant execute, correct the device first");
                return dev;
            }
            ProcessID[] ids = dev.init(args);
            ProcessID myID = dev.id();
            int myRank = -1;
            for (int i = 0; i < ids.length; ++i) {
                if (!myID.uuid().equals(ids[i].uuid())) continue;
                myRank = i;
                break;
            }
            WORLD = new Comm(dev, new Group(ids, myID, myRank));
            return dev;
        }
    }

    public static int getSendOverhead() {
        if (dev == null) {
            throw new MPJDevException("MPJDev should call init before getting getSendOverhead()");
        }
        return dev.getSendOverhead();
    }

    public static int getRecvOverhead() {
        if (dev == null) {
            throw new MPJDevException("MPJDev should call init before getting getRecvOverhead()");
        }
        return dev.getRecvOverhead();
    }

    public static void finish() throws MPJDevException {
        try {
            dev.finish();
        }
        catch (XDevException xde) {
            throw new MPJDevException(xde);
        }
        dev = null;
    }
}

