/*
 * Decompiled with CFR 0.152.
 */
package xdev.niodev;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.Vector;
import mpi.ProcTree;
import mpjbuf.Buffer;
import mpjbuf.BufferFactory;
import mpjbuf.NIOBuffer;
import mpjbuf.RawBuffer;
import mpjbuf.Type;
import mpjdev.Request;
import mpjdev.Status;
import org.apache.log4j.Logger;
import xdev.Device;
import xdev.ProcessID;
import xdev.XDevException;
import xdev.niodev.ConfigReader;
import xdev.niodev.NIORecvRequest;
import xdev.niodev.NIORequest;
import xdev.niodev.NIOSendRequest;

public class NIODevice
implements Device {
    int index;
    int root;
    int extent;
    int places;
    ProcTree procTree;
    long nextSequenceNum = 1L;
    CustomSemaphore sLock = new CustomSemaphore(1);
    CustomSemaphore sem = new CustomSemaphore(1);
    CustomSemaphore buffer_sem = new CustomSemaphore(1);
    static Logger logger = Logger.getLogger((String)"mpj");
    Vector<SocketChannel> writableChannels = new Vector();
    Vector<SocketChannel> readableChannels = new Vector();
    Hashtable<UUID, SocketChannel> worldWritableTable = new Hashtable();
    Hashtable<UUID, SocketChannel> worldReadableTable = new Hashtable();
    Hashtable<SocketChannel, CustomSemaphore> writeLockTable = new Hashtable();
    InetAddress localaddr = null;
    Selector selector = null;
    volatile boolean selectorFlag = true;
    private HashMap<Integer, NIOSendRequest> sendMap = new HashMap();
    private int sendCounter = 0;
    private int recvCounter = 0;
    HashMap<Integer, NIORecvRequest> recvMap = new HashMap();
    RecvQueue recvQueue = new RecvQueue();
    ArrvQueue arrQue = new ArrvQueue();
    String localHostName = null;
    ServerSocketChannel writableServerChannel = null;
    ServerSocketChannel readableServerChannel = null;
    ByteBuffer rcb = ByteBuffer.allocate(45);
    ByteBuffer rendezBuffer = ByteBuffer.allocate(8);
    ByteBuffer rendez_send_buffer = ByteBuffer.allocate(17);
    ByteBuffer wcb = ByteBuffer.allocate(49);
    ByteBuffer e_wcb = ByteBuffer.allocate(49);
    static ByteBuffer _wcb = ByteBuffer.allocate(21);
    ByteBuffer s_wcb = ByteBuffer.allocate(20);
    Thread selectorThreadStarter = null;
    int psl = 0;
    int nprocs = 0;
    int rank = 0;
    int size = 0;
    int my_server_port = 0;
    ProcessID[] pids = null;
    ProcessID id = null;
    private final int INIT_MSG_HEADER_DATA_CHANNEL = -21;
    private final int INIT_MSG_HEADER_CTRL_CHANNEL = -20;
    private final int RENDEZ_CTRL_MSG_LENGTH = 4;
    private final int ACK_LENGTH = 17;
    private final int CTRL_MSG_LENGTH = 45;
    int SEND_OVERHEAD = 49;
    int RECV_OVERHEAD = 0;
    private final int STD_COMM_MODE = 3;
    private final int SYNC_COMM_MODE = 2;
    private final boolean NO_ACK_RECEIVED = false;
    private final boolean REQ_NOT_COMPLETED = false;
    private final boolean RECV_POSTED = true;
    private final int READY_TO_SEND = -24;
    private static final int ACK_HEADER = -23;
    private final int RENDEZ_HEADER = -22;
    private final int SEND_ACK_TO_SENDER = -80;
    private final int RECV_IN_USER_MEMORY = -81;
    private final int RECV_IN_DEV_MEMORY = -82;
    private final int MORE_TO_WRITE = -83;
    private final int MORE_TO_READ = -84;
    private String mpjHomeDir = null;
    SocketChannel msgReceivedFrom;
    boolean finished = false;
    static CompletedList completedList = new CompletedList();
    Object finishLock = new Object();
    static final int SHUTDOWN_SIGNAL = -13;
    static final int END_OF_STREAM = -14;
    Runnable selectorThread = new Runnable(){

        @Override
        public void run() {
            Set<SelectionKey> readyKeys = null;
            long t_start = 0L;
            long t_end = 0L;
            long diff_start = 0L;
            long diff_end = 0L;
            long stop_ready_sendrecv = 0L;
            long start_ready_sendrecv = 0L;
            Iterator<SelectionKey> readyItor = null;
            SelectionKey key = null;
            SelectableChannel keyChannel = null;
            SocketChannel socketChannel = null;
            ByteBuffer lilBuffer = ByteBuffer.allocate(4);
            boolean tempRead = false;
            boolean read = false;
            boolean shutdownCounter = false;
            Object sendRequest = null;
            NIORecvRequest recvRequest = null;
            Object pendingReadChannel = null;
            int header = 0;
            try {
                while (NIODevice.this.selectorFlag && NIODevice.this.selector.select() > -1) {
                    readyKeys = NIODevice.this.selector.selectedKeys();
                    readyItor = readyKeys.iterator();
                    block11: while (readyItor.hasNext()) {
                        key = readyItor.next();
                        readyItor.remove();
                        keyChannel = key.channel();
                        if (key.isValid() && key.isAcceptable()) {
                            ServerSocketChannel sChannel = (ServerSocketChannel)keyChannel;
                            if (sChannel.socket().getLocalPort() == NIODevice.this.my_server_port) {
                                NIODevice.this.doAccept(keyChannel, NIODevice.this.writableChannels, true);
                                continue;
                            }
                            NIODevice.this.doAccept(keyChannel, NIODevice.this.readableChannels, false);
                            continue;
                        }
                        if (key.isValid() && key.isReadable()) {
                            socketChannel = (SocketChannel)keyChannel;
                            if (key.attachment() == null) {
                                lilBuffer.clear();
                                header = 0;
                                while (lilBuffer.hasRemaining() && (header = socketChannel.read(lilBuffer)) != -1) {
                                }
                                if (header != -1) {
                                    lilBuffer.flip();
                                    header = lilBuffer.getInt();
                                    lilBuffer.clear();
                                } else {
                                    header = -14;
                                }
                                switch (header) {
                                    case -24: {
                                        recvRequest = NIODevice.this.recvCtrlMsgFromSender(socketChannel, key);
                                        if (recvRequest.code == -80) {
                                            SocketChannel c = NIODevice.this.worldWritableTable.get(recvRequest.srcUUID);
                                            CustomSemaphore wLock = NIODevice.this.writeLockTable.get(c);
                                            long acq = System.nanoTime();
                                            wLock.acquire();
                                            long rel = System.nanoTime();
                                            NIODevice.rendezCtrlMsgR2S(c, recvRequest);
                                            wLock.signal();
                                            continue block11;
                                        }
                                        if (recvRequest.code == -81) {
                                            NIODevice.this.eagerRecv2UserMem(recvRequest, socketChannel);
                                            recvRequest.notifyMe();
                                            continue block11;
                                        }
                                        if (recvRequest.code != -82) continue block11;
                                        NIODevice.this.eagerRecv2mpjMem(recvRequest, socketChannel);
                                        NIODevice.this.arrQue.add(recvRequest);
                                        NIODevice.this.sem.signal();
                                        continue block11;
                                    }
                                    case -23: {
                                        NIODevice.this.buffer_sem.acquire();
                                        NIODevice.this.doRendezSendCompletion(socketChannel, key);
                                        new Thread(NIODevice.this.rendezSenderThread).start();
                                        continue block11;
                                    }
                                    case -22: {
                                        NIODevice.this.rcb.limit(4);
                                        NIODevice.this.rcb.position(0);
                                        while (NIODevice.this.rcb.hasRemaining()) {
                                            if (socketChannel.read(NIODevice.this.rcb) != -1) continue;
                                            throw new ClosedChannelException();
                                        }
                                        NIODevice.this.rcb.flip();
                                        int recvCounter = NIODevice.this.rcb.getInt();
                                        NIODevice.this.sem.acquire();
                                        recvRequest = NIODevice.this.recvMap.remove(new Integer(recvCounter));
                                        NIODevice.this.sem.signal();
                                        if (recvRequest == null) continue block11;
                                        header = -22;
                                        int code2 = NIODevice.this.rendezRecvData(socketChannel, header, recvRequest);
                                        if (code2 != -84) {
                                            recvRequest.notifyMe();
                                            key.attach(null);
                                            recvRequest = null;
                                            continue block11;
                                        }
                                        key.attach(recvRequest);
                                        continue block11;
                                    }
                                    case -21: {
                                        NIODevice.this.doBarrierRead((SocketChannel)keyChannel, NIODevice.this.worldReadableTable, false);
                                        continue block11;
                                    }
                                    case -20: {
                                        NIODevice.this.doBarrierRead((SocketChannel)keyChannel, NIODevice.this.worldReadableTable, false);
                                        continue block11;
                                    }
                                    case -14: {
                                        NIODevice.this.realFinish();
                                        continue block11;
                                    }
                                }
                                System.out.println(" impossible ");
                                continue;
                            }
                            recvRequest = (NIORecvRequest)key.attachment();
                            if (recvRequest == null) {
                                System.out.println("recvRequest cannot be null");
                                continue;
                            }
                            header = -22;
                            int code4 = NIODevice.this.rendezRecvData(socketChannel, header, recvRequest);
                            if (code4 == -84) continue;
                            recvRequest.notifyMe();
                            key.attach(null);
                            continue;
                        }
                        if (!key.isValid() || !key.isWritable()) continue;
                        key.interestOps(1);
                    }
                }
            }
            catch (Exception ioe1) {
                // empty catch block
            }
        }
    };
    Runnable rendezSenderThread = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                byte goAhead = 0;
                int tag = 0;
                int context = 0;
                int sendCounter = 0;
                int recvCounter = 0;
                ByteBuffer byteBuffer = NIODevice.this.rendez_send_buffer;
                synchronized (byteBuffer) {
                    SocketChannel channel = NIODevice.this.msgReceivedFrom;
                    goAhead = NIODevice.this.rendez_send_buffer.get();
                    tag = NIODevice.this.rendez_send_buffer.getInt();
                    context = NIODevice.this.rendez_send_buffer.getInt();
                    sendCounter = NIODevice.this.rendez_send_buffer.getInt();
                    recvCounter = NIODevice.this.rendez_send_buffer.getInt();
                    NIODevice.this.rendez_send_buffer.clear();
                }
                NIODevice.this.buffer_sem.signal();
                NIODevice.this.sLock.acquire();
                NIOSendRequest sendRequest = (NIOSendRequest)NIODevice.this.sendMap.remove(new Integer(sendCounter));
                sendRequest.recvCounter = recvCounter;
                NIODevice.this.s_wcb.clear();
                NIODevice.this.sLock.signal();
                SocketChannel ch = NIODevice.this.worldWritableTable.get(sendRequest.dstUUID);
                CustomSemaphore wLock = NIODevice.this.writeLockTable.get(ch);
                wLock.acquire();
                if (sendRequest == null) {
                    System.out.println("Calling rendezSendData (WRITE_EVENT)");
                    System.out.println("Problem ");
                    System.exit(0);
                }
                NIODevice.this.rendezSendCtrlMsg(ch, sendRequest);
                int code = NIODevice.this.rendezSendData(ch, sendRequest);
                if (code != -83) {
                    sendRequest.notifyMe();
                } else {
                    System.out.println(" The channel is in blocking mode ");
                    System.out.println(" This shouldn't happen ");
                    System.exit(0);
                }
                wLock.signal();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessID[] init(String[] args) throws XDevException {
        int i;
        Vector<SocketChannel> e4;
        if (args.length < 3) {
            throw new XDevException("Usage: java NIODevice <myrank> <conf_file> <device_name>conf_file can be, ../conf/xdev.conf <Local>OR http://holly.dsg.port.ac.uk:15000/xdev.conf <Remote>");
        }
        this.rank = Integer.parseInt(args[0]);
        UUID myuuid = UUID.randomUUID();
        this.id = new ProcessID(myuuid);
        Map<String, String> map = System.getenv();
        this.mpjHomeDir = map.get("MPJ_HOME");
        try {
            this.localaddr = InetAddress.getLocalHost();
            this.localHostName = this.localaddr.getHostName();
        }
        catch (UnknownHostException unkhe) {
            throw new XDevException(unkhe);
        }
        ConfigReader reader = null;
        try {
            reader = new ConfigReader(args[1]);
            this.nprocs = new Integer(reader.readNoOfProc());
            this.psl = new Integer(reader.readIntAsString());
            if (this.psl < 12) {
                logger.debug((Object)"lowest possible psl is 12 bytes");
                this.psl = 12;
            }
        }
        catch (Exception config_error) {
            throw new XDevException(config_error);
        }
        this.pids = new ProcessID[this.nprocs];
        String[] nodeList = new String[this.nprocs];
        int[] pList = new int[this.nprocs];
        int[] rankList = new int[this.nprocs];
        int count = 0;
        while (count < this.nprocs) {
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException ioe) {
                throw new XDevException(ioe);
            }
            if (line == null || line.equals("") || line.equals("#")) continue;
            line = line.trim();
            StringTokenizer tokenizer = new StringTokenizer(line, "@");
            nodeList[count] = tokenizer.nextToken();
            pList[count] = new Integer(tokenizer.nextToken());
            rankList[count] = new Integer(tokenizer.nextToken());
            ++count;
        }
        reader.close();
        try {
            this.selector = Selector.open();
        }
        catch (IOException ioe) {
            throw new XDevException(ioe);
        }
        SocketChannel[] rChannels = new SocketChannel[nodeList.length - 1];
        SocketChannel[] wChannels = new SocketChannel[nodeList.length - 1];
        boolean isOK = false;
        boolean isError = false;
        while (!isOK) {
            isOK = false;
            isError = false;
            try {
                this.writableServerChannel = ServerSocketChannel.open();
                this.writableServerChannel.configureBlocking(false);
                this.writableServerChannel.socket().bind(new InetSocketAddress(pList[this.rank]));
                this.writableServerChannel.register(this.selector, 16);
                this.my_server_port = pList[this.rank];
                this.readableServerChannel = ServerSocketChannel.open();
                this.readableServerChannel.configureBlocking(false);
                this.readableServerChannel.socket().bind(new InetSocketAddress(pList[this.rank] + 1));
                this.readableServerChannel.register(this.selector, 16);
            }
            catch (IOException ioe) {
                isError = true;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            finally {
                if (isError) {
                    isOK = false;
                    continue;
                }
                if (isError) continue;
                isOK = true;
            }
        }
        boolean connected = false;
        int temp = 0;
        int index = 0;
        while (temp < this.nprocs - 1) {
            if (this.rank == rankList[temp]) {
                ++temp;
                continue;
            }
            if (rankList[temp] < this.rank) {
                while (!connected) {
                    try {
                        rChannels[index] = SocketChannel.open();
                        rChannels[index].configureBlocking(true);
                    }
                    catch (Exception e3) {
                        throw new XDevException(e3);
                    }
                    try {
                        connected = rChannels[index].connect(new InetSocketAddress(nodeList[temp], pList[temp]));
                    }
                    catch (AlreadyConnectedException ace) {
                        throw new XDevException(ace);
                    }
                    catch (ConnectionPendingException cpe) {
                        throw new XDevException(cpe);
                    }
                    catch (ClosedChannelException cce) {
                        throw new XDevException(cce);
                    }
                    catch (UnresolvedAddressException uae) {
                        throw new XDevException(uae);
                    }
                    catch (UnsupportedAddressTypeException uate) {
                        throw new XDevException(uate);
                    }
                    catch (SecurityException se) {
                        throw new XDevException(se);
                    }
                    catch (IOException ioe) {
                        connected = false;
                        continue;
                    }
                    try {
                        rChannels[index].configureBlocking(false);
                        rChannels[index].register(this.selector, 1);
                        rChannels[index].socket().setTcpNoDelay(true);
                        rChannels[index].socket().setSendBufferSize(524288);
                        rChannels[index].socket().setReceiveBufferSize(524288);
                    }
                    catch (Exception e4) {
                        throw new XDevException(e4);
                    }
                    e4 = this.readableChannels;
                    synchronized (e4) {
                        this.readableChannels.add(rChannels[index]);
                        if (this.readableChannels.size() == this.nprocs - 1) {
                            this.readableChannels.notify();
                        }
                    }
                    connected = true;
                }
                connected = false;
            }
            ++index;
            ++temp;
        }
        connected = false;
        temp = 0;
        index = 0;
        while (temp < this.nprocs - 1) {
            if (this.rank == rankList[temp]) {
                ++temp;
                continue;
            }
            if (rankList[temp] < this.rank) {
                while (!connected) {
                    try {
                        wChannels[index] = SocketChannel.open();
                        wChannels[index].configureBlocking(true);
                    }
                    catch (Exception e5) {
                        throw new XDevException(e5);
                    }
                    try {
                        connected = wChannels[index].connect(new InetSocketAddress(nodeList[temp], pList[temp] + 1));
                    }
                    catch (AlreadyConnectedException ace) {
                        throw new XDevException(ace);
                    }
                    catch (ConnectionPendingException cpe) {
                        throw new XDevException(cpe);
                    }
                    catch (ClosedChannelException cce) {
                        throw new XDevException(cce);
                    }
                    catch (UnresolvedAddressException uae) {
                        throw new XDevException(uae);
                    }
                    catch (UnsupportedAddressTypeException uate) {
                        throw new XDevException(uate);
                    }
                    catch (SecurityException se) {
                        throw new XDevException(se);
                    }
                    catch (IOException ioe) {
                        connected = false;
                        continue;
                    }
                    try {
                        wChannels[index].configureBlocking(true);
                        wChannels[index].socket().setTcpNoDelay(true);
                        wChannels[index].socket().setSendBufferSize(524288);
                        wChannels[index].socket().setReceiveBufferSize(524288);
                    }
                    catch (Exception e6) {
                        throw new XDevException(e6);
                    }
                    e4 = this.writableChannels;
                    synchronized (e4) {
                        this.writableChannels.add(wChannels[index]);
                        if (this.writableChannels.size() == this.nprocs - 1) {
                            this.writableChannels.notify();
                        }
                    }
                    connected = true;
                }
                connected = false;
            }
            ++index;
            ++temp;
        }
        index = this.rank;
        this.root = 0;
        this.procTree = new ProcTree();
        this.extent = this.nprocs;
        this.places = 4 * index;
        for (int i2 = 1; i2 <= 4; ++i2) {
            ++this.places;
            int ch = 4 * index + i2 + this.root;
            ch %= this.extent;
            if (this.places >= this.extent) continue;
            this.procTree.child[i2 - 1] = ch;
            ++this.procTree.numChildren;
        }
        if (index == this.root) {
            this.procTree.isRoot = true;
        } else {
            int pr;
            this.procTree.isRoot = false;
            this.procTree.parent = pr = (index - 1) / 4;
        }
        this.procTree.root = this.root;
        this.selectorThreadStarter = new Thread(this.selectorThread);
        this.selectorThreadStarter.start();
        count = 0;
        Vector<SocketChannel> pr = this.writableChannels;
        synchronized (pr) {
            if (this.writableChannels.size() != this.nprocs - 1) {
                try {
                    this.writableChannels.wait();
                }
                catch (Exception e7) {
                    throw new XDevException(e7);
                }
            }
        }
        pr = this.readableChannels;
        synchronized (pr) {
            if (this.readableChannels.size() != this.nprocs - 1) {
                try {
                    this.readableChannels.wait();
                }
                catch (Exception e8) {
                    throw new XDevException(e8);
                }
            }
        }
        SocketChannel socketChannel = null;
        ByteBuffer initMsgBuffer = ByteBuffer.allocate(24);
        long msb = myuuid.getMostSignificantBits();
        long lsb = myuuid.getLeastSignificantBits();
        initMsgBuffer.putInt(-21);
        initMsgBuffer.putInt(this.rank);
        initMsgBuffer.putLong(msb);
        initMsgBuffer.putLong(lsb);
        for (int i3 = 0; i3 < this.writableChannels.size(); ++i3) {
            socketChannel = this.writableChannels.get(i3);
            initMsgBuffer.flip();
            while (initMsgBuffer.hasRemaining()) {
                try {
                    if (socketChannel.write(initMsgBuffer) != -1) continue;
                    throw new XDevException(new ClosedChannelException());
                }
                catch (Exception e9) {
                    throw new XDevException(e9);
                }
            }
            _wcb.clear();
        }
        Hashtable<UUID, SocketChannel> i3 = this.worldReadableTable;
        synchronized (i3) {
            if (this.worldReadableTable.size() != this.nprocs - 1) {
                try {
                    this.worldReadableTable.wait();
                }
                catch (Exception e10) {
                    throw new XDevException(e10);
                }
            }
        }
        for (i = 0; i < this.readableChannels.size(); ++i) {
            socketChannel = this.readableChannels.get(i);
            initMsgBuffer.flip();
            while (initMsgBuffer.hasRemaining()) {
                try {
                    if (socketChannel.write(initMsgBuffer) != -1) continue;
                    throw new XDevException(new ClosedChannelException());
                }
                catch (Exception e11) {
                    throw new XDevException(e11);
                }
            }
        }
        for (i = 0; i < this.writableChannels.size(); ++i) {
            socketChannel = this.writableChannels.get(i);
            this.doBarrierRead(socketChannel, this.worldWritableTable, true);
            continue;
        }
        Hashtable<UUID, SocketChannel> i4 = this.worldWritableTable;
        synchronized (i4) {
            if (this.worldWritableTable.size() != this.nprocs - 1) {
                try {
                    this.worldWritableTable.wait();
                }
                catch (Exception e12) {
                    throw new XDevException(e12);
                }
            }
        }
        this.pids[this.rank] = this.id;
        for (int k = 0; k < this.writableChannels.size(); ++k) {
            this.writeLockTable.put(this.writableChannels.elementAt(k), new CustomSemaphore(1));
        }
        try {
            this.writableServerChannel.close();
            this.readableServerChannel.close();
        }
        catch (Exception e13) {
            throw new XDevException(e13);
        }
        return this.pids;
    }

    @Override
    public ProcessID id() {
        return this.id;
    }

    @Override
    public int getSendOverhead() {
        return this.SEND_OVERHEAD;
    }

    @Override
    public int getRecvOverhead() {
        return this.RECV_OVERHEAD;
    }

    @Override
    public Status iprobe(ProcessID srcID, int tag, int context) throws XDevException {
        UUID dstUUID = this.id.uuid();
        UUID srcUUID = srcID.uuid();
        Status status = null;
        try {
            this.sem.acquire();
        }
        catch (Exception e) {
            throw new XDevException(e);
        }
        NIORecvRequest request = this.arrQue.check(context, srcUUID, tag);
        if (request != null) {
            status = new Status(request.srcUUID, request.tag, -1, request.type, request.numEls);
        }
        this.sem.signal();
        return status;
    }

    @Override
    public Status probe(ProcessID srcID, int tag, int context) throws XDevException {
        Status status = null;
        boolean comp = false;
        while (!comp) {
            status = this.iprobe(srcID, tag, context);
            if (status == null) continue;
            comp = true;
        }
        return status;
    }

    private synchronized int sendCounter() {
        return ++this.sendCounter;
    }

    private synchronized int recvCounter() {
        return ++this.recvCounter;
    }

    private synchronized int hashCode(int tag, int context, int srcHash, int dstHash) {
        return tag + context * 5 + dstHash * 11 + srcHash * 17;
    }

    @Override
    public Request isend(Buffer buf, ProcessID dstID, int tag, int context) throws XDevException {
        UUID srcUUID;
        UUID dstUUID = dstID.uuid();
        if (dstUUID.equals(srcUUID = this.id.uuid())) {
            try {
                this.sem.acquire();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            NIORecvRequest recvRequest = this.recvQueue.rem(context, srcUUID, tag);
            NIOSendRequest sendRequest = new NIOSendRequest(tag, this.id(), dstID, buf, context, 3, -1);
            if (recvRequest != null) {
                this.sem.signal();
                recvRequest.type = sendRequest.type;
                recvRequest.numEls = sendRequest.numEls;
                recvRequest.buffer.setSize(sendRequest.sBufSize);
                recvRequest.sBufSize = sendRequest.sBufSize;
                recvRequest.dBufSize = sendRequest.dBufSize;
                recvRequest.buffer.setDynamicBuffer(sendRequest.dynamicBuffer);
                recvRequest.staticBuffer.limit(recvRequest.sBufSize);
                recvRequest.staticBuffer.position(0);
                sendRequest.staticBuffer.limit(recvRequest.sBufSize + sendRequest.bufoffset);
                sendRequest.staticBuffer.position(sendRequest.bufoffset);
                recvRequest.staticBuffer.put(sendRequest.staticBuffer);
                recvRequest.staticBuffer.flip();
                recvRequest.setCompleted(true);
                sendRequest.setCompleted(true);
                return sendRequest;
            }
            recvRequest = new NIORecvRequest(this.id.uuid(), tag, false, context, sendRequest.sBufSize, sendRequest.dBufSize, sendRequest.commMode, null, sendRequest.numEls, sendRequest.type, -1, -1, srcUUID);
            recvRequest.sendRequest = sendRequest;
            this.arrQue.add(recvRequest);
            this.sem.signal();
            return sendRequest;
        }
        NIOSendRequest req = new NIOSendRequest(tag, this.id(), dstID, buf, context, 3, this.sendCounter());
        SocketChannel channel = this.worldWritableTable.get(dstUUID);
        if (req.sBufSize + req.dBufSize <= this.psl) {
            CustomSemaphore wLock = this.writeLockTable.get(channel);
            try {
                wLock.acquire();
                this.eagerSend(req, channel);
                wLock.signal();
                req.notifyMe();
            }
            catch (Exception e) {
                throw new XDevException(e);
            }
        }
        if (req.sBufSize + req.dBufSize > this.psl) {
            try {
                this.sLock.acquire();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.sendMap.put(new Integer(req.sendCounter), req);
            this.sLock.signal();
            CustomSemaphore wLock = this.writeLockTable.get(channel);
            try {
                wLock.acquire();
                this.rendezCtrlMsgSend(req, channel);
                wLock.signal();
            }
            catch (Exception e) {
                throw new XDevException(e);
            }
        }
        return req;
    }

    @Override
    public Request issend(Buffer buf, ProcessID dstID, int tag, int context) throws XDevException {
        UUID srcUUID;
        NIOSendRequest req = null;
        SocketChannel channel = null;
        UUID dstUUID = dstID.uuid();
        if (dstUUID.equals(srcUUID = this.id.uuid())) {
            try {
                this.sem.acquire();
            }
            catch (Exception e) {
                // empty catch block
            }
            NIORecvRequest recvRequest = this.recvQueue.rem(context, srcUUID, tag);
            NIOSendRequest sendRequest = new NIOSendRequest(tag, this.id(), dstID, buf, context, 2, -1);
            if (recvRequest != null) {
                this.sem.signal();
                recvRequest.type = sendRequest.type;
                recvRequest.numEls = sendRequest.numEls;
                recvRequest.buffer.setSize(sendRequest.sBufSize);
                recvRequest.sBufSize = sendRequest.sBufSize;
                recvRequest.dBufSize = sendRequest.dBufSize;
                recvRequest.buffer.setDynamicBuffer(sendRequest.dynamicBuffer);
                recvRequest.staticBuffer.limit(recvRequest.sBufSize);
                recvRequest.staticBuffer.position(0);
                sendRequest.staticBuffer.limit(recvRequest.sBufSize + sendRequest.bufoffset);
                sendRequest.staticBuffer.position(sendRequest.bufoffset);
                recvRequest.staticBuffer.put(sendRequest.staticBuffer);
                recvRequest.staticBuffer.flip();
                recvRequest.setCompleted(true);
                sendRequest.setCompleted(true);
                return sendRequest;
            }
            recvRequest = new NIORecvRequest(this.id.uuid(), tag, false, context, sendRequest.sBufSize, sendRequest.dBufSize, sendRequest.commMode, null, sendRequest.numEls, sendRequest.type, -1, -1, srcUUID);
            recvRequest.sendRequest = sendRequest;
            this.arrQue.add(recvRequest);
            this.sem.signal();
            return sendRequest;
        }
        req = new NIOSendRequest(tag, this.id(), dstID, buf, context, 2, this.sendCounter());
        channel = this.worldWritableTable.get(dstUUID);
        try {
            this.sLock.acquire();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.sendMap.put(new Integer(req.sendCounter), req);
        this.sLock.signal();
        CustomSemaphore wLock = this.writeLockTable.get(channel);
        try {
            wLock.acquire();
            this.rendezCtrlMsgSend(req, channel);
            wLock.signal();
        }
        catch (Exception e) {
            throw new XDevException(e);
        }
        return req;
    }

    @Override
    public void send(Buffer buf, ProcessID dstID, int tag, int context) throws XDevException {
        Request request = this.isend(buf, dstID, tag, context);
        request.iwait();
    }

    @Override
    public void ssend(Buffer buf, ProcessID dstID, int tag, int context) throws XDevException {
        Request request = this.issend(buf, dstID, tag, context);
        request.iwait();
    }

    private void rendezCtrlMsgSend(NIOSendRequest request, SocketChannel socketChannel) throws Exception {
        request.staticBuffer.limit(request.bufoffset);
        request.staticBuffer.position(0);
        request.staticBuffer.putInt(-24);
        request.staticBuffer.putLong(this.id().uuid().getMostSignificantBits());
        request.staticBuffer.putLong(this.id().uuid().getLeastSignificantBits());
        request.staticBuffer.putInt(request.tag);
        request.staticBuffer.putInt(request.sBufSize);
        request.staticBuffer.putInt(request.dBufSize);
        request.staticBuffer.putInt(request.commMode);
        request.staticBuffer.putInt(request.context);
        request.staticBuffer.putInt(request.numEls);
        request.staticBuffer.putInt(request.sendCounter);
        request.staticBuffer.put((byte)request.type.getCode());
        request.staticBuffer.limit(request.bufoffset);
        request.staticBuffer.position(0);
        int w = 0;
        int ww = 0;
        while (request.staticBuffer.hasRemaining()) {
            w = socketChannel.write(request.staticBuffer);
            if (w == -1) {
                throw new ClosedChannelException();
            }
            ww += w;
        }
    }

    private void eagerSend(NIOSendRequest request, SocketChannel socketChannel) throws Exception {
        int w = 0;
        int ww = 0;
        request.staticBuffer.limit(request.bufoffset);
        request.staticBuffer.position(0);
        request.staticBuffer.putInt(-24);
        request.staticBuffer.putLong(this.id().uuid().getMostSignificantBits());
        request.staticBuffer.putLong(this.id().uuid().getLeastSignificantBits());
        request.staticBuffer.putInt(request.tag);
        request.staticBuffer.putInt(request.sBufSize);
        request.staticBuffer.putInt(request.dBufSize);
        request.staticBuffer.putInt(request.commMode);
        request.staticBuffer.putInt(request.context);
        request.staticBuffer.putInt(request.numEls);
        request.staticBuffer.putInt(request.sendCounter);
        request.staticBuffer.put((byte)request.type.getCode());
        if (request.sBufSize > 0) {
            request.staticBuffer.limit(request.sBufSize + request.bufoffset);
            request.staticBuffer.position(0);
            w = 0;
            ww = 0;
            while (request.staticBuffer.hasRemaining()) {
                w = socketChannel.write(request.staticBuffer);
                if (w == -1) {
                    throw new ClosedChannelException();
                }
                ww += w;
            }
        }
        if (request.dynamicBuffer != null && request.dBufSize > 0) {
            RawBuffer rawBuffer = BufferFactory.create(request.dBufSize);
            ByteBuffer buffer = ((NIOBuffer)rawBuffer).getBuffer();
            buffer.position(0);
            buffer.limit(request.dBufSize);
            buffer.put(request.dynamicBuffer, 0, request.dBufSize);
            buffer.flip();
            ww = 0;
            w = 0;
            while (buffer.hasRemaining()) {
                w = socketChannel.write(buffer);
                if (w == -1) {
                    throw new ClosedChannelException();
                }
                ww += w;
            }
            BufferFactory.destroy(rawBuffer);
        }
    }

    @Override
    public Request peek() throws XDevException {
        return completedList.remove();
    }

    @Override
    public Status recv(Buffer buf, ProcessID srcID, int tag, int context) throws XDevException {
        Status status = new Status(srcID.uuid(), tag, -1);
        Request request = this.irecv(buf, srcID, tag, context, status);
        return request.iwait();
    }

    @Override
    public Request irecv(Buffer buf, ProcessID srcID, int tag, int context, Status status) throws XDevException {
        UUID dstUUID = this.id.uuid();
        UUID srcUUID = srcID.uuid();
        try {
            this.sem.acquire();
        }
        catch (Exception e) {
            throw new XDevException(e);
        }
        NIORecvRequest request = null;
        try {
            request = this.arrQue.rem(context, srcUUID, tag);
        }
        catch (Exception e) {
            throw new XDevException(e);
        }
        if (request != null) {
            request.staticBuffer = ((NIOBuffer)buf.getStaticBuffer()).getBuffer();
            request.status = status;
            if (request.srcUUID.equals(dstUUID)) {
                this.sem.signal();
                buf.copy(request.sendRequest.staticBuffer, request.sendRequest.bufoffset, request.sBufSize, 0, request.sendRequest.dynamicBuffer, request.dBufSize);
                request.setCompleted(true);
                request.sendRequest.setCompleted(true);
                return request;
            }
            if (request.sBufSize + request.dBufSize <= this.psl && request.commMode == 3) {
                if (request.sBufSize > 0) {
                    ByteBuffer eagerBuffer = ((NIOBuffer)request.eagerBuffer).getBuffer();
                    request.staticBuffer.position(0);
                    request.staticBuffer.limit(request.sBufSize);
                    eagerBuffer.limit(request.sBufSize);
                    eagerBuffer.position(0);
                    request.staticBuffer.put(eagerBuffer);
                    BufferFactory.destroy(request.eagerBuffer);
                }
                buf.setSize(request.sBufSize);
                if (request.dBufSize > 0) {
                    buf.setDynamicBuffer(request.dynamicBuffer);
                }
                request.notifyMe();
                this.sem.signal();
                return request;
            }
            if (request.sBufSize + request.dBufSize > this.psl && request.commMode == 3 || request.commMode == 2) {
                request.buffer = buf;
                SocketChannel tc = this.worldReadableTable.get(request.srcUUID);
                SocketChannel c = this.worldWritableTable.get(request.srcUUID);
                this.recvMap.put(new Integer(request.recvCounter), request);
                this.sem.signal();
                CustomSemaphore wLock = this.writeLockTable.get(c);
                try {
                    wLock.acquire();
                }
                catch (Exception e) {
                    // empty catch block
                }
                NIODevice.rendezCtrlMsgR2S(c, request);
                wLock.signal();
                return request;
            }
        }
        request = new NIORecvRequest(srcID, null, null, this.id(), tag, false, buf, context, status, ++this.recvCounter, this.nextSequenceNum++);
        this.recvQueue.add(request);
        this.sem.signal();
        return request;
    }

    void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.debug((Object)"shutdownHook thread");
                try {
                    NIODevice.this.selector.wakeup();
                    NIODevice.this.selectorFlag = false;
                    try {
                        SocketChannel peerChannel = null;
                        Object controlChannel = null;
                        for (int i = 0; i < NIODevice.this.writableChannels.size(); ++i) {
                            peerChannel = NIODevice.this.writableChannels.get(i);
                            peerChannel.close();
                        }
                        peerChannel = null;
                        NIODevice.this.selector.close();
                    }
                    catch (IOException e) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realFinish() throws XDevException {
        this.selectorFlag = false;
        try {
            this.selector.wakeup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.selector.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SocketChannel peerChannel = null;
        SocketChannel peerCtrlChannel = null;
        for (int i = 0; i < this.writableChannels.size(); ++i) {
            peerChannel = this.writableChannels.get(i);
            peerCtrlChannel = this.readableChannels.get(i);
            try {
                if (peerChannel.isOpen()) {
                    peerChannel.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (!peerCtrlChannel.isOpen()) continue;
                peerCtrlChannel.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Object object = this.finishLock;
        synchronized (object) {
            this.finished = true;
            this.finishLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void finish() throws XDevException {
        int i;
        Object object = this.finishLock;
        synchronized (object) {
            if (this.finished) {
                return;
            }
        }
        int offset = 0;
        int[] data = new int[1];
        int count = 1;
        int btag = -994576;
        int context = 50;
        Buffer sbuf = new Buffer(BufferFactory.create(23 + this.SEND_OVERHEAD), this.SEND_OVERHEAD, 23 + this.SEND_OVERHEAD);
        Buffer rbuf = new Buffer(BufferFactory.create(16), 0, 16);
        if (this.procTree.numChildren == -1 || !this.procTree.isRoot) {
            try {
                sbuf.putSectionHeader(Type.INT);
                sbuf.write(data, offset, count);
                sbuf.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.procTree.isRoot) {
            for (i = 0; i < this.procTree.child.length; ++i) {
                if (this.procTree.child[i] == -1) continue;
                this.recv(rbuf, this.pids[this.procTree.child[i]], btag, context);
                try {
                    rbuf.clear();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        } else {
            if (this.procTree.parent == -1) {
                System.out.println("non root's node parent doesn't exist");
            }
            for (i = 0; i < this.procTree.child.length; ++i) {
                if (this.procTree.child[i] == -1) continue;
                this.recv(rbuf, this.pids[this.procTree.child[i]], btag, context);
                try {
                    rbuf.clear();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.send(sbuf, this.pids[this.procTree.parent], btag, context);
        }
        if (this.procTree.isRoot) {
            this.realFinish();
        }
        Object object2 = this.finishLock;
        synchronized (object2) {
            while (!this.finished) {
                try {
                    this.finishLock.wait();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        BufferFactory.destroy(sbuf.getStaticBuffer());
        BufferFactory.destroy(rbuf.getStaticBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doBarrierRead(SocketChannel socketChannel, Hashtable table, boolean ignoreFirstFourBytes) throws XDevException {
        boolean read = false;
        boolean tempRead = false;
        UUID ruid = null;
        ByteBuffer barrBuffer = ByteBuffer.allocate(24);
        if (ignoreFirstFourBytes) {
            barrBuffer.limit(24);
        } else {
            barrBuffer.limit(20);
        }
        while (barrBuffer.hasRemaining()) {
            try {
                if (socketChannel.read(barrBuffer) != -1) continue;
                throw new XDevException(new ClosedChannelException());
            }
            catch (Exception e) {
                throw new XDevException(e);
            }
        }
        barrBuffer.flip();
        if (ignoreFirstFourBytes) {
            barrBuffer.getInt();
        }
        int rank = barrBuffer.getInt();
        long msb = barrBuffer.getLong();
        long lsb = barrBuffer.getLong();
        barrBuffer.clear();
        ruid = new UUID(msb, lsb);
        this.pids[rank] = new ProcessID(ruid);
        this.size = this.nprocs;
        Hashtable hashtable = table;
        synchronized (hashtable) {
            table.put(ruid, socketChannel);
            if (table.size() == this.nprocs - 1) {
                try {
                    table.notify();
                }
                catch (Exception e) {
                    throw new XDevException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doAccept(SelectableChannel keyChannel, Vector channelCollection, boolean blocking) throws Exception {
        SocketChannel peerChannel = null;
        Vector vector = channelCollection;
        synchronized (vector) {
            if (!keyChannel.isOpen()) {
                return false;
            }
            peerChannel = ((ServerSocketChannel)keyChannel).accept();
            channelCollection.add(peerChannel);
            if (!blocking) {
                peerChannel.configureBlocking(blocking);
                peerChannel.register(this.selector, 5);
            } else {
                peerChannel.configureBlocking(blocking);
            }
            peerChannel.socket().setTcpNoDelay(true);
            peerChannel.socket().setSendBufferSize(524288);
            peerChannel.socket().setReceiveBufferSize(524288);
            if (channelCollection.size() == this.nprocs - 1) {
                channelCollection.notify();
                return true;
            }
        }
        peerChannel = null;
        return false;
    }

    private void eagerRecv2UserMem(NIORecvRequest request, SocketChannel socketChannel) throws Exception {
        if (request.sBufSize > 0) {
            request.staticBuffer.limit(request.sBufSize);
            request.staticBuffer.position(0);
            while (request.staticBuffer.hasRemaining()) {
                if (socketChannel.read(request.staticBuffer) != -1) continue;
                throw new ClosedChannelException();
            }
            request.buffer.setSize(request.sBufSize);
        }
        if (request.dBufSize > 0) {
            RawBuffer rawBuffer = BufferFactory.create(request.dBufSize);
            ByteBuffer tmpBuffer = ((NIOBuffer)rawBuffer).getBuffer();
            tmpBuffer.position(0);
            tmpBuffer.limit(request.dBufSize);
            byte[] tmpArray = new byte[request.dBufSize];
            while (tmpBuffer.hasRemaining()) {
                if (socketChannel.read(tmpBuffer) != -1) continue;
                throw new ClosedChannelException();
            }
            tmpBuffer.flip();
            tmpBuffer.get(tmpArray, 0, tmpArray.length);
            request.dynamicBuffer = tmpArray;
            request.buffer.setDynamicBuffer(tmpArray);
            BufferFactory.destroy(rawBuffer);
        }
    }

    private void eagerRecv2mpjMem(NIORecvRequest request, SocketChannel socketChannel) throws Exception {
        if (request.sBufSize > 0) {
            request.eagerBuffer = BufferFactory.create(request.sBufSize);
            ByteBuffer eagerBuffer = ((NIOBuffer)request.eagerBuffer).getBuffer();
            eagerBuffer.limit(request.sBufSize);
            eagerBuffer.position(0);
            while (eagerBuffer.hasRemaining()) {
                if (socketChannel.read(eagerBuffer) != -1) continue;
                throw new ClosedChannelException();
            }
        }
        if (request.dBufSize > 0) {
            RawBuffer rawBuffer = BufferFactory.create(request.dBufSize);
            ByteBuffer tmpBuffer = ((NIOBuffer)rawBuffer).getBuffer();
            tmpBuffer.position(0);
            tmpBuffer.limit(request.dBufSize);
            byte[] tmpArray = new byte[request.dBufSize];
            while (tmpBuffer.hasRemaining()) {
                if (socketChannel.read(tmpBuffer) != -1) continue;
                throw new ClosedChannelException();
            }
            tmpBuffer.flip();
            tmpBuffer.get(tmpArray, 0, tmpArray.length);
            tmpBuffer.clear();
            BufferFactory.destroy(rawBuffer);
            request.dynamicBuffer = tmpArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRendezSendCompletion(SocketChannel socketChannel, SelectionKey key) throws Exception {
        ByteBuffer byteBuffer = this.rendez_send_buffer;
        synchronized (byteBuffer) {
            this.rendez_send_buffer.position(0);
            this.rendez_send_buffer.limit(17);
            while (this.rendez_send_buffer.hasRemaining()) {
                if (socketChannel.read(this.rendez_send_buffer) != -1) continue;
                throw new ClosedChannelException();
            }
            this.rendez_send_buffer.flip();
            this.msgReceivedFrom = socketChannel;
        }
    }

    private NIORecvRequest recvCtrlMsgFromSender(SocketChannel socketChannel, SelectionKey skey) throws Exception {
        this.rcb.clear();
        this.rcb.limit(45);
        while (this.rcb.hasRemaining()) {
            if (socketChannel.read(this.rcb) != -1) continue;
            throw new ClosedChannelException();
        }
        this.rcb.flip();
        long msb = this.rcb.getLong();
        long lsb = this.rcb.getLong();
        int tag = this.rcb.getInt();
        int staBufferSize = this.rcb.getInt();
        int dynaBufferSize = this.rcb.getInt();
        int commMode = this.rcb.getInt();
        int context = this.rcb.getInt();
        int numEls = this.rcb.getInt();
        int sendCounter = this.rcb.getInt();
        byte t = this.rcb.get();
        Type type = Type.getType(t);
        UUID srcUUID = new UUID(msb, lsb);
        this.rcb.clear();
        this.sem.acquire();
        NIORecvRequest request = this.recvQueue.rem(context, srcUUID, tag);
        if (request != null) {
            request.srcUUID = srcUUID;
            request.tag = tag;
            request.numEls = numEls;
            request.type = type;
            if (staBufferSize + dynaBufferSize > this.psl && commMode == 3 || commMode == 2) {
                request.sBufSize = staBufferSize;
                request.dBufSize = dynaBufferSize;
                request.sendCounter = sendCounter;
                this.recvMap.put(new Integer(request.recvCounter), request);
                this.sem.signal();
                request.code = -80;
                return request;
            }
            request.sBufSize = staBufferSize;
            request.dBufSize = dynaBufferSize;
            this.sem.signal();
            request.code = -81;
            return request;
        }
        request = new NIORecvRequest(this.id.uuid(), tag, false, context, staBufferSize, dynaBufferSize, commMode, socketChannel, numEls, type, sendCounter, ++this.recvCounter, srcUUID);
        if (staBufferSize + dynaBufferSize <= this.psl && commMode == 3) {
            request.code = -82;
        } else if (staBufferSize + dynaBufferSize > this.psl && commMode == 3 || commMode == 2) {
            this.arrQue.add(request);
            this.sem.signal();
            return request;
        }
        return request;
    }

    synchronized void rendezSendCtrlMsg(SocketChannel socketChannel, NIOSendRequest request) throws Exception {
        this.rendezBuffer.putInt(-22);
        this.rendezBuffer.putInt(request.recvCounter);
        this.rendezBuffer.flip();
        while (this.rendezBuffer.hasRemaining()) {
            if (socketChannel.write(this.rendezBuffer) != -1) continue;
            throw new ClosedChannelException();
        }
        this.rendezBuffer.clear();
    }

    int rendezSendData(SocketChannel socketChannel, NIOSendRequest request) throws Exception {
        int wrote = request.bufoffset;
        int tempWrote = 0;
        int ww = request.bufoffset;
        int w = 0;
        if (request.sBufSize > 0 && request.sSection) {
            request.staticBuffer.limit(request.sBufSize + request.bufoffset);
            request.staticBuffer.position(request.bufoffset);
            while (request.staticBuffer.hasRemaining()) {
                request.staticBuffer.position(wrote);
                tempWrote = socketChannel.write(request.staticBuffer);
                if (tempWrote == -1) {
                    throw new ClosedChannelException();
                }
                wrote += tempWrote;
                w = tempWrote;
                ww += w;
            }
            request.sSection = false;
            request.bytesWritten = 0;
        }
        wrote = 0;
        tempWrote = 0;
        ww = 0;
        w = 0;
        if (request.dBufSize > 0 && request.dSection) {
            if (request.dBuffer == null) {
                request.eagerBuffer = BufferFactory.create(request.dBufSize);
                request.dBuffer = ((NIOBuffer)request.eagerBuffer).getBuffer();
                request.dBuffer.position(0);
                request.dBuffer.limit(request.dBufSize);
                request.dBuffer.put(request.dynamicBuffer, 0, request.dBufSize);
                request.dBuffer.flip();
                request.bytesWritten = 0;
            }
            request.dBuffer.position(request.bytesWritten);
            wrote = request.bytesWritten;
            while (ww != request.dBufSize) {
                request.dBuffer.position(wrote);
                tempWrote = socketChannel.write(request.dBuffer);
                if (tempWrote == -1) {
                    throw new ClosedChannelException();
                }
                wrote += tempWrote;
                w = tempWrote;
                ww += w;
            }
            request.dSection = false;
            BufferFactory.destroy(request.eagerBuffer);
            return 0;
        }
        return 2;
    }

    private int rendezRecvData(SocketChannel socketChannel, int datum, NIORecvRequest request) throws Exception {
        int read = 0;
        int tempRead = 0;
        if (request.sBufSize > 0 && request.sSection) {
            request.staticBuffer.limit(request.sBufSize);
            request.staticBuffer.position(request.bytesRead);
            if (datum != -22) {
                request.staticBuffer.putInt(datum);
                request.bytesRead += 4;
                request.staticBuffer.position(request.bytesRead);
                datum = -22;
            }
            read = request.bytesRead;
            while (request.staticBuffer.hasRemaining()) {
                request.staticBuffer.position(read);
                tempRead = socketChannel.read(request.staticBuffer);
                if (tempRead == -1) {
                    throw new ClosedChannelException();
                }
                read += tempRead;
                if (request.staticBuffer.remaining() <= 3) continue;
                request.bytesRead = read;
                return -84;
            }
            request.sSection = false;
            request.bytesRead = 0;
        }
        read = 0;
        tempRead = 0;
        if (request.dBufSize > 0 && request.dSection) {
            if (request.dBuffer == null) {
                request.dBuffer = ByteBuffer.allocate(request.dBufSize);
                request.bytes = new byte[request.dBufSize];
                request.bytesRead = 0;
            }
            if (datum != -22) {
                request.dBuffer.putInt(datum);
                request.bytesRead += 4;
                request.dBuffer.position(request.bytesRead);
                datum = -22;
            }
            read = request.bytesRead;
            request.dBuffer.limit(request.dBufSize);
            request.dBuffer.position(request.bytesRead);
            while (request.dBuffer.hasRemaining()) {
                request.dBuffer.position(read);
                tempRead = socketChannel.read(request.dBuffer);
                if (tempRead == -1) {
                    throw new ClosedChannelException();
                }
                read += tempRead;
                if (request.dBuffer.remaining() <= 3) continue;
                request.bytesRead = read;
                return -84;
            }
            request.dSection = false;
            request.dBuffer.flip();
            request.dBuffer.get(request.bytes, 0, request.bytes.length);
            request.dynamicBuffer = request.bytes;
            request.buffer.setDynamicBuffer(request.bytes);
        }
        request.buffer.setSize(request.sBufSize);
        return -1;
    }

    static synchronized void rendezCtrlMsgR2S(SocketChannel socketChannel, NIORecvRequest request) throws XDevException {
        _wcb.putInt(-23);
        _wcb.put((byte)0);
        _wcb.putInt(request.tag);
        _wcb.putInt(request.context);
        _wcb.putInt(request.sendCounter);
        _wcb.putInt(request.recvCounter);
        _wcb.flip();
        int ww = 0;
        int w = 0;
        while (_wcb.hasRemaining()) {
            try {
                w = socketChannel.write(_wcb);
                if (w == -1) {
                    throw new XDevException(new ClosedChannelException());
                }
            }
            catch (Exception e) {
                throw new XDevException(e);
            }
            ww += w;
            if (_wcb.hasRemaining()) {
                // empty if block
            }
            if (_wcb.position() != _wcb.limit()) {
                System.out.println(" eixting ");
                System.exit(1);
            }
            if (_wcb.position() == 21) continue;
            System.out.println(" eixting ");
            System.exit(1);
        }
        _wcb.clear();
    }

    class CustomSemaphore {
        private int s;

        public CustomSemaphore(int s) {
            this.s = s;
        }

        public synchronized void acquire() throws InterruptedException {
            while (this.s == 0) {
                this.wait(0L);
            }
            --this.s;
        }

        public synchronized void signal() {
            ++this.s;
            this.notify();
        }
    }

    static class CompletedList {
        NIORequest front;
        NIORequest back;
        int size;

        CompletedList() {
        }

        synchronized void remove(NIORequest request) {
            if (request.inCompletedList) {
                if (this.front == this.back) {
                    this.front = null;
                    this.back = null;
                } else if (this.front == request) {
                    this.front.prevCompleted.nextCompleted = this.front.nextCompleted;
                    this.front.nextCompleted.prevCompleted = this.front.prevCompleted;
                    this.front = this.front.prevCompleted;
                } else if (this.back == request) {
                    this.back.prevCompleted.nextCompleted = this.back.nextCompleted;
                    this.back.nextCompleted.prevCompleted = this.back.prevCompleted;
                    this.back = this.back.nextCompleted;
                } else {
                    request.prevCompleted.nextCompleted = request.nextCompleted;
                    request.nextCompleted.prevCompleted = request.prevCompleted;
                }
                request.inCompletedList = false;
                --this.size;
                System.out.println(" size " + this.size);
            }
        }

        synchronized NIORequest remove() {
            while (this.listEmpty()) {
                try {
                    this.wait();
                }
                catch (Exception e) {}
            }
            NIORequest oldFront = null;
            oldFront = this.front;
            if (this.front == this.back) {
                this.front = null;
                this.back = null;
            } else {
                this.front.prevCompleted.nextCompleted = this.front.nextCompleted;
                this.front.nextCompleted.prevCompleted = this.front.prevCompleted;
                this.front = this.front.prevCompleted;
            }
            oldFront.inCompletedList = false;
            --this.size;
            System.out.println(" size " + this.size);
            return oldFront;
        }

        synchronized void add(NIORequest request) {
            if (this.listEmpty()) {
                this.front = request;
                this.back = request;
                request.nextCompleted = request;
                request.prevCompleted = request;
            } else {
                this.front.nextCompleted.prevCompleted = request;
                request.nextCompleted = this.front.nextCompleted;
                this.front.nextCompleted = request;
                request.prevCompleted = this.front;
                this.back = request;
            }
            ++this.size;
            System.out.println(" size " + this.size);
            request.inCompletedList = true;
            this.notify();
        }

        boolean listEmpty() {
            return this.front == null && this.back == null;
        }
    }

    class Key {
        private int context;
        private int tag;
        private UUID srcUUID;

        Key(int context, UUID srcUUID, int tag) {
            this.context = context;
            this.srcUUID = srcUUID;
            this.tag = tag;
        }

        public int hashCode() {
            return this.tag + this.context * 5 + this.srcUUID.hashCode() * 17;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return other.context == this.context && this.srcUUID.equals(other.srcUUID) && other.tag == this.tag;
            }
            return false;
        }
    }

    class ArrvQueue {
        private HashMap<Key, NIORecvRequest> map = new HashMap();

        ArrvQueue() {
        }

        NIORecvRequest rem(int context, UUID srcUUID, int tag) {
            Key key = new Key(context, srcUUID, tag);
            NIORecvRequest matchingSend = this.get(key);
            if (matchingSend != null) {
                Key[] keys = matchingSend.arrKeys;
                for (int i = 0; i < keys.length; ++i) {
                    this.rem(i, keys[i], matchingSend);
                }
            }
            return matchingSend;
        }

        private NIORecvRequest get(Key key) {
            return this.map.get(key);
        }

        private void add(int i, Key key, NIORecvRequest send) {
            NIORecvRequest head = this.map.get(key);
            if (head == null) {
                send.arrNext[i] = send;
                send.arrPrev[i] = send;
                this.map.put(key, send);
            } else {
                NIORecvRequest last = head.arrPrev[i];
                last.arrNext[i] = send;
                head.arrPrev[i] = send;
                send.arrPrev[i] = last;
                send.arrNext[i] = head;
            }
        }

        private void rem(int i, Key key, NIORecvRequest send) {
            NIORecvRequest head = this.map.get(key);
            if (send == head) {
                if (send.arrNext[i] == send) {
                    this.map.remove(key);
                } else {
                    NIORecvRequest next = send.arrNext[i];
                    NIORecvRequest last = send.arrPrev[i];
                    last.arrNext[i] = next;
                    next.arrPrev[i] = last;
                    this.map.put(key, next);
                }
            } else {
                NIORecvRequest next = send.arrNext[i];
                NIORecvRequest prev = send.arrPrev[i];
                prev.arrNext[i] = next;
                next.arrPrev[i] = prev;
            }
        }

        NIORecvRequest check(int context, UUID srcUUID, int tag) {
            Key key = new Key(context, srcUUID, tag);
            return this.get(key);
        }

        void add(NIORecvRequest request) {
            request.arrKeys = new Key[]{new Key(request.context, request.srcUUID, request.tag), new Key(request.context, request.srcUUID, -2), new Key(request.context, Device.ANY_SRC.uuid(), request.tag), new Key(request.context, Device.ANY_SRC.uuid(), -2)};
            for (int i = 0; i < request.arrKeys.length; ++i) {
                this.add(i, request.arrKeys[i], request);
            }
        }
    }

    class RecvQueue {
        private HashMap<Key, NIORecvRequest> map = new HashMap();

        RecvQueue() {
        }

        private NIORecvRequest get(Key key) {
            return this.map.get(key);
        }

        private void add(Key key, NIORecvRequest recv) {
            NIORecvRequest head = this.map.get(key);
            if (head == null) {
                recv.recvNext = recv;
                recv.recvPrev = recv;
                this.map.put(key, recv);
            } else {
                NIORecvRequest last = head.recvPrev;
                last.recvNext = recv;
                head.recvPrev = recv;
                recv.recvPrev = last;
                recv.recvNext = head;
            }
        }

        private void rem(Key key, NIORecvRequest recv) {
            NIORecvRequest head = this.map.get(key);
            if (recv == head) {
                if (recv.recvNext == recv) {
                    this.map.remove(key);
                } else {
                    NIORecvRequest next = recv.recvNext;
                    NIORecvRequest last = recv.recvPrev;
                    last.recvNext = next;
                    next.recvPrev = last;
                    this.map.put(key, next);
                }
            } else {
                NIORecvRequest next = recv.recvNext;
                NIORecvRequest prev = recv.recvPrev;
                prev.recvNext = next;
                next.recvPrev = prev;
            }
        }

        void add(NIORecvRequest request) {
            request.recvKey = new Key(request.context, request.srcUUID, request.tag);
            this.add(request.recvKey, request);
        }

        NIORecvRequest rem(int context, UUID srcUUID, int tag) {
            Key[] keys = new Key[]{new Key(context, srcUUID, tag), new Key(context, srcUUID, -2), new Key(context, Device.ANY_SRC.uuid(), tag), new Key(context, Device.ANY_SRC.uuid(), -2)};
            NIORecvRequest matchingRecv = null;
            long minSequenceNum = Long.MAX_VALUE;
            for (int i = 0; i < keys.length; ++i) {
                NIORecvRequest recv = this.get(keys[i]);
                if (recv == null || recv.sequenceNum >= minSequenceNum) continue;
                minSequenceNum = recv.sequenceNum;
                matchingRecv = recv;
            }
            if (matchingRecv != null) {
                this.rem(matchingRecv.recvKey, matchingRecv);
            }
            return matchingRecv;
        }
    }
}

