/*
 * Decompiled with CFR 0.152.
 */
package xdev.niodev;

import mpjbuf.Buffer;
import mpjbuf.NIOBuffer;
import mpjdev.Status;
import xdev.ProcessID;
import xdev.XDevException;
import xdev.niodev.NIORequest;

public class NIOSendRequest
extends NIORequest {
    int bytesWritten = 0;
    int bufoffset = 0;

    NIOSendRequest(int tag, ProcessID srcID, ProcessID dstID, Buffer buf, int context, int commMode, int sendCounter) throws XDevException {
        try {
            buf.commit();
            this.type = buf.getSectionHeader();
            this.numEls = buf.getSectionSize();
        }
        catch (Exception e) {
            throw new XDevException(e);
        }
        this.tag = tag;
        this.buffer = buf;
        this.srcUUID = srcID.uuid();
        this.dstUUID = dstID.uuid();
        this.sBufSize = buf.getSize();
        this.staticBuffer = ((NIOBuffer)buf.getStaticBuffer()).getBuffer();
        this.context = context;
        this.commMode = commMode;
        this.sendCounter = sendCounter;
        this.bufoffset = buf.offset();
        if (buf.getDynamicBuffer() != null && buf.getDynamicBuffer().length > 0) {
            this.dynamicBuffer = buf.getDynamicBuffer();
            this.dBufSize = buf.getDynamicBuffer().length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status iwait() {
        if (this.alreadyCompleted) {
            return new Status(this.rank_source, this.tag, -1);
        }
        NIOSendRequest nIOSendRequest = this;
        synchronized (nIOSendRequest) {
            if (!this.isCompleted()) {
                this.waitMe();
            }
        }
        Status status = new Status(this.rank_source, this.tag, -1);
        this.complete(status);
        this.alreadyCompleted = true;
        return status;
    }
}

