/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Vector;
import pal.alignment.Alignment;
import pal.alignment.AlignmentParseException;
import pal.alignment.AlignmentReceiver;
import pal.datatype.DataType;
import pal.misc.IdGroup;
import pal.misc.Identifier;

public final class AlignmentReaders {
    private static final String WHITESPACE = " \r\n\t";

    /*
     * WARNING - void declaration
     */
    public static final Alignment readFastaSequences(Reader r, DataType dt) throws IOException {
        String line;
        String sequenceName = "Unnamed";
        Vector<ConstructionSequence> sequences = new Vector<ConstructionSequence>();
        StringBuffer currentSequence = new StringBuffer();
        BufferedReader br = new BufferedReader(r);
        while ((line = br.readLine()) != null) {
            void var4_6;
            line = var4_6.trim();
            if (line.length() <= 0) continue;
            if (line.startsWith(">")) {
                if (currentSequence.length() != 0) {
                    sequences.addElement(new ConstructionSequence(sequenceName, currentSequence.toString(), dt));
                    currentSequence.setLength(0);
                }
                sequenceName = line.substring(1).trim();
                continue;
            }
            currentSequence.append(AlignmentReaders.remove(line, WHITESPACE));
        }
        if (currentSequence.length() > 0) {
            sequences.addElement(new ConstructionSequence(sequenceName, currentSequence.toString(), dt));
        }
        Object[] seqs = new ConstructionSequence[sequences.size()];
        sequences.copyInto(seqs);
        return new UnalignedAlignment(ConstructionSequence.getNames((ConstructionSequence[])seqs), ConstructionSequence.getSequences((ConstructionSequence[])seqs), dt);
    }

    private static final String readNextNonEmptyLine(BufferedReader br) throws IOException {
        String line = br.readLine();
        if (line == null) {
            return null;
        }
        line = line.trim();
        while (line.length() == 0) {
            line = br.readLine();
            if (line == null) {
                return null;
            }
            line = line.trim();
        }
        return line;
    }

    /*
     * WARNING - void declaration
     */
    public static final Alignment readNewLineSeperatedSequences(Reader r, DataType dt) throws IOException {
        String line;
        String sequenceName = "Unnamed";
        ArrayList<ConstructionSequence> sequences = new ArrayList<ConstructionSequence>();
        StringBuffer currentSequence = new StringBuffer();
        BufferedReader br = new BufferedReader(r);
        Object name = null;
        while ((line = AlignmentReaders.readNextNonEmptyLine(br)) != null) {
            void var4_7;
            if (name == null) {
                name = var4_7;
                continue;
            }
            sequences.add(new ConstructionSequence(name, (String)var4_7, dt));
            name = null;
        }
        ConstructionSequence[] seqs = new ConstructionSequence[sequences.size()];
        sequences.toArray(seqs);
        return new UnalignedAlignment(ConstructionSequence.getNames(seqs), ConstructionSequence.getSequences(seqs), dt);
    }

    public static final Alignment readPhylipClustalAlignment(Reader r, DataType dt) throws AlignmentParseException, IOException {
        AlignmentReceiver.SingleReceiver sr = new AlignmentReceiver.SingleReceiver();
        AlignmentReaders.readPhylipClustalAlignment(r, dt, sr);
        return sr.getLastReceivedAlignment();
    }

    public static final Alignment[] readAllPhylipClustalAlignments(Reader r, DataType dt) throws AlignmentParseException, IOException {
        AlignmentReceiver.BucketReceiver br = new AlignmentReceiver.BucketReceiver();
        AlignmentReaders.readPhylipClustalAlignment(r, dt, br);
        return br.getReceivedAlignments();
    }

    private static final boolean processWhiteSpaceStartingLine(String line, AlignmentBuilder builder) {
        String[] components = AlignmentReaders.toWords(line);
        if (builder.hasSequences() && !Character.isDigit(components[0].charAt(0)) && (components.length == 1 || AlignmentReaders.compareLength(components, 0, components.length - 1) == 10) && line.indexOf(42) < 0) {
            builder.appendToShortest(AlignmentReaders.concat(components));
            return false;
        }
        if (components.length == 2) {
            try {
                int sequences = Integer.parseInt(components[0]);
                int sites = Integer.parseInt(components[1]);
                builder.setSize(sequences, sites);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    private static final boolean processNormalLine(String line, AlignmentBuilder builder) throws AlignmentParseException {
        String[] components = AlignmentReaders.toWords(line);
        if (components.length == 1) {
            if (components[0].length() > 10) {
                if (components[0].length() == builder.getExpectedSequenceSegmentSize()) {
                    builder.appendToShortest(components[0]);
                } else {
                    builder.append(components[0].substring(0, 10), components[0].substring(10));
                }
                return false;
            }
            return true;
        }
        String name = components[0];
        String sequenceSegment = AlignmentReaders.concat(components, 1);
        if (name != null) {
            if (components.length == 2) {
                try {
                    builder.setSize(Integer.parseInt(name), Integer.parseInt(sequenceSegment));
                    return true;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            builder.append(name, sequenceSegment);
            return false;
        }
        return true;
    }

    private static final boolean processLine(String line, AlignmentBuilder builder) throws AlignmentParseException {
        if (Character.isWhitespace(line.charAt(0))) {
            return AlignmentReaders.processWhiteSpaceStartingLine(line, builder);
        }
        return AlignmentReaders.processNormalLine(line, builder);
    }

    public static final void readPhylipClustalAlignment(Reader r, DataType dt, AlignmentReceiver receiver) throws AlignmentParseException, IOException {
        BufferedReader br = new BufferedReader(r);
        String line = AlignmentReaders.nextNonEmptyLine(br);
        AlignmentBuilder builder = new AlignmentBuilder(dt);
        if (line == null) {
            throw new IOException("File contains no data!");
        }
        boolean foundRepeat = false;
        boolean firstAlignment = true;
        while (line != null) {
            boolean isDelimiter = false;
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("CLUSTAL")) {
                isDelimiter = true;
            }
            if (trimmedLine.startsWith(">")) {
                isDelimiter = true;
            }
            if (trimmedLine.toLowerCase().startsWith("#nexus")) {
                throw new AlignmentParseException("Invalid format : can't read NEXUS files!");
            }
            boolean bl = isDelimiter = isDelimiter || AlignmentReaders.processLine(line, builder);
            if (isDelimiter) {
                Alignment a = builder.generateAlignment();
                if (a != null) {
                    receiver.newAlignment(a);
                }
                builder.reset(dt);
            }
            line = AlignmentReaders.nextNonEmptyLine(br);
        }
        Alignment a = builder.generateAlignment();
        if (a != null) {
            receiver.newAlignment(a);
        }
    }

    private static final String remove(String target, String lint) {
        StringBuffer newString = new StringBuffer();
        int i = 0;
        while (i < target.length()) {
            if (lint.indexOf(target.charAt(i)) == -1) {
                newString.append(target.charAt(i));
            }
            ++i;
        }
        return new String(newString);
    }

    /*
     * Unable to fully structure code
     */
    private static final String nextNonEmptyLine(BufferedReader r) throws IOException {
        line = r.readLine();
        if (line != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            line = r.readLine();
            if (line != null) continue;
            return null;
lbl7:
            // 2 sources

            ** while (line != null && line.trim().length() == 0)
        }
lbl8:
        // 1 sources

        return line;
    }

    private static final int maxLength(String[] ss) {
        int count = 0;
        int i = 0;
        while (i < ss.length) {
            count = Math.max(count, ss[i].length());
            ++i;
        }
        return count;
    }

    private static final String pad(String s, char toPadWith, int length) {
        StringBuffer sb = new StringBuffer(length);
        sb.append(s);
        while (sb.length() < length) {
            sb.append(toPadWith);
        }
        return sb.toString();
    }

    private static final String[] pad(String[] ss, char toPadWith, int length) {
        String[] result = new String[ss.length];
        int i = 0;
        while (i < ss.length) {
            result[i] = AlignmentReaders.pad(ss[i], toPadWith, length);
            ++i;
        }
        return result;
    }

    private static final String concat(String[] words) {
        return AlignmentReaders.concat(words, 0, words.length);
    }

    private static final boolean isNumber(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static final String concat(String[] words, int start) {
        return AlignmentReaders.concat(words, start, words.length);
    }

    private static final String concat(String[] words, int start, int end) {
        StringBuffer sb = new StringBuffer();
        int i = start;
        while (i < end) {
            sb.append(words[i]);
            ++i;
        }
        return sb.toString();
    }

    private static final String[] toWords(String text) {
        String[] words = new String[AlignmentReaders.countNonWhiteSpaceBlocks(text)];
        int count = 0;
        boolean inBlock = false;
        int wordStart = 0;
        int i = 0;
        while (i < text.length()) {
            if (WHITESPACE.indexOf(text.charAt(i)) < 0) {
                if (!inBlock) {
                    wordStart = i;
                    inBlock = true;
                }
            } else {
                if (inBlock) {
                    words[count] = text.substring(wordStart, i);
                    ++count;
                }
                inBlock = false;
            }
            ++i;
        }
        if (inBlock) {
            words[count] = text.substring(wordStart);
            ++count;
        }
        return words;
    }

    private static final int countNonWhiteSpaceBlocks(String s) {
        int count = 0;
        boolean inBlock = false;
        int i = 0;
        while (i < s.length()) {
            if (WHITESPACE.indexOf(s.charAt(i)) < 0) {
                if (!inBlock) {
                    inBlock = true;
                    ++count;
                }
            } else {
                inBlock = false;
            }
            ++i;
        }
        return count;
    }

    private static final int compareLength(String[] words) {
        return AlignmentReaders.compareLength(words, 0, words.length);
    }

    private static final int compareLength(String[] words, int start) {
        return AlignmentReaders.compareLength(words, start, words.length);
    }

    private static final int compareLength(String[] words, int start, int end) {
        int length = words[start].length();
        int i = start + 1;
        while (i < end) {
            if (words[i].length() != length) {
                return -1;
            }
            ++i;
        }
        return length;
    }

    private static class ConstructionSequence {
        private final String name_;
        private String sequence_ = null;

        public ConstructionSequence(String name) {
            this.name_ = name;
        }

        public ConstructionSequence(String name, String sequence, DataType dt) {
            this.name_ = name;
            this.sequence_ = DataType.Utils.getPreferredChars(sequence, dt, true);
        }

        public void appendSequence(String sequence, DataType dt) {
            this.sequence_ = this.sequence_ == null ? DataType.Utils.getPreferredChars(sequence, dt) : this.sequence_ + DataType.Utils.getPreferredChars(sequence, dt);
        }

        public String toString() {
            return this.name_ + ":" + this.sequence_;
        }

        public void appendSequence(String sequenceSegment, DataType dt, ConstructionSequence first) {
            int start;
            String firstSequence = first.sequence_;
            if (this.sequence_ == null) {
                this.sequence_ = DataType.Utils.getPreferredChars(sequenceSegment, dt);
                start = 0;
            } else {
                start = this.sequence_.length();
                this.sequence_ = this.sequence_ + DataType.Utils.getPreferredChars(sequenceSegment, dt);
            }
            char[] data = this.sequence_.toCharArray();
            int i = 0;
            while (i < sequenceSegment.length()) {
                if (sequenceSegment.charAt(i) == '.') {
                    data[i + start] = firstSequence.charAt(i + start);
                }
                ++i;
            }
            this.sequence_ = new String(data);
        }

        public final void fillInDotsBasedOn(String template) {
            char[] newSequence = new char[this.sequence_.length()];
            int i = 0;
            while (i < template.length()) {
                char c = this.sequence_.charAt(i);
                if (c == '.') {
                    c = template.charAt(i);
                }
                newSequence[i] = c;
                ++i;
            }
            this.sequence_ = new String(newSequence);
        }

        public final int getSequenceLength() {
            return this.sequence_ == null ? 0 : this.sequence_.length();
        }

        public final boolean hasSameName(String n) {
            return this.name_.equals(n);
        }

        public static final String[] getNames(ConstructionSequence[] seqs) {
            String[] ss = new String[seqs.length];
            int i = 0;
            while (i < ss.length) {
                ss[i] = seqs[i].name_;
                ++i;
            }
            return ss;
        }

        public static final String[] getSequences(ConstructionSequence[] seqs) {
            String[] ss = new String[seqs.length];
            int i = 0;
            while (i < ss.length) {
                ss[i] = seqs[i].sequence_;
                ++i;
            }
            return ss;
        }

        public static final void fillInDots(ConstructionSequence[] seqs) {
            String template = seqs[0].sequence_;
            int i = 1;
            while (i < seqs.length) {
                seqs[i].fillInDotsBasedOn(template);
                ++i;
            }
        }

        public static final ConstructionSequence getConstructionSequence(Vector sequences, String sequenceName) {
            Object cs = null;
            int i = 0;
            while (i < sequences.size()) {
                ConstructionSequence currentCS = (ConstructionSequence)sequences.elementAt(i);
                if (currentCS.hasSameName(sequenceName)) {
                    return currentCS;
                }
                ++i;
            }
            return null;
        }

        public static final ConstructionSequence findShortest(Vector sequences) {
            ConstructionSequence cs = null;
            int minimumLength = -1;
            int i = 0;
            while (i < sequences.size()) {
                ConstructionSequence currentCS = (ConstructionSequence)sequences.elementAt(i);
                int currentLength = currentCS.getSequenceLength();
                if (minimumLength < 0 || currentLength < minimumLength) {
                    cs = currentCS;
                    minimumLength = currentLength;
                }
                ++i;
            }
            return cs;
        }

        public static final boolean isAllSameLength(ConstructionSequence[] seqs) {
            int length = seqs[0].getSequenceLength();
            int i = 1;
            while (i < seqs.length) {
                if (seqs[i].getSequenceLength() != length) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public static class PhylipClustalAlignment
    extends StringAlignment {
        public PhylipClustalAlignment(String[] names, String[] sequences, DataType dt) {
            super(names, sequences, dt);
        }
    }

    public static class UnalignedAlignment
    extends StringAlignment {
        public UnalignedAlignment(String[] names, String[] sequences, DataType dt) {
            super(names, sequences, dt);
        }
    }

    private static class StringAlignment
    implements Alignment {
        private static final long serialVersionUID = 2225713077370547221L;
        String[] sequences_;
        Identifier[] ids_;
        int siteCount_;
        DataType dt_;

        protected StringAlignment(String[] names, String[] sequences, DataType dt) {
            this.siteCount_ = AlignmentReaders.maxLength(sequences);
            this.sequences_ = AlignmentReaders.pad(sequences, '-', this.siteCount_);
            this.ids_ = Identifier.getIdentifiers(names);
            this.dt_ = dt;
        }

        public char getData(int seq, int site) {
            return this.sequences_[seq].charAt(site);
        }

        public int getSiteCount() {
            return this.siteCount_;
        }

        public int getSequenceCount() {
            return this.sequences_.length;
        }

        public DataType getDataType() {
            return this.dt_;
        }

        public void setDataType(DataType dataType) {
            this.dt_ = dataType;
        }

        public String getAlignedSequenceString(int sequence) {
            return this.sequences_[sequence];
        }

        public double[] getFrequency() {
            return null;
        }

        public void setFrequency(double[] frequencies) {
        }

        public int getIdCount() {
            return this.ids_.length;
        }

        public Identifier getIdentifier(int i) {
            return this.ids_[i];
        }

        public void setIdentifier(int i, Identifier id) {
            this.ids_[i] = id;
        }

        public int whichIdNumber(String s) {
            return IdGroup.Utils.whichIdNumber(this, s);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\t");
            sb.append(this.getSequenceCount());
            sb.append(" ");
            sb.append(this.getSiteCount());
            sb.append("\n");
            int i = 0;
            while (i < this.ids_.length) {
                sb.append(this.ids_[i].getName());
                sb.append("\t");
                sb.append(this.sequences_[i]);
                sb.append("\n");
                ++i;
            }
            return sb.toString();
        }
    }

    private static final class AlignmentBuilder {
        private final Vector sequences_ = new Vector();
        private DataType dt_;
        private boolean foundRepeat_ = false;
        private int suggestedNumberOfSequences_;
        private int suggestNumberOfSites_;
        private int expectedSequenceSegmentSize_;

        public AlignmentBuilder(DataType dt) {
            this.reset(dt);
        }

        public void setSize(int numberOfSequences, int numberOfSites) {
            this.suggestedNumberOfSequences_ = numberOfSequences;
            this.suggestNumberOfSites_ = numberOfSites;
            this.expectedSequenceSegmentSize_ = numberOfSites;
        }

        public boolean isFoundRepeat() {
            return this.foundRepeat_;
        }

        public void appendToShortest(String sequenceSegment) {
            ConstructionSequence cs = ConstructionSequence.findShortest(this.sequences_);
            cs.appendSequence(sequenceSegment, this.dt_);
            this.expectedSequenceSegmentSize_ = sequenceSegment.length();
        }

        public int getExpectedSequenceSegmentSize() {
            return this.expectedSequenceSegmentSize_;
        }

        public void append(String sequenceName, String sequence) throws AlignmentParseException {
            ConstructionSequence cs = ConstructionSequence.getConstructionSequence(this.sequences_, sequenceName);
            if (cs == null) {
                cs = new ConstructionSequence(sequenceName, sequence, this.dt_);
                this.sequences_.addElement(cs);
                if (this.foundRepeat_) {
                    throw new AlignmentParseException("New sequence found after interleaved sequence - cound mean two sequences with same name (" + sequenceName + ")");
                }
            } else {
                cs.appendSequence(sequence, this.dt_);
                this.foundRepeat_ = true;
            }
            this.expectedSequenceSegmentSize_ = sequence.length();
        }

        public void reset(DataType dt) {
            this.dt_ = dt;
            this.foundRepeat_ = false;
            this.expectedSequenceSegmentSize_ = -1;
            this.sequences_.removeAllElements();
        }

        public final boolean hasSequences() {
            return this.sequences_.size() != 0;
        }

        public Alignment generateAlignment() throws AlignmentParseException {
            if (this.sequences_.size() == 0) {
                return null;
            }
            Object[] seqs = new ConstructionSequence[this.sequences_.size()];
            this.sequences_.copyInto(seqs);
            if (ConstructionSequence.isAllSameLength((ConstructionSequence[])seqs)) {
                ConstructionSequence.fillInDots((ConstructionSequence[])seqs);
                return new PhylipClustalAlignment(ConstructionSequence.getNames((ConstructionSequence[])seqs), ConstructionSequence.getSequences((ConstructionSequence[])seqs), this.dt_);
            }
            throw new AlignmentParseException("Not all sequences are of the same length");
        }
    }
}

