/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.PrintWriter;
import java.util.Vector;
import pal.alignment.AbstractAlignment;
import pal.alignment.AlignmentUtils;
import pal.alignment.AnnotationAlignment;
import pal.datatype.DataType;
import pal.misc.Identifier;
import pal.misc.SimpleIdGroup;

public class ConcatenatedAnnotatedAlignment
extends AbstractAlignment
implements AnnotationAlignment {
    private AnnotationAlignment[] alignmentList;
    private int numAlignments;
    private int[] alignmentIndex;
    private int[] siteIndex;
    private int[][] sequenceIndex;
    private boolean mergeByID;
    private boolean union;

    public ConcatenatedAnnotatedAlignment(AnnotationAlignment[] list, boolean mergeByID, boolean union) throws IllegalArgumentException {
        this.alignmentList = list;
        this.numAlignments = this.alignmentList.length;
        if (this.numAlignments == 0) {
            throw new IllegalArgumentException("NO ALIGNMENT");
        }
        this.mergeByID = mergeByID;
        this.union = union;
        if (mergeByID) {
            this.initMergeByID(union);
        } else {
            this.initStraightMerge();
        }
    }

    private void initStraightMerge() {
        this.numSeqs = this.alignmentList[0].getSequenceCount();
        this.idGroup = this.alignmentList[0];
        this.numSites = 0;
        int i = 0;
        while (i < this.numAlignments) {
            this.numSites += this.alignmentList[i].getSiteCount();
            if (this.alignmentList[i].getSequenceCount() != this.numSeqs) {
                throw new IllegalArgumentException("INCOMPATIBLE ALIGNMENTS");
            }
            ++i;
        }
        this.alignmentIndex = new int[this.numSites];
        this.siteIndex = new int[this.numSites];
        int s = 0;
        int i2 = 0;
        while (i2 < this.numAlignments) {
            int j = 0;
            while (j < this.alignmentList[i2].getSiteCount()) {
                this.alignmentIndex[s + j] = i2;
                this.siteIndex[s + j] = j;
                ++j;
            }
            s += this.alignmentList[i2].getSiteCount();
            ++i2;
        }
    }

    private void initMergeByID(boolean union) {
        int i;
        Identifier[] ids;
        int i2;
        this.numSites = 0;
        Vector<Identifier> idVector = new Vector<Identifier>();
        int i3 = 0;
        while (i3 < this.numAlignments) {
            this.numSites += this.alignmentList[i3].getSiteCount();
            int j = 0;
            while (j < this.alignmentList[i3].getSequenceCount()) {
                if (!idVector.contains(this.alignmentList[i3].getIdentifier(j))) {
                    idVector.addElement(this.alignmentList[i3].getIdentifier(j));
                }
                ++j;
            }
            ++i3;
        }
        if (!union) {
            Vector intersectionVector = new Vector();
            i2 = 0;
            while (i2 < idVector.size()) {
                boolean inAll = true;
                String id = ((Identifier)idVector.elementAt(i2)).getName();
                int j = 0;
                while (j < this.numAlignments) {
                    if (this.alignmentList[j].whichIdNumber(id) < 0) {
                        inAll = false;
                    }
                    ++j;
                }
                if (inAll) {
                    intersectionVector.addElement(idVector.elementAt(i2));
                }
                ++i2;
            }
            ids = new Identifier[intersectionVector.size()];
            int i4 = 0;
            while (i4 < ids.length) {
                ids[i4] = (Identifier)intersectionVector.elementAt(i4);
                ++i4;
            }
        } else {
            ids = new Identifier[idVector.size()];
            i = 0;
            while (i < ids.length) {
                ids[i] = (Identifier)idVector.elementAt(i);
                ++i;
            }
        }
        this.idGroup = new SimpleIdGroup(ids);
        this.numSeqs = this.idGroup.getIdCount();
        this.sequenceIndex = new int[this.numAlignments][this.numSeqs];
        i = 0;
        while (i < this.numAlignments) {
            int j = 0;
            while (j < this.numSeqs) {
                this.sequenceIndex[i][j] = -1;
                ++j;
            }
            ++i;
        }
        this.alignmentIndex = new int[this.numSites];
        this.siteIndex = new int[this.numSites];
        int s = 0;
        i2 = 0;
        while (i2 < this.numAlignments) {
            int j = 0;
            while (j < this.alignmentList[i2].getSiteCount()) {
                this.alignmentIndex[s + j] = i2;
                this.siteIndex[s + j] = j;
                ++j;
            }
            s += this.alignmentList[i2].getSiteCount();
            int k = 0;
            while (k < this.alignmentList[i2].getSequenceCount()) {
                if (this.idGroup.whichIdNumber(this.alignmentList[i2].getIdentifier(k).getName()) > -1) {
                    this.sequenceIndex[i2][this.idGroup.whichIdNumber((String)this.alignmentList[i2].getIdentifier((int)k).getName())] = k;
                }
                ++k;
            }
            ++i2;
        }
    }

    public char getData(int seq, int site) {
        if (this.mergeByID) {
            if (this.sequenceIndex[this.alignmentIndex[site]][seq] == -1) {
                return '?';
            }
            return this.alignmentList[this.alignmentIndex[site]].getData(this.sequenceIndex[this.alignmentIndex[site]][seq], this.siteIndex[site]);
        }
        return this.alignmentList[this.alignmentIndex[site]].getData(seq, this.siteIndex[site]);
    }

    public DataType getDataType(int site) {
        return this.alignmentList[this.alignmentIndex[site]].getDataType();
    }

    public float getChromosomePosition(int site) {
        return this.alignmentList[this.alignmentIndex[site]].getChromosomePosition(this.siteIndex[site]);
    }

    public int getChromosome(int site) {
        return this.alignmentList[this.alignmentIndex[site]].getChromosome(this.siteIndex[site]);
    }

    public float getWeightedLocusPosition(int site) {
        return 0.0f;
    }

    public int getLocusPosition(int site) {
        return this.alignmentList[this.alignmentIndex[site]].getLocusPosition(this.siteIndex[site]);
    }

    public char getPositionType(int site) {
        return '\u0000';
    }

    public String getLocusName(int site) {
        return this.alignmentList[this.alignmentIndex[site]].getLocusName(this.siteIndex[site]);
    }

    public void sortSites() {
        boolean flag = true;
        double[] sortPos = new double[this.getSiteCount()];
        do {
            flag = false;
            int i = 1;
            while (i < this.getSiteCount()) {
                if (!this.isSiteIBeforeSiteJ(i - 1, i)) {
                    flag = true;
                    double tempSortPos = sortPos[i];
                    sortPos[i] = sortPos[i - 1];
                    sortPos[i - 1] = tempSortPos;
                    int tempAlignmentIndex = this.alignmentIndex[i];
                    this.alignmentIndex[i] = this.alignmentIndex[i - 1];
                    this.alignmentIndex[i - 1] = tempAlignmentIndex;
                    int tempSiteIndex = this.siteIndex[i];
                    this.siteIndex[i] = this.siteIndex[i - 1];
                    this.siteIndex[i - 1] = tempSiteIndex;
                }
                ++i;
            }
        } while (flag);
        System.err.println("Sites sorted");
    }

    private boolean isSiteIBeforeSiteJ(int siteI, int siteJ) {
        if (this.getChromosome(siteI) < this.getChromosome(siteJ)) {
            return true;
        }
        if (this.getChromosome(siteI) > this.getChromosome(siteJ)) {
            return false;
        }
        if (this.getChromosomePosition(siteI) < this.getChromosomePosition(siteJ)) {
            return true;
        }
        if (this.getChromosomePosition(siteI) > this.getChromosomePosition(siteJ)) {
            return false;
        }
        if (this.getLocusPosition(siteI) < this.getLocusPosition(siteJ)) {
            return true;
        }
        return this.getLocusPosition(siteI) <= this.getLocusPosition(siteJ);
    }

    public void report(PrintWriter out) {
        AlignmentUtils.report(this, out);
        out.println("Number of Alignments: " + this.alignmentList.length);
        out.println();
        int i = 0;
        while (i < this.alignmentList.length) {
            out.println("Alignment: " + i);
            this.alignmentList[i].report(out);
            out.println();
            ++i;
        }
    }
}

