/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import pal.alignment.CharacterAlignment;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.misc.Report;
import pal.misc.SimpleIdGroup;

public class SimpleCharacterAlignment
implements CharacterAlignment,
Serializable,
IdGroup,
Report {
    protected double[][] traitValues;
    protected String[] traitNames;
    protected String[] environmentNames;
    protected int numSeqs;
    protected int numTraits;
    protected IdGroup idGroup;

    public SimpleCharacterAlignment() {
    }

    public SimpleCharacterAlignment(Identifier[] ids, double[][] traitValues, String[] traitNames) {
        this((IdGroup)new SimpleIdGroup(ids), traitValues, traitNames);
    }

    public SimpleCharacterAlignment(IdGroup group, double[][] traitValues, String[] traitNames) {
        System.out.println("Starting CharacterAlignment(IdGroup group, double[][] traitValues, String[] traitNames)");
        if (group.getIdCount() != traitValues.length) {
            return;
        }
        this.idGroup = group;
        this.traitNames = traitNames;
        this.traitValues = traitValues;
        this.numSeqs = this.idGroup.getIdCount();
        this.numTraits = traitValues[0].length;
        this.environmentNames = new String[this.numTraits];
        int i = 0;
        while (i < this.numTraits) {
            this.environmentNames[i] = "NA";
            ++i;
        }
    }

    public SimpleCharacterAlignment(IdGroup group, double[][] traitValues, String[] traitNames, String[] environNames) {
        System.out.println("Starting CharacterAlignment(IdGroup group, double[][] traitValues, String[] traitNames, String[] environNames)" + this.environmentNames);
        if (group.getIdCount() != traitValues.length) {
            return;
        }
        this.idGroup = group;
        this.traitNames = traitNames;
        this.traitValues = traitValues;
        this.numSeqs = this.idGroup.getIdCount();
        this.numTraits = traitValues[0].length;
        this.environmentNames = environNames;
    }

    public SimpleCharacterAlignment(IdGroup group, double[] traitValue, String traitName) {
        if (group.getIdCount() != this.traitValues.length) {
            return;
        }
        this.idGroup = group;
        this.traitNames = new String[1];
        this.environmentNames = new String[1];
        this.traitNames[0] = traitName;
        this.environmentNames[0] = "NA";
        this.traitValues = new double[traitValue.length][1];
        int i = 0;
        while (i < traitValue.length) {
            this.traitValues[i][0] = traitValue[i];
            ++i;
        }
        this.numSeqs = this.idGroup.getIdCount();
        this.numTraits = 1;
    }

    public double getTrait(int seq, int trait) {
        return this.traitValues[seq][trait];
    }

    public final int getLength() {
        return this.numTraits;
    }

    public final int getSequenceCount() {
        return this.numSeqs;
    }

    public final int getTraitCount() {
        return this.numTraits;
    }

    public String getTraitName(int trait) {
        return this.traitNames[trait];
    }

    public String getEnvironmentName(int trait) {
        return this.environmentNames[trait];
    }

    public Identifier getIdentifier(int i) {
        return this.idGroup.getIdentifier(i);
    }

    public void setIdentifier(int i, Identifier ident) {
        this.idGroup.setIdentifier(i, ident);
    }

    public int getIdCount() {
        return this.idGroup.getIdCount();
    }

    public int whichIdNumber(String name) {
        return this.idGroup.whichIdNumber(name);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println("  " + this.getSequenceCount() + " " + this.getTraitCount());
        out.print("Taxa/Trait\t");
        int j = 0;
        while (j < this.getTraitCount()) {
            out.print(this.traitNames[j] + "\t");
            ++j;
        }
        out.println();
        if (this.environmentNames != null) {
            out.print("Taxa/Environ\t");
            int j2 = 0;
            while (j2 < this.getTraitCount()) {
                out.print(this.environmentNames[j2] + "\t");
                ++j2;
            }
            out.println();
        }
        int i = 0;
        while (i < this.getSequenceCount()) {
            out.print(this.idGroup.getIdentifier(i).getName() + "\t");
            int j3 = 0;
            while (j3 < this.getTraitCount()) {
                out.print(this.getTrait(i, j3) + "\t");
                ++j3;
            }
            out.println();
            ++i;
        }
        return sw.toString();
    }

    public void report(PrintWriter out) {
        out.println("Number of sequences: " + this.getSequenceCount());
        out.println("Number of traits: " + this.getTraitCount());
    }

    public Object[] getTableColumnNames() {
        Object[] basicLabels = new String[this.getTraitCount() + 1];
        basicLabels[0] = "Taxa";
        int c = 0;
        while (c < this.getTraitCount()) {
            basicLabels[c + 1] = this.getTraitName(c) + "." + this.getEnvironmentName(c);
            ++c;
        }
        return basicLabels;
    }

    public Object[][] getTableData() {
        boolean i = false;
        Object[][] data = new String[this.getSequenceCount()][this.getTraitCount() + 1];
        int r = 0;
        while (r < this.getSequenceCount()) {
            data[r][0] = this.getIdentifier(r).getName();
            int c = 0;
            while (c < this.getTraitCount()) {
                data[r][c + 1] = "" + this.getTrait(r, c);
                ++c;
            }
            ++r;
        }
        return data;
    }

    public String getTableTitle() {
        return "Phenotypes";
    }
}

