/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import pal.alignment.AbstractAlignment;
import pal.alignment.Alignment;

public class StrippedAlignment
extends AbstractAlignment {
    protected Alignment rawAlignment = null;
    protected int rawNumSites;
    protected int[] alias;
    protected boolean[] notDropped;

    public StrippedAlignment(Alignment raw) {
        this.numSeqs = raw.getSequenceCount();
        this.idGroup = raw;
        this.numSites = raw.getSiteCount();
        this.rawAlignment = raw;
        this.rawNumSites = this.getSiteCount();
        this.alias = new int[this.getSiteCount()];
        this.notDropped = new boolean[this.getSiteCount()];
        int i = 0;
        while (i < this.getSiteCount()) {
            this.alias[i] = i;
            this.notDropped[i] = true;
            ++i;
        }
        this.setDataType(raw.getDataType());
    }

    public char getData(int seq, int site) {
        return this.rawAlignment.getData(seq, this.alias[site]);
    }

    public void dropSite(int s) {
        if (this.notDropped[s]) {
            this.notDropped[s] = false;
            --this.numSites;
            int n = 0;
            while (this.alias[n] != s) {
                ++n;
            }
            int i = n;
            while (i < this.getSiteCount()) {
                this.alias[i] = this.alias[i + 1];
                ++i;
            }
            this.alias[this.getSiteCount()] = -1;
        }
    }

    public void removeSites(char c) {
        int i = 0;
        while (i < this.rawAlignment.getSiteCount()) {
            int j = 0;
            while (j < this.numSeqs) {
                if (this.rawAlignment.getData(j, i) == c) {
                    this.dropSite(i);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void removeGaps() {
        this.removeSites('-');
    }

    public void removeUnknowns() {
        this.removeSites('?');
    }

    public void removeConstantSites() {
        int i = 0;
        while (i < this.rawAlignment.getSiteCount()) {
            char c = this.rawAlignment.getData(0, i);
            int count = 1;
            int j = 1;
            while (j < this.numSeqs) {
                if (this.rawAlignment.getData(j, i) != c) break;
                ++count;
                ++j;
            }
            if (count == this.numSeqs) {
                this.dropSite(i);
            }
            ++i;
        }
    }

    public void removeNoninformativeSites() {
        int[] charCount = new int[this.numSeqs];
        int i = 0;
        while (i < this.rawAlignment.getSiteCount()) {
            int j = 0;
            while (j < this.numSeqs) {
                charCount[j] = 0;
                ++j;
            }
            int j2 = 0;
            while (j2 < this.numSeqs) {
                if (charCount[j2] == 0) {
                    charCount[j2] = 1;
                    char c = this.rawAlignment.getData(j2, i);
                    int k = j2 + 1;
                    while (k < this.numSeqs) {
                        if (c == this.rawAlignment.getData(k, i)) {
                            int n = j2;
                            charCount[n] = charCount[n] + 1;
                            charCount[k] = -1;
                        }
                        ++k;
                    }
                }
                ++j2;
            }
            int num = 0;
            int j3 = 0;
            while (j3 < this.numSeqs) {
                if (charCount[j3] > 1) {
                    ++num;
                }
                ++j3;
            }
            if (num < 2) {
                this.dropSite(i);
            }
            ++i;
        }
    }
}

