/*
 * Decompiled with CFR 0.152.
 */
package pal.coalescent;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.coalescent.DemographicModel;
import pal.io.OutputTarget;
import pal.misc.Parameterized;
import pal.misc.Report;
import pal.misc.Summarizable;
import pal.misc.Units;

public class ConstantPopulation
extends DemographicModel
implements Report,
Summarizable,
Parameterized,
Serializable {
    private static final String[] CP_SUMMARY_TYPES = new String[]{"N0", "N0SE"};
    public double N0;
    public double N0SE = 0.0;

    public ConstantPopulation(int units) {
        this.setUnits(units);
        this.N0 = this.getDefaultValue(0);
    }

    public ConstantPopulation(double size, int units) {
        this.N0 = size;
        this.setUnits(units);
    }

    public Object clone() {
        return new ConstantPopulation(this.getN0(), this.getUnits());
    }

    public String[] getSummaryTypes() {
        return CP_SUMMARY_TYPES;
    }

    public double getSummaryValue(int summaryType) {
        switch (summaryType) {
            case 0: {
                return this.N0;
            }
            case 1: {
                return this.N0SE;
            }
        }
        throw new RuntimeException("Assertion error: unknown summary type :" + summaryType);
    }

    public double getN0() {
        return this.N0;
    }

    public double getDemographic(double t) {
        return this.N0;
    }

    public double getIntensity(double t) {
        return t / this.N0;
    }

    public double getInverseIntensity(double x) {
        return this.N0 * x;
    }

    public int getNumParameters() {
        return 1;
    }

    public double getParameter(int k) {
        return this.N0;
    }

    public double getUpperLimit(int k) {
        return 1.0E50;
    }

    public double getLowerLimit(int k) {
        return 1.0E-12;
    }

    public double getDefaultValue(int k) {
        if (this.getUnits() == 1) {
            return 1000.0;
        }
        return 0.2;
    }

    public void setParameter(double value, int k) {
        this.N0 = value;
    }

    public void setParameterSE(double value, int k) {
        this.N0SE = value;
    }

    public String toString() {
        OutputTarget out = OutputTarget.openString();
        this.report(out);
        out.close();
        return out.getString();
    }

    public void report(PrintWriter out) {
        out.println("Demographic model: constant population size ");
        out.println("Demographic function: N(t) = N0");
        out.print("Unit of time: ");
        out.print(Units.UNIT_NAMES[this.getUnits()]);
        out.println();
        out.println();
        out.println("Parameters of demographic function:");
        if (this.getUnits() == 1) {
            out.print(" present day population size N0: ");
            this.fo.displayDecimal(out, this.N0, 6);
        } else {
            out.print(" present day Theta (N0 * mu): ");
            this.fo.displayDecimal(out, this.N0, 6);
        }
        if (this.N0SE != 0.0) {
            out.print(" (S.E. ");
            this.fo.displayDecimal(out, this.N0SE, 6);
            out.print(")");
        }
        out.println();
        if (this.getLogL() != 0.0) {
            out.println();
            out.print("log L: ");
            this.fo.displayDecimal(out, this.getLogL(), 6);
            out.println();
        }
    }
}

