/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import pal.datatype.AminoAcids;
import pal.datatype.CodonTable;
import pal.datatype.UniversalTranslator;

public class CodonTableFactory {
    public static CodonTable createTranslator(int type) {
        UniversalTranslator ut = new UniversalTranslator();
        ut.setOrganismTypeID(type);
        switch (type) {
            case 0: {
                return ut;
            }
            case 1: {
                ut.add("UGA", 'W');
                ut.add("AGA", '*');
                ut.add("AGG", '*');
                ut.add("AUA", 'M');
                return ut;
            }
            case 2: {
                ut.add("CUA", 'T');
                ut.add("CUC", 'T');
                ut.add("CUG", 'T');
                ut.add("CUT", 'T');
                ut.add("UGA", 'W');
                ut.add("AUA", 'M');
                return ut;
            }
            case 3: {
                ut.add("UGA", 'W');
                return ut;
            }
            case 4: {
                ut.add("UGA", 'W');
                return ut;
            }
            case 5: {
                ut.add("AGA", 'S');
                ut.add("AGG", 'S');
                ut.add("UGA", 'W');
                ut.add("AUA", 'M');
                return ut;
            }
            case 6: {
                ut.add("UAA", 'Q');
                ut.add("UAG", 'Q');
                return ut;
            }
            case 7: {
                ut.add("UGA", 'W');
                ut.add("AGA", 'S');
                ut.add("AGG", 'S');
                ut.add("AAA", 'N');
                return ut;
            }
            case 8: {
                ut.add("UGA", 'C');
                return ut;
            }
            case 9: {
                ut.add("AUA", 'M');
                ut.add("UGA", 'W');
                ut.add("AGA", 'G');
                ut.add("AGG", 'G');
                return ut;
            }
            case 10: {
                ut.add("AAA", 'N');
                ut.add("UAA", 'Y');
                ut.add("UGA", 'W');
                return ut;
            }
            case 11: {
                ut.add("UAG", 'Q');
                return ut;
            }
            case 12: {
                return ut;
            }
            case 13: {
                ut.add("CUG", 'S');
                return ut;
            }
        }
        ut.setOrganismTypeID(0);
        return ut;
    }

    public static final CodonTable createUniversalTranslator() {
        return CodonTableFactory.createTranslator(0);
    }

    public static final void main(String[] args) {
        CodonTable universal = CodonTableFactory.createUniversalTranslator();
        AminoAcids dt = new AminoAcids();
        int i = 0;
        while (i < 20) {
            int[] codon = universal.getIUPACStatesFromAminoAcidState(i);
            System.out.println("AA:" + i + "  " + dt.getChar(i));
            System.out.println("Codon:" + codon[0] + " " + codon[1] + " " + codon[2]);
            int back = universal.getAminoAcidStateFromStates(codon);
            System.out.println("Back:" + back + "  " + dt.getChar(back) + " " + dt.getChar(i));
            char[][] codons = universal.getCodonsFromAminoAcidState(i);
            System.out.println("Codon Check");
            int c = 0;
            while (c < codons.length) {
                int s = universal.getAminoAcidState(codons[c]);
                System.out.println("C:" + c + ":" + s + "  " + dt.getChar(s) + " " + dt.getChar(i));
                ++c;
            }
            ++i;
        }
    }
}

