/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import pal.alignment.Alignment;
import pal.alignment.BootstrappedAlignment;
import pal.alignment.SitePattern;
import pal.distance.AlignmentDistanceMatrix;
import pal.distance.DistanceMatrix;
import pal.substmodel.SubstitutionModel;
import pal.tree.SimulatedAlignment;
import pal.tree.Tree;
import pal.util.AlgorithmCallback;

public interface DistanceMatrixGenerator {
    public DistanceMatrix generateNextMatrix(AlgorithmCallback var1);

    public static final class Utils {
        public static DistanceMatrixGenerator createEvolutionary(Alignment a, SubstitutionModel sm) {
            return new Evolutionary(a, sm);
        }

        public static DistanceMatrixGenerator createParametric(Tree baseTree, SubstitutionModel sm, int numberOfSites) {
            return new Parametric(baseTree, sm, numberOfSites);
        }

        private static final class Evolutionary
        implements DistanceMatrixGenerator {
            private final Alignment alignment_;
            private final SubstitutionModel model_;

            public Evolutionary(Alignment alignment, SubstitutionModel model) {
                this.alignment_ = alignment;
                this.model_ = model;
            }

            public DistanceMatrix generateNextMatrix(AlgorithmCallback callback) {
                return new AlignmentDistanceMatrix(SitePattern.getSitePattern(new BootstrappedAlignment(this.alignment_)), this.model_, callback);
            }
        }

        private static final class Parametric
        implements DistanceMatrixGenerator {
            private final Tree baseTree_;
            private final SubstitutionModel evolutionaryModel_;
            private final int numberOfSites_;

            public Parametric(Tree baseTree, SubstitutionModel evolutionaryModel, int numberOfSites) {
                this.numberOfSites_ = numberOfSites;
                this.baseTree_ = baseTree;
                this.evolutionaryModel_ = evolutionaryModel;
            }

            public DistanceMatrix generateNextMatrix(AlgorithmCallback callback) {
                SimulatedAlignment sa = new SimulatedAlignment(this.numberOfSites_, this.baseTree_, this.evolutionaryModel_);
                return new AlignmentDistanceMatrix(SitePattern.getSitePattern(sa), this.evolutionaryModel_, callback);
            }
        }
    }
}

