/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import java.io.IOException;
import java.io.PushbackReader;
import pal.distance.DistanceMatrix;
import pal.distance.DistanceParseException;
import pal.io.FormattedInput;
import pal.io.InputSource;
import pal.misc.Identifier;
import pal.misc.SimpleIdGroup;

public class ReadDistanceMatrix
extends DistanceMatrix {
    public ReadDistanceMatrix(PushbackReader input) throws DistanceParseException {
        this.readSquare(input);
    }

    public ReadDistanceMatrix(String file) throws DistanceParseException, IOException {
        InputSource input = InputSource.openFile(file);
        this.readSquare(input);
        input.close();
    }

    private void readSquare(PushbackReader in) throws DistanceParseException {
        FormattedInput fi = FormattedInput.getInstance();
        try {
            int numSeqs = fi.readInt(in);
            fi.nextLine(in);
            double[][] distance = new double[numSeqs][numSeqs];
            SimpleIdGroup idGroup = new SimpleIdGroup(numSeqs);
            int i = 0;
            while (i < numSeqs) {
                idGroup.setIdentifier(i, new Identifier(fi.readLabel(in, 10)));
                int j = 0;
                while (j < numSeqs) {
                    distance[i][j] = fi.readDouble(in);
                    ++j;
                }
                fi.nextLine(in);
                ++i;
            }
            this.setIdGroup(idGroup);
            this.setDistances(distance);
        }
        catch (IOException e) {
            throw new DistanceParseException("IO error");
        }
        catch (NumberFormatException e) {
            throw new DistanceParseException("Number format error");
        }
    }
}

