/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.distance.DistanceMatrix;
import pal.distance.DistanceMatrixUtils;
import pal.math.DifferentialEvolution;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;
import pal.math.OrthogonalHints;
import pal.tree.ParameterizedTree;
import pal.tree.Tree;
import pal.tree.TreeDistanceMatrix;

public class ChiSquareValue
implements MultivariateFunction {
    private int numParams;
    private Tree tree;
    private ParameterizedTree ptree;
    private DistanceMatrix givenMat;
    private TreeDistanceMatrix inducedMat;
    private boolean weighted;
    private MultivariateMinimum mvm = null;

    public ChiSquareValue(DistanceMatrix m, boolean w) {
        this.givenMat = m;
        this.weighted = w;
    }

    public void setTree(Tree t) {
        this.tree = t;
        this.inducedMat = new TreeDistanceMatrix(this.tree);
        if (this.tree instanceof ParameterizedTree) {
            this.ptree = (ParameterizedTree)this.tree;
            this.numParams = this.ptree.getNumParameters();
        } else {
            this.ptree = null;
            this.numParams = 0;
        }
    }

    public Tree getTree() {
        return this.tree;
    }

    public double compute() {
        this.inducedMat.recompute(this.tree);
        return DistanceMatrixUtils.squaredDistance(this.inducedMat, this.givenMat, this.weighted);
    }

    public double optimiseParameters() {
        return this.optimiseParameters(null);
    }

    public double optimiseParameters(MultivariateMinimum mm) {
        if (!(this.tree instanceof ParameterizedTree)) {
            new IllegalArgumentException("ParameterizedTree required");
        }
        if (mm == null) {
            if (this.mvm == null) {
                this.mvm = new DifferentialEvolution(this.numParams);
            }
        } else {
            this.mvm = mm;
        }
        double[] estimate = new double[this.numParams];
        int i = 0;
        while (i < this.numParams) {
            estimate[i] = this.ptree.getDefaultValue(i);
            ++i;
        }
        this.mvm.findMinimum(this, estimate, 6, 6);
        return this.evaluate(estimate);
    }

    public double evaluate(double[] params) {
        int i = 0;
        while (i < this.numParams) {
            this.ptree.setParameter(params[i], i);
            ++i;
        }
        return this.compute();
    }

    public int getNumArguments() {
        return this.ptree.getNumParameters();
    }

    public double getLowerBound(int n) {
        return this.ptree.getLowerLimit(n);
    }

    public double getUpperBound(int n) {
        return this.ptree.getUpperLimit(n);
    }

    public OrthogonalHints getOrthogonalHints() {
        return null;
    }
}

