/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.datatype.DataType;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.LHCalculator;
import pal.eval.PatternInfo;
import pal.eval.SimpleLHCalculator;
import pal.eval.SimpleLeafCalculator;
import pal.substmodel.SubstitutionModel;

public final class FastFourStateLHCalculator
implements LHCalculator {
    private static final int FOUR_STATES = 4;

    private static final void calculateSingleExtendedIndirectImpl(double distance, SubstitutionModel model, int numberOfPatterns, ConditionalProbabilityStore baseConditionalProbabilities, ConditionalProbabilityStore resultConditionalProbabilities, double[][][] transitionProbabilityStore, int numberOfCategories) {
        model.getTransitionProbabilities(distance, transitionProbabilityStore);
        double[][][] baseStoreValues = baseConditionalProbabilities.getCurrentConditionalProbabilities();
        double[][][] resultStoreValues = baseConditionalProbabilities.getConditionalProbabilityAccess(numberOfPatterns, false);
        int category = 0;
        while (category < numberOfCategories) {
            double[][] basePatternStateProbabilities = baseStoreValues[category];
            double[][] resultPatternStateProbabilities = resultStoreValues[category];
            double[][] transProb = transitionProbabilityStore[category];
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                double[] baseStateProbabilities = basePatternStateProbabilities[pattern];
                double[] resultStateProbabilities = resultPatternStateProbabilities[pattern];
                double[] speedupArray0 = transProb[0];
                double[] speedupArray1 = transProb[1];
                double[] speedupArray2 = transProb[2];
                double[] speedupArray3 = transProb[3];
                resultStateProbabilities[0] = speedupArray0[1] * baseStateProbabilities[0] + speedupArray0[1] * baseStateProbabilities[1] + speedupArray0[2] * baseStateProbabilities[2] + speedupArray0[3] * baseStateProbabilities[3];
                resultStateProbabilities[1] = speedupArray1[1] * baseStateProbabilities[0] + speedupArray1[1] * baseStateProbabilities[1] + speedupArray1[2] * baseStateProbabilities[2] + speedupArray1[3] * baseStateProbabilities[3];
                resultStateProbabilities[2] = speedupArray2[1] * baseStateProbabilities[0] + speedupArray2[1] * baseStateProbabilities[1] + speedupArray2[2] * baseStateProbabilities[2] + speedupArray2[3] * baseStateProbabilities[3];
                resultStateProbabilities[3] = speedupArray3[1] * baseStateProbabilities[0] + speedupArray3[1] * baseStateProbabilities[1] + speedupArray3[2] * baseStateProbabilities[2] + speedupArray3[3] * baseStateProbabilities[3];
                ++pattern;
            }
            ++category;
        }
    }

    private static final void calculateFlatImpl(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, ConditionalProbabilityStore resultStore, int numberOfCategories) {
        int[] patternLookup = centerPattern.getPatternLookup();
        int numberOfPatterns = centerPattern.getNumberOfPatterns();
        double[][][] resultStoreValues = resultStore.getConditionalProbabilityAccess(numberOfPatterns, false);
        int category = 0;
        while (category < numberOfCategories) {
            int patternAccess = 0;
            double[][] myPatternStateProbabilities = resultStoreValues[category];
            double[][] leftPatternStateProbabilities = leftConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            double[][] rightPatternStateProbabilities = rightConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                int leftPattern = patternLookup[patternAccess++];
                int rightPattern = patternLookup[patternAccess++];
                double[] myStateProbabilities = myPatternStateProbabilities[pattern];
                double[] leftStateProbabilities = leftPatternStateProbabilities[leftPattern];
                double[] rightStateProbabilities = rightPatternStateProbabilities[rightPattern];
                myStateProbabilities[0] = leftStateProbabilities[0] * rightStateProbabilities[0];
                myStateProbabilities[1] = leftStateProbabilities[1] * rightStateProbabilities[1];
                myStateProbabilities[2] = leftStateProbabilities[2] * rightStateProbabilities[2];
                myStateProbabilities[3] = leftStateProbabilities[3] * rightStateProbabilities[3];
                ++pattern;
            }
            ++category;
        }
    }

    private static final void calculateExtendedImpl(double[][][] transitionProbabilityStore, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, ConditionalProbabilityStore resultStore, int numberOfCategories) {
        int[] patternLookup = centerPattern.getPatternLookup();
        int numberOfPatterns = centerPattern.getNumberOfPatterns();
        double[][][] resultStoreValues = resultStore.getConditionalProbabilityAccess(numberOfPatterns, false);
        int category = 0;
        while (category < numberOfCategories) {
            int patternAccess = 0;
            double[][] myPatternStateProbabilities = resultStoreValues[category];
            double[][] leftPatternStateProbabilities = leftConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            double[][] rightPatternStateProbabilities = rightConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            double[][] transProb = transitionProbabilityStore[category];
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                int leftPattern = patternLookup[patternAccess++];
                int rightPattern = patternLookup[patternAccess++];
                double[] myStateProbabilities = myPatternStateProbabilities[pattern];
                double[] leftStateProbabilities = leftPatternStateProbabilities[leftPattern];
                double[] rightStateProbabilities = rightPatternStateProbabilities[rightPattern];
                double es0 = leftStateProbabilities[0] * rightStateProbabilities[0];
                double es1 = leftStateProbabilities[1] * rightStateProbabilities[1];
                double es2 = leftStateProbabilities[2] * rightStateProbabilities[2];
                double es3 = leftStateProbabilities[3] * rightStateProbabilities[3];
                double[] sa0 = transProb[0];
                double[] sa1 = transProb[1];
                double[] sa2 = transProb[2];
                double[] sa3 = transProb[3];
                myStateProbabilities[0] = sa0[0] * es0 + sa0[1] * es1 + sa0[2] * es2 + sa0[3] * es3;
                myStateProbabilities[1] = sa1[0] * es0 + sa1[1] * es1 + sa1[2] * es2 + sa1[3] * es3;
                myStateProbabilities[2] = sa2[0] * es0 + sa2[1] * es1 + sa2[2] * es2 + sa2[3] * es3;
                myStateProbabilities[3] = sa3[0] * es0 + sa3[1] * es1 + sa3[2] * es2 + sa3[3] * es3;
                ++pattern;
            }
            ++category;
        }
    }

    public static final LHCalculator.Factory getFactory(LHCalculator.Factory fallbackFactory) {
        return new SimpleFactory(fallbackFactory);
    }

    public static final LHCalculator.Factory getFactory() {
        return new SimpleFactory(SimpleLHCalculator.getFactory());
    }

    private static final class SimpleGenerator
    implements LHCalculator.Generator {
        private final int numberOfCategories_;
        private final double[] endStateProbabilityStore_ = new double[4];

        public SimpleGenerator(int numberOfCategories) {
            this.numberOfCategories_ = numberOfCategories;
        }

        public LHCalculator.Leaf createNewLeaf(int[] patternStateMatchup, int numberOfPatterns) {
            return new SimpleLeafCalculator(patternStateMatchup, numberOfPatterns, 4, this.numberOfCategories_, this);
        }

        public LHCalculator.Leaf createNewLeaf(int[] patternStateMatchup, int numberOfPatterns, LHCalculator.Generator parentGenerator) {
            return new SimpleLeafCalculator(patternStateMatchup, numberOfPatterns, 4, this.numberOfCategories_, parentGenerator);
        }

        public LHCalculator.Internal createNewInternal() {
            return new InternalImpl(this.numberOfCategories_, this.endStateProbabilityStore_, this);
        }

        public LHCalculator.External createNewExternal() {
            return new ExternalImpl(this.numberOfCategories_, this.endStateProbabilityStore_);
        }

        public LHCalculator.External createNewExternal(LHCalculator.Generator parentGenerator) throws IllegalArgumentException {
            return new ExternalImpl(this.numberOfCategories_, this.endStateProbabilityStore_);
        }

        public LHCalculator.Internal createNewInternal(LHCalculator.Generator parentGenerator) throws IllegalArgumentException {
            return new InternalImpl(this.numberOfCategories_, this.endStateProbabilityStore_, parentGenerator);
        }

        public ConditionalProbabilityStore createAppropriateConditionalProbabilityStore(boolean isForLeaf) {
            return new ConditionalProbabilityStore(this.numberOfCategories_, 4);
        }

        public boolean isAllowCaching() {
            return true;
        }
    }

    private static final class SimpleFactory
    implements LHCalculator.Factory {
        private final LHCalculator.Factory fallbackFactory_;

        public SimpleFactory(LHCalculator.Factory fallbackFactory) {
            this.fallbackFactory_ = fallbackFactory;
        }

        public LHCalculator.Generator createSeries(int numberOfCategories, DataType dt) {
            if (dt.getNumStates() == 4) {
                return new SimpleGenerator(numberOfCategories);
            }
            return this.fallbackFactory_.createSeries(numberOfCategories, dt);
        }
    }

    private static final class ExternalImpl
    extends LHCalculator.AbstractExternal
    implements LHCalculator.External {
        private final int numberOfCategories_;
        private final double[][][] transitionProbabilityStore_;
        private final double[] endStateProbabilityStore_;

        private ExternalImpl(int numberOfCategories, double[] endStateProbabilityStore) {
            this.numberOfCategories_ = numberOfCategories;
            this.endStateProbabilityStore_ = endStateProbabilityStore;
            this.transitionProbabilityStore_ = new double[numberOfCategories][4][4];
        }

        public final void calculateExtended(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, ConditionalProbabilityStore resultStore) {
            model.getTransitionProbabilities(distance, this.transitionProbabilityStore_);
            FastFourStateLHCalculator.calculateExtendedImpl(this.transitionProbabilityStore_, centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, resultStore, this.numberOfCategories_);
        }

        public void calculateSingleExtendedDirect(double distance, SubstitutionModel model, int numberOfPatterns, ConditionalProbabilityStore conditionalProbabilities) {
            model.getTransitionProbabilities(distance, this.transitionProbabilityStore_);
            double[][][] baseStoreValues = conditionalProbabilities.getCurrentConditionalProbabilities();
            int category = 0;
            while (category < this.numberOfCategories_) {
                double[][] basePatternStateProbabilities = baseStoreValues[category];
                double[][] transProb = this.transitionProbabilityStore_[category];
                int pattern = 0;
                while (pattern < numberOfPatterns) {
                    double[] baseStateProbabilities = basePatternStateProbabilities[pattern];
                    double[] speedupArray0 = transProb[0];
                    double[] speedupArray1 = transProb[1];
                    double[] speedupArray2 = transProb[2];
                    double[] speedupArray3 = transProb[3];
                    double probTotal0 = speedupArray0[1] * baseStateProbabilities[0] + speedupArray0[1] * baseStateProbabilities[1] + speedupArray0[2] * baseStateProbabilities[2] + speedupArray0[3] * baseStateProbabilities[3];
                    double probTotal1 = speedupArray1[1] * baseStateProbabilities[0] + speedupArray1[1] * baseStateProbabilities[1] + speedupArray1[2] * baseStateProbabilities[2] + speedupArray1[3] * baseStateProbabilities[3];
                    double probTotal2 = speedupArray2[1] * baseStateProbabilities[0] + speedupArray2[1] * baseStateProbabilities[1] + speedupArray2[2] * baseStateProbabilities[2] + speedupArray2[3] * baseStateProbabilities[3];
                    double probTotal3 = speedupArray3[1] * baseStateProbabilities[0] + speedupArray3[1] * baseStateProbabilities[1] + speedupArray3[2] * baseStateProbabilities[2] + speedupArray3[3] * baseStateProbabilities[3];
                    baseStateProbabilities[0] = probTotal0;
                    baseStateProbabilities[1] = probTotal1;
                    baseStateProbabilities[2] = probTotal2;
                    baseStateProbabilities[3] = probTotal3;
                    ++pattern;
                }
                ++category;
            }
        }

        public double calculateLogLikelihoodSingle(SubstitutionModel model, int[] patternWeights, int numberOfPatterns, ConditionalProbabilityStore conditionalProbabilityStore) {
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            double[] probabilities = model.getTransitionCategoryProbabilities();
            double logLikelihood = 0.0;
            double[][][] conditionalProbabilities = conditionalProbabilityStore.getCurrentConditionalProbabilities();
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                double total = 0.0;
                int cat = 0;
                while (cat < this.numberOfCategories_) {
                    double[] baseStates = conditionalProbabilities[cat][pattern];
                    total += probabilities[cat] * (equilibriumFrequencies[0] * baseStates[0] + equilibriumFrequencies[1] * baseStates[1] + equilibriumFrequencies[2] * baseStates[2] + equilibriumFrequencies[3] * baseStates[3]);
                    ++cat;
                }
                logLikelihood += Math.log(total) * (double)patternWeights[pattern];
                ++pattern;
            }
            return logLikelihood;
        }

        public void calculateSingleExtendedIndirect(double distance, SubstitutionModel model, int numberOfPatterns, ConditionalProbabilityStore baseConditionalProbabilities, ConditionalProbabilityStore resultConditionalProbabilities) {
            FastFourStateLHCalculator.calculateSingleExtendedIndirectImpl(distance, model, numberOfPatterns, baseConditionalProbabilities, resultConditionalProbabilities, this.transitionProbabilityStore_, this.numberOfCategories_);
        }

        public final void calculateFlat(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, ConditionalProbabilityStore resultStore) {
            FastFourStateLHCalculator.calculateFlatImpl(centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, resultStore, this.numberOfCategories_);
        }

        private final double[][][] getResultStoreValues(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftFlatConditionalProbabilities, ConditionalProbabilityStore rightFlatConditionalProbabilities, ConditionalProbabilityStore tempStore) {
            int[] patternWeights = centerPattern.getPatternWeights();
            int[] patternLookup = centerPattern.getPatternLookup();
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            model.getTransitionProbabilities(distance, this.transitionProbabilityStore_);
            double[][][] resultStoreValues = tempStore.getConditionalProbabilityAccess(numberOfPatterns, false);
            int category = 0;
            while (category < this.numberOfCategories_) {
                int patternAccess = 0;
                double[][] myPatternStateProbabilities = resultStoreValues[category];
                double[][] leftPatternStateProbabilities = leftFlatConditionalProbabilities.getCurrentConditionalProbabilities(category);
                double[][] rightPatternStateProbabilities = rightFlatConditionalProbabilities.getCurrentConditionalProbabilities(category);
                double[][] transProb = this.transitionProbabilityStore_[category];
                int pattern = 0;
                while (pattern < numberOfPatterns) {
                    int leftPattern = patternLookup[patternAccess++];
                    int rightPattern = patternLookup[patternAccess++];
                    double[] myStateProbabilities = myPatternStateProbabilities[pattern];
                    double[] leftStateProbabilities = leftPatternStateProbabilities[leftPattern];
                    double[] rightStateProbabilities = rightPatternStateProbabilities[rightPattern];
                    double[] sa0 = transProb[0];
                    double[] sa1 = transProb[1];
                    double[] sa2 = transProb[2];
                    double[] sa3 = transProb[3];
                    myStateProbabilities[0] = (sa0[0] * leftStateProbabilities[0] + sa0[1] * leftStateProbabilities[1] + sa0[2] * leftStateProbabilities[2] + sa0[3] * leftStateProbabilities[3]) * rightStateProbabilities[0];
                    myStateProbabilities[1] = (sa1[0] * leftStateProbabilities[0] + sa1[1] * leftStateProbabilities[1] + sa1[2] * leftStateProbabilities[2] + sa1[3] * leftStateProbabilities[3]) * rightStateProbabilities[1];
                    myStateProbabilities[2] = (sa2[0] * leftStateProbabilities[0] + sa2[1] * leftStateProbabilities[1] + sa2[2] * leftStateProbabilities[2] + sa2[3] * leftStateProbabilities[3]) * rightStateProbabilities[2];
                    myStateProbabilities[3] = (sa3[0] * leftStateProbabilities[0] + sa3[1] * leftStateProbabilities[1] + sa3[2] * leftStateProbabilities[2] + sa3[3] * leftStateProbabilities[3]) * rightStateProbabilities[3];
                    ++pattern;
                }
                ++category;
            }
            return resultStoreValues;
        }

        protected final void calculateCategoryPatternProbabilities(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftFlatConditionalProbabilities, ConditionalProbabilityStore rightFlatConditionalProbabilities, ConditionalProbabilityStore tempStore, double[][] categoryPatternLogLikelihoodStore) {
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            int[] patternWeights = centerPattern.getPatternWeights();
            double[][][] resultStoreValues = this.getResultStoreValues(distance, model, centerPattern, leftFlatConditionalProbabilities, rightFlatConditionalProbabilities, tempStore);
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            int cat = 0;
            while (cat < this.numberOfCategories_) {
                double total = 0.0;
                double[] patternLogLikelihoodStore = categoryPatternLogLikelihoodStore[cat];
                int pattern = 0;
                while (pattern < numberOfPatterns) {
                    double prob;
                    double[] states = resultStoreValues[cat][pattern];
                    patternLogLikelihoodStore[pattern] = prob = equilibriumFrequencies[0] * states[0] + equilibriumFrequencies[1] * states[1] + equilibriumFrequencies[2] * states[2] + equilibriumFrequencies[3] * states[3];
                    ++pattern;
                }
                ++cat;
            }
        }

        public final double calculateLogLikelihood(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftFlatConditionalProbabilities, ConditionalProbabilityStore rightFlatConditionalProbabilities, ConditionalProbabilityStore tempStore) {
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            int[] patternWeights = centerPattern.getPatternWeights();
            double[][][] resultStoreValues = this.getResultStoreValues(distance, model, centerPattern, leftFlatConditionalProbabilities, rightFlatConditionalProbabilities, tempStore);
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            double[] probabilities = model.getTransitionCategoryProbabilities();
            double logLikelihood = 0.0;
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                double total = 0.0;
                int cat = 0;
                while (cat < this.numberOfCategories_) {
                    double[] states = resultStoreValues[cat][pattern];
                    double prob = equilibriumFrequencies[0] * states[0] + equilibriumFrequencies[1] * states[1] + equilibriumFrequencies[2] * states[2] + equilibriumFrequencies[3] * states[3];
                    total += probabilities[cat] * prob;
                    ++cat;
                }
                logLikelihood += Math.log(total) * (double)patternWeights[pattern];
                ++pattern;
            }
            return logLikelihood;
        }

        protected final void calculateCategoryPatternProbabilities(SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilities, ConditionalProbabilityStore rightConditionalProbabilities, double[][] categoryPatternLikelihoodStore) {
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            int[] patternLookup = centerPattern.getPatternLookup();
            int[] patternWeights = centerPattern.getPatternWeights();
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            double[][][] leftValues = leftConditionalProbabilities.getCurrentConditionalProbabilities();
            double[][][] rightValues = rightConditionalProbabilities.getCurrentConditionalProbabilities();
            int cat = 0;
            while (cat < this.numberOfCategories_) {
                double total = 0.0;
                double[][] leftPattern = leftValues[cat];
                double[][] rightPattern = rightValues[cat];
                double[] patternLikelihoodStore = categoryPatternLikelihoodStore[cat];
                int patternIndex = 0;
                int pattern = 0;
                while (pattern < numberOfPatterns) {
                    double prob;
                    double[] left = leftPattern[patternLookup[patternIndex++]];
                    double[] right = rightPattern[patternLookup[patternIndex++]];
                    patternLikelihoodStore[pattern] = prob = equilibriumFrequencies[0] * (left[0] * right[0]) + equilibriumFrequencies[1] * (left[1] * right[1]) + equilibriumFrequencies[2] * (left[2] * right[2]) + equilibriumFrequencies[3] * (left[3] * right[3]);
                    ++pattern;
                }
                ++cat;
            }
        }

        public double calculateLogLikelihood(SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilities, ConditionalProbabilityStore rightConditionalProbabilities) {
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            int[] patternLookup = centerPattern.getPatternLookup();
            int[] patternWeights = centerPattern.getPatternWeights();
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            double[] probabilities = model.getTransitionCategoryProbabilities();
            double logLikelihood = 0.0;
            int patternIndex = 0;
            double[][][] leftValues = leftConditionalProbabilities.getCurrentConditionalProbabilities();
            double[][][] rightValues = rightConditionalProbabilities.getCurrentConditionalProbabilities();
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                double total = 0.0;
                int leftIndex = patternLookup[patternIndex++];
                int rightIndex = patternLookup[patternIndex++];
                int cat = 0;
                while (cat < this.numberOfCategories_) {
                    double[] left = leftValues[cat][leftIndex];
                    double[] right = rightValues[cat][rightIndex];
                    double prob = equilibriumFrequencies[0] * (left[0] * right[0]) + equilibriumFrequencies[1] * (left[1] * right[1]) + equilibriumFrequencies[2] * (left[2] * right[2]) + equilibriumFrequencies[3] * (left[3] * right[3]);
                    total += probabilities[cat] * prob;
                    ++cat;
                }
                logLikelihood += Math.log(total) * (double)patternWeights[pattern];
                ++pattern;
            }
            return logLikelihood;
        }
    }

    private static final class InternalImpl
    implements LHCalculator.Internal {
        private final int numberOfCategories_;
        private final ConditionalProbabilityStore myResultStore_;
        private final double[][][] transitionProbabilityStore_;
        private final double[] endStateProbabilityStore_;
        private double lastDistance_ = -1.0;

        private InternalImpl(int numberOfCategories, double[] endStateProbabilityStore, LHCalculator.Generator parentGenerator) {
            this.numberOfCategories_ = numberOfCategories;
            this.endStateProbabilityStore_ = endStateProbabilityStore;
            this.transitionProbabilityStore_ = new double[numberOfCategories][4][4];
            this.myResultStore_ = parentGenerator.createAppropriateConditionalProbabilityStore(false);
        }

        public final ConditionalProbabilityStore calculateSingleExtended(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore baseConditionalProbabilityProbabilties, boolean modelChangedSinceLastCall) {
            FastFourStateLHCalculator.calculateSingleExtendedIndirectImpl(distance, model, centerPattern.getNumberOfPatterns(), baseConditionalProbabilityProbabilties, this.myResultStore_, this.transitionProbabilityStore_, this.numberOfCategories_);
            return this.myResultStore_;
        }

        public final ConditionalProbabilityStore calculatePostExtendedFlat(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, boolean modelChangedSinceLastCall) {
            throw new RuntimeException("Not implemented yet!");
        }

        public final ConditionalProbabilityStore calculateExtended(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, boolean modelChangedSinceLastCall) {
            if (modelChangedSinceLastCall || distance != this.lastDistance_ || this.lastDistance_ < 0.0) {
                model.getTransitionProbabilities(distance, this.transitionProbabilityStore_);
                this.lastDistance_ = distance;
            }
            FastFourStateLHCalculator.calculateExtendedImpl(this.transitionProbabilityStore_, centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, this.myResultStore_, this.numberOfCategories_);
            return this.myResultStore_;
        }

        public final ConditionalProbabilityStore calculateFlat(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties) {
            FastFourStateLHCalculator.calculateFlatImpl(centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, this.myResultStore_, this.numberOfCategories_);
            return this.myResultStore_;
        }
    }
}

