/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.alignment.Alignment;
import pal.alignment.AlignmentUtils;
import pal.datatype.DataType;
import pal.eval.LikelihoodCalculator;
import pal.eval.LikelihoodSummary;
import pal.misc.Identifier;
import pal.misc.PalObjectEvent;
import pal.misc.PalObjectListener;
import pal.misc.Utils;
import pal.substmodel.RateDistribution;
import pal.substmodel.RateMatrix;
import pal.substmodel.SubstitutionModel;
import pal.tree.Node;
import pal.tree.Tree;

public class GeneralLikelihoodCalculator
implements PalObjectListener,
LikelihoodCalculator {
    NNode root_;
    boolean modelChanged_ = false;
    int numberOfSites_;
    int numberOfStates_;
    int numberOfTransitionCategories_;
    int[] patternWeightWorkingStore_;
    SubstitutionModel model_;
    double[] equilibriumFrequencies_;
    Alignment baseAlignment_;
    private static double THRESHOLD = 1.0E-12;
    double[] gapPriors_;

    public GeneralLikelihoodCalculator(Alignment baseAlignment, Tree tree, RateMatrix model) {
        this(baseAlignment, tree, SubstitutionModel.Utils.createSubstitutionModel(model));
    }

    public GeneralLikelihoodCalculator(Alignment baseAlignment, Tree tree, RateMatrix model, RateDistribution distribution) {
        this(baseAlignment, tree, SubstitutionModel.Utils.createSubstitutionModel(model, distribution));
    }

    public GeneralLikelihoodCalculator(Alignment baseAlignment, Tree tree, SubstitutionModel model) {
        this.baseAlignment_ = baseAlignment;
        this.numberOfTransitionCategories_ = model.getNumberOfTransitionCategories();
        this.numberOfSites_ = baseAlignment.getSiteCount();
        this.patternWeightWorkingStore_ = new int[this.numberOfSites_];
        this.numberOfStates_ = baseAlignment.getDataType().getNumStates();
        this.buildGapPriors();
        this.setup(tree, model);
    }

    public void parametersChanged(PalObjectEvent pe) {
        this.modelChanged_ = true;
    }

    public void structureChanged(PalObjectEvent pe) {
        this.modelChanged_ = true;
    }

    private void buildGapPriors() {
        if (this.gapPriors_ == null || this.gapPriors_.length != this.numberOfStates_) {
            this.gapPriors_ = new double[this.numberOfStates_];
            int i = 0;
            while (i < this.numberOfStates_) {
                this.gapPriors_[i] = 1.0;
                ++i;
            }
        }
    }

    public final void setup(Tree t, SubstitutionModel model) {
        if (this.model_ == null || this.model_ != model) {
            if (this.model_ != null) {
                this.model_.removePalObjectListener(this);
            }
            this.model_ = model;
            this.model_.addPalObjectListener(this);
            this.modelChanged_ = true;
            this.equilibriumFrequencies_ = Utils.getCopy(this.model_.getEquilibriumFrequencies());
        }
        if (this.root_ == null) {
            this.root_ = this.create(t.getRoot());
        }
        this.root_.setupSequences(this.patternWeightWorkingStore_, AlignmentUtils.getAlignedStates(this.baseAlignment_), this.baseAlignment_);
    }

    public void release() {
        try {
            this.model_.removePalObjectListener(this);
            this.model_ = null;
        }
        catch (NullPointerException e) {}
    }

    public double calculateLogLikelihood() {
        double lkl = this.root_.computeLikelihood();
        return lkl;
    }

    public LikelihoodSummary calculateLogLikelihoodSummary() {
        return this.root_.computeLikelihoodSummary();
    }

    final NNode create(Node peer) {
        switch (peer.getChildCount()) {
            case 0: {
                return new LeafNode(peer);
            }
            case 2: {
                if (this.numberOfStates_ == 4) {
                    return new BificatingFourStateInternalNode(peer);
                }
                return new BificatingInternalNode(peer);
            }
        }
        if (this.numberOfStates_ == 4) {
            return new FourStateInternalNode(peer);
        }
        return new InternalNode(peer);
    }

    private static final LikelihoodSummary calculateFinalSummaryImpl(DataType dt, double[] equilibriumProbabilities, int numberOfPatterns, double[] categoryProbabilities, int[] patternWeights, double[][][][] childPatternProbs, int[] patterns, int[] sitePatternMatchup) {
        int numberOfTransitionCategories = categoryProbabilities.length;
        double[][] individualLikelihoods = new double[numberOfPatterns][numberOfTransitionCategories];
        int numberOfChildren = childPatternProbs.length;
        int numberOfStates = dt.getNumStates();
        double logSum = 0.0;
        int patternReadPoint = 0;
        int pattern = 0;
        while (pattern < numberOfPatterns) {
            double probabilitySum = 0.0;
            double[] patternCategoryLikelihoods = individualLikelihoods[pattern];
            int transitionCategory = 0;
            while (transitionCategory < numberOfTransitionCategories) {
                double total = 0.0;
                int state = 0;
                while (state < numberOfStates) {
                    double stateProb = childPatternProbs[0][transitionCategory][patterns[patternReadPoint]][state];
                    int i = 1;
                    while (i < numberOfChildren) {
                        stateProb *= childPatternProbs[i][transitionCategory][patterns[patternReadPoint + i]][state];
                        ++i;
                    }
                    total += equilibriumProbabilities[state] * stateProb;
                    ++state;
                }
                patternCategoryLikelihoods[transitionCategory] = total;
                probabilitySum += total * categoryProbabilities[transitionCategory];
                ++transitionCategory;
            }
            patternReadPoint += numberOfChildren;
            logSum += Math.log(probabilitySum) * (double)patternWeights[pattern];
            ++pattern;
        }
        return new LikelihoodSummary(dt, logSum, categoryProbabilities, individualLikelihoods, sitePatternMatchup);
    }

    private static final boolean matches(int[] patternStore, int[] pattern, int patternIndex, int patternSize) {
        int i = 0;
        while (i < patternSize) {
            if (patternStore[patternIndex++] != pattern[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static final double dotProduct4(double[] v1, double[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2] + v1[3] * v2[3];
    }

    protected static final double dotProduct4(double[] v1, double[] v2, double[] v3) {
        return v1[0] * v2[0] * v3[0] + v1[1] * v2[1] * v3[1] + v1[2] * v2[2] * v3[2] + v1[3] * v2[3] * v3[3];
    }

    protected static final void directProduct4(double[] v1, double[] v2, double[] store) {
        store[0] = v1[0] * v2[0];
        store[1] = v1[1] * v2[1];
        store[2] = v1[2] * v2[2];
        store[3] = v1[3] * v2[3];
    }

    protected static final double sum4(double[] v) {
        return v[0] + v[1] + v[2] + v[3];
    }

    class FourStateInternalNode
    extends InternalNode {
        public FourStateInternalNode(Node peer) {
            super(peer);
        }

        public boolean calculatePatternProbabilities() {
            if (!this.setupProbabilityCalculate()) {
                return false;
            }
            int transitionCategory = 0;
            while (transitionCategory < GeneralLikelihoodCalculator.this.numberOfTransitionCategories_) {
                double[][] transProbs = this.transitionProbs_[transitionCategory];
                double[][] patternStateProbs = this.patternStateProbabilities_[transitionCategory];
                int patternReadPoint = 0;
                int pattern = 0;
                while (pattern < this.numberOfPatterns_) {
                    GeneralLikelihoodCalculator.directProduct4(this.childPatternProbs_[0][transitionCategory][this.patterns_[patternReadPoint]], this.childPatternProbs_[1][transitionCategory][this.patterns_[patternReadPoint + 1]], this.endStateProbs_);
                    int i = 2;
                    while (i < this.childPatternProbs_.length) {
                        GeneralLikelihoodCalculator.directProduct4(this.endStateProbs_, this.childPatternProbs_[i][transitionCategory][this.patterns_[patternReadPoint + i]], this.endStateProbs_);
                        ++i;
                    }
                    patternReadPoint += this.childPatternProbs_.length;
                    double[] probabilityStore = patternStateProbs[pattern];
                    probabilityStore[0] = GeneralLikelihoodCalculator.dotProduct4(transProbs[0], this.endStateProbs_);
                    probabilityStore[1] = GeneralLikelihoodCalculator.dotProduct4(transProbs[1], this.endStateProbs_);
                    probabilityStore[2] = GeneralLikelihoodCalculator.dotProduct4(transProbs[2], this.endStateProbs_);
                    probabilityStore[3] = GeneralLikelihoodCalculator.dotProduct4(transProbs[3], this.endStateProbs_);
                    ++pattern;
                }
                ++transitionCategory;
            }
            return true;
        }

        public double calculateFinal(double[] equilibriumProbs) {
            this.populateChildPatternProbs();
            double logSum = 0.0;
            int patternReadPoint = 0;
            double[] categoryProbabilities = GeneralLikelihoodCalculator.this.model_.getTransitionCategoryProbabilities();
            int numberOfChildren = this.childPatternProbs_.length;
            int pattern = 0;
            while (pattern < this.numberOfPatterns_) {
                double probabilitySum = 0.0;
                int transitionCategory = 0;
                while (transitionCategory < GeneralLikelihoodCalculator.this.numberOfTransitionCategories_) {
                    GeneralLikelihoodCalculator.directProduct4(this.childPatternProbs_[0][transitionCategory][this.patterns_[patternReadPoint]], this.childPatternProbs_[1][transitionCategory][this.patterns_[patternReadPoint + 1]], this.endStateProbs_);
                    int i = 2;
                    while (i < numberOfChildren) {
                        GeneralLikelihoodCalculator.directProduct4(this.endStateProbs_, this.childPatternProbs_[i][transitionCategory][this.patterns_[patternReadPoint + i]], this.endStateProbs_);
                        ++i;
                    }
                    GeneralLikelihoodCalculator.directProduct4(this.endStateProbs_, equilibriumProbs, this.endStateProbs_);
                    probabilitySum += GeneralLikelihoodCalculator.sum4(this.endStateProbs_) * categoryProbabilities[transitionCategory];
                    ++transitionCategory;
                }
                patternReadPoint += numberOfChildren;
                logSum += Math.log(probabilitySum) * (double)this.patternWeights_[pattern];
                ++pattern;
            }
            return logSum;
        }
    }

    class InternalNode
    extends NNode {
        protected NNode[] children_;
        protected double[][][][] childPatternProbs_;
        protected final double[] endStateProbs_;
        protected int[] patterns_;
        protected int numberOfPatterns_;

        public InternalNode(Node peer) {
            super(peer);
            this.endStateProbs_ = new double[GeneralLikelihoodCalculator.this.numberOfStates_];
            this.children_ = new NNode[peer.getChildCount()];
            int i = 0;
            while (i < this.children_.length) {
                this.children_[i] = GeneralLikelihoodCalculator.this.create(peer.getChild(i));
                ++i;
            }
            this.childPatternProbs_ = new double[this.children_.length][][][];
        }

        public void setupSequences(int[] patternWeightStore, int[][] states, Alignment base) {
            int i = 0;
            while (i < this.children_.length) {
                this.children_[i].setupSequences(patternWeightStore, states, base);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.children_.length) {
                this.childPatternProbs_[i2] = this.children_[i2].patternStateProbabilities_;
                ++i2;
            }
            int numberOfChildren = this.children_.length;
            int[] patternStore = new int[GeneralLikelihoodCalculator.this.numberOfSites_ * numberOfChildren];
            int numberOfPatterns = 0;
            int insertionPoint = 0;
            int[] currentPattern = new int[numberOfChildren];
            this.sitePatternMatchup_ = new int[GeneralLikelihoodCalculator.this.numberOfSites_];
            int site = 0;
            while (site < GeneralLikelihoodCalculator.this.numberOfSites_) {
                int child = 0;
                while (child < numberOfChildren) {
                    currentPattern[child] = this.children_[child].sitePatternMatchup_[site];
                    ++child;
                }
                int patternIndex = 0;
                int patternInsertionIndex = -1;
                int pattern = 0;
                while (pattern < numberOfPatterns) {
                    if (GeneralLikelihoodCalculator.matches(patternStore, currentPattern, patternIndex, numberOfChildren)) {
                        patternInsertionIndex = pattern;
                        int n = pattern;
                        patternWeightStore[n] = patternWeightStore[n] + 1;
                        break;
                    }
                    patternIndex += numberOfChildren;
                    ++pattern;
                }
                if (patternInsertionIndex < 0) {
                    int i3 = 0;
                    while (i3 < numberOfChildren) {
                        patternStore[insertionPoint++] = currentPattern[i3];
                        ++i3;
                    }
                    patternInsertionIndex = numberOfPatterns;
                    patternWeightStore[numberOfPatterns] = 1;
                    ++numberOfPatterns;
                }
                this.sitePatternMatchup_[site] = patternInsertionIndex;
                ++site;
            }
            this.numberOfPatterns_ = numberOfPatterns;
            this.patterns_ = new int[insertionPoint];
            System.arraycopy(patternStore, 0, this.patterns_, 0, insertionPoint);
            this.patternWeights_ = new int[numberOfPatterns];
            System.arraycopy(patternWeightStore, 0, this.patternWeights_, 0, numberOfPatterns);
            this.patternStateProbabilities_ = new double[GeneralLikelihoodCalculator.this.numberOfTransitionCategories_][numberOfPatterns][GeneralLikelihoodCalculator.this.numberOfStates_];
        }

        protected final boolean populateChildPatternProbs() {
            boolean changed = false;
            int i = 0;
            while (i < this.children_.length) {
                if (this.children_[i].calculatePatternProbabilities()) {
                    changed = true;
                }
                ++i;
            }
            return changed;
        }

        public LikelihoodSummary computeLikelihoodSummary() {
            LikelihoodSummary ls = this.calculateFinalSummary(GeneralLikelihoodCalculator.this.equilibriumFrequencies_);
            GeneralLikelihoodCalculator.this.modelChanged_ = false;
            return ls;
        }

        public double computeLikelihood() {
            double lh = this.calculateFinal(GeneralLikelihoodCalculator.this.equilibriumFrequencies_);
            GeneralLikelihoodCalculator.this.modelChanged_ = false;
            return lh;
        }

        protected final int getNumberOfChildren() {
            return this.children_.length;
        }

        public void printPatternInfo() {
            System.out.print(this.numberOfPatterns_ + ":(");
            int i = 0;
            while (i < this.children_.length) {
                this.children_[i].printPatternInfo();
                if (i != this.children_.length - 1) {
                    System.out.print(", ");
                }
                ++i;
            }
            System.out.print(")");
        }

        protected boolean setupProbabilityCalculate() {
            boolean a = this.populateChildPatternProbs();
            boolean b = this.updateTransitionProbabilities();
            return a || b;
        }

        public boolean calculatePatternProbabilities() {
            if (!this.setupProbabilityCalculate()) {
                return false;
            }
            int transitionCategory = 0;
            while (transitionCategory < GeneralLikelihoodCalculator.this.numberOfTransitionCategories_) {
                double[][] transProbs = this.transitionProbs_[transitionCategory];
                double[][] patternStateProbs = this.patternStateProbabilities_[transitionCategory];
                int patternReadPoint = 0;
                int pattern = 0;
                while (pattern < this.numberOfPatterns_) {
                    int endState = 0;
                    while (endState < GeneralLikelihoodCalculator.this.numberOfStates_) {
                        double probOfEndState = this.childPatternProbs_[0][transitionCategory][this.patterns_[patternReadPoint]][endState];
                        int i = 1;
                        while (i < this.childPatternProbs_.length) {
                            probOfEndState *= this.childPatternProbs_[i][transitionCategory][this.patterns_[patternReadPoint + i]][endState];
                            ++i;
                        }
                        this.endStateProbs_[endState] = probOfEndState;
                        ++endState;
                    }
                    patternReadPoint += this.childPatternProbs_.length;
                    double[] probabilityStore = patternStateProbs[pattern];
                    int startState = 0;
                    while (startState < GeneralLikelihoodCalculator.this.numberOfStates_) {
                        double probOfStartState = 0.0;
                        int endState2 = 0;
                        while (endState2 < GeneralLikelihoodCalculator.this.numberOfStates_) {
                            probOfStartState += transProbs[startState][endState2] * this.endStateProbs_[endState2];
                            ++endState2;
                        }
                        probabilityStore[startState] = probOfStartState;
                        ++startState;
                    }
                    ++pattern;
                }
                ++transitionCategory;
            }
            return true;
        }

        public double calculateFinal(double[] equilibriumProbs) {
            this.populateChildPatternProbs();
            double logSum = 0.0;
            int patternReadPoint = 0;
            double[] categoryProbabilities = GeneralLikelihoodCalculator.this.model_.getTransitionCategoryProbabilities();
            int numberOfChildren = this.childPatternProbs_.length;
            int pattern = 0;
            while (pattern < this.numberOfPatterns_) {
                double probabilitySum = 0.0;
                int transitionCategory = 0;
                while (transitionCategory < GeneralLikelihoodCalculator.this.numberOfTransitionCategories_) {
                    double total = 0.0;
                    int state = 0;
                    while (state < GeneralLikelihoodCalculator.this.numberOfStates_) {
                        double stateProb = this.childPatternProbs_[0][transitionCategory][this.patterns_[patternReadPoint]][state];
                        int i = 1;
                        while (i < numberOfChildren) {
                            stateProb *= this.childPatternProbs_[i][transitionCategory][this.patterns_[patternReadPoint + i]][state];
                            ++i;
                        }
                        total += equilibriumProbs[state] * stateProb;
                        ++state;
                    }
                    probabilitySum += total * categoryProbabilities[transitionCategory];
                    ++transitionCategory;
                }
                patternReadPoint += numberOfChildren;
                logSum += Math.log(probabilitySum) * (double)this.patternWeights_[pattern];
                ++pattern;
            }
            return logSum;
        }

        public LikelihoodSummary calculateFinalSummary(double[] equilibriumProbs) {
            this.populateChildPatternProbs();
            return GeneralLikelihoodCalculator.calculateFinalSummaryImpl(GeneralLikelihoodCalculator.this.model_.getDataType(), equilibriumProbs, this.numberOfPatterns_, GeneralLikelihoodCalculator.this.model_.getTransitionCategoryProbabilities(), this.patternWeights_, this.childPatternProbs_, this.patterns_, this.sitePatternMatchup_);
        }
    }

    class BificatingFourStateInternalNode
    extends BificatingInternalNode {
        public BificatingFourStateInternalNode(Node peer) {
            super(peer);
        }

        public boolean calculatePatternProbabilities() {
            if (!this.setupProbabilityCalculate()) {
                return false;
            }
            int transitionCategory = 0;
            while (transitionCategory < GeneralLikelihoodCalculator.this.numberOfTransitionCategories_) {
                double[][] leftProbs = this.leftChildPatternProbs_[transitionCategory];
                double[][] rightProbs = this.rightChildPatternProbs_[transitionCategory];
                double[][] patternStateProb = this.patternStateProbabilities_[transitionCategory];
                double[][] transProbs = this.transitionProbs_[transitionCategory];
                int patternReadPoint = 0;
                int pattern = 0;
                while (pattern < this.numberOfPatterns_) {
                    GeneralLikelihoodCalculator.directProduct4(leftProbs[this.patterns_[patternReadPoint]], rightProbs[this.patterns_[patternReadPoint + 1]], this.endStateProbs_);
                    patternReadPoint += 2;
                    double[] probabilityStore = patternStateProb[pattern];
                    probabilityStore[0] = GeneralLikelihoodCalculator.dotProduct4(transProbs[0], this.endStateProbs_);
                    probabilityStore[1] = GeneralLikelihoodCalculator.dotProduct4(transProbs[1], this.endStateProbs_);
                    probabilityStore[2] = GeneralLikelihoodCalculator.dotProduct4(transProbs[2], this.endStateProbs_);
                    probabilityStore[3] = GeneralLikelihoodCalculator.dotProduct4(transProbs[3], this.endStateProbs_);
                    ++pattern;
                }
                ++transitionCategory;
            }
            return true;
        }

        public double calculateFinal(double[] equilibriumProbs) {
            this.populateChildPatternProbs();
            double logSum = 0.0;
            int patternReadPoint = 0;
            double[] categoryProbabilities = GeneralLikelihoodCalculator.this.model_.getTransitionCategoryProbabilities();
            int pattern = 0;
            while (pattern < this.numberOfPatterns_) {
                double probabilitySum = 0.0;
                int patternLeft = this.patterns_[patternReadPoint];
                int patternRight = this.patterns_[patternReadPoint + 1];
                int transitionCategory = 0;
                while (transitionCategory < GeneralLikelihoodCalculator.this.numberOfTransitionCategories_) {
                    probabilitySum += GeneralLikelihoodCalculator.dotProduct4(equilibriumProbs, this.leftChildPatternProbs_[transitionCategory][patternLeft], this.rightChildPatternProbs_[transitionCategory][patternRight]) * categoryProbabilities[transitionCategory];
                    ++transitionCategory;
                }
                patternReadPoint += 2;
                logSum += Math.log(probabilitySum) * (double)this.patternWeights_[pattern];
                ++pattern;
            }
            return logSum;
        }
    }

    class BificatingInternalNode
    extends NNode {
        protected NNode left_;
        protected NNode right_;
        protected double[][][] leftChildPatternProbs_;
        protected double[][][] rightChildPatternProbs_;
        protected final double[] endStateProbs_;
        protected int[] patterns_;
        protected int numberOfPatterns_;

        public BificatingInternalNode(Node peer) {
            super(peer);
            this.endStateProbs_ = new double[GeneralLikelihoodCalculator.this.numberOfStates_];
            this.left_ = GeneralLikelihoodCalculator.this.create(peer.getChild(0));
            this.right_ = GeneralLikelihoodCalculator.this.create(peer.getChild(1));
        }

        public void setupSequences(int[] patternWeightStore, int[][] states, Alignment base) {
            this.left_.setupSequences(patternWeightStore, states, base);
            this.right_.setupSequences(patternWeightStore, states, base);
            this.leftChildPatternProbs_ = this.left_.patternStateProbabilities_;
            this.rightChildPatternProbs_ = this.right_.patternStateProbabilities_;
            int[] patternStore = new int[GeneralLikelihoodCalculator.this.numberOfSites_ * 2];
            int numberOfPatterns = 0;
            int insertionPoint = 0;
            int[] currentPattern = new int[2];
            this.sitePatternMatchup_ = new int[GeneralLikelihoodCalculator.this.numberOfSites_];
            int site = 0;
            while (site < GeneralLikelihoodCalculator.this.numberOfSites_) {
                currentPattern[0] = this.left_.sitePatternMatchup_[site];
                currentPattern[1] = this.right_.sitePatternMatchup_[site];
                int patternIndex = 0;
                int patternInsertionIndex = -1;
                int pattern = 0;
                while (pattern < numberOfPatterns) {
                    if (GeneralLikelihoodCalculator.matches(patternStore, currentPattern, patternIndex, 2)) {
                        patternInsertionIndex = pattern;
                        int n = pattern;
                        patternWeightStore[n] = patternWeightStore[n] + 1;
                        break;
                    }
                    patternIndex += 2;
                    ++pattern;
                }
                if (patternInsertionIndex < 0) {
                    patternStore[insertionPoint++] = currentPattern[0];
                    patternStore[insertionPoint++] = currentPattern[1];
                    patternInsertionIndex = numberOfPatterns;
                    patternWeightStore[numberOfPatterns] = 1;
                    ++numberOfPatterns;
                }
                this.sitePatternMatchup_[site] = patternInsertionIndex;
                ++site;
            }
            this.numberOfPatterns_ = numberOfPatterns;
            this.patterns_ = new int[insertionPoint];
            System.arraycopy(patternStore, 0, this.patterns_, 0, insertionPoint);
            this.patternWeights_ = new int[numberOfPatterns];
            System.arraycopy(patternWeightStore, 0, this.patternWeights_, 0, numberOfPatterns);
            this.patternStateProbabilities_ = new double[GeneralLikelihoodCalculator.this.numberOfTransitionCategories_][numberOfPatterns][GeneralLikelihoodCalculator.this.numberOfStates_];
        }

        protected final boolean populateChildPatternProbs() {
            if (this.left_.calculatePatternProbabilities()) {
                this.right_.calculatePatternProbabilities();
                return true;
            }
            return this.right_.calculatePatternProbabilities();
        }

        public LikelihoodSummary computeLikelihoodSummary() {
            LikelihoodSummary ls = this.calculateFinalSummary(GeneralLikelihoodCalculator.this.equilibriumFrequencies_);
            GeneralLikelihoodCalculator.this.modelChanged_ = false;
            return ls;
        }

        public double computeLikelihood() {
            double lh = this.calculateFinal(GeneralLikelihoodCalculator.this.equilibriumFrequencies_);
            GeneralLikelihoodCalculator.this.modelChanged_ = false;
            return lh;
        }

        protected final int getNumberOfChildren() {
            return 2;
        }

        public void printPatternInfo() {
            System.out.print(this.numberOfPatterns_ + ":(");
            this.left_.printPatternInfo();
            System.out.print(", ");
            this.right_.printPatternInfo();
            System.out.print(")");
        }

        protected boolean setupProbabilityCalculate() {
            boolean a = this.populateChildPatternProbs();
            boolean b = this.updateTransitionProbabilities();
            return a || b;
        }

        public boolean calculatePatternProbabilities() {
            if (!this.setupProbabilityCalculate()) {
                return false;
            }
            int transitionCategory = 0;
            while (transitionCategory < GeneralLikelihoodCalculator.this.numberOfTransitionCategories_) {
                double[][] leftProbs = this.leftChildPatternProbs_[transitionCategory];
                double[][] rightProbs = this.rightChildPatternProbs_[transitionCategory];
                double[][] patternStateProb = this.patternStateProbabilities_[transitionCategory];
                double[][] transProbs = this.transitionProbs_[transitionCategory];
                int patternReadPoint = 0;
                int pattern = 0;
                while (pattern < this.numberOfPatterns_) {
                    int endState = 0;
                    while (endState < GeneralLikelihoodCalculator.this.numberOfStates_) {
                        this.endStateProbs_[endState] = leftProbs[this.patterns_[patternReadPoint]][endState] * rightProbs[this.patterns_[patternReadPoint + 1]][endState];
                        ++endState;
                    }
                    patternReadPoint += 2;
                    double[] probabilityStore = patternStateProb[pattern];
                    int startState = 0;
                    while (startState < GeneralLikelihoodCalculator.this.numberOfStates_) {
                        double probOfStartState = 0.0;
                        int endState2 = 0;
                        while (endState2 < GeneralLikelihoodCalculator.this.numberOfStates_) {
                            probOfStartState += transProbs[startState][endState2] * this.endStateProbs_[endState2];
                            ++endState2;
                        }
                        probabilityStore[startState] = probOfStartState;
                        ++startState;
                    }
                    ++pattern;
                }
                ++transitionCategory;
            }
            return true;
        }

        public double calculateFinal(double[] equilibriumProbs) {
            this.populateChildPatternProbs();
            double logSum = 0.0;
            int patternReadPoint = 0;
            double[] categoryProbabilities = GeneralLikelihoodCalculator.this.model_.getTransitionCategoryProbabilities();
            int pattern = 0;
            while (pattern < this.numberOfPatterns_) {
                double probabilitySum = 0.0;
                int transitionCategory = 0;
                while (transitionCategory < GeneralLikelihoodCalculator.this.numberOfTransitionCategories_) {
                    double total = 0.0;
                    double[][] leftProbs = this.leftChildPatternProbs_[transitionCategory];
                    double[][] rightProbs = this.rightChildPatternProbs_[transitionCategory];
                    int state = 0;
                    while (state < GeneralLikelihoodCalculator.this.numberOfStates_) {
                        total += equilibriumProbs[state] * leftProbs[this.patterns_[patternReadPoint]][state] * rightProbs[this.patterns_[patternReadPoint + 1]][state];
                        ++state;
                    }
                    probabilitySum += total * categoryProbabilities[transitionCategory];
                    ++transitionCategory;
                }
                patternReadPoint += 2;
                logSum += Math.log(probabilitySum) * (double)this.patternWeights_[pattern];
                ++pattern;
            }
            return logSum;
        }

        public LikelihoodSummary calculateFinalSummary(double[] equilibriumProbs) {
            this.populateChildPatternProbs();
            return GeneralLikelihoodCalculator.calculateFinalSummaryImpl(GeneralLikelihoodCalculator.this.model_.getDataType(), equilibriumProbs, this.numberOfPatterns_, GeneralLikelihoodCalculator.this.model_.getTransitionCategoryProbabilities(), this.patternWeights_, new double[][][][]{this.leftChildPatternProbs_, this.rightChildPatternProbs_}, this.patterns_, this.sitePatternMatchup_);
        }
    }

    class LeafNode
    extends NNode {
        public LeafNode(Node peer) {
            super(peer);
        }

        public void setupSequences(int[] patternWeightStore, int[][] states, Alignment base) {
            Identifier id = this.getIdentifier();
            if (id != null) {
                int number = base.whichIdNumber(id.getName());
                if (number >= 0) {
                    this.setSequence(states[number], base.getDataType());
                }
            } else {
                throw new RuntimeException("Assertion error - leaf node has no matching sequence in base alignment");
            }
        }

        public double computeLikelihood() {
            return 0.0;
        }

        public LikelihoodSummary computeLikelihoodSummary() {
            throw new RuntimeException("Cannot generate Likelihood Summary from leaf node");
        }

        private final void setSequence(int[] sequence, DataType dt) {
            int numberOfStates = dt.getNumStates();
            sequence = this.normalise(sequence, dt);
            int[] stateCount = new int[numberOfStates + 1];
            int uniqueCount = 0;
            this.sitePatternMatchup_ = new int[GeneralLikelihoodCalculator.this.numberOfSites_];
            int i = 0;
            while (i < sequence.length) {
                int state = sequence[i];
                if (stateCount[state] == 0) {
                    ++uniqueCount;
                }
                int n = state;
                stateCount[n] = stateCount[n] + 1;
                ++i;
            }
            this.patternStateProbabilities_ = new double[GeneralLikelihoodCalculator.this.numberOfTransitionCategories_][uniqueCount][];
            this.patternWeights_ = new int[uniqueCount];
            int index = 0;
            int[] statePatternMatchup = new int[numberOfStates + 1];
            int i2 = 0;
            while (i2 < numberOfStates) {
                if (stateCount[i2] > 0) {
                    int transitionCategory = 0;
                    while (transitionCategory < GeneralLikelihoodCalculator.this.numberOfTransitionCategories_) {
                        this.patternStateProbabilities_[transitionCategory][index] = this.transitionProbs_[transitionCategory][i2];
                        ++transitionCategory;
                    }
                    this.patternWeights_[index] = stateCount[i2];
                    statePatternMatchup[i2] = index++;
                }
                ++i2;
            }
            int gapCount = stateCount[numberOfStates];
            if (gapCount > 0) {
                int transitionCategory = 0;
                while (transitionCategory < GeneralLikelihoodCalculator.this.numberOfTransitionCategories_) {
                    this.patternStateProbabilities_[transitionCategory][index] = GeneralLikelihoodCalculator.this.gapPriors_;
                    ++transitionCategory;
                }
                this.patternWeights_[index] = gapCount;
                statePatternMatchup[numberOfStates] = index;
            }
            int i3 = 0;
            while (i3 < GeneralLikelihoodCalculator.this.numberOfSites_) {
                this.sitePatternMatchup_[i3] = statePatternMatchup[sequence[i3]];
                ++i3;
            }
        }

        private final int[] normalise(int[] sequence, DataType dt) {
            int[] normal = new int[sequence.length];
            int numberOfStates = dt.getNumStates();
            int i = 0;
            while (i < normal.length) {
                normal[i] = dt.isUnknownState(sequence[i]) ? numberOfStates : sequence[i];
                ++i;
            }
            return normal;
        }

        public void printPatternInfo() {
            System.out.print(this.patternWeights_.length);
        }

        public boolean calculatePatternProbabilities() {
            return this.updateTransitionProbabilitiesTranspose();
        }
    }

    abstract class NNode {
        private double lastLength_ = Double.NEGATIVE_INFINITY;
        private Node peer_;
        protected double[][][] transitionProbs_;
        protected double[][][] patternStateProbabilities_;
        protected int[] patternWeights_;
        protected int[] sitePatternMatchup_;

        public NNode(Node peer) {
            this.peer_ = peer;
            this.transitionProbs_ = new double[GeneralLikelihoodCalculator.this.numberOfTransitionCategories_][GeneralLikelihoodCalculator.this.numberOfStates_][GeneralLikelihoodCalculator.this.numberOfStates_];
        }

        public final boolean isBranchLengthChanged() {
            return Math.abs(this.peer_.getBranchLength() - this.lastLength_) > THRESHOLD;
        }

        protected final double getBranchLength() {
            return this.peer_.getBranchLength();
        }

        protected boolean updateTransitionProbabilities() {
            if (GeneralLikelihoodCalculator.this.modelChanged_ || this.isBranchLengthChanged()) {
                double distance = this.peer_.getBranchLength();
                GeneralLikelihoodCalculator.this.model_.getTransitionProbabilities(distance, this.transitionProbs_);
                this.lastLength_ = distance;
                return true;
            }
            return false;
        }

        protected boolean updateTransitionProbabilitiesTranspose() {
            if (GeneralLikelihoodCalculator.this.modelChanged_ || this.isBranchLengthChanged()) {
                double distance = this.peer_.getBranchLength();
                GeneralLikelihoodCalculator.this.model_.getTransitionProbabilitiesTranspose(distance, this.transitionProbs_);
                this.lastLength_ = distance;
                return true;
            }
            return false;
        }

        public final Identifier getIdentifier() {
            return this.peer_.getIdentifier();
        }

        private String toString(byte[] bs) {
            char[] cs = new char[bs.length];
            int i = 0;
            while (i < cs.length) {
                cs[i] = (char)(65 + bs[i]);
                ++i;
            }
            return new String(cs);
        }

        public abstract void printPatternInfo();

        public abstract boolean calculatePatternProbabilities();

        public abstract void setupSequences(int[] var1, int[][] var2, Alignment var3);

        public abstract double computeLikelihood();

        public abstract LikelihoodSummary computeLikelihoodSummary();
    }
}

