/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.alignment.SitePattern;
import pal.distance.AlignmentDistanceMatrix;
import pal.eval.LikelihoodValue;
import pal.math.ConjugateGradientSearch;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;
import pal.math.NumericalDerivative;
import pal.math.OrthogonalHints;
import pal.math.OrthogonalSearch;
import pal.substmodel.SubstitutionModel;
import pal.tree.NeighborJoiningTree;
import pal.tree.ParameterizedTree;
import pal.tree.UnconstrainedTree;

public class ModelParameters
implements MultivariateFunction {
    public static final int FRACDIGITS = 3;
    private int numParams;
    private SubstitutionModel model;
    private SitePattern sitePattern;
    private ParameterizedTree tree;
    private LikelihoodValue lv;
    private MultivariateMinimum mvm;

    public ModelParameters(SitePattern sp, SubstitutionModel m) {
        this.sitePattern = sp;
        this.model = m;
        this.numParams = this.model.getNumParameters();
        this.lv = new LikelihoodValue(this.sitePattern);
        this.lv.setModel(this.model);
        this.mvm = this.numParams == 1 ? new OrthogonalSearch() : new ConjugateGradientSearch();
    }

    public double[] estimate() {
        double fp;
        double[] p = new double[this.numParams];
        int i = 0;
        while (i < this.numParams) {
            p[i] = this.model.getDefaultValue(i);
            ++i;
        }
        AlignmentDistanceMatrix distMat = null;
        double tolfp = Math.pow(10.0, -4.0);
        double tolp = Math.pow(10.0, -4.0);
        boolean first = true;
        do {
            if (first) {
                distMat = new AlignmentDistanceMatrix(this.sitePattern, this.model);
            } else {
                distMat.recompute(this.sitePattern, this.model);
            }
            NeighborJoiningTree t = new NeighborJoiningTree(distMat);
            UnconstrainedTree pt = new UnconstrainedTree(t);
            this.lv.setTree(pt);
            if (first) {
                fp = this.evaluate(p);
                this.mvm.stopCondition(fp, p, tolfp, tolp, true);
                first = false;
            }
            this.mvm.optimize(this, p, tolfp, tolp);
        } while (!this.mvm.stopCondition(fp = this.evaluate(p), p, tolfp, tolp, false));
        double m = Math.pow(10.0, 3.0);
        int i2 = 0;
        while (i2 < p.length) {
            p[i2] = (double)Math.round(p[i2] * m) / m;
            ++i2;
        }
        fp = this.evaluate(p);
        double[] pSE = new double[this.numParams];
        pSE = NumericalDerivative.diagonalHessian(this, p);
        int i3 = 0;
        while (i3 < this.numParams) {
            pSE[i3] = Math.sqrt(1.0 / pSE[i3]);
            this.model.setParameterSE(pSE[i3], i3);
            ++i3;
        }
        return p;
    }

    public double[] estimateFromTree(ParameterizedTree t) {
        double fp;
        double[] p = new double[this.numParams];
        int i = 0;
        while (i < this.numParams) {
            p[i] = this.model.getDefaultValue(i);
            ++i;
        }
        double tolfp = Math.pow(10.0, -4.0);
        double tolp = Math.pow(10.0, -4.0);
        boolean first = true;
        do {
            this.lv.setTree(t);
            if (first) {
                fp = this.evaluate(p);
                this.mvm.stopCondition(fp, p, tolfp, tolp, true);
                first = false;
            }
            this.mvm.optimize(this, p, tolfp, tolp);
        } while (!this.mvm.stopCondition(fp = this.evaluate(p), p, tolfp, tolp, false));
        double m = Math.pow(10.0, 3.0);
        int i2 = 0;
        while (i2 < p.length) {
            p[i2] = (double)Math.round(p[i2] * m) / m;
            ++i2;
        }
        fp = this.evaluate(p);
        double[] pSE = new double[this.numParams];
        pSE = NumericalDerivative.diagonalHessian(this, p);
        int i3 = 0;
        while (i3 < this.numParams) {
            pSE[i3] = Math.sqrt(1.0 / pSE[i3]);
            this.model.setParameterSE(pSE[i3], i3);
            ++i3;
        }
        return p;
    }

    public double evaluate(double[] params) {
        int i = 0;
        while (i < this.numParams) {
            this.model.setParameter(params[i], i);
            ++i;
        }
        double r = -this.lv.compute();
        return r;
    }

    public int getNumArguments() {
        return this.numParams;
    }

    public double getLowerBound(int n) {
        return this.model.getLowerLimit(n);
    }

    public double getUpperBound(int n) {
        return this.model.getUpperLimit(n);
    }

    public OrthogonalHints getOrthogonalHints() {
        return null;
    }
}

