/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pal.datatype.DataType;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.LHCalculator;
import pal.eval.PatternInfo;
import pal.eval.SimpleLeafCalculator;
import pal.substmodel.SubstitutionModel;

public class SimpleLHCalculator
implements LHCalculator {
    private static final SimpleFactory FACTORY_INSTANCE = new SimpleFactory();

    private static final void calculateSingleExtendedIndirectImpl(double distance, SubstitutionModel model, int numberOfPatterns, ConditionalProbabilityStore baseConditionalProbabilities, ConditionalProbabilityStore resultConditionalProbabilities, double[][][] transitionProbabilityStore, int numberOfCategories, int numberOfStates) {
        model.getTransitionProbabilities(distance, transitionProbabilityStore);
        double[][][] resultStoreValues = resultConditionalProbabilities.getConditionalProbabilityAccess(numberOfPatterns, false);
        double[][][] baseStoreValues = baseConditionalProbabilities.getCurrentConditionalProbabilities();
        int category = 0;
        while (category < numberOfCategories) {
            boolean patternAccess = false;
            double[][] resultPatternStateProbabilities = resultStoreValues[category];
            double[][] basePatternStateProbabilities = baseStoreValues[category];
            double[][] transProb = transitionProbabilityStore[category];
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                double[] resultStateProbabilities = resultPatternStateProbabilities[pattern];
                double[] baseStateProbabilities = basePatternStateProbabilities[pattern];
                int startState = 0;
                while (startState < numberOfStates) {
                    double probTotal = 0.0;
                    double[] speedupArray = transProb[startState];
                    int endState = 0;
                    while (endState < numberOfStates) {
                        probTotal += speedupArray[endState] * baseStateProbabilities[endState];
                        ++endState;
                    }
                    resultStateProbabilities[startState] = probTotal;
                    ++startState;
                }
                ++pattern;
            }
            ++category;
        }
    }

    private static final void calculateFlatImpl(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, ConditionalProbabilityStore resultStore, int numberOfCategories, int numberOfStates) {
        int[] patternLookup = centerPattern.getPatternLookup();
        int numberOfPatterns = centerPattern.getNumberOfPatterns();
        double[][][] resultStoreValues = resultStore.getConditionalProbabilityAccess(numberOfPatterns, false);
        int category = 0;
        while (category < numberOfCategories) {
            int patternAccess = 0;
            double[][] myPatternStateProbabilities = resultStoreValues[category];
            double[][] leftPatternStateProbabilities = leftConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            double[][] rightPatternStateProbabilities = rightConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                int leftPattern = patternLookup[patternAccess++];
                int rightPattern = patternLookup[patternAccess++];
                double[] myStateProbabilities = myPatternStateProbabilities[pattern];
                double[] leftStateProbabilities = leftPatternStateProbabilities[leftPattern];
                double[] rightStateProbabilities = rightPatternStateProbabilities[rightPattern];
                int endState = 0;
                while (endState < numberOfStates) {
                    myStateProbabilities[endState] = leftStateProbabilities[endState] * rightStateProbabilities[endState];
                    ++endState;
                }
                ++pattern;
            }
            ++category;
        }
    }

    private static final void calculateExtendedImpl(double[][][] transitionProbabilityStore, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, ConditionalProbabilityStore resultStore, int numberOfCategories, int numberOfStates, double[] endStateProbabilityStore) {
        int[] patternLookup = centerPattern.getPatternLookup();
        int numberOfPatterns = centerPattern.getNumberOfPatterns();
        double[][][] resultStoreValues = resultStore.getConditionalProbabilityAccess(numberOfPatterns, false);
        int category = 0;
        while (category < numberOfCategories) {
            int patternAccess = 0;
            double[][] myPatternStateProbabilities = resultStoreValues[category];
            double[][] leftPatternStateProbabilities = leftConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            double[][] rightPatternStateProbabilities = rightConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            double[][] transProb = transitionProbabilityStore[category];
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                int leftPattern = patternLookup[patternAccess++];
                int rightPattern = patternLookup[patternAccess++];
                double[] myStateProbabilities = myPatternStateProbabilities[pattern];
                double[] leftStateProbabilities = leftPatternStateProbabilities[leftPattern];
                double[] rightStateProbabilities = rightPatternStateProbabilities[rightPattern];
                int endState = 0;
                while (endState < numberOfStates) {
                    endStateProbabilityStore[endState] = leftStateProbabilities[endState] * rightStateProbabilities[endState];
                    ++endState;
                }
                int startState = 0;
                while (startState < numberOfStates) {
                    double probTotal = 0.0;
                    double[] speedupArray = transProb[startState];
                    int endState2 = 0;
                    while (endState2 < numberOfStates) {
                        probTotal += speedupArray[endState2] * endStateProbabilityStore[endState2];
                        ++endState2;
                    }
                    myStateProbabilities[startState] = probTotal;
                    ++startState;
                }
                ++pattern;
            }
            ++category;
        }
    }

    private static final void calculatePostExtendedFlatImpl(double distance, SubstitutionModel model, double[][][] transitionProbabilityStore, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, ConditionalProbabilityStore resultStore, int numberOfCategories, int numberOfStates) {
        model.getTransitionProbabilities(distance, transitionProbabilityStore);
        int[] patternLookup = centerPattern.getPatternLookup();
        int numberOfPatterns = centerPattern.getNumberOfPatterns();
        double[][][] resultStoreValues = resultStore.getConditionalProbabilityAccess(numberOfPatterns, false);
        int category = 0;
        while (category < numberOfCategories) {
            int patternAccess = 0;
            double[][] myPatternStateProbabilities = resultStoreValues[category];
            double[][] leftPatternStateProbabilities = leftConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            double[][] rightPatternStateProbabilities = rightConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            double[][] transProb = transitionProbabilityStore[category];
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                int leftPattern = patternLookup[patternAccess++];
                int rightPattern = patternLookup[patternAccess++];
                double[] myStateProbabilities = myPatternStateProbabilities[pattern];
                double[] leftStateProbabilities = leftPatternStateProbabilities[leftPattern];
                double[] rightStateProbabilities = rightPatternStateProbabilities[rightPattern];
                int startState = 0;
                while (startState < numberOfStates) {
                    double leftTotal = 0.0;
                    double rightTotal = 0.0;
                    double[] speedupArray = transProb[startState];
                    int endState = 0;
                    while (endState < numberOfStates) {
                        leftTotal += speedupArray[endState] * leftStateProbabilities[endState];
                        rightTotal += speedupArray[endState] * rightStateProbabilities[endState];
                        ++endState;
                    }
                    myStateProbabilities[startState] = leftTotal * rightTotal;
                    ++startState;
                }
                ++pattern;
            }
            ++category;
        }
    }

    public static final LHCalculator.Factory getFactory() {
        return FACTORY_INSTANCE;
    }

    private static final class SimpleGenerator
    implements LHCalculator.Generator {
        private int numberOfCategories_;
        private int numberOfStates_;
        private static final long serialVersionUID = 75762749252L;

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeByte(2);
            out.writeInt(this.numberOfCategories_);
            out.writeInt(this.numberOfStates_);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            byte version = in.readByte();
            switch (version) {
                case 1: {
                    this.numberOfCategories_ = in.readInt();
                    this.numberOfStates_ = in.readInt();
                    in.readObject();
                    break;
                }
                default: {
                    this.numberOfCategories_ = in.readInt();
                    this.numberOfStates_ = in.readInt();
                }
            }
        }

        public SimpleGenerator(int numberOfCategories, int numberOfStates) {
            this.numberOfCategories_ = numberOfCategories;
            this.numberOfStates_ = numberOfStates;
        }

        public LHCalculator.Leaf createNewLeaf(int[] patternStateMatchup, int numberOfPatterns) {
            return new SimpleLeafCalculator(patternStateMatchup, numberOfPatterns, this.numberOfStates_, this.numberOfCategories_, this);
        }

        public LHCalculator.Leaf createNewLeaf(int[] patternStateMatchup, int numberOfPatterns, LHCalculator.Generator parentGenerator) {
            return parentGenerator.createNewLeaf(patternStateMatchup, numberOfPatterns);
        }

        public LHCalculator.External createNewExternal() {
            return new ExternalImpl(this.numberOfCategories_, this.numberOfStates_);
        }

        public LHCalculator.Internal createNewInternal() {
            return new InternalImpl(this.numberOfCategories_, this.numberOfStates_, this);
        }

        public LHCalculator.External createNewExternal(LHCalculator.Generator parentGenerator) throws IllegalArgumentException {
            return new ExternalImpl(this.numberOfCategories_, this.numberOfStates_);
        }

        public LHCalculator.Internal createNewInternal(LHCalculator.Generator parentGenerator) throws IllegalArgumentException {
            return new InternalImpl(this.numberOfCategories_, this.numberOfStates_, parentGenerator);
        }

        public ConditionalProbabilityStore createAppropriateConditionalProbabilityStore(boolean isForLeaf) {
            return new ConditionalProbabilityStore(this.numberOfCategories_, this.numberOfStates_);
        }

        public boolean isAllowCaching() {
            return false;
        }
    }

    private static final class SimpleFactory
    implements LHCalculator.Factory {
        public LHCalculator.Generator createSeries(int numberOfCategories, DataType dt) {
            return new SimpleGenerator(numberOfCategories, dt.getNumStates());
        }
    }

    private static final class InternalImpl
    implements LHCalculator.Internal {
        private final int numberOfCategories_;
        private final int numberOfStates_;
        private final ConditionalProbabilityStore myResultStore_;
        private final double[][][] transitionProbabilityStore_;
        private final double[] endStateProbabilityStore_;
        private int currentNumberOfPatterns_ = 0;
        private double lastDistance_ = -1.0;

        private InternalImpl(int numberOfCategories, int numberOfStates, LHCalculator.Generator parentGenerator) {
            this.numberOfCategories_ = numberOfCategories;
            this.numberOfStates_ = numberOfStates;
            this.endStateProbabilityStore_ = new double[numberOfStates];
            this.transitionProbabilityStore_ = new double[numberOfCategories][numberOfStates][numberOfStates];
            this.myResultStore_ = parentGenerator.createAppropriateConditionalProbabilityStore(false);
        }

        public final ConditionalProbabilityStore calculateSingleExtended(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore baseConditionalProbabilityProbabilties, boolean modelChangedSinceLastCall) {
            return baseConditionalProbabilityProbabilties;
        }

        public final ConditionalProbabilityStore calculateExtended(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, boolean modelChangedSinceLastCall) {
            if (modelChangedSinceLastCall || distance != this.lastDistance_ || this.lastDistance_ < 0.0) {
                model.getTransitionProbabilities(distance, this.transitionProbabilityStore_);
                this.lastDistance_ = distance;
            }
            SimpleLHCalculator.calculateExtendedImpl(this.transitionProbabilityStore_, centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, this.myResultStore_, this.numberOfCategories_, this.numberOfStates_, this.endStateProbabilityStore_);
            return this.myResultStore_;
        }

        public final ConditionalProbabilityStore calculatePostExtendedFlat(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, boolean modelChangedSinceLastCall) {
            SimpleLHCalculator.calculatePostExtendedFlatImpl(distance, model, this.transitionProbabilityStore_, centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, this.myResultStore_, this.numberOfCategories_, this.numberOfStates_);
            return this.myResultStore_;
        }

        public final ConditionalProbabilityStore calculateFlat(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties) {
            SimpleLHCalculator.calculateFlatImpl(centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, this.myResultStore_, this.numberOfCategories_, this.numberOfStates_);
            return this.myResultStore_;
        }
    }

    private static final class ExternalImpl
    extends LHCalculator.AbstractExternal
    implements LHCalculator.External {
        private final int numberOfCategories_;
        private final int numberOfStates_;
        private final double[][][] transitionProbabilityStore_;
        private final double[] stateProbabilityStore_;
        private static final long serialVersionUID = 98765372758522L;

        private ExternalImpl(int numberOfCategories, int numberOfStates) {
            this.numberOfCategories_ = numberOfCategories;
            this.numberOfStates_ = numberOfStates;
            this.stateProbabilityStore_ = new double[numberOfStates];
            this.transitionProbabilityStore_ = new double[numberOfCategories][numberOfStates][numberOfStates];
        }

        public final void calculateExtended(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, ConditionalProbabilityStore resultStore) {
            model.getTransitionProbabilities(distance, this.transitionProbabilityStore_);
            SimpleLHCalculator.calculateExtendedImpl(this.transitionProbabilityStore_, centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, resultStore, this.numberOfCategories_, this.numberOfStates_, this.stateProbabilityStore_);
        }

        public final void calculateFlat(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, ConditionalProbabilityStore resultStore) {
            SimpleLHCalculator.calculateFlatImpl(centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, resultStore, this.numberOfCategories_, this.numberOfStates_);
        }

        public void calculateSingleExtendedDirect(double distance, SubstitutionModel model, int numberOfPatterns, ConditionalProbabilityStore conditionalProbabilities) {
            model.getTransitionProbabilities(distance, this.transitionProbabilityStore_);
            double[][][] baseStoreValues = conditionalProbabilities.getCurrentConditionalProbabilities();
            int category = 0;
            while (category < this.numberOfCategories_) {
                boolean patternAccess = false;
                double[][] basePatternStateProbabilities = baseStoreValues[category];
                double[][] transProb = this.transitionProbabilityStore_[category];
                int pattern = 0;
                while (pattern < numberOfPatterns) {
                    double[] baseStateProbabilities = basePatternStateProbabilities[pattern];
                    int startState = 0;
                    while (startState < this.numberOfStates_) {
                        double probTotal = 0.0;
                        double[] speedupArray = transProb[startState];
                        int endState = 0;
                        while (endState < this.numberOfStates_) {
                            probTotal += speedupArray[endState] * baseStateProbabilities[endState];
                            ++endState;
                        }
                        this.stateProbabilityStore_[startState] = probTotal;
                        ++startState;
                    }
                    System.arraycopy(this.stateProbabilityStore_, 0, baseStateProbabilities, 0, this.numberOfStates_);
                    ++pattern;
                }
                ++category;
            }
        }

        public void calculateSingleExtendedIndirect(double distance, SubstitutionModel model, int numberOfPatterns, ConditionalProbabilityStore baseConditionalProbabilities, ConditionalProbabilityStore resultConditionalProbabilities) {
            SimpleLHCalculator.calculateSingleExtendedIndirectImpl(distance, model, numberOfPatterns, baseConditionalProbabilities, resultConditionalProbabilities, this.transitionProbabilityStore_, this.numberOfCategories_, this.numberOfStates_);
        }

        private final double[][][] getResultStoreValues(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftFlatConditionalProbabilities, ConditionalProbabilityStore rightFlatConditionalProbabilities, ConditionalProbabilityStore tempStore) {
            int[] patternWeights = centerPattern.getPatternWeights();
            int[] patternLookup = centerPattern.getPatternLookup();
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            model.getTransitionProbabilities(distance, this.transitionProbabilityStore_);
            double[][][] resultStoreValues = tempStore.getConditionalProbabilityAccess(numberOfPatterns, false);
            int category = 0;
            while (category < this.numberOfCategories_) {
                int patternAccess = 0;
                double[][] myPatternStateProbabilities = resultStoreValues[category];
                double[][] leftPatternStateProbabilities = leftFlatConditionalProbabilities.getCurrentConditionalProbabilities(category);
                double[][] rightPatternStateProbabilities = rightFlatConditionalProbabilities.getCurrentConditionalProbabilities(category);
                double[][] transProb = this.transitionProbabilityStore_[category];
                int pattern = 0;
                while (pattern < numberOfPatterns) {
                    int leftPattern = patternLookup[patternAccess++];
                    int rightPattern = patternLookup[patternAccess++];
                    double[] myStateProbabilities = myPatternStateProbabilities[pattern];
                    double[] leftStateProbabilities = leftPatternStateProbabilities[leftPattern];
                    double[] rightStateProbabilities = rightPatternStateProbabilities[rightPattern];
                    int startState = 0;
                    while (startState < this.numberOfStates_) {
                        double probTotal = 0.0;
                        double[] speedupArray = transProb[startState];
                        int endState = 0;
                        while (endState < this.numberOfStates_) {
                            probTotal += speedupArray[endState] * leftStateProbabilities[endState];
                            ++endState;
                        }
                        myStateProbabilities[startState] = probTotal * rightStateProbabilities[startState];
                        ++startState;
                    }
                    ++pattern;
                }
                ++category;
            }
            return resultStoreValues;
        }

        public double calculateLogLikelihood(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftFlatConditionalProbabilities, ConditionalProbabilityStore rightFlatConditionalProbabilities, ConditionalProbabilityStore tempStore) {
            int[] patternWeights = centerPattern.getPatternWeights();
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            double[][][] resultStoreValues = this.getResultStoreValues(distance, model, centerPattern, leftFlatConditionalProbabilities, rightFlatConditionalProbabilities, tempStore);
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            double[] probabilities = model.getTransitionCategoryProbabilities();
            double logLikelihood = 0.0;
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                double total = 0.0;
                int cat = 0;
                while (cat < this.numberOfCategories_) {
                    double[] states = resultStoreValues[cat][pattern];
                    double prob = 0.0;
                    int state = 0;
                    while (state < this.numberOfStates_) {
                        prob += equilibriumFrequencies[state] * states[state];
                        ++state;
                    }
                    total += probabilities[cat] * prob;
                    ++cat;
                }
                logLikelihood += Math.log(total) * (double)patternWeights[pattern];
                ++pattern;
            }
            return logLikelihood;
        }

        protected void calculateCategoryPatternProbabilities(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftFlatConditionalProbabilities, ConditionalProbabilityStore rightFlatConditionalProbabilities, ConditionalProbabilityStore tempStore, double[][] categoryPatternLogLikelihoods) {
            int[] patternWeights = centerPattern.getPatternWeights();
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            double[][][] resultStoreValues = this.getResultStoreValues(distance, model, centerPattern, leftFlatConditionalProbabilities, rightFlatConditionalProbabilities, tempStore);
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            double logLikelihood = 0.0;
            int cat = 0;
            while (cat < this.numberOfCategories_) {
                double total = 0.0;
                double[][] patternValues = resultStoreValues[cat];
                double[] patternLogLikelihoods = categoryPatternLogLikelihoods[cat];
                int pattern = 0;
                while (pattern < numberOfPatterns) {
                    double[] states = patternValues[pattern];
                    double prob = 0.0;
                    int state = 0;
                    while (state < this.numberOfStates_) {
                        prob += equilibriumFrequencies[state] * states[state];
                        ++state;
                    }
                    patternLogLikelihoods[pattern] = prob;
                    ++pattern;
                }
                ++cat;
            }
        }

        public double calculateLogLikelihoodSingle(SubstitutionModel model, int[] patternWeights, int numberOfPatterns, ConditionalProbabilityStore conditionalProbabilityStore) {
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            double[] probabilities = model.getTransitionCategoryProbabilities();
            double logLikelihood = 0.0;
            double[][][] conditionalProbabilities = conditionalProbabilityStore.getCurrentConditionalProbabilities();
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                double total = 0.0;
                int cat = 0;
                while (cat < this.numberOfCategories_) {
                    double[] baseStates = conditionalProbabilities[cat][pattern];
                    double prob = 0.0;
                    int state = 0;
                    while (state < this.numberOfStates_) {
                        prob += equilibriumFrequencies[state] * baseStates[state];
                        ++state;
                    }
                    total += probabilities[cat] * prob;
                    ++cat;
                }
                logLikelihood += Math.log(total) * (double)patternWeights[pattern];
                ++pattern;
            }
            return logLikelihood;
        }

        public double calculateLogLikelihood(SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore) {
            int[] patternWeights = centerPattern.getPatternWeights();
            int[] patternLookup = centerPattern.getPatternLookup();
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            int[] sitePatternMatchup = centerPattern.getSitePatternMatchup();
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            double[] probabilities = model.getTransitionCategoryProbabilities();
            double logLikelihood = 0.0;
            double[][][] leftConditionalProbabilities = leftConditionalProbabilitiesStore.getCurrentConditionalProbabilities();
            double[][][] rightConditionalProbabilities = rightConditionalProbabilitiesStore.getCurrentConditionalProbabilities();
            int patternIndex = 0;
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                double total = 0.0;
                int leftIndex = patternLookup[patternIndex++];
                int rightIndex = patternLookup[patternIndex++];
                int cat = 0;
                while (cat < this.numberOfCategories_) {
                    double[] left = leftConditionalProbabilities[cat][leftIndex];
                    double[] right = rightConditionalProbabilities[cat][rightIndex];
                    double prob = 0.0;
                    int state = 0;
                    while (state < this.numberOfStates_) {
                        prob += equilibriumFrequencies[state] * (left[state] * right[state]);
                        ++state;
                    }
                    total += probabilities[cat] * prob;
                    ++cat;
                }
                logLikelihood += Math.log(total) * (double)patternWeights[pattern];
                ++pattern;
            }
            return logLikelihood;
        }

        public void calculateCategoryPatternProbabilities(SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore, double[][] categoryPatternLogLikelihoods) {
            int[] patternLookup = centerPattern.getPatternLookup();
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            double[][][] leftConditionalProbabilities = leftConditionalProbabilitiesStore.getCurrentConditionalProbabilities();
            double[][][] rightConditionalProbabilities = rightConditionalProbabilitiesStore.getCurrentConditionalProbabilities();
            int cat = 0;
            while (cat < this.numberOfCategories_) {
                double total = 0.0;
                double[][] leftPatterns = leftConditionalProbabilities[cat];
                double[][] rightPatterns = rightConditionalProbabilities[cat];
                double[] patternLogLikelihoods = categoryPatternLogLikelihoods[cat];
                int patternIndex = 0;
                int pattern = 0;
                while (pattern < numberOfPatterns) {
                    double[] left = leftPatterns[patternLookup[patternIndex++]];
                    double[] right = rightPatterns[patternLookup[patternIndex++]];
                    double prob = 0.0;
                    int state = 0;
                    while (state < this.numberOfStates_) {
                        prob += equilibriumFrequencies[state] * (left[state] * right[state]);
                        ++state;
                    }
                    patternLogLikelihoods[pattern] = prob;
                    ++pattern;
                }
                ++cat;
            }
        }
    }
}

