/*
 * Decompiled with CFR 0.152.
 */
package pal.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.DecimalFormat;
import pal.alignment.AnnotationAlignment;
import pal.popgen.LinkageDisequilibrium;

public class LinkageDisequilibriumComponent
extends Component
implements Printable {
    public static final int P_VALUE = 0;
    public static final int DPRIME = 1;
    public static final int RSQUARE = 2;
    float minimumChromosomeLength = 10.0f;
    LinkageDisequilibrium theLD;
    AnnotationAlignment theAA;
    boolean includeBlockSchematic;
    boolean chromosomalScale;
    BorderLayout borderLayout1 = new BorderLayout();
    int totalVariableSites;
    int totalLoci;
    int totalChromosomes;
    int totalIntervals;
    int totalBlocks;
    float[] startPos;
    float[] endPos;
    float[] blockBeginPos;
    float[] blockEndPos;
    String[] blockNames;
    int[] xPos;
    int[] yPos;
    int[] xEndPos;
    int[] blockBeginX;
    int[] blockEndX;
    int ih;
    int iw;
    float totalUnits;
    float[] blockStart;
    float[] blockEnd;
    String upperLabel;
    String lowerLabel;
    double[][] diseq;
    Color theColor = new Color(0, 0, 0);
    int distanceBetweenGraphAndGene = 40;
    int hoff = 70;
    int h2off = 70;
    int voff = 20;
    boolean probability = true;
    boolean upperProb = false;
    boolean lowerProb = true;

    public LinkageDisequilibriumComponent(LinkageDisequilibrium theLD, boolean includeBlockSchematic, boolean chromosomalScale) {
        this.theLD = theLD;
        this.theAA = theLD.getAnnotatedAlignment();
        this.includeBlockSchematic = includeBlockSchematic;
        this.chromosomalScale = chromosomalScale;
        this.diseq = new double[theLD.getSiteCount()][theLD.getSiteCount()];
        this.setUpperCorner(2);
        this.setLowerCorner(0);
        this.totalVariableSites = theLD.getSiteCount();
        if (this.theAA != null) {
            this.countGenesAndChromosomes();
            this.calculateStartAndEndPositions();
        } else {
            includeBlockSchematic = false;
        }
        this.xPos = new int[theLD.getSiteCount() + 1];
        this.yPos = new int[theLD.getSiteCount() + 1];
        this.xEndPos = new int[theLD.getSiteCount() + 1];
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setLowerCorner(int ldMeasure) {
        int r = 0;
        while (r < this.theLD.getSiteCount()) {
            int c = r;
            while (c < this.theLD.getSiteCount()) {
                switch (ldMeasure) {
                    case 0: {
                        this.diseq[r][c] = this.theLD.getP(r, c);
                        this.lowerLabel = "P value";
                        break;
                    }
                    case 1: {
                        this.diseq[r][c] = this.theLD.getDPrime(r, c);
                        this.lowerLabel = "D'";
                        break;
                    }
                    case 2: {
                        this.diseq[r][c] = this.theLD.getRSqr(r, c);
                        this.lowerLabel = "R^2";
                    }
                }
                ++c;
            }
            ++r;
        }
        this.lowerProb = ldMeasure == 0;
    }

    public void setUpperCorner(int ldMeasure) {
        int c = 0;
        while (c < this.theLD.getSiteCount()) {
            int r = c;
            while (r < this.theLD.getSiteCount()) {
                switch (ldMeasure) {
                    case 0: {
                        this.diseq[r][c] = this.theLD.getP(r, c);
                        this.upperLabel = "P value";
                        break;
                    }
                    case 1: {
                        this.diseq[r][c] = this.theLD.getDPrime(r, c);
                        this.upperLabel = "D'";
                        break;
                    }
                    case 2: {
                        this.diseq[r][c] = this.theLD.getRSqr(r, c);
                        this.upperLabel = "R^2";
                    }
                }
                ++r;
            }
            ++c;
        }
        this.upperProb = ldMeasure == 0;
    }

    public void setScaleOfView(boolean chromosomalScale) {
        this.chromosomalScale = chromosomalScale;
        this.countGenesAndChromosomes();
        this.calculateStartAndEndPositions();
    }

    public void setShowSchematic(boolean includeBlockSchematic) {
        if (this.theAA == null) {
            return;
        }
        this.includeBlockSchematic = includeBlockSchematic;
        this.countGenesAndChromosomes();
        this.calculateStartAndEndPositions();
    }

    private void countGenesAndChromosomes() {
        this.totalChromosomes = 0;
        this.totalLoci = 0;
        int currc = -1999;
        String currLocus = "";
        int r = 0;
        while (r < this.totalVariableSites) {
            if (this.theAA.getChromosome(r) != currc) {
                ++this.totalChromosomes;
                currc = this.theAA.getChromosome(r);
            }
            if (!currLocus.equals(this.theAA.getLocusName(r))) {
                ++this.totalLoci;
                currLocus = this.theAA.getLocusName(r);
            }
            ++r;
        }
        this.totalBlocks = this.chromosomalScale ? this.totalChromosomes : this.totalLoci;
        this.blockStart = new float[this.totalBlocks];
        this.blockEnd = new float[this.totalBlocks];
        this.blockNames = new String[this.totalBlocks];
        int i = 0;
        while (i < this.totalChromosomes) {
            this.blockStart[i] = 999999.0f;
            this.blockEnd[i] = -999999.0f;
            ++i;
        }
        int c = -1;
        currLocus = "";
        currc = -1999;
        int r2 = 0;
        while (r2 < this.totalVariableSites) {
            if (this.chromosomalScale) {
                if (this.theAA.getChromosome(r2) != currc) {
                    currc = this.theAA.getChromosome(r2);
                    this.blockNames[++c] = "Chr." + currc;
                }
                if (this.blockStart[c] > this.theAA.getChromosomePosition(r2)) {
                    this.blockStart[c] = this.theAA.getChromosomePosition(r2);
                }
                if (this.blockEnd[c] < this.theAA.getChromosomePosition(r2)) {
                    this.blockEnd[c] = this.theAA.getChromosomePosition(r2);
                }
            } else {
                if (!currLocus.equals(this.theAA.getLocusName(r2))) {
                    this.blockNames[++c] = currLocus = this.theAA.getLocusName(r2);
                }
                if (this.blockStart[c] > (float)this.theAA.getLocusPosition(r2)) {
                    this.blockStart[c] = this.theAA.getLocusPosition(r2);
                }
                if (this.blockEnd[c] < (float)this.theAA.getLocusPosition(r2)) {
                    this.blockEnd[c] = this.theAA.getLocusPosition(r2);
                }
            }
            ++r2;
        }
        this.totalUnits = 0.5f;
        int i2 = 0;
        while (i2 < this.totalBlocks) {
            if (this.chromosomalScale && this.blockEnd[i2] - this.blockStart[i2] < this.minimumChromosomeLength) {
                this.blockEnd[i2] = this.blockStart[i2] + this.minimumChromosomeLength;
            } else if (this.blockEnd[i2] - this.blockStart[i2] < 1.0f) {
                this.blockEnd[i2] = this.blockStart[i2] + 1.0f;
            }
            this.totalUnits += this.blockEnd[i2] - this.blockStart[i2];
            ++i2;
        }
        System.out.println("Got here");
    }

    void calculateStartAndEndPositions() {
        float proportionPerPolymorphism;
        float proportionPerUnit = 0.0f;
        if (this.includeBlockSchematic) {
            this.totalIntervals = this.totalVariableSites + this.totalBlocks - 1;
            proportionPerPolymorphism = 1.0f / (float)this.totalIntervals;
            proportionPerUnit = proportionPerPolymorphism * (float)this.totalVariableSites / this.totalUnits;
            this.blockBeginPos = new float[this.totalBlocks];
            this.blockEndPos = new float[this.totalBlocks];
        } else {
            this.totalIntervals = this.totalVariableSites;
            proportionPerPolymorphism = 1.0f / (float)this.totalIntervals;
        }
        this.startPos = new float[this.totalVariableSites];
        this.endPos = new float[this.totalVariableSites];
        this.startPos[0] = 0.0f;
        this.endPos[0] = 0.0f;
        float currStartBase = 0.0f;
        float currEndBase = 0.0f;
        float geneToChromosomeSpace = 0.0f;
        int r = 0;
        while (r < this.totalVariableSites) {
            if (this.chromosomalScale && r > 0 && this.includeBlockSchematic && this.theAA.getChromosome(r) != this.theAA.getChromosome(r - 1)) {
                currStartBase += proportionPerPolymorphism;
            }
            if (!this.chromosomalScale && r > 0 && this.includeBlockSchematic && !this.theAA.getLocusName(r).equals(this.theAA.getLocusName(r - 1))) {
                currStartBase += proportionPerPolymorphism;
            }
            this.startPos[r] = currStartBase;
            currStartBase += proportionPerPolymorphism;
            ++r;
        }
        if (this.includeBlockSchematic) {
            currStartBase = 0.0f;
            int b = 0;
            while (b < this.totalBlocks) {
                this.blockBeginPos[b] = currStartBase;
                this.blockEndPos[b] = this.blockBeginPos[b] + (this.blockEnd[b] - this.blockStart[b]) * proportionPerUnit;
                currStartBase = this.blockEndPos[b] + proportionPerPolymorphism;
                ++b;
            }
            int currB = 0;
            this.endPos[0] = this.chromosomalScale ? this.blockBeginPos[0] + (this.theAA.getChromosomePosition(0) - this.blockStart[0]) * proportionPerUnit : this.blockBeginPos[0] + ((float)this.theAA.getLocusPosition(0) - this.blockStart[0]) * proportionPerUnit;
            int r2 = 1;
            while (r2 < this.totalVariableSites) {
                if (this.chromosomalScale) {
                    if (this.theAA.getChromosome(r2) != this.theAA.getChromosome(r2 - 1)) {
                        ++currB;
                    }
                    this.endPos[r2] = this.blockBeginPos[currB] + (this.theAA.getChromosomePosition(r2) - this.blockStart[currB]) * proportionPerUnit;
                } else {
                    if (!this.theAA.getLocusName(r2).equals(this.theAA.getLocusName(r2 - 1))) {
                        ++currB;
                    }
                    this.endPos[r2] = this.blockBeginPos[currB] + ((float)this.theAA.getLocusPosition(r2) - this.blockStart[currB]) * proportionPerUnit;
                }
                ++r2;
            }
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.red);
        this.setSize(400, 400);
    }

    private Color getMagnitudeColor(int r, int c) {
        if (r == c) {
            return Color.getHSBColor(0.999f, (float)this.diseq[r][c], 1.0f);
        }
        if (this.diseq[r][c] > 0.999) {
            return Color.getHSBColor(1.0f, 1.0f, 1.0f);
        }
        if (this.diseq[r][c] < -998.0) {
            return Color.lightGray;
        }
        return Color.getHSBColor((float)this.diseq[r][c], (float)this.diseq[r][c], 1.0f);
    }

    private Color getProbabilityColor(int r, int c) {
        double p1 = 0.01;
        double p2 = 0.001;
        double p3 = 1.0E-4;
        if (this.diseq[r][c] < -998.0) {
            return Color.lightGray;
        }
        if (this.diseq[r][c] > p1) {
            return Color.white;
        }
        if (this.diseq[r][c] > p2) {
            return Color.blue;
        }
        if (this.diseq[r][c] > p3) {
            return Color.green;
        }
        return Color.red;
    }

    private void addPolymorphismLabels(Graphics g, int ih) {
        boolean gr = false;
        g.setFont(new Font("Dialog", 0, 9));
        g.setColor(Color.black);
        int r = 0;
        while (r < this.totalVariableSites) {
            String s = this.chromosomalScale ? this.theAA.getChromosome(r) + "c" + Math.round(this.theAA.getChromosomePosition(r)) : this.theAA.getLocusName(r) + "s" + this.theAA.getLocusPosition(r);
            g.drawString(s, 4, this.yPos[r] + ih - 1);
            ++r;
        }
    }

    private void calculateCoordinates(Graphics gr) {
        Dimension d = this.getSize();
        float ySize = d.height - this.voff - this.distanceBetweenGraphAndGene;
        float ihf = ySize / (float)this.totalIntervals;
        float xSize = d.width - this.hoff - this.h2off;
        float iwf = xSize / (float)this.totalIntervals;
        this.ih = Math.round(ihf);
        this.iw = Math.round(iwf);
        int r = 0;
        while (r < this.totalVariableSites) {
            this.xPos[r] = (int)(this.startPos[r] * xSize + (float)this.hoff);
            this.yPos[r] = (int)(this.startPos[r] * ySize + (float)this.voff);
            ++r;
        }
        this.xPos[this.totalVariableSites] = d.width - this.h2off;
        this.yPos[this.totalVariableSites] = (int)ySize + this.voff;
        if (this.includeBlockSchematic) {
            int r2 = 0;
            while (r2 < this.totalVariableSites) {
                this.xEndPos[r2] = Math.round(this.endPos[r2] * xSize + (float)this.hoff);
                ++r2;
            }
            this.blockBeginX = new int[this.totalBlocks];
            this.blockEndX = new int[this.totalBlocks];
            int b = 0;
            while (b < this.totalBlocks) {
                this.blockBeginX[b] = Math.round(this.blockBeginPos[b] * xSize + (float)this.hoff);
                this.blockEndX[b] = Math.round(this.blockEndPos[b] * xSize + (float)this.hoff);
                ++b;
            }
        }
    }

    protected void paintComponent(Graphics g) {
        if (this.diseq == null) {
            return;
        }
        Dimension d = this.getSize();
        this.calculateCoordinates(g);
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width, d.height);
        System.out.println("UpperProb=" + this.upperProb + "  LowerProb=" + this.lowerProb);
        g.setColor(Color.darkGray);
        g.fillRect(this.xPos[0], this.yPos[0], this.xPos[this.totalVariableSites] - this.xPos[0], this.yPos[this.totalVariableSites] - this.yPos[0] + 2);
        int r = 0;
        while (r < this.totalVariableSites) {
            int c = 0;
            while (c < this.totalVariableSites) {
                if (c < r && this.upperProb || c > r && this.lowerProb) {
                    g.setColor(this.getProbabilityColor(r, c));
                } else if (r == c) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(this.getMagnitudeColor(r, c));
                }
                g.fillRect(this.xPos[r], this.yPos[c], this.iw + 1, this.ih + 1);
                ++c;
            }
            ++r;
        }
        g.setColor(Color.darkGray);
        int r2 = 0;
        while (r2 < this.totalVariableSites) {
            g.drawLine(this.xPos[r2], this.yPos[0], this.xPos[r2], this.yPos[this.totalVariableSites]);
            g.drawLine(this.xPos[0], this.yPos[r2], this.xPos[this.totalVariableSites], this.yPos[r2]);
            ++r2;
        }
        this.addPolymorphismLabels(g, this.ih);
        if (this.includeBlockSchematic) {
            this.addGenePicture(g, this.ih, this.iw);
        }
        this.addLegend(g);
    }

    public void paint(Graphics g) {
        this.paintComponent(g);
    }

    private void addLegend(Graphics g) {
        Dimension d = this.getSize();
        int localX = d.width - this.h2off + 10;
        int mid = d.height / 2;
        g.setColor(Color.black);
        g.drawString("Upper " + this.upperLabel, localX, 10);
        this.addLegendGraph(g, this.upperProb, localX, 20, mid - 10);
        g.setColor(Color.black);
        g.drawString("Lower " + this.lowerLabel, localX, mid + 10);
        this.addLegendGraph(g, this.lowerProb, localX, mid + 20, d.height - 10);
    }

    private void addLegendGraph(Graphics g, boolean prob, int xStart, int yStart, int yEnd) {
        int currY = yStart;
        int barWidth = 10;
        if (prob) {
            int yInc = (yEnd - yStart) / 4;
            g.setColor(Color.white);
            g.fillRect(xStart, currY, barWidth, yInc);
            g.setColor(Color.black);
            g.drawRect(xStart, currY, barWidth, yInc);
            g.drawString(">0.01", xStart + barWidth + 5, currY + 10);
            g.setColor(Color.blue);
            g.fillRect(xStart, currY += yInc, barWidth, yInc);
            g.setColor(Color.black);
            g.drawRect(xStart, currY, barWidth, yInc);
            g.drawString("<0.01", xStart + barWidth + 5, currY + 10);
            g.setColor(Color.green);
            g.fillRect(xStart, currY += yInc, barWidth, yInc);
            g.setColor(Color.black);
            g.drawRect(xStart, currY, barWidth, yInc);
            g.drawString("<0.001", xStart + barWidth + 5, currY + 10);
            g.setColor(Color.red);
            g.fillRect(xStart, currY += yInc, barWidth, yInc);
            g.setColor(Color.black);
            g.drawRect(xStart, currY, barWidth, yInc);
            g.drawString("<0.0001", xStart + barWidth + 5, currY + 10);
        } else {
            int yInc = (yEnd - yStart) / 11;
            DecimalFormat dF = new DecimalFormat("0.00");
            float d = 1.0001f;
            while (d >= 0.0f) {
                g.setColor(Color.getHSBColor(d, d, 1.0f));
                g.fillRect(xStart, currY, barWidth, yInc);
                g.setColor(Color.black);
                g.drawRect(xStart, currY, barWidth, yInc);
                g.drawString(dF.format(d), xStart + barWidth + 5, currY + 10);
                currY += yInc;
                d = (float)((double)d - 0.1);
            }
        }
    }

    private void addGenePicture(Graphics g, int ih, int iw) {
        int halfIW = iw / 2;
        Dimension d = this.getSize();
        int yOfLinkBlock = this.yPos[this.totalVariableSites];
        int yOfGene = yOfLinkBlock + this.distanceBetweenGraphAndGene / 2;
        int yOfGeneLabel = yOfLinkBlock + (int)(0.8f * (float)this.distanceBetweenGraphAndGene);
        int r = 0;
        while (r < this.totalVariableSites) {
            g.drawLine(this.xPos[r] + halfIW, yOfLinkBlock, this.xEndPos[r], yOfGene);
            ++r;
        }
        g.setColor(Color.blue);
        int b = 0;
        while (b < this.totalBlocks) {
            g.drawLine(this.blockBeginX[b], yOfGene, this.blockEndX[b], yOfGene);
            g.drawLine(this.blockBeginX[b], yOfGene + 1, this.blockEndX[b], yOfGene + 1);
            g.drawString(this.blockNames[b], this.blockBeginX[b], yOfGeneLabel);
            ++b;
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pf.getImageableX(), pf.getImageableY());
        double pageHeight = pf.getImageableHeight();
        double pageWidth = pf.getImageableWidth();
        double tableWidth = this.getWidth();
        double tableHeight = this.getHeight();
        double scaleW = pageWidth / tableWidth;
        double scaleH = pageHeight / tableHeight;
        double maxScale = scaleW > scaleH ? scaleH : scaleW;
        g2.scale(maxScale, maxScale);
        this.paint(g2);
        return 0;
    }
}

