/*
 * Decompiled with CFR 0.152.
 */
package pal.io;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Serializable;

public class FormattedInput
implements Serializable {
    private static FormattedInput singleton;

    public static FormattedInput getInstance() {
        if (singleton == null) {
            singleton = new FormattedInput();
        }
        return singleton;
    }

    public void nextLine(PushbackReader in) throws IOException {
        this.readLine(in, false);
    }

    public String readLine(PushbackReader in, boolean keepWhiteSpace) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int EOF = -1;
        int c = in.read();
        while (c != EOF && c != 10 && c != 13) {
            if (!FormattedInput.isWhite(c) || keepWhiteSpace) {
                buffer.append((char)c);
            }
            c = in.read();
        }
        if (c == 13 && (c = in.read()) != 10) {
            in.unread(c);
        }
        return buffer.toString();
    }

    public int skipWhiteSpace(PushbackReader in) throws IOException {
        int c;
        int EOF = -1;
        while ((c = in.read()) != EOF && FormattedInput.isWhite(c)) {
        }
        return c;
    }

    public int readNextChar(PushbackReader input) throws IOException {
        int EOF = -1;
        int c = this.skipWhiteSpace(input);
        if (c == EOF) {
            new IOException("End of file/stream");
        }
        return c;
    }

    public String readWord(PushbackReader in) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int EOF = -1;
        int c = this.skipWhiteSpace(in);
        while (c != EOF && !FormattedInput.isWhite(c)) {
            buffer.append((char)c);
            c = in.read();
        }
        if (c != EOF) {
            in.unread(c);
        }
        return buffer.toString();
    }

    public String readLabel(PushbackReader in, int maxLength) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int EOF = -1;
        boolean len = false;
        int c = this.skipWhiteSpace(in);
        while (!(c == EOF || buffer.length() == maxLength || FormattedInput.isWhite(c) && c != 10 && c != 13 || c == 58 || c == 44 || c == 59 || c == 40 || c == 41 || c == 91 || c == 93 || c == 123 || c == 125)) {
            if (c != 10 && c != 13) {
                buffer.append((char)c);
            }
            c = in.read();
        }
        if (c != EOF) {
            in.unread(c);
        }
        return buffer.toString();
    }

    public String readNumber(PushbackReader in, boolean ignoreNewlineCR) throws IOException {
        int c;
        StringBuffer buffer = new StringBuffer();
        int EOF = -1;
        while ((c = in.read()) != EOF && c != 45 && c != 46 && !Character.isDigit((char)c)) {
        }
        while (c != EOF && (c == 45 || c == 46 || c == 101 || c == 69 || Character.isDigit((char)c)) || FormattedInput.isNewlineCR(c) && ignoreNewlineCR) {
            if (!FormattedInput.isNewlineCR(c) || !ignoreNewlineCR) {
                buffer.append((char)c);
            }
            c = in.read();
        }
        if (c != EOF) {
            in.unread(c);
        }
        return buffer.toString();
    }

    public double readDouble(PushbackReader in) throws IOException, NumberFormatException {
        return this.readDouble(in, false);
    }

    public double readDouble(PushbackReader in, boolean ignoreNewlineCR) throws IOException, NumberFormatException {
        String w = this.readNumber(in, ignoreNewlineCR);
        if (w.length() == 0) {
            throw new IOException("End of file/stream");
        }
        return Double.valueOf(w);
    }

    public int readInt(PushbackReader in) throws IOException, NumberFormatException {
        return this.readInt(in, false);
    }

    public int readInt(PushbackReader in, boolean ignoreNewlineCR) throws IOException, NumberFormatException {
        String w = this.readNumber(in, ignoreNewlineCR);
        if (w.length() == 0) {
            throw new IOException("End of file/stream");
        }
        return Integer.valueOf(w);
    }

    private FormattedInput() {
    }

    private static boolean isWhite(int c) {
        return Character.isWhitespace((char)c);
    }

    private static boolean isNewlineCR(int c) {
        return c == 10 || c == 114;
    }
}

