/*
 * Decompiled with CFR 0.152.
 */
package pal.io;

import java.io.FileReader;
import java.io.IOException;
import java.io.PushbackReader;
import pal.io.NexusParseException;

public final class NexusTokenizer {
    public static final char L_PARENTHESIS = '(';
    public static final char R_PARENTHESIS = ')';
    public static final char L_BRACKET = '[';
    public static final char R_BRACKET = ']';
    public static final char L_BRACE = '{';
    public static final char R_BRACE = '}';
    public static final char F_SLASH = '/';
    public static final char B_SLASH = '\\';
    public static final char COMMA = ',';
    public static final char SEMI_COLON = ';';
    public static final char COLON = ':';
    public static final char EQUALS = '=';
    public static final char ASTERIX = '*';
    public static final char S_QUOTE = '\'';
    public static final char D_QUOTE = '\"';
    public static final char B_TICK = '`';
    public static final char ADDITION = '+';
    public static final char DASH = '-';
    public static final char L_THAN = '<';
    public static final char G_THAN = '>';
    public static final char HASH = '#';
    public static final char PERIOD = '.';
    public static final char L_FEED = '\n';
    public static final char C_RETURN = '\r';
    public static final char TAB = '\t';
    public static final char SPACE = ' ';
    private static final int EOF = -1;
    private PushbackReader pr;
    private int col;
    private int row;
    private String cToken;
    public static final int WORD_UPPERCASE = 0;
    public static final int WORD_LOWERCASE = 1;
    public static final int WORD_UNMODIFIED = 2;
    public static final int UNDEFINED_TOKEN = 10;
    public static final int WORD_TOKEN = 11;
    public static final int PUNCTUATION_TOKEN = 12;
    public static final int NEWLINE_TOKEN = 13;
    public static final int WHITESPACE_TOKEN = 14;
    public static final int HEADER_TOKEN = 15;
    private boolean readWS;
    private boolean ignoreComments;
    private boolean convertNL;
    private char nlChar;
    private int wordMod;
    private int lastReadTokenType;

    public NexusTokenizer(String file) throws IOException {
        this(new PushbackReader(new FileReader(file)));
    }

    public NexusTokenizer(PushbackReader pr) throws IOException {
        this.pr = pr;
        this.readWS = false;
        this.convertNL = false;
        this.nlChar = (char)10;
        this.wordMod = 2;
        this.lastReadTokenType = 10;
    }

    public synchronized boolean readWhiteSpace() {
        return this.readWS;
    }

    public synchronized boolean convertNewLine() {
        return this.convertNL;
    }

    public synchronized void setReadWhiteSpace(boolean b) {
        this.readWS = b;
    }

    public synchronized void setConvertNewLine(boolean b) {
        this.convertNL = b;
    }

    public synchronized void setIgnoreComments(boolean b) {
        this.ignoreComments = b;
    }

    public synchronized void setNewLineChar(char nl) {
        this.nlChar = nl;
    }

    public synchronized int getCol() {
        return this.col;
    }

    public synchronized int getRow() {
        return this.row;
    }

    public synchronized int getWordModification() {
        return this.wordMod;
    }

    public synchronized void setWordModification(int flag) {
        switch (flag) {
            case 1: {
                this.wordMod = 1;
                break;
            }
            case 0: {
                this.wordMod = 0;
                break;
            }
            case 2: {
                this.wordMod = 2;
                break;
            }
            default: {
                this.wordMod = 2;
            }
        }
    }

    public synchronized String readToken() throws IOException, NexusParseException {
        int r = this.pr.read();
        if (r == -1 || r == 65535) {
            return null;
        }
        char c = (char)r;
        if (this.isPunctuation(c)) {
            if (c == '#') {
                this.pr.unread(c);
                this.cToken = this.readHeaderToken();
                this.lastReadTokenType = 15;
                return this.cToken;
            }
            if (c == '[' & this.ignoreComments) {
                this.pr.unread(c);
                this.readComment();
                return this.readToken();
            }
            ++this.col;
            this.cToken = "" + c;
            this.lastReadTokenType = 12;
            return this.cToken;
        }
        if (this.isNewLine(c)) {
            this.pr.unread(c);
            this.cToken = this.readNewLineToken();
            this.lastReadTokenType = 13;
            return this.cToken;
        }
        if (this.isWhiteSpace(c)) {
            if (this.readWS) {
                this.pr.unread(c);
                this.cToken = this.readWhiteSpaceToken();
                this.lastReadTokenType = 14;
                return this.cToken;
            }
            this.pr.unread(c);
            this.readWhiteSpaceToken();
            return this.readToken();
        }
        if (this.isWordChar(c)) {
            this.pr.unread(c);
            this.cToken = this.readWordToken();
            this.lastReadTokenType = 11;
            return this.cToken;
        }
        throw new NexusParseException("Error: unknown character at col:" + this.col + ", row:" + this.row);
    }

    public synchronized int getLastTokenType() {
        return this.lastReadTokenType;
    }

    public synchronized String seek(int tokenType) throws IOException, NexusParseException {
        if (tokenType == 14 && !this.readWhiteSpace()) {
            throw new NexusParseException("Error: not returning whitespace tokens");
        }
        switch (tokenType) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                throw new NexusParseException("Error: unknown token type:" + tokenType);
            }
        }
        String nToken = this.readToken();
        while (nToken != null && this.getLastTokenType() != tokenType) {
            nToken = this.readToken();
        }
        return nToken;
    }

    public synchronized String seek(String token) throws IOException, NexusParseException {
        if (!this.readWhiteSpace()) {
            boolean wsStr = true;
            int i = 0;
            while (i < token.length()) {
                if (!this.isWhiteSpace(token.charAt(i))) {
                    wsStr = false;
                    break;
                }
                ++i;
            }
            if (wsStr) {
                throw new NexusParseException("Error: not returning whitespace tokens");
            }
        }
        String nToken = this.readToken();
        while (nToken != null && !nToken.equals(token)) {
            nToken = this.readToken();
        }
        return nToken;
    }

    public synchronized String getLastReadToken() {
        return this.cToken;
    }

    private synchronized String readHeaderToken() throws IOException, NexusParseException {
        StringBuffer sb = new StringBuffer();
        sb.append((char)this.pr.read());
        ++this.col;
        char c = (char)this.pr.read();
        if (c != 'N' && c != 'n') {
            throw new NexusParseException("Error: malformed NEXUS header at col:" + this.col + ", row:" + this.row);
        }
        sb.append(c);
        ++this.col;
        c = (char)this.pr.read();
        if (c != 'E' && c != 'e') {
            throw new NexusParseException("Error: malformed NEXUS header at col:" + this.col + ", row:" + this.row);
        }
        sb.append(c);
        ++this.col;
        c = (char)this.pr.read();
        if (c != 'X' && c != 'x') {
            throw new NexusParseException("Error: malformed NEXUS header at col:" + this.col + ", row:" + this.row);
        }
        sb.append(c);
        ++this.col;
        c = (char)this.pr.read();
        if (c != 'U' && c != 'u') {
            throw new NexusParseException("Error: malformed NEXUS header at col:" + this.col + ", row:" + this.row);
        }
        sb.append(c);
        ++this.col;
        c = (char)this.pr.read();
        if (c != 'S' && c != 's') {
            throw new NexusParseException("Error: malformed NEXUS header at col:" + this.col + ", row:" + this.row);
        }
        sb.append(c);
        ++this.col;
        return this.modWord(sb).toString();
    }

    private synchronized String readNewLineToken() throws IOException {
        char c = (char)this.pr.read();
        StringBuffer sb = new StringBuffer();
        ++this.row;
        this.col = 0;
        if (c == '\r') {
            sb.append('\r');
            char t = (char)this.pr.read();
            if (t == '\n') {
                sb.append('\n');
            } else {
                this.pr.unread(t);
            }
        } else {
            sb.append('\n');
        }
        if (this.convertNL) {
            return "" + this.nlChar;
        }
        return sb.toString();
    }

    private synchronized String readWhiteSpaceToken() throws IOException {
        StringBuffer sb = new StringBuffer();
        char c = (char)this.pr.read();
        ++this.col;
        while (this.isWhiteSpace(c)) {
            sb.append(c);
            c = (char)this.pr.read();
            ++this.col;
        }
        this.pr.unread(c);
        --this.col;
        return sb.toString();
    }

    private synchronized String readWordToken() throws IOException {
        StringBuffer sb = new StringBuffer();
        char c = (char)this.pr.read();
        ++this.col;
        while (this.isWordChar(c)) {
            sb.append(c);
            c = (char)this.pr.read();
            ++this.col;
        }
        this.pr.unread(c);
        --this.col;
        return this.modWord(sb).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized String readComment() throws IOException, NexusParseException {
        StringBuffer sb = new StringBuffer();
        int unbalanced = 0;
        char c = (char)this.pr.read();
        if (c != '[') {
            throw new NexusParseException("Error: first read character was not start of comment");
        }
        ++unbalanced;
        sb.append(c);
        while (unbalanced != 0) {
            c = (char)this.pr.read();
            switch (c) {
                case '[': {
                    ++unbalanced;
                    break;
                }
                case ']': {
                    --unbalanced;
                    break;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private synchronized StringBuffer modWord(StringBuffer sb) {
        String temp = sb.toString();
        switch (this.wordMod) {
            case 1: {
                temp = temp.toLowerCase();
                break;
            }
            case 0: {
                temp = temp.toUpperCase();
                break;
            }
        }
        return new StringBuffer(temp);
    }

    private synchronized String modWord(String s) {
        switch (this.wordMod) {
            case 1: {
                s = s.toLowerCase();
                break;
            }
            case 0: {
                s = s.toUpperCase();
                break;
            }
        }
        return s;
    }

    private synchronized boolean isPunctuation(char c) {
        switch (c) {
            case '\"': 
            case '#': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '[': 
            case '\\': 
            case ']': 
            case '`': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private synchronized boolean isWhiteSpace(char c) {
        switch (c) {
            case '\t': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private synchronized boolean isNewLine(char c) {
        switch (c) {
            case '\n': 
            case '\r': {
                return true;
            }
        }
        return false;
    }

    private synchronized boolean isWordChar(char c) {
        if (this.isPunctuation(c)) {
            return false;
        }
        if (this.isWhiteSpace(c)) {
            return false;
        }
        return !this.isNewLine(c);
    }
}

