/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MachineAccuracy;
import pal.math.MultivariateFunction;
import pal.math.UnivariateFunction;
import pal.math.UnivariateMinimum;

public class LineFunction
implements UnivariateFunction {
    private MultivariateFunction f;
    private int lowerBoundParam;
    private int upperBoundParam;
    private int dim;
    private double lowerBound;
    private double upperBound;
    private double[] s;
    private double[] d;
    private double[] x;
    private double[] min;
    private double[] max;
    private UnivariateMinimum um = null;

    public LineFunction(MultivariateFunction func) {
        this.f = func;
        this.dim = this.f.getNumArguments();
        this.x = new double[this.dim];
    }

    public void update(double[] start, double[] dir) {
        this.s = start;
        this.d = dir;
        this.computeBounds();
    }

    public void getPoint(double lambda, double[] p) {
        int i = 0;
        while (i < this.dim) {
            p[i] = this.s[i] + lambda * this.d[i];
            ++i;
        }
    }

    public double evaluate(double lambda) {
        this.getPoint(lambda, this.x);
        return this.f.evaluate(this.x);
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public double findMinimum() {
        if (this.um == null) {
            this.um = new UnivariateMinimum();
        }
        return this.um.findMinimum(this);
    }

    public int getUpperBoundParameter() {
        return this.upperBoundParam;
    }

    public int getLowerBoundParameter() {
        return this.lowerBoundParam;
    }

    public boolean checkPoint(double[] p) {
        boolean modified = false;
        int i = 0;
        while (i < this.dim) {
            if (p[i] < this.f.getLowerBound(i)) {
                p[i] = this.f.getLowerBound(i);
                modified = true;
            }
            if (p[i] > this.f.getUpperBound(i)) {
                p[i] = this.f.getUpperBound(i);
                modified = true;
            }
            ++i;
        }
        return modified;
    }

    public int checkVariables(double[] p, double[] grad, boolean[] active) {
        double EPS = MachineAccuracy.SQRT_EPSILON;
        int numActive = 0;
        int i = 0;
        while (i < this.dim) {
            active[i] = true;
            if (p[i] <= this.f.getLowerBound(i) + EPS) {
                if (grad[i] > 0.0) {
                    active[i] = false;
                }
            } else if (p[i] >= this.f.getUpperBound(i) - EPS) {
                if (grad[i] < 0.0) {
                    active[i] = false;
                }
            } else {
                ++numActive;
            }
            ++i;
        }
        return numActive;
    }

    public int checkDirection(double[] p, double[] dir) {
        double EPS = MachineAccuracy.SQRT_EPSILON;
        int numChanged = 0;
        int i = 0;
        while (i < this.dim) {
            if (p[i] <= this.f.getLowerBound(i) + EPS) {
                if (dir[i] < 0.0) {
                    dir[i] = 0.0;
                    ++numChanged;
                }
            } else if (p[i] >= this.f.getUpperBound(i) - EPS && dir[i] > 0.0) {
                dir[i] = 0.0;
                ++numChanged;
            }
            ++i;
        }
        return numChanged;
    }

    private void computeBounds() {
        boolean firstVisit = true;
        int i = 0;
        while (i < this.dim) {
            if (this.d[i] != 0.0) {
                double upper = (this.f.getUpperBound(i) - this.s[i]) / this.d[i];
                double lower = (this.f.getLowerBound(i) - this.s[i]) / this.d[i];
                if (lower > upper) {
                    double tmp = upper;
                    upper = lower;
                    lower = tmp;
                }
                if (firstVisit) {
                    this.lowerBound = lower;
                    this.lowerBoundParam = i;
                    this.upperBound = upper;
                    this.upperBoundParam = i;
                    firstVisit = false;
                } else {
                    if (lower > this.lowerBound) {
                        this.lowerBound = lower;
                        this.lowerBoundParam = i;
                    }
                    if (upper < this.upperBound) {
                        this.upperBound = upper;
                        this.upperBoundParam = i;
                    }
                }
            }
            ++i;
        }
    }
}

