/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.misc.Utils;

public final class Matrix {
    private final int width_;
    private final int height_;
    private final double[][] data_;

    public Matrix(int size, boolean identity) {
        this(size, size);
        if (identity) {
            int i = 0;
            while (i < size) {
                this.setValue(i, i, 1.0);
                ++i;
            }
        }
    }

    public Matrix(int width, int height) {
        this.data_ = new double[height][width];
        this.width_ = width;
        this.height_ = height;
    }

    public double[] toArray() {
        double[] result = new double[this.width_ * this.height_];
        int index = 0;
        int row = 0;
        while (row < this.height_) {
            int col = 0;
            while (col < this.width_) {
                result[index++] = this.data_[row][col];
                ++col;
            }
            ++row;
        }
        return result;
    }

    public Matrix(double[][] data) {
        this.data_ = Utils.getCopy(data);
        this.height_ = data.length;
        this.width_ = data[0].length;
    }

    private Matrix(Matrix toCopy) {
        this(toCopy.data_);
    }

    public final void setValue(int row, int col, double value) {
        this.data_[row][col] = value;
    }

    public final double getValue(int row, int col) {
        return this.data_[row][col];
    }

    public final boolean isSquare() {
        return this.width_ == this.height_;
    }

    public final int getWidth() {
        return this.width_;
    }

    public final int getHeight() {
        return this.height_;
    }

    public Matrix getAppendedHorizontally(Matrix other) {
        if (other.height_ != this.height_) {
            throw new IllegalArgumentException("Height not same!");
        }
        double[][] otherData = other.data_;
        double[][] newData = new double[this.height_][this.width_ + other.width_];
        int y = 0;
        while (y < this.height_) {
            int x = 0;
            while (x < this.width_) {
                newData[y][x] = this.data_[y][x];
                ++x;
            }
            int x2 = 0;
            while (x2 < other.width_) {
                newData[y][x2 + this.width_] = otherData[y][x2];
                ++x2;
            }
            ++y;
        }
        return new Matrix(newData);
    }

    public Matrix getAppendedVertically(Matrix other) {
        if (other.width_ != this.width_) {
            throw new IllegalArgumentException("Width not same!");
        }
        double[][] otherData = other.data_;
        double[][] newData = new double[this.height_ + other.height_][this.width_];
        int x = 0;
        while (x < this.width_) {
            int y = 0;
            while (y < this.height_) {
                newData[y][x] = this.data_[y][x];
                ++y;
            }
            int y2 = 0;
            while (y2 < other.height_) {
                newData[y2 + this.height_][x] = otherData[y2][x];
                ++y2;
            }
            ++x;
        }
        return new Matrix(newData);
    }

    public Matrix getSubsetColumns(int startColumn, int numberToKeep) {
        double[][] newData = new double[this.height_][numberToKeep];
        int row = 0;
        while (row < this.height_) {
            int i = 0;
            while (i < numberToKeep) {
                newData[row][i] = this.data_[row][i + startColumn];
                ++i;
            }
            ++row;
        }
        return new Matrix(newData);
    }

    public final void transpose() {
        if (!this.isSquare()) {
            throw new RuntimeException("Cannot transpose no square matrix!");
        }
        int row = 0;
        while (row < this.height_) {
            int col = row + 1;
            while (col < this.width_) {
                double temp = this.data_[row][col];
                this.data_[row][col] = this.data_[col][row];
                this.data_[col][row] = temp;
                ++col;
            }
            ++row;
        }
    }

    public final Matrix getTranspose() {
        double[][] newData = new double[this.width_][this.height_];
        int row = 0;
        while (row < this.height_) {
            int col = 0;
            while (col < this.width_) {
                newData[col][row] = this.data_[row][col];
                ++col;
            }
            ++row;
        }
        return new Matrix(newData);
    }

    public final void multiply(double scale) {
        int row = 0;
        while (row < this.height_) {
            int col = 0;
            while (col < this.width_) {
                double[] dArray = this.data_[row];
                int n = col++;
                dArray[n] = dArray[n] * scale;
            }
            ++row;
        }
    }

    public final Matrix getMultiplied(Matrix other) {
        if (this.width_ != other.height_) {
            throw new IllegalArgumentException("Other matrix wrong size!");
        }
        double[][] otherData = other.data_;
        double[][] newData = new double[this.height_][other.width_];
        int row = 0;
        while (row < this.height_) {
            int otherCol = 0;
            while (otherCol < other.width_) {
                double total = 0.0;
                int col = 0;
                while (col < this.width_) {
                    total += this.data_[row][col] * otherData[col][otherCol];
                    ++col;
                }
                newData[row][otherCol] = total;
                ++otherCol;
            }
            ++row;
        }
        return new Matrix(newData);
    }

    public final Matrix getMultiplied(double scale) {
        Matrix m = this.getMatrixCopy();
        m.multiply(scale);
        return m;
    }

    public Matrix getInverse() {
        if (!this.isSquare()) {
            throw new RuntimeException("Can invert non square matrix");
        }
        Matrix combined = this.getAppendedHorizontally(new Matrix(this.height_, true));
        combined.rowReduce();
        return combined.getSubsetColumns(this.width_, this.width_);
    }

    private void scaleRow(int row, double scale) {
        double[] rowData = this.data_[row];
        int i = 0;
        while (i < this.width_) {
            int n = i++;
            rowData[n] = rowData[n] * scale;
        }
    }

    private void divideRow(int row, double factor) {
        double[] rowData = this.data_[row];
        int i = 0;
        while (i < this.width_) {
            int n = i++;
            rowData[n] = rowData[n] / factor;
        }
    }

    private void addRow(int fromRow, int toRow) {
        double[] fromRowData = this.data_[fromRow];
        double[] toRowData = this.data_[toRow];
        int i = 0;
        while (i < this.width_) {
            int n = i;
            toRowData[n] = toRowData[n] + fromRowData[i];
            ++i;
        }
    }

    private void subtractRow(int fromRow, int toRow) {
        double[] fromRowData = this.data_[fromRow];
        double[] toRowData = this.data_[toRow];
        int i = 0;
        while (i < this.width_) {
            int n = i;
            toRowData[n] = toRowData[n] - fromRowData[i];
            ++i;
        }
    }

    private void subtractRow(int fromRow, double scale, int toRow) {
        double[] fromRowData = this.data_[fromRow];
        double[] toRowData = this.data_[toRow];
        int i = 0;
        while (i < this.width_) {
            int n = i;
            toRowData[n] = toRowData[n] - scale * fromRowData[i];
            ++i;
        }
    }

    private static final boolean equalsZero(double value) {
        return value < 1.0E-7 && value > -1.0E-7;
    }

    private void swapRow(int rowOne, int rowTwo) {
        double[] temp = this.data_[rowOne];
        this.data_[rowOne] = this.data_[rowTwo];
        this.data_[rowTwo] = temp;
    }

    private boolean swapZeroRow(int startRow, int targetColumn) {
        int check = startRow + 1;
        while (check < this.height_) {
            if (!Matrix.equalsZero(this.getValue(check, targetColumn))) {
                this.swapRow(startRow, check);
                return true;
            }
            ++check;
        }
        return false;
    }

    public void rowReduce() {
        int extent = Math.min(this.width_, this.height_);
        int reduce = 0;
        while (reduce < extent) {
            boolean doColumn = true;
            double primaryFactor = this.getValue(reduce, reduce);
            if (Matrix.equalsZero(primaryFactor)) {
                if (this.swapZeroRow(reduce, reduce)) {
                    doColumn = false;
                } else {
                    primaryFactor = this.getValue(reduce, reduce);
                }
            }
            if (doColumn) {
                this.divideRow(reduce, primaryFactor);
                int row = 0;
                while (row < reduce) {
                    double subScale = this.getValue(row, reduce);
                    if (!Matrix.equalsZero(subScale)) {
                        this.subtractRow(reduce, subScale, row);
                    }
                    ++row;
                }
                int row2 = reduce + 1;
                while (row2 < this.height_) {
                    double subFactor = this.getValue(row2, reduce);
                    if (Matrix.equalsZero(subFactor)) {
                        if (!this.swapZeroRow(row2, reduce)) break;
                        subFactor = this.getValue(row2, reduce);
                    }
                    this.divideRow(row2, subFactor);
                    this.subtractRow(reduce, row2);
                    ++row2;
                }
            }
            ++reduce;
        }
    }

    public Matrix getRowReduced() {
        Matrix m = this.getMatrixCopy();
        m.rowReduce();
        return m;
    }

    public Matrix getMatrixCopy() {
        return new Matrix(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.width_);
        sb.append(", ");
        sb.append(this.height_);
        sb.append(")\n");
        int row = 0;
        while (row < this.height_) {
            sb.append('[');
            int col = 0;
            while (col < this.width_) {
                sb.append(this.getValue(row, col));
                sb.append("  ");
                ++col;
            }
            sb.append("]\n");
            ++row;
        }
        return sb.toString();
    }
}

