/*
 * Decompiled with CFR 0.152.
 */
package pal.misc;

public class Attribute {
    public static final String STRING = "string";
    public static final String INTEGER = "integer";
    public static final String BOOLEAN = "boolean";
    public static final String DOUBLE = "double";
    public static final String FLOAT = "float";
    private String name = null;
    private Object value = null;

    public Attribute(String name, String val, String type) {
        this.name = name;
        if (type == null) {
            try {
                this.value = new Integer(val);
            }
            catch (NumberFormatException nfe1) {
                try {
                    this.value = new Double(val);
                }
                catch (NumberFormatException nfe2) {
                    this.value = val;
                }
            }
        } else if (type.equals(BOOLEAN)) {
            this.value = new Boolean(val);
        } else if (type.equals(INTEGER)) {
            this.value = new Integer(val);
        } else if (type.equals(DOUBLE)) {
            this.value = new Double(val);
        } else if (type.equals(FLOAT)) {
            this.value = new Float(val);
        }
        this.value = val;
    }

    public Attribute(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }
}

