/*
 * Decompiled with CFR 0.152.
 */
package pal.misc;

import pal.misc.SampleInformation;
import pal.misc.TimeOrderCharacterData;

public class TOCDSampleInformation
implements SampleInformation {
    private final TimeOrderCharacterData base_;
    private final boolean hasTimes_;

    public TOCDSampleInformation(TimeOrderCharacterData base) {
        this.base_ = base;
        this.hasTimes_ = base.hasTimes();
    }

    public int getNumberOfSamples() {
        return this.base_.getOrdinalCount();
    }

    public int getSampleOrdinal(String leafID) {
        return this.base_.getTimeOrdinal(leafID);
    }

    public double getHeight(int sample) {
        if (this.hasTimes_) {
            return this.base_.getOrdinalTime(sample);
        }
        return sample;
    }

    public int getHeightUnits() {
        if (this.hasTimes_) {
            return this.base_.getUnits();
        }
        return 5;
    }

    public double getMaxHeight() {
        if (this.hasTimes_) {
            return this.base_.getMaximumTime();
        }
        return this.base_.getOrdinalCount() - 1;
    }
}

