/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import pal.alignment.Alignment;
import pal.alignment.AlignmentGenerator;
import pal.statistics.LikelihoodEvaluator;
import pal.statistics.ReplicateLikelihoodEvaluator;
import pal.statistics.TopologyTestEngine;
import pal.tree.Tree;
import pal.util.AlgorithmCallback;

public class GeneralTopologyPool
implements TopologyTestEngine.TopologyPool {
    private final Tree[] baseTopologies_;
    private final double[] logLikelihoods_;
    private final LikelihoodEvaluator baseCalculator_;
    private final ReplicateLikelihoodEvaluator replicateCalculator_;
    private final Alignment baseAlignment_;
    private final AlignmentGenerator replicateGenerator_;
    private boolean logLikelihoodsCalculated_;

    public GeneralTopologyPool(Tree[] topologies, LikelihoodEvaluator baseCalculator, ReplicateLikelihoodEvaluator replicateCalculator, Alignment baseAlignment, AlignmentGenerator replicateGenerator) {
        this.baseCalculator_ = baseCalculator;
        this.replicateCalculator_ = replicateCalculator;
        this.baseAlignment_ = baseAlignment;
        this.replicateGenerator_ = replicateGenerator;
        this.baseTopologies_ = new Tree[topologies.length];
        System.arraycopy(topologies, 0, this.baseTopologies_, 0, topologies.length);
        this.logLikelihoods_ = new double[topologies.length];
        this.logLikelihoodsCalculated_ = false;
    }

    public void optimiseOriginalTopologies(AlgorithmCallback callback) {
        int i = 0;
        while (i < this.baseTopologies_.length) {
            callback.updateProgress((double)i / (double)this.baseTopologies_.length);
            AlgorithmCallback subCallback = AlgorithmCallback.Utils.getSubCallback(callback, "Optimisation:" + i, (double)i / (double)this.baseTopologies_.length, (double)(i + 1) / (double)this.baseTopologies_.length);
            LikelihoodEvaluator.MLResult result = this.baseCalculator_.getMLOptimised(this.baseTopologies_[i], this.baseAlignment_, subCallback);
            this.baseTopologies_[i] = result.getOptimisedTree();
            this.logLikelihoods_[i] = result.getLogLikelihood();
            ++i;
        }
        this.logLikelihoodsCalculated_ = true;
    }

    private void calculateOriginalLogLikelihoods() {
        System.out.println("Calculate original");
        int i = 0;
        while (i < this.baseTopologies_.length) {
            this.logLikelihoods_[i] = this.baseCalculator_.calculateLikelihood(this.baseTopologies_[i], this.baseAlignment_);
            ++i;
        }
        System.out.println("Finished Calculate original");
        this.logLikelihoodsCalculated_ = true;
    }

    private void checkLogLikelihoods() {
        if (!this.logLikelihoodsCalculated_) {
            this.calculateOriginalLogLikelihoods();
        }
    }

    public int getNumberOfTopologies() {
        return this.baseTopologies_.length;
    }

    public Tree[] getOriginalOptimisedTrees() {
        return this.baseTopologies_;
    }

    public double[] getOriginalOptimisedLogLikelihoods() {
        this.checkLogLikelihoods();
        return this.logLikelihoods_;
    }

    public double[] getNewReplicateLogLikelihoods(AlgorithmCallback callback) {
        AlgorithmCallback replicateCallback = AlgorithmCallback.Utils.getSubCallback(callback, "Replicate Generator", 0.0, 0.1);
        AlgorithmCallback remainderCallback = AlgorithmCallback.Utils.getSubCallback(callback, "Log Likelihood Calculation", 0.1, 1.0);
        Alignment replicateAlignment = this.replicateGenerator_.getNextAlignment(replicateCallback);
        double[] replicateLogLikelihoods = new double[this.baseTopologies_.length];
        int topology = 0;
        while (topology < this.baseTopologies_.length) {
            remainderCallback.updateProgress((double)topology / (double)this.baseTopologies_.length);
            replicateLogLikelihoods[topology] = this.replicateCalculator_.getReplicateLogLikelihood(this.baseTopologies_[topology], replicateAlignment);
            ++topology;
        }
        return replicateLogLikelihoods;
    }
}

