/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import java.io.PrintWriter;
import pal.io.FormattedOutput;
import pal.math.MersenneTwisterFast;
import pal.misc.Report;
import pal.util.HeapSort;

public class ModelSupport
implements Report {
    public int[] likelihoodOrder;
    public int[] supportOrder;
    public double[] deltaL;
    public double[] posterior;
    public double[] support;
    public int numBootstraps;

    public void compare(double[][] sLogL, int numBoot) {
        this.srtest(sLogL, null, numBoot);
    }

    public void compare(double[][] pLogL, int[] alias, int numBoot) {
        this.srtest(pLogL, alias, numBoot);
    }

    public void report(PrintWriter out) {
        FormattedOutput fo = FormattedOutput.getInstance();
        out.println("CREDIBLE SET " + this.numBootstraps + " bootstraps):");
        out.println();
        out.println("tree\tdeltaL\tpost\tsupp");
        out.println("--------------------------------");
        int i = 0;
        while (i < this.deltaL.length) {
            out.print(i + 1 + "\t");
            fo.displayDecimal(out, this.deltaL[i], 2);
            out.print("\t");
            fo.displayDecimal(out, this.posterior[i], 4);
            out.print("\t");
            fo.displayDecimal(out, this.support[i], 4);
            out.println();
            ++i;
        }
        out.println();
        out.println("prob = Akaike weight (non-informative posterior probability)");
        out.println("supp = expected Akaike weight");
        out.println();
        out.println();
        out.println("supp\toptimal 95% credible sets (expected Akaike weights)");
        out.println("------------------------------------------------------------");
        this.printSets(out, this.supportOrder, 0.95);
        out.println();
    }

    private void printSets(PrintWriter out, int[] order, double level) {
        FormattedOutput fo = FormattedOutput.getInstance();
        double conf = 0.0;
        int pos = 0;
        while (conf < level) {
            double conf2 = pos + 1 < order.length ? conf + this.support[order[pos + 1]] : (conf += this.support[order[pos]]);
            if (conf2 >= level) {
                fo.displayDecimal(out, conf, 4);
                out.print("\t{" + (order[0] + 1));
                int i = 0;
                while (i < pos) {
                    out.print(", " + (order[i + 1] + 1));
                    ++i;
                }
                out.println("}");
            }
            ++pos;
        }
    }

    private void srtest(double[][] pLogL, int[] alias, int numBoot) {
        int numH = pLogL.length;
        this.deltaL = new double[numH];
        this.support = new double[numH];
        this.posterior = new double[numH];
        this.likelihoodOrder = new int[numH];
        this.supportOrder = new int[numH];
        this.numBootstraps = numBoot;
        int numSites = alias == null ? pLogL[0].length : alias.length;
        int j = 0;
        while (j < numSites) {
            int p = alias == null ? j : alias[j];
            int k = 0;
            while (k < numH) {
                int n = k;
                this.deltaL[n] = this.deltaL[n] - pLogL[k][p];
                ++k;
            }
            ++j;
        }
        HeapSort.sort(this.deltaL, this.likelihoodOrder);
        double maxL = -this.deltaL[this.likelihoodOrder[0]];
        int j2 = 0;
        while (j2 < numH) {
            this.deltaL[j2] = -(this.deltaL[j2] + maxL);
            ++j2;
        }
        double sum1 = 0.0;
        int j3 = 0;
        while (j3 < numH) {
            this.posterior[j3] = Math.exp(this.deltaL[j3]);
            sum1 += this.posterior[j3];
            ++j3;
        }
        int j4 = 0;
        while (j4 < numH) {
            this.posterior[j4] = this.posterior[j4] / sum1;
            ++j4;
        }
        int j5 = 0;
        while (j5 < numH) {
            this.deltaL[j5] = -this.deltaL[j5];
            ++j5;
        }
        this.deltaL[this.likelihoodOrder[0]] = 0.0;
        double[] rs = new double[numH];
        MersenneTwisterFast mt = new MersenneTwisterFast();
        int i = 0;
        while (i < numBoot) {
            int k;
            int k2 = 0;
            while (k2 < numH) {
                rs[k2] = 0.0;
                ++k2;
            }
            int j6 = 0;
            while (j6 < numSites) {
                int s = mt.nextInt(numSites);
                int p = alias == null ? s : alias[s];
                k = 0;
                while (k < numH) {
                    int n = k;
                    rs[n] = rs[n] + pLogL[k][p];
                    ++k;
                }
                ++j6;
            }
            double maxLogL = this.findMax(rs);
            k = 0;
            while (k < numH) {
                rs[k] = rs[k] - maxLogL;
                ++k;
            }
            double sum = 0.0;
            int k3 = 0;
            while (k3 < numH) {
                rs[k3] = Math.exp(rs[k3]);
                sum += rs[k3];
                ++k3;
            }
            int k4 = 0;
            while (k4 < numH) {
                int n = k4;
                this.support[n] = this.support[n] + rs[k4] / sum;
                ++k4;
            }
            ++i;
        }
        int j7 = 0;
        while (j7 < numH) {
            this.support[j7] = this.support[j7] / (double)numBoot;
            ++j7;
        }
        HeapSort.sort(this.support, this.supportOrder);
        int len = this.supportOrder.length;
        int i2 = 0;
        while (i2 < len / 2) {
            int tmp = this.supportOrder[i2];
            this.supportOrder[i2] = this.supportOrder[len - i2 - 1];
            this.supportOrder[len - i2 - 1] = tmp;
            ++i2;
        }
        rs = null;
    }

    private double findMax(double[] array) {
        int len = array.length;
        int best = 0;
        double max = array[0];
        int i = 1;
        while (i < len) {
            if (array[i] > max) {
                best = i;
                max = array[i];
            }
            ++i;
        }
        return max;
    }
}

