/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import pal.misc.Utils;
import pal.statistics.TopologyTestEngine;

public class ShimodairaHasegawaStatistics
implements TopologyTestEngine.StatisticsHandler {
    public double[] getOriginalTestStatistics(double[] originalOptimisedLogLikelihoods, int numberOfTopologies) {
        double maxLikelihood = Utils.getMax(originalOptimisedLogLikelihoods, 0, numberOfTopologies);
        double[] testStatistics = new double[numberOfTopologies];
        int i = 0;
        while (i < numberOfTopologies) {
            testStatistics[i] = maxLikelihood - originalOptimisedLogLikelihoods[i];
            ++i;
        }
        return testStatistics;
    }

    private static final double[][] createCentered(double[][] replicateLogLiklihoods, int numberOfReplicates, int numberOfTopologies) {
        double[][] result = new double[numberOfReplicates][numberOfTopologies];
        int topology = 0;
        while (topology < numberOfTopologies) {
            double total = 0.0;
            int replicate = 0;
            while (replicate < numberOfReplicates) {
                total += replicateLogLiklihoods[replicate][topology];
                ++replicate;
            }
            double average = total / (double)numberOfReplicates;
            int replicate2 = 0;
            while (replicate2 < numberOfReplicates) {
                result[replicate2][topology] = replicateLogLiklihoods[replicate2][topology] - average;
                ++replicate2;
            }
            ++topology;
        }
        return result;
    }

    private static final double[][] createReplicateStatistics(double[][] centeredValues, int numberOfReplicates, int numberOfTopologies) {
        double[][] result = new double[numberOfReplicates][numberOfTopologies];
        int replicate = 0;
        while (replicate < numberOfReplicates) {
            double max = Utils.getMax(centeredValues[replicate]);
            int topology = 0;
            while (topology < numberOfTopologies) {
                result[replicate][topology] = max - centeredValues[replicate][topology];
                ++topology;
            }
            ++replicate;
        }
        return result;
    }

    public double[] getPValues(double[] originalOptimisedLogLikelihoods, double[][] replicateLogLikelihoods, int numberOfReplicates, int numberOfTopologies) {
        double[][] replicateStatistics = ShimodairaHasegawaStatistics.createReplicateStatistics(ShimodairaHasegawaStatistics.createCentered(replicateLogLikelihoods, numberOfReplicates, numberOfTopologies), numberOfReplicates, numberOfTopologies);
        double[] testStatistics = this.getOriginalTestStatistics(originalOptimisedLogLikelihoods, numberOfTopologies);
        double[] pValues = new double[numberOfTopologies];
        int topology = 0;
        while (topology < numberOfTopologies) {
            double statistic = testStatistics[topology];
            int count = 0;
            int replicate = 0;
            while (replicate < numberOfReplicates) {
                if (replicateStatistics[replicate][topology] >= statistic) {
                    ++count;
                }
                ++replicate;
            }
            pValues[topology] = (double)count / (double)numberOfReplicates;
            ++topology;
        }
        return pValues;
    }
}

