/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import pal.util.AlgorithmCallback;

public class TopologyTestEngine {
    private final StatisticsHandler statistics_;

    public TopologyTestEngine(StatisticsHandler statistics) {
        this.statistics_ = statistics;
    }

    public TestResult performTest(TopologyPool topologyPool, int numberOfReplicates, AlgorithmCallback callback) {
        double[][] replicateLogLiklihoods = new double[numberOfReplicates][];
        double[] originalLogLiklihoods = topologyPool.getOriginalOptimisedLogLikelihoods();
        int i = 0;
        while (i < numberOfReplicates) {
            AlgorithmCallback subCallback = AlgorithmCallback.Utils.getSubCallback(callback, "Replicate:" + i, (double)i / (double)numberOfReplicates, (double)(i + 1) / (double)numberOfReplicates);
            replicateLogLiklihoods[i] = topologyPool.getNewReplicateLogLikelihoods(subCallback);
            ++i;
        }
        return new TestResultImpl(this.statistics_.getOriginalTestStatistics(originalLogLiklihoods, originalLogLiklihoods.length), this.statistics_.getPValues(originalLogLiklihoods, replicateLogLiklihoods, numberOfReplicates, originalLogLiklihoods.length));
    }

    public static interface StatisticsHandler {
        public double[] getOriginalTestStatistics(double[] var1, int var2);

        public double[] getPValues(double[] var1, double[][] var2, int var3, int var4);
    }

    public static interface TopologyPool {
        public int getNumberOfTopologies();

        public double[] getOriginalOptimisedLogLikelihoods();

        public double[] getNewReplicateLogLikelihoods(AlgorithmCallback var1);
    }

    public static interface TestResult {
        public int[] getSignificantTopologyIndex(double var1);

        public int[] getUnsignificantTopologyIndex(double var1);

        public double getPValue(int var1);
    }

    private static final class TestResultImpl
    implements TestResult {
        private final double[] baseTestStatistics_;
        private final double[] pValues_;

        public TestResultImpl(double[] baseTestStatistics, double[] pValues) {
            this.baseTestStatistics_ = baseTestStatistics;
            this.pValues_ = pValues;
        }

        public int[] getSignificantTopologyIndex(double significanceLevel) {
            int count = 0;
            int i = 0;
            while (i < this.pValues_.length) {
                if (this.pValues_[i] >= significanceLevel) {
                    ++count;
                }
                ++i;
            }
            int[] result = new int[count];
            int index = 0;
            int i2 = 0;
            while (i2 < this.pValues_.length) {
                if (this.pValues_[i2] >= significanceLevel) {
                    result[index] = i2;
                }
                ++i2;
            }
            return result;
        }

        public int[] getUnsignificantTopologyIndex(double significanceLevel) {
            int count = 0;
            int i = 0;
            while (i < this.pValues_.length) {
                if (this.pValues_[i] < significanceLevel) {
                    ++count;
                }
                ++i;
            }
            int[] result = new int[count];
            int index = 0;
            int i2 = 0;
            while (i2 < this.pValues_.length) {
                if (this.pValues_[i2] < significanceLevel) {
                    result[index] = i2;
                }
                ++i2;
            }
            return result;
        }

        public double getPValue(int topology) {
            return this.pValues_[topology];
        }
    }
}

