/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import pal.datatype.DataType;
import pal.substmodel.NeoRateMatrix;

public class GeneralPoissonRateMatrix
implements NeoRateMatrix {
    private final int dimension_;

    public GeneralPoissonRateMatrix(int dimension) {
        this.dimension_ = dimension;
    }

    public String getUniqueName() {
        return "General Poisson (dimension " + this.dimension_ + ")";
    }

    public boolean isReversible() {
        return true;
    }

    public int getDimension() {
        return this.dimension_;
    }

    public boolean isDataTypeCompatible(DataType dt) {
        return dt.getNumStates() == this.dimension_;
    }

    public void createRelativeRates(double[][] rateStore, double[] rateParameters, int startIndex) {
        int i = 0;
        while (i < this.dimension_) {
            int j = 0;
            while (j < this.dimension_) {
                rateStore[j][i] = 1.0;
                ++j;
            }
            ++i;
        }
    }

    public int getNumberOfRateParameters() {
        return 0;
    }

    public double getRateParameterLowerBound(int parameter) {
        throw new RuntimeException("Assertion error : not expected");
    }

    public double getRateParameterUpperBound(int parameter) {
        throw new RuntimeException("Assertion error : not expected");
    }

    public void getDefaultRateParameters(double[] store, int startIndex) {
    }
}

