/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.math.MathUtils;
import pal.misc.NeoParameterized;
import pal.misc.Utils;
import pal.substmodel.MatrixExponential;
import pal.substmodel.NeoRateMatrix;

public class MultiRateMatrixHandler
implements NeoParameterized,
Serializable {
    private static final double SUBSTITUTION_CLASS_LOWER_LIMIT = 1.0;
    private static final double SUBSTITUTION_CLASS_UPPER_LIMIT = 1.0E8;
    private static final double SUBSTITUTION_CLASS_DEFAULT_VALUE = 100.0;
    private final NeoRateMatrix[] rateMatrices_;
    private final double[] rateParameters_;
    private final double[] substitutionClassProbabilities_;
    private final double[] rateParametersSE_;
    private final double[] defaultRateParameters_;
    private boolean updateMatrix_ = true;
    private final double[] equilibriumFrequencies_;
    private final int dimension_;
    private final double[][] relativeRateStore_;
    private final double[][][] qMatrixStores_;
    private final MatrixExponential[] matrixExps_;
    private final boolean reversible_;
    private final int[] baseLookup_;
    private final int[] rateParameterIndexLookup_;

    private MultiRateMatrixHandler(MultiRateMatrixHandler toCopy) {
        this(toCopy.rateMatrices_, toCopy.equilibriumFrequencies_, toCopy.substitutionClassProbabilities_);
        System.arraycopy(toCopy.rateParameters_, 0, this.rateParameters_, 0, this.dimension_);
        System.arraycopy(toCopy.rateParametersSE_, 0, this.rateParametersSE_, 0, this.dimension_);
    }

    public MultiRateMatrixHandler(NeoRateMatrix[] rateMatrices, double[] equilibriumFrequencies, double[] initialClassProportions) {
        this.rateMatrices_ = rateMatrices;
        this.dimension_ = rateMatrices[0].getDimension();
        int i = 1;
        while (i < rateMatrices.length) {
            if (rateMatrices[i].getDimension() != this.dimension_) {
                throw new IllegalArgumentException("Incompatible dimensions:" + this.dimension_ + " to " + rateMatrices[i].getDimension());
            }
            ++i;
        }
        int totalNumberOfParameters = 0;
        int i2 = 0;
        while (i2 < rateMatrices.length) {
            totalNumberOfParameters += rateMatrices[i2].getNumberOfRateParameters();
            ++i2;
        }
        this.rateParameters_ = new double[totalNumberOfParameters];
        this.rateParametersSE_ = new double[totalNumberOfParameters];
        this.defaultRateParameters_ = new double[totalNumberOfParameters];
        int index = 0;
        int i3 = 0;
        while (i3 < rateMatrices.length) {
            rateMatrices[i3].getDefaultRateParameters(this.defaultRateParameters_, index);
            index += rateMatrices[i3].getNumberOfRateParameters();
            ++i3;
        }
        System.arraycopy(this.defaultRateParameters_, 0, this.rateParameters_, 0, this.rateParameters_.length);
        this.equilibriumFrequencies_ = MathUtils.getNormalized(equilibriumFrequencies);
        this.relativeRateStore_ = new double[this.dimension_][this.dimension_];
        this.qMatrixStores_ = new double[this.rateMatrices_.length][this.dimension_][this.dimension_];
        this.matrixExps_ = new MatrixExponential[rateMatrices.length];
        int i4 = 0;
        while (i4 < this.matrixExps_.length) {
            this.matrixExps_[i4] = new MatrixExponential(this.dimension_);
            ++i4;
        }
        boolean reversible = true;
        int i5 = 0;
        while (i5 < rateMatrices.length) {
            reversible &= this.rateMatrices_[i5].isReversible();
            ++i5;
        }
        this.baseLookup_ = new int[totalNumberOfParameters];
        this.rateParameterIndexLookup_ = new int[totalNumberOfParameters];
        MultiRateMatrixHandler.setupLookups(rateMatrices, this.baseLookup_, this.rateParameterIndexLookup_, totalNumberOfParameters);
        this.reversible_ = reversible;
        this.substitutionClassProbabilities_ = new double[rateMatrices.length];
        this.setSubstitutionClassProbabilities(initialClassProportions);
        this.parametersChanged();
    }

    private final void normaliseSubstitutionClassProbabilities() {
        double total = 0.0;
        int i = 0;
        while (i < this.substitutionClassProbabilities_.length) {
            total += this.substitutionClassProbabilities_[i];
            ++i;
        }
        if (total > 0.0) {
            int i2 = 0;
            while (i2 < this.substitutionClassProbabilities_.length) {
                int n = i2++;
                this.substitutionClassProbabilities_[n] = this.substitutionClassProbabilities_[n] / total;
            }
        } else {
            int i3 = 0;
            while (i3 < this.substitutionClassProbabilities_.length) {
                this.substitutionClassProbabilities_[i3] = 1.0 / (double)this.substitutionClassProbabilities_.length;
                ++i3;
            }
        }
    }

    public void setSubstitutionClassProbabilities(double[] classProportions) {
        this.setSubstitutionClassProbabilities(classProportions, 0);
    }

    public void setSubstitutionClassProbabilities(double[] classProportions, int startIndex) {
        System.arraycopy(classProportions, startIndex, this.substitutionClassProbabilities_, 0, this.substitutionClassProbabilities_.length);
        this.parametersChanged();
    }

    public final int getNumberOfSubstitutionClasses() {
        return this.substitutionClassProbabilities_.length;
    }

    public final MultiRateMatrixHandler getCopy() {
        return new MultiRateMatrixHandler(this);
    }

    public final double[] getEquilibriumFrequencies() {
        return this.equilibriumFrequencies_;
    }

    private final void checkMatrix() {
        if (this.updateMatrix_) {
            System.out.println("Updating parameters:" + Utils.toString(this.rateParameters_));
            int index = 0;
            double scale = 0.0;
            int i = 0;
            while (i < this.rateMatrices_.length) {
                this.rateMatrices_[i].createRelativeRates(this.relativeRateStore_, this.rateParameters_, index);
                MultiRateMatrixHandler.fromQToR(this.relativeRateStore_, this.equilibriumFrequencies_, this.qMatrixStores_[i], this.dimension_, this.rateMatrices_[i].isReversible());
                scale += this.substitutionClassProbabilities_[i] * MultiRateMatrixHandler.makeValid(this.qMatrixStores_[i], this.equilibriumFrequencies_, this.dimension_);
                index += this.rateMatrices_[i].getNumberOfRateParameters();
                ++i;
            }
            int i2 = 0;
            while (i2 < this.rateMatrices_.length) {
                MultiRateMatrixHandler.scale(this.qMatrixStores_[i2], this.dimension_, scale);
                this.matrixExps_[i2].updateByRelativeRates(this.qMatrixStores_[i2]);
                ++i2;
            }
            this.updateMatrix_ = false;
        }
    }

    public void getTransitionProbabilities(double distance, double[][][] store) {
        this.checkMatrix();
        int i = 0;
        while (i < this.rateMatrices_.length) {
            this.matrixExps_[i].setDistance(distance);
            this.matrixExps_[i].getTransitionProbabilities(store[i]);
            ++i;
        }
    }

    public void getTransitionProbabilities(double distance, int category, double[][] store) {
        this.checkMatrix();
        this.matrixExps_[category].setDistance(distance);
        this.matrixExps_[category].getTransitionProbabilities(store);
    }

    public void getTransitionProbabilitiesTranspose(double distance, double[][][] store) {
        this.checkMatrix();
        int i = 0;
        while (i < this.rateMatrices_.length) {
            this.matrixExps_[i].setDistanceTranspose(distance);
            this.matrixExps_[i].getTransitionProbabilities(store[i]);
            ++i;
        }
    }

    public void getTransitionProbabilitiesTranspose(double distance, int category, double[][] store) {
        this.checkMatrix();
        this.matrixExps_[category].setDistanceTranspose(distance);
        this.matrixExps_[category].getTransitionProbabilities(store);
    }

    private static final void fromQToR(double[][] relativeRates, double[] equilibriumFrequencies, double[][] qMatrix, int dimension, boolean reversible) {
        if (reversible) {
            int i = 0;
            while (i < dimension) {
                int j = i + 1;
                while (j < dimension) {
                    qMatrix[i][j] = relativeRates[i][j] * equilibriumFrequencies[j];
                    qMatrix[j][i] = relativeRates[i][j] * equilibriumFrequencies[i];
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < dimension) {
                int j = i + 1;
                while (j < dimension) {
                    qMatrix[i][j] = relativeRates[i][j] * equilibriumFrequencies[j];
                    qMatrix[j][i] = relativeRates[j][i] * equilibriumFrequencies[i];
                    ++j;
                }
                ++i;
            }
        }
    }

    private static final double makeValid(double[][] relativeRates, double[] equilibriumFrequencies, int dimension) {
        double total = 0.0;
        int i = 0;
        while (i < dimension) {
            double sum = 0.0;
            int j = 0;
            while (j < dimension) {
                if (i != j) {
                    sum += relativeRates[i][j];
                }
                ++j;
            }
            relativeRates[i][i] = -sum;
            total += equilibriumFrequencies[i] * sum;
            ++i;
        }
        return total;
    }

    private static final double calculateNormalScale(double[][] relativeRates, double[] equilibriumFrequencies, int dimension) {
        double scale = 0.0;
        int i = 0;
        while (i < dimension) {
            scale += -relativeRates[i][i] * equilibriumFrequencies[i];
            ++i;
        }
        return scale;
    }

    private static final void normalize(double[][] relativeRates, double[] equilibriumFrequencies, int dimension) {
        MultiRateMatrixHandler.scale(relativeRates, dimension, MultiRateMatrixHandler.calculateNormalScale(relativeRates, equilibriumFrequencies, dimension));
    }

    private static final void scale(double[][] relativeRates, int dimension, double scale) {
        int i = 0;
        while (i < dimension) {
            int j = 0;
            while (j < dimension) {
                relativeRates[i][j] = relativeRates[i][j] / scale;
                ++j;
            }
            ++i;
        }
    }

    private static final void checkFrequencies(double[] frequencies, int dimension) {
        double MINFDIFF = 1.0E-10;
        double MINFREQ = 1.0E-10;
        int maxi = 0;
        double sum = 0.0;
        double maxfreq = 0.0;
        int i = 0;
        while (i < dimension) {
            double freq = frequencies[i];
            if (freq < 1.0E-10) {
                frequencies[i] = 1.0E-10;
            }
            if (freq > maxfreq) {
                maxfreq = freq;
                maxi = i;
            }
            sum += frequencies[i];
            ++i;
        }
        int n = maxi;
        frequencies[n] = frequencies[n] + (1.0 - sum);
        int i2 = 0;
        while (i2 < dimension - 1) {
            int j = i2 + 1;
            while (j < dimension) {
                if (frequencies[i2] == frequencies[j]) {
                    int n2 = i2;
                    frequencies[n2] = frequencies[n2] + 1.0E-10;
                    int n3 = j;
                    frequencies[n3] = frequencies[n3] - 1.0E-10;
                }
                ++j;
            }
            ++i2;
        }
    }

    public void report(PrintWriter out) {
        out.println("Reporting Not functioning yet...");
    }

    private final void parametersChanged() {
        this.updateMatrix_ = true;
    }

    public final double getSubstitutionClassLowerLimit() {
        return 1.0;
    }

    public final double getSubstitutionClassUpperLimit() {
        return 1.0E8;
    }

    public final double getSubstitutionClassDefaultValue() {
        return 100.0;
    }

    public double getLowerLimit(int n) {
        return this.rateMatrices_[this.baseLookup_[n]].getRateParameterLowerBound(this.rateParameterIndexLookup_[n]);
    }

    public double getUpperLimit(int n) {
        return this.rateMatrices_[this.baseLookup_[n]].getRateParameterUpperBound(this.rateParameterIndexLookup_[n]);
    }

    public double getDefaultValue(int n) {
        return this.defaultRateParameters_[n];
    }

    public int getNumberOfParameters() {
        return this.rateParameters_.length;
    }

    public void setAllParameters(double[] rateParameters, double[] classProportions) {
        System.arraycopy(classProportions, 0, this.substitutionClassProbabilities_, 0, this.substitutionClassProbabilities_.length);
        System.arraycopy(rateParameters, 0, this.rateParameters_, 0, this.rateParameters_.length);
        this.parametersChanged();
    }

    public void setParameters(double[] parameters, int startIndex) {
        System.arraycopy(parameters, startIndex, this.rateParameters_, 0, this.rateParameters_.length);
        this.parametersChanged();
    }

    public void getParameters(double[] parameterStore, int startIndex) {
        System.arraycopy(this.rateParameters_, 0, parameterStore, startIndex, this.rateParameters_.length);
    }

    public void getDefaultValues(double[] store, int startIndex) {
        System.arraycopy(this.defaultRateParameters_, 0, store, startIndex, this.defaultRateParameters_.length);
    }

    /*
     * Unable to fully structure code
     */
    private static final void setupLookups(NeoRateMatrix[] bases, int[] baseLookup, int[] parameterIndexLookup, int totalNumberOfParameters) {
        baseIndex = 0;
        parameterIndex = 0;
        i = 0;
        ** GOTO lbl12
        {
            ++baseIndex;
            parameterIndex = 0;
            do {
                if (bases[baseIndex].getNumberOfRateParameters() <= parameterIndex) continue block0;
                baseLookup[i] = baseIndex;
                parameterIndexLookup[i] = parameterIndex++;
                ++i;
lbl12:
                // 2 sources

            } while (i < totalNumberOfParameters);
        }
    }
}

