/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import pal.math.MersenneTwisterFast;
import pal.substmodel.SubstitutionModel;

public class SequenceSimulator {
    private final SubstitutionModel model_;
    private final int[] siteCategories_;
    private final int sequenceLength_;
    private final int numberOfStates_;
    private final int numberOfCategories_;
    private final MersenneTwisterFast random_;
    private final double[][][] transitionProbabilityStore_;

    public SequenceSimulator(SubstitutionModel model, int sequenceLength, boolean stochasticDistribution) {
        this(model, sequenceLength, new MersenneTwisterFast(), stochasticDistribution);
    }

    public SequenceSimulator(SubstitutionModel model, int sequenceLength, MersenneTwisterFast random, boolean stochasticDistribution) {
        this.model_ = model;
        this.sequenceLength_ = sequenceLength;
        this.siteCategories_ = new int[sequenceLength];
        this.random_ = random;
        this.transitionProbabilityStore_ = SubstitutionModel.Utils.generateTransitionProbabilityTables(model);
        this.numberOfStates_ = this.model_.getDataType().getNumStates();
        this.numberOfCategories_ = this.model_.getNumberOfTransitionCategories();
        this.resetSiteCategoryDistribution(stochasticDistribution);
    }

    public void resetSiteCategoryDistribution(boolean stochasticDistribution) {
        this.resetSiteCategoryDistribution(this.model_.getTransitionCategoryProbabilities(), stochasticDistribution);
    }

    public void resetSiteCategoryDistribution(double[] categoryDistribution, boolean stochasticDistribution) {
        if (stochasticDistribution) {
            int i = 0;
            while (i < this.sequenceLength_) {
                this.siteCategories_[i] = this.cumulativeSelect(categoryDistribution, this.numberOfCategories_);
                ++i;
            }
        } else {
            int total = 0;
            int index = 0;
            int category = 0;
            while (category < this.numberOfCategories_) {
                int count = (int)((double)this.sequenceLength_ * categoryDistribution[category]);
                int i = 0;
                while (i < count) {
                    this.siteCategories_[index++] = category;
                    ++i;
                }
                total += count;
                ++category;
            }
            int i = total;
            while (i < this.sequenceLength_) {
                this.siteCategories_[index++] = this.numberOfCategories_ - 1;
                ++i;
            }
        }
    }

    public void resetSiteCategoryDistribution(double[][] posteriorCategoryDistribution) {
        this.resetSiteCategoryDistribution(posteriorCategoryDistribution, this.siteCategories_);
    }

    public int[] getSiteCategoryDistribution() {
        return this.siteCategories_;
    }

    public void resetSiteCategoryDistribution(double[][] posteriorCategoryDistribution, SequenceSimulator base) {
        if (base.sequenceLength_ == this.sequenceLength_) {
            throw new IllegalArgumentException("Base simulator has incompatible sequence length:" + base.sequenceLength_ + " found, " + this.sequenceLength_ + " expected");
        }
        this.resetSiteCategoryDistribution(posteriorCategoryDistribution, base.siteCategories_);
    }

    public void resetSiteCategoryDistribution(double[][] posteriorCategoryDistribution, int[] baseSiteCategories) {
        int i = 0;
        while (i < this.sequenceLength_) {
            int oldCategory = baseSiteCategories[i];
            this.siteCategories_[i] = this.cumulativeSelect(posteriorCategoryDistribution[oldCategory], this.numberOfCategories_);
            ++i;
        }
    }

    public void simulate(int[] startingSequence, double distance, int[] endingSequenceStore) {
        this.model_.getTransitionProbabilities(distance, this.transitionProbabilityStore_);
        int i = 0;
        while (i < this.sequenceLength_) {
            int startState = startingSequence[i];
            int category = this.siteCategories_[i];
            double[] distribution = this.transitionProbabilityStore_[category][startState];
            endingSequenceStore[i] = this.cumulativeSelect(distribution, this.numberOfStates_);
            ++i;
        }
    }

    public int[] getSimulated(int[] startingSequence, double distance) {
        int[] endingSequenceStore = new int[this.sequenceLength_];
        this.simulate(startingSequence, distance, endingSequenceStore);
        return endingSequenceStore;
    }

    public int[] generateRoot() {
        int[] root = new int[this.sequenceLength_];
        double[] equilibriumDistribution = this.model_.getEquilibriumFrequencies();
        int i = 0;
        while (i < this.sequenceLength_) {
            root[i] = this.cumulativeSelect(equilibriumDistribution, this.numberOfStates_);
            ++i;
        }
        return root;
    }

    private final int cumulativeSelect(double[] distribution, int numberInDistribution) {
        double r = this.random_.nextDouble();
        double total = 0.0;
        int i = 0;
        while (i < numberInDistribution) {
            if (r < (total += distribution[i])) {
                return i;
            }
            ++i;
        }
        return numberInDistribution - 1;
    }
}

