/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import pal.datatype.DataType;
import pal.math.OrthogonalHints;
import pal.misc.PalObjectListener;
import pal.misc.Parameterized;
import pal.substmodel.NeoRateMatrix;
import pal.substmodel.RateMatrixHandler;
import pal.substmodel.SubstitutionModel;

public class SingleClassSubstitutionModel
extends Parameterized.ParameterizedUser
implements SubstitutionModel {
    private RateMatrixHandler handler_;
    private DataType dataType_;
    private static final long serialVersionUID = 4938429359234234234L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.handler_);
        out.writeObject(this.dataType_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.handler_ = (RateMatrixHandler)in.readObject();
        this.dataType_ = (DataType)in.readObject();
        this.setParameterizedBase(this.handler_);
    }

    private SingleClassSubstitutionModel(SingleClassSubstitutionModel toCopy) {
        this.handler_ = toCopy.handler_.getCopy();
        this.dataType_ = toCopy.dataType_;
        this.setParameterizedBase(this.handler_);
    }

    public SingleClassSubstitutionModel(NeoRateMatrix base, DataType dt, double[] frequencies) {
        this.handler_ = new RateMatrixHandler(base, frequencies);
        this.dataType_ = dt;
        this.setParameterizedBase(this.handler_);
    }

    public DataType getDataType() {
        return this.dataType_;
    }

    public int getNumberOfTransitionCategories() {
        return 1;
    }

    public double getTransitionCategoryProbability(int category) {
        return 1.0;
    }

    public double[] getTransitionCategoryProbabilities() {
        return new double[]{1.0};
    }

    public double[] getEquilibriumFrequencies() {
        return this.handler_.getEquilibriumFrequencies();
    }

    public void getTransitionProbabilities(double branchLength, double[][][] store) {
        this.handler_.getTransitionProbabilities(branchLength, store[0]);
    }

    public void getTransitionProbabilities(double branchLength, int category, double[][] store) {
        this.handler_.getTransitionProbabilities(branchLength, store);
    }

    public void getTransitionProbabilitiesTranspose(double branchLength, double[][][] store) {
        this.handler_.getTransitionProbabilitiesTranspose(branchLength, store[0]);
    }

    public void getTransitionProbabilitiesTranspose(double branchLength, int category, double[][] store) {
        this.handler_.getTransitionProbabilitiesTranspose(branchLength, store);
    }

    public void addPalObjectListener(PalObjectListener l) {
        throw new RuntimeException("Sorry, NeoRateMatrix stuff does not work with old likelihood calculators!");
    }

    public void removePalObjectListener(PalObjectListener l) {
        throw new RuntimeException("Sorry, NeoRateMatrix stuff does not work with old likelihood calculators!");
    }

    public OrthogonalHints getOrthogonalHints() {
        return null;
    }

    public void report(PrintWriter out) {
        this.handler_.report(out);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        this.report(pw);
        return "Single Class Substitution Model:\n" + sw.toString();
    }

    public Object clone() {
        return new SingleClassSubstitutionModel(this);
    }

    public SubstitutionModel getCopy() {
        return new SingleClassSubstitutionModel(this);
    }
}

